/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.tools.editor;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMManagedEntityRequest;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.attribute.SMAttributeDataException;
import com.sun.symon.base.client.attribute.SMAttributeEntryData;
import com.sun.symon.base.client.attribute.SMAttributeGroupData;
import com.sun.symon.base.client.attribute.SMAttributeUpdateData;
import com.sun.symon.base.console.manager.CmBrowserConsole;
import com.sun.symon.base.console.tools.editor.CtEditedEvent;
import com.sun.symon.base.console.tools.editor.CtEditedListener;
import com.sun.symon.base.console.tools.editor.CtEditorDataSource;
import com.sun.symon.base.console.tools.editor.CtEditorISDException;
import com.sun.symon.base.console.tools.editor.CtEditorListPanel;
import com.sun.symon.base.console.tools.editor.CtExEditorDataSource;
import com.sun.symon.base.console.tools.editor.CtFocusTraversable;
import com.sun.symon.base.console.tools.editor.CtResetEvent;
import com.sun.symon.base.console.tools.editor.CtResetListener;
import com.sun.symon.base.console.tools.editor.CtSaveEvent;
import com.sun.symon.base.console.tools.editor.CtSaveListener;
import com.sun.symon.base.console.tools.editor.CtScrollPanel;
import com.sun.symon.base.console.tools.editor.ListPanel;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcListUtil;
import com.sun.symon.base.utility.UcURL;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTabbedPane;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CtAttributeEditor
extends JPanel {
    public String requiredMesg;
    public String invalidIntMesg;
    public String invalidUintMesg;
    public String invalidFloatMesg;
    public String instanceMesg1;
    public String instanceMesg2;
    public String nonAsciiMesg;
    public String crashMesg;
    public String nospaceMesg;
    public String filenameMesg;
    private Dimension editorSize = new Dimension(400, 500);
    private Font attValueFont = new Font("SansSerif", 0, 12);
    private Font tabTitleFont = new Font("SansSerif", 1, 14);
    private Font attNameFont = new Font("SansSerif", 0, 12);
    private Font headerFont = new Font("SansSerif", 1, 14);
    private Font labelFont = new Font("SansSerif", 1, 12);
    private Font attEditedFont = new Font("SansSerif", 1, 12);
    private Color attValueBackground = Color.white;
    private Color nonEditableBackground = new Color(174, 178, 195);
    private Color nonEditableForeground = new Color(240, 100, 100);
    private Color labelForeground = Color.black;
    private Color attValueForeground = Color.black;
    private Color headerForeground = Color.black;
    private Color editedForeground = Color.blue;
    private Color focusedBorderColor = Color.blue;
    private Color chosenAttBackground = new Color(174, 178, 195);
    private Color chosenAttForeground = Color.black;
    private String url = null;
    private CtEditorDataSource dataSource1 = null;
    private SMManagedEntityRequest dataSource2 = null;
    private String initialShadowGroup = "";
    private SMRawDataRequest rawDataSource = null;
    private boolean source1Set = false;
    private boolean source2Set = false;
    private SMAttributeGroupData[] attGroups;
    private int groupSize = 0;
    private SMAttributeGroupData currentGroup;
    private int selectedIndex = 0;
    private Hashtable groupKeyIndex = new Hashtable();
    private String currentGroupKey;
    private SMAttributeEntryData[] currentAtt;
    private Vector allAttributes = new Vector();
    private Vector originalAttributes = new Vector();
    private Vector saveData = new Vector();
    private JTabbedPane tabPane;
    CtEditorListPanel currentPanel;
    private int numberOfObjects = 1;
    private String[] urls = null;
    private boolean loadAsRequired = true;
    private boolean LARSet = false;
    private Vector resetListener = new Vector();
    private Vector editListener = new Vector();
    private Vector saveListener = new Vector();
    private boolean dead = false;
    private boolean forColumn = false;
    private String moduleBuilderAgentIP = null;

    public CtAttributeEditor() {
        this.setLayout(new BorderLayout());
    }

    public void setForColumn(boolean bl) {
        this.forColumn = bl;
    }

    public void setInitShadowGroup(String string) {
        this.initialShadowGroup = string;
    }

    public synchronized void addCtEditedListener(CtEditedListener ctEditedListener) {
        if (!this.editListener.contains(ctEditedListener)) {
            this.editListener.addElement(ctEditedListener);
        }
    }

    public synchronized void addCtResetListener(CtResetListener ctResetListener) {
        if (!this.resetListener.contains(ctResetListener)) {
            this.resetListener.addElement(ctResetListener);
        }
    }

    public synchronized void addCtSaveListener(CtSaveListener ctSaveListener) {
        if (!this.saveListener.contains(ctSaveListener)) {
            this.saveListener.addElement(ctSaveListener);
        }
    }

    private int alreadyEdited(SMAttributeUpdateData sMAttributeUpdateData) {
        int n = 0;
        while (n < this.saveData.size()) {
            String string = sMAttributeUpdateData.getKey();
            String string2 = sMAttributeUpdateData.getGroup();
            SMAttributeUpdateData sMAttributeUpdateData2 = (SMAttributeUpdateData)this.saveData.elementAt(n);
            String string3 = sMAttributeUpdateData2.getKey();
            String string4 = sMAttributeUpdateData2.getGroup();
            if (string.equals(string3) && string2.equals(string4)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    SMAttributeEntryData[] commonPart(SMAttributeEntryData[] sMAttributeEntryDataArray, SMAttributeEntryData[] sMAttributeEntryDataArray2) {
        Vector<SMAttributeEntryData> vector = new Vector<SMAttributeEntryData>();
        int n = 0;
        while (n < sMAttributeEntryDataArray.length) {
            if (this.isInAttributes(sMAttributeEntryDataArray[n], sMAttributeEntryDataArray2)) {
                vector.addElement(sMAttributeEntryDataArray[n]);
            }
            ++n;
        }
        int n2 = vector.size();
        SMAttributeEntryData[] sMAttributeEntryDataArray3 = new SMAttributeEntryData[n2];
        int n3 = 0;
        while (n3 < n2) {
            sMAttributeEntryDataArray3[n3] = (SMAttributeEntryData)vector.elementAt(n3);
            ++n3;
        }
        return sMAttributeEntryDataArray3;
    }

    SMAttributeGroupData[] commonPartOfTwo(SMAttributeGroupData[] sMAttributeGroupDataArray, SMAttributeGroupData[] sMAttributeGroupDataArray2) {
        Vector<SMAttributeGroupData> vector = new Vector<SMAttributeGroupData>();
        int n = 0;
        while (n < sMAttributeGroupDataArray.length) {
            if (this.isInGroups(sMAttributeGroupDataArray[n], sMAttributeGroupDataArray2)) {
                vector.addElement(sMAttributeGroupDataArray[n]);
            }
            ++n;
        }
        int n2 = vector.size();
        SMAttributeGroupData[] sMAttributeGroupDataArray3 = new SMAttributeGroupData[n2];
        int n3 = 0;
        while (n3 < n2) {
            sMAttributeGroupDataArray3[n3] = (SMAttributeGroupData)vector.elementAt(n3);
            ++n3;
        }
        return sMAttributeGroupDataArray3;
    }

    public void confirmEditedData(SMAttributeUpdateData sMAttributeUpdateData) throws CtEditorISDException {
        this.confirmEditedData(sMAttributeUpdateData, false);
    }

    public void confirmEditedData(SMAttributeUpdateData sMAttributeUpdateData, boolean bl) throws CtEditorISDException {
        int n;
        String string = sMAttributeUpdateData.getGroup();
        String string2 = sMAttributeUpdateData.getKey();
        String string3 = sMAttributeUpdateData.getValue();
        String string4 = this.getType(string, string2);
        String string5 = this.getFormat(string, string2);
        String string6 = this.getDescription(string, string2);
        if (!(bl || string3.indexOf("\"") == -1 && string3.indexOf("\\") == -1)) {
            this.throwISDException(string, string2, "\"" + string6 + "\" " + this.crashMesg, sMAttributeUpdateData);
        }
        if (!string5.equals("unicode") && !UcListUtil.isAsciiString((String)string3)) {
            this.throwISDException(string, string2, "\"" + string6 + "\" " + this.nonAsciiMesg, sMAttributeUpdateData);
        }
        if (string5.equals("instance")) {
            if (Character.isDigit(string3.trim().charAt(0))) {
                this.throwISDException(string, string2, "\"" + string6 + "\" " + this.instanceMesg1, sMAttributeUpdateData);
            } else if (this.containSpecialChar(string3)) {
                this.throwISDException(string, string2, "\"" + string6 + "\" " + this.instanceMesg2, sMAttributeUpdateData);
            } else {
                n = (string3 = string3.trim()).indexOf(" ");
                if (n > 0) {
                    this.throwISDException(string, string2, "\"" + string6 + "\" " + this.nospaceMesg, sMAttributeUpdateData);
                }
            }
            string3 = string3.trim();
            if (string3.length() > 32) {
                string3 = string3.substring(0, 32);
                sMAttributeUpdateData.setValue(string3);
            }
        } else if (string5.equals("filename_nopath")) {
            if ((string3 = string3.trim()).indexOf("/") != -1 || string3.indexOf("#") != -1 || string3.indexOf(";") != -1 || string3.indexOf(":") != -1 || string3.indexOf("?") != -1) {
                JComponent jComponent = this.currentPanel.getInvalidField(string2);
                if (jComponent != null) {
                    jComponent.requestFocus();
                }
                throw new CtEditorISDException("\"" + string6 + "\" " + this.filenameMesg, sMAttributeUpdateData);
            }
        } else if (string5.equals("nospecial_char")) {
            if (this.containSpecialChar(string3 = string3.trim())) {
                this.throwISDException(string, string2, "\"" + string6 + "\" " + this.instanceMesg2, sMAttributeUpdateData);
            } else if (string3.indexOf(" ") > 0) {
                this.throwISDException(string, string2, "\"" + string6 + "\" " + this.nospaceMesg, sMAttributeUpdateData);
            }
        }
        if (string4.equals("int")) {
            if (!this.typeMatch(string3, string4) && string3.length() != 0) {
                this.throwISDException(string, string2, "\"" + string6 + "\" " + this.invalidIntMesg, sMAttributeUpdateData);
            }
        } else if (string4.equals("uint")) {
            if (!this.typeMatch(string3, string4) && string3.length() != 0) {
                this.throwISDException(string, string2, "\"" + string6 + "\" " + this.invalidUintMesg, sMAttributeUpdateData);
            }
        } else if (string4.equals("float")) {
            if (!this.typeMatch(string3, string4) && string3.length() != 0) {
                this.throwISDException(string, string2, "\"" + string6 + "\" " + this.invalidFloatMesg, sMAttributeUpdateData);
            }
        } else if (string4.equals("nospace") && (n = (string3 = string3.trim()).indexOf(" ")) > 0) {
            this.throwISDException(string, string2, "\"" + string6 + "\" " + this.nospaceMesg, sMAttributeUpdateData);
        }
    }

    private void throwISDException(String string, String string2, String string3, SMAttributeUpdateData sMAttributeUpdateData) throws CtEditorISDException {
        int n = (Integer)this.groupKeyIndex.get(string);
        this.tabPane.setSelectedIndex(n);
        JComponent jComponent = this.currentPanel.getInvalidField(string2);
        if (jComponent != null) {
            jComponent.requestFocus();
        }
        throw new CtEditorISDException(string3, sMAttributeUpdateData);
    }

    private boolean containSpecialChar(String string) {
        return string.indexOf("\"") != -1 || string.indexOf("\\") != -1 || string.indexOf("<") != -1 || string.indexOf(">") != -1 || string.indexOf("#") != -1 || string.indexOf("%") != -1 || string.indexOf("{") != -1 || string.indexOf("}") != -1 || string.indexOf("|") != -1 || string.indexOf("^") != -1 || string.indexOf("~") != -1 || string.indexOf("`") != -1 || string.indexOf("[") != -1 || string.indexOf("]") != -1 || string.indexOf(":") != -1 || string.indexOf(".") != -1 || string.indexOf("$") != -1 || string.indexOf("(") != -1 || string.indexOf(")") != -1 || string.indexOf("!") != -1 || string.indexOf("@") != -1 || string.indexOf("&") != -1 || string.indexOf("*") != -1 || string.indexOf("=") != -1 || string.indexOf("'") != -1 || string.indexOf("?") != -1 || string.indexOf(",") != -1 || string.indexOf(";") != -1;
    }

    private SMAttributeUpdateData[] convertVector2Array(Vector vector) {
        int n = vector.size();
        SMAttributeUpdateData[] sMAttributeUpdateDataArray = new SMAttributeUpdateData[n];
        int n2 = 0;
        while (n2 < n) {
            sMAttributeUpdateDataArray[n2] = (SMAttributeUpdateData)vector.elementAt(n2);
            ++n2;
        }
        return sMAttributeUpdateDataArray;
    }

    private boolean typeMatch(String string, String string2) {
        if (string2.equals("int")) {
            try {
                int n = Integer.parseInt(string);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        if (string2.equals("uint")) {
            try {
                int n = Integer.parseInt(string);
                return n >= 0;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        if (string2.equals("float")) {
            try {
                Float f = Float.valueOf(string);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return true;
    }

    private Vector getAllAttributes() {
        Vector<SMAttributeGroupData> vector = new Vector<SMAttributeGroupData>();
        Vector<SMAttributeEntryData[]> vector2 = new Vector<SMAttributeEntryData[]>();
        if (this.numberOfObjects != 1) {
            int n = 0;
            while (n < this.groupSize) {
                SMAttributeEntryData[] sMAttributeEntryDataArray = new SMAttributeEntryData[this.groupSize];
                SMAttributeGroupData sMAttributeGroupData = this.attGroups[n];
                String string = sMAttributeGroupData.getGroupKey();
                try {
                    sMAttributeEntryDataArray = this.getCommonAttributeEntries(string);
                }
                catch (SMAttributeDataException sMAttributeDataException) {
                    System.err.println(sMAttributeDataException.toString());
                }
                if (sMAttributeEntryDataArray.length != 0) {
                    vector2.addElement(sMAttributeEntryDataArray);
                    vector.addElement(sMAttributeGroupData);
                }
                ++n;
            }
            this.groupSize = vector.size();
            int n2 = 0;
            while (n2 < this.groupSize) {
                this.attGroups[n2] = (SMAttributeGroupData)vector.elementAt(n2);
                ++n2;
            }
        } else {
            int n = 0;
            while (n < this.groupSize) {
                if (this.loadAsRequired) {
                    vector2.addElement(new SMAttributeEntryData[1]);
                } else {
                    SMAttributeGroupData sMAttributeGroupData = this.attGroups[n];
                    String string = sMAttributeGroupData.getGroupKey();
                    try {
                        SMAttributeEntryData[] sMAttributeEntryDataArray = this.source1Set ? this.dataSource1.getAttributeEntries(this.url, string) : this.dataSource2.getAttributeEntries(this.url, string);
                        vector2.addElement(sMAttributeEntryDataArray);
                    }
                    catch (SMAttributeDataException sMAttributeDataException) {
                        vector2.addElement(new SMAttributeEntryData[0]);
                    }
                }
                ++n;
            }
        }
        return vector2;
    }

    public Font getAttEditedFont() {
        return this.attEditedFont;
    }

    public Font getAttNameFont() {
        return this.attNameFont;
    }

    public Color getAttValueBackground() {
        return this.attValueBackground;
    }

    public Font getAttValueFont() {
        return this.attValueFont;
    }

    public Color getAttValueForeground() {
        return this.attValueForeground;
    }

    private SMAttributeGroupData[] getAttributeGroups() throws SMAttributeDataException {
        if (this.numberOfObjects == 1) {
            if (this.source1Set) {
                if (this.dataSource1 instanceof CtExEditorDataSource) {
                    CtExEditorDataSource ctExEditorDataSource = (CtExEditorDataSource)this.dataSource1;
                    return ctExEditorDataSource.getAttributeGroups(this.url, this.initialShadowGroup);
                }
                return this.dataSource1.getAttributeGroups(this.url);
            }
            return this.dataSource2.getAttributeGroups(this.url, this.initialShadowGroup);
        }
        return this.getCommonGroups();
    }

    public Color getChosenAttBackground() {
        return this.chosenAttBackground;
    }

    public Color getChosenAttForeground() {
        return this.chosenAttForeground;
    }

    SMAttributeEntryData[] getCommonAttributeEntries(String string) throws SMAttributeDataException {
        SMAttributeEntryData[] sMAttributeEntryDataArray = this.source1Set ? this.dataSource1.getAttributeEntries(this.urls[0], string) : this.dataSource2.getAttributeEntries(this.urls[0], string);
        int n = 1;
        while (n < this.numberOfObjects) {
            SMAttributeEntryData[] sMAttributeEntryDataArray2 = this.source1Set ? this.dataSource1.getAttributeEntries(this.urls[n], string) : this.dataSource2.getAttributeEntries(this.urls[n], string);
            sMAttributeEntryDataArray = this.commonPart(sMAttributeEntryDataArray, sMAttributeEntryDataArray2);
            ++n;
        }
        return sMAttributeEntryDataArray;
    }

    SMAttributeGroupData[] getCommonGroups() throws SMAttributeDataException {
        SMAttributeGroupData[] sMAttributeGroupDataArray;
        if (this.source1Set) {
            if (this.dataSource1 instanceof CtExEditorDataSource) {
                CtExEditorDataSource ctExEditorDataSource = (CtExEditorDataSource)this.dataSource1;
                sMAttributeGroupDataArray = ctExEditorDataSource.getAttributeGroups(this.urls[0], this.initialShadowGroup);
            } else {
                sMAttributeGroupDataArray = this.dataSource1.getAttributeGroups(this.urls[0]);
            }
        } else {
            sMAttributeGroupDataArray = this.dataSource2.getAttributeGroups(this.urls[0]);
        }
        int n = 1;
        while (n < this.numberOfObjects) {
            SMAttributeGroupData[] sMAttributeGroupDataArray2;
            if (this.source1Set) {
                if (this.dataSource1 instanceof CtExEditorDataSource) {
                    CtExEditorDataSource ctExEditorDataSource = (CtExEditorDataSource)this.dataSource1;
                    sMAttributeGroupDataArray2 = ctExEditorDataSource.getAttributeGroups(this.urls[n], this.initialShadowGroup);
                } else {
                    sMAttributeGroupDataArray2 = this.dataSource1.getAttributeGroups(this.urls[n]);
                }
            } else {
                sMAttributeGroupDataArray2 = this.dataSource2.getAttributeGroups(this.urls[n]);
            }
            sMAttributeGroupDataArray = this.commonPartOfTwo(sMAttributeGroupDataArray, sMAttributeGroupDataArray2);
            ++n;
        }
        return sMAttributeGroupDataArray;
    }

    private CtEditorListPanel getCurrentPanel() {
        ListPanel listPanel = (ListPanel)this.tabPane.getComponentAt(this.selectedIndex);
        CtScrollPanel ctScrollPanel = listPanel.getScrollPanel();
        CtEditorListPanel ctEditorListPanel = (CtEditorListPanel)ctScrollPanel.getScrollComponent();
        return ctEditorListPanel;
    }

    public Color getEditedForeground() {
        return this.editedForeground;
    }

    public Dimension getEditorSize() {
        return this.editorSize;
    }

    private void getErrorMessages() {
        this.instanceMesg1 = this.translate("instance1");
        this.instanceMesg2 = this.translate("instance2");
        this.nonAsciiMesg = this.translate("nonascii");
        this.invalidIntMesg = this.translate("notint");
        this.invalidUintMesg = this.translate("notuint");
        this.invalidFloatMesg = this.translate("notfloat");
        this.requiredMesg = this.translate("required");
        this.crashMesg = this.translate("crash");
        this.nospaceMesg = this.translate("nospace");
        this.filenameMesg = this.translate("filename_nopath");
    }

    public Color getFocusedBorderColor() {
        return this.focusedBorderColor;
    }

    public Font getHeaderFont() {
        return this.headerFont;
    }

    public Color getHeaderForeground() {
        return this.headerForeground;
    }

    private String getType(String string, String string2) {
        int n = (Integer)this.groupKeyIndex.get(string);
        SMAttributeEntryData[] sMAttributeEntryDataArray = (SMAttributeEntryData[])this.allAttributes.elementAt(n);
        int n2 = 0;
        while (n2 < sMAttributeEntryDataArray.length) {
            SMAttributeEntryData sMAttributeEntryData = sMAttributeEntryDataArray[n2];
            if (sMAttributeEntryData.getKey().equals(string2)) {
                return sMAttributeEntryData.getType();
            }
            ++n2;
        }
        return "";
    }

    private String getFormat(String string, String string2) {
        int n = (Integer)this.groupKeyIndex.get(string);
        SMAttributeEntryData[] sMAttributeEntryDataArray = (SMAttributeEntryData[])this.allAttributes.elementAt(n);
        int n2 = 0;
        while (n2 < sMAttributeEntryDataArray.length) {
            SMAttributeEntryData sMAttributeEntryData = sMAttributeEntryDataArray[n2];
            if (sMAttributeEntryData.getKey().equals(string2)) {
                return sMAttributeEntryData.getFormat();
            }
            ++n2;
        }
        return "";
    }

    private String getDescription(String string, String string2) {
        int n = (Integer)this.groupKeyIndex.get(string);
        SMAttributeEntryData[] sMAttributeEntryDataArray = (SMAttributeEntryData[])this.allAttributes.elementAt(n);
        int n2 = 0;
        while (n2 < sMAttributeEntryDataArray.length) {
            SMAttributeEntryData sMAttributeEntryData = sMAttributeEntryDataArray[n2];
            if (sMAttributeEntryData.getKey().equals(string2)) {
                return sMAttributeEntryData.getDescId();
            }
            ++n2;
        }
        return "";
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public Color getLabelForeground() {
        return this.labelForeground;
    }

    public boolean getLoadAsRequired() {
        return this.loadAsRequired;
    }

    public Color getNonEditableBackground() {
        return this.nonEditableBackground;
    }

    public Color getNonEditableForeground() {
        return this.nonEditableForeground;
    }

    private boolean getRequired(String string, String string2) {
        int n = (Integer)this.groupKeyIndex.get(string);
        SMAttributeEntryData[] sMAttributeEntryDataArray = (SMAttributeEntryData[])this.allAttributes.elementAt(n);
        int n2 = 0;
        while (n2 < sMAttributeEntryDataArray.length) {
            SMAttributeEntryData sMAttributeEntryData = sMAttributeEntryDataArray[n2];
            if (sMAttributeEntryData.getKey().equals(string2)) {
                return sMAttributeEntryData.getRequired();
            }
            ++n2;
        }
        return false;
    }

    public Vector getSaveData() {
        return this.saveData;
    }

    public Font getTabTitleFont() {
        return this.tabTitleFont;
    }

    public String[] getTimezoneInfo() {
        String[] stringArray;
        Vector vector;
        block7: {
            if (this.rawDataSource == null) {
                return this.dataSource1.getTimezoneInfo();
            }
            UcURL ucURL = new UcURL(this.url);
            String string = "snmp://" + ucURL.getHost() + ":" + ucURL.getPort() + "/sym/base/info/system/localtime#0";
            vector = new Vector();
            try {
                stringArray = new String[]{string};
                StObject[][] stObjectArray = this.rawDataSource.getURLValue(stringArray);
                if (stObjectArray == null || stObjectArray[0] == null || stObjectArray[0][0] == null) {
                    return null;
                }
                boolean bl = UcListUtil.decomposeList((String)stObjectArray[0][0].toString(), vector);
                if (!bl) {
                    return null;
                }
            }
            catch (SMAPIException sMAPIException) {
                vector = null;
                if (sMAPIException.getReasonCode() != 7) break block7;
                UcDDL.logDebugMessage((String)"CtAttributeEditor:: you are running an old agent");
            }
        }
        if (vector != null) {
            stringArray = new String[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                stringArray[n] = (String)vector.elementAt(n);
                ++n;
            }
            stringArray[0] = UcInternationalizer.translateKey((String)stringArray[0], (String)stringArray[1]);
            return stringArray;
        }
        return null;
    }

    public Window getTopWindow() {
        Container container = this;
        while (container != null) {
            if (container instanceof Window) {
                return (Window)container;
            }
            container = container.getParent();
        }
        return null;
    }

    private void initialize() {
        Object object;
        String string;
        this.getErrorMessages();
        this.tabPane = new JTabbedPane();
        this.tabPane.setBorder(new BevelBorder(0));
        try {
            this.attGroups = this.getAttributeGroups();
        }
        catch (SMAttributeDataException sMAttributeDataException) {
            string = UcInternationalizer.translateKey((String)"base.console.ConsoleMessages:attedit.load.failed.title");
            object = new String[]{UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:message.ok")};
            JOptionPane.showOptionDialog(this, sMAttributeDataException.getMessage(), string, -1, 0, null, object, object[0]);
            this.dead = true;
        }
        if (this.attGroups == null) {
            return;
        }
        this.groupSize = this.attGroups.length;
        this.allAttributes = this.getAllAttributes();
        this.updateOriginal();
        int n = 0;
        while (n < this.groupSize) {
            string = this.attGroups[n];
            object = string.getGroupDisplayId();
            String string2 = string.getGroupKey();
            this.groupKeyIndex.put(string2, new Integer(n));
            this.tabPane.setFont(this.tabTitleFont);
            CtScrollPanel ctScrollPanel = this.makeListPanel(string2, (SMAttributeEntryData[])this.allAttributes.elementAt(n));
            ListPanel listPanel = new ListPanel(ctScrollPanel);
            this.tabPane.addTab(" " + (String)object + " ", null, listPanel);
            ++n;
        }
        this.add("Center", this.tabPane);
        this.tabPane.setSelectedIndex(this.selectedIndex);
        this.update();
        this.tabPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                CtAttributeEditor.this.update();
            }
        });
    }

    public void setSelectedIndex(int n) {
        if (n > 0 && n < this.tabPane.getTabCount()) {
            this.tabPane.setSelectedIndex(n);
        }
    }

    public boolean getStatus() {
        return this.dead;
    }

    boolean isInAttributes(SMAttributeEntryData sMAttributeEntryData, SMAttributeEntryData[] sMAttributeEntryDataArray) {
        String string = sMAttributeEntryData.getKey();
        int n = 0;
        while (n < sMAttributeEntryDataArray.length) {
            SMAttributeEntryData sMAttributeEntryData2 = sMAttributeEntryDataArray[n];
            String string2 = sMAttributeEntryData2.getKey();
            if (string.equals(string2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean isInGroups(SMAttributeGroupData sMAttributeGroupData, SMAttributeGroupData[] sMAttributeGroupDataArray) {
        int n = 0;
        while (n < sMAttributeGroupDataArray.length) {
            String string;
            SMAttributeGroupData sMAttributeGroupData2 = sMAttributeGroupDataArray[n];
            String string2 = sMAttributeGroupData.getGroupKey();
            if (string2.equals(string = sMAttributeGroupData2.getGroupKey())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private CtScrollPanel makeListPanel(String string, SMAttributeEntryData[] sMAttributeEntryDataArray) {
        CtEditorListPanel ctEditorListPanel = new CtEditorListPanel(string, sMAttributeEntryDataArray, this);
        CtScrollPanel ctScrollPanel = new CtScrollPanel(ctEditorListPanel);
        return ctScrollPanel;
    }

    public void notifyEdited() {
        Vector vector;
        CtEditedEvent ctEditedEvent = new CtEditedEvent(this);
        CtAttributeEditor ctAttributeEditor = this;
        synchronized (ctAttributeEditor) {
            vector = (Vector)this.editListener.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            CtEditedListener ctEditedListener = (CtEditedListener)vector.elementAt(n);
            ctEditedListener.attributeEdited(ctEditedEvent);
            ++n;
        }
    }

    public void notifyReset() {
        Vector vector;
        CtResetEvent ctResetEvent = new CtResetEvent(this);
        CtAttributeEditor ctAttributeEditor = this;
        synchronized (ctAttributeEditor) {
            vector = (Vector)this.resetListener.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            CtResetListener ctResetListener = (CtResetListener)vector.elementAt(n);
            ctResetListener.attributeReset(ctResetEvent);
            ++n;
        }
    }

    public void notifySaved() {
        Vector vector;
        CtSaveEvent ctSaveEvent = new CtSaveEvent(this);
        CtAttributeEditor ctAttributeEditor = this;
        synchronized (ctAttributeEditor) {
            vector = (Vector)this.saveListener.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            CtSaveListener ctSaveListener = (CtSaveListener)vector.elementAt(n);
            ctSaveListener.attributeSaved(ctSaveEvent);
            ++n;
        }
    }

    public synchronized void removeCtEditedListener(CtEditedListener ctEditedListener) {
        if (this.editListener.contains(ctEditedListener)) {
            this.editListener.removeElement(ctEditedListener);
        }
    }

    public synchronized void removeCtResetListener(CtResetListener ctResetListener) {
        if (this.resetListener.contains(ctResetListener)) {
            this.resetListener.removeElement(ctResetListener);
        }
    }

    public synchronized void removeCtSaveListener(CtSaveListener ctSaveListener) {
        if (this.saveListener.contains(ctSaveListener)) {
            this.saveListener.removeElement(ctSaveListener);
        }
    }

    public void resetAttributes() {
        this.notifyReset();
        this.saveData.removeAllElements();
        this.back2Original();
    }

    private void updateOriginal() {
        this.originalAttributes.removeAllElements();
        int n = 0;
        while (n < this.allAttributes.size()) {
            SMAttributeEntryData[] sMAttributeEntryDataArray = (SMAttributeEntryData[])this.allAttributes.elementAt(n);
            SMAttributeEntryData[] sMAttributeEntryDataArray2 = new SMAttributeEntryData[sMAttributeEntryDataArray.length];
            int n2 = 0;
            while (n2 < sMAttributeEntryDataArray.length) {
                sMAttributeEntryDataArray2[n2] = sMAttributeEntryDataArray[n2];
                ++n2;
            }
            this.originalAttributes.addElement(sMAttributeEntryDataArray2);
            ++n;
        }
    }

    private void back2Original() {
        this.allAttributes.removeAllElements();
        int n = 0;
        while (n < this.originalAttributes.size()) {
            SMAttributeEntryData[] sMAttributeEntryDataArray = (SMAttributeEntryData[])this.originalAttributes.elementAt(n);
            SMAttributeEntryData[] sMAttributeEntryDataArray2 = new SMAttributeEntryData[sMAttributeEntryDataArray.length];
            int n2 = 0;
            while (n2 < sMAttributeEntryDataArray.length) {
                sMAttributeEntryDataArray2[n2] = sMAttributeEntryDataArray[n2];
                ++n2;
            }
            this.allAttributes.addElement(sMAttributeEntryDataArray2);
            ++n;
        }
    }

    public void saveAttributes() throws CtEditorISDException, SMAttributeDataException {
        String string;
        SMAttributeUpdateData[] sMAttributeUpdateDataArray;
        int n = 0;
        while (n < this.saveData.size()) {
            SMAttributeUpdateData sMAttributeUpdateData = (SMAttributeUpdateData)this.saveData.elementAt(n);
            sMAttributeUpdateDataArray = sMAttributeUpdateData.getGroup();
            string = sMAttributeUpdateData.getKey();
            String string2 = sMAttributeUpdateData.getValue();
            this.setNewAtt((String)sMAttributeUpdateDataArray, string, string2);
            ++n;
        }
        this.verifyRequiredData();
        int n2 = 0;
        while (n2 < this.saveData.size()) {
            sMAttributeUpdateDataArray = (SMAttributeUpdateData)this.saveData.elementAt(n2);
            this.confirmEditedData((SMAttributeUpdateData)sMAttributeUpdateDataArray);
            ++n2;
        }
        if (this.numberOfObjects == 1) {
            sMAttributeUpdateDataArray = this.convertVector2Array(this.saveData);
            if (this.source1Set) {
                this.dataSource1.updateAttributes(this.url, sMAttributeUpdateDataArray);
            } else {
                if (this.forColumn) {
                    this.dataSource2.updateAttributes(this.url, sMAttributeUpdateDataArray, true);
                }
                this.dataSource2.updateAttributes(this.url, sMAttributeUpdateDataArray);
            }
        } else {
            sMAttributeUpdateDataArray = this.convertVector2Array(this.saveData);
            if (this.source1Set) {
                int n3 = 0;
                while (n3 < this.numberOfObjects) {
                    this.dataSource1.updateAttributes(this.urls[n3], sMAttributeUpdateDataArray);
                    ++n3;
                }
            } else {
                int n4 = 0;
                while (n4 < this.numberOfObjects) {
                    this.dataSource2.updateAttributes(this.urls[n4], sMAttributeUpdateDataArray);
                    ++n4;
                }
            }
        }
        this.notifySaved();
        int n5 = 0;
        while (n5 < this.saveData.size()) {
            string = ((SMAttributeUpdateData)this.saveData.elementAt(n5)).getGroup();
            int n6 = (Integer)this.groupKeyIndex.get(string);
            this.allAttributes.setElementAt(new SMAttributeEntryData[1], n6);
            this.update();
            ++n5;
        }
        this.updateOriginal();
        this.saveData.removeAllElements();
        this.saveData = new Vector();
        if (this.moduleBuilderAgentIP != null) {
            CmBrowserConsole.refreshModuleBuilder(this.moduleBuilderAgentIP);
        }
    }

    public void setAttEditedFont(Font font) {
        this.attEditedFont = font;
    }

    public void setAttNameFont(Font font) {
        this.attNameFont = font;
    }

    public void setAttValueBackground(Color color) {
        this.attValueBackground = color;
    }

    public void setAttValueFont(Font font) {
        this.attValueFont = font;
    }

    public void setAttValueForeground(Color color) {
        this.attValueForeground = color;
    }

    public void setChosenAttBackground(Color color) {
        this.chosenAttBackground = color;
    }

    public void setChosenAttForeground(Color color) {
        this.chosenAttForeground = color;
    }

    public void setDataSource(CtEditorDataSource ctEditorDataSource) {
        if (!this.source2Set) {
            this.dataSource1 = ctEditorDataSource;
            if ((this.url != null || this.urls != null) && this.LARSet) {
                this.initialize();
            }
            this.source1Set = true;
        }
    }

    public void setDataSource(SMRawDataRequest sMRawDataRequest) {
        this.rawDataSource = sMRawDataRequest;
        if (!this.source1Set) {
            this.dataSource2 = new SMManagedEntityRequest(sMRawDataRequest);
            if ((this.url != null || this.urls != null) && this.LARSet) {
                this.initialize();
            }
            this.source2Set = true;
        }
    }

    public CtEditorDataSource getEditorDataSource() {
        return this.dataSource1;
    }

    public SMRawDataRequest getDataSource() {
        return this.rawDataSource;
    }

    public String getEditObject() {
        return this.url;
    }

    public void setEditObject(String string) {
        int n;
        if (string.indexOf("mod/builder") > 0 && string.indexOf("root") > 0 && (n = string.indexOf("snmp://")) >= 0) {
            this.moduleBuilderAgentIP = string.substring(n + 7);
            n = this.moduleBuilderAgentIP.indexOf(47);
            this.moduleBuilderAgentIP = this.moduleBuilderAgentIP.substring(0, n);
        }
        this.url = string;
        if ((this.source1Set || this.source2Set) && this.LARSet) {
            this.initialize();
        }
    }

    public void setEditObjects(String[] stringArray) {
        this.numberOfObjects = stringArray.length;
        this.urls = new String[this.numberOfObjects];
        int n = 0;
        while (n < this.numberOfObjects) {
            this.urls[n] = stringArray[n];
            ++n;
        }
        if ((this.source1Set || this.source2Set) && this.LARSet) {
            this.initialize();
        }
    }

    public void setEditedForeground(Color color) {
        this.editedForeground = color;
    }

    public void setEditorSize(Dimension dimension) {
        this.editorSize = dimension;
    }

    public void setFocusedBorderColor(Color color) {
        this.focusedBorderColor = color;
    }

    public void setHeaderFont(Font font) {
        this.headerFont = font;
    }

    public void setHeaderForeground(Color color) {
        this.headerForeground = color;
    }

    public void setLabelForeground(Color color) {
        this.labelForeground = color;
    }

    public void setLoadAsRequired(boolean bl) {
        this.loadAsRequired = bl;
        this.LARSet = true;
        if ((this.url != null || this.urls != null) && (this.source1Set || this.source2Set)) {
            this.initialize();
        }
    }

    private void setNewAtt(String string, String string2, String string3) {
        int n = (Integer)this.groupKeyIndex.get(string);
        SMAttributeEntryData[] sMAttributeEntryDataArray = (SMAttributeEntryData[])this.allAttributes.elementAt(n);
        int n2 = 0;
        while (n2 < sMAttributeEntryDataArray.length) {
            SMAttributeEntryData sMAttributeEntryData = sMAttributeEntryDataArray[n2];
            if (sMAttributeEntryData != null && sMAttributeEntryData.getKey().equals(string2)) {
                SMAttributeEntryData sMAttributeEntryData2;
                sMAttributeEntryDataArray[n2] = sMAttributeEntryData2 = new SMAttributeEntryData(string2, sMAttributeEntryData.getDescId(), sMAttributeEntryData.getAccess(), sMAttributeEntryData.getRequired(), sMAttributeEntryData.getType(), sMAttributeEntryData.getFormat(), string3, sMAttributeEntryData.getDefault());
            }
            ++n2;
        }
        this.allAttributes.setElementAt(sMAttributeEntryDataArray, n);
    }

    public void setNonEditableBackground(Color color) {
        this.nonEditableBackground = color;
    }

    public void setNonEditableForeground(Color color) {
        this.nonEditableForeground = color;
    }

    public void setTabTitleFont(Font font) {
        this.tabTitleFont = font;
    }

    protected void update() {
        Component component;
        Window window;
        JScrollBar jScrollBar;
        JComponent jComponent;
        CtScrollPanel ctScrollPanel;
        SMAttributeEntryData[] sMAttributeEntryDataArray;
        try {
            this.selectedIndex = this.tabPane.getSelectedIndex();
            this.currentGroup = this.attGroups[this.selectedIndex];
            this.currentGroupKey = this.currentGroup.getGroupKey();
            sMAttributeEntryDataArray = (SMAttributeEntryData[])this.allAttributes.elementAt(this.selectedIndex);
            if (sMAttributeEntryDataArray == null || sMAttributeEntryDataArray.length == 0 || sMAttributeEntryDataArray[0] == null) {
                this.currentAtt = this.numberOfObjects == 1 ? (this.source1Set ? this.dataSource1.getAttributeEntries(this.url, this.currentGroupKey) : this.dataSource2.getAttributeEntries(this.url, this.currentGroupKey)) : this.getCommonAttributeEntries(this.currentGroupKey);
                this.allAttributes.setElementAt(this.currentAtt, this.selectedIndex);
                this.originalAttributes.setElementAt(this.currentAtt, this.selectedIndex);
                ctScrollPanel = this.makeListPanel(this.currentGroupKey, this.currentAtt);
                jComponent = new ListPanel(ctScrollPanel);
                this.tabPane.setComponentAt(this.selectedIndex, jComponent);
            } else {
                this.currentAtt = (SMAttributeEntryData[])this.allAttributes.elementAt(this.selectedIndex);
            }
        }
        catch (SMAttributeDataException sMAttributeDataException) {
            // empty catch block
        }
        this.currentPanel = this.getCurrentPanel();
        sMAttributeEntryDataArray = (SMAttributeEntryData[])this.tabPane.getComponentAt(this.selectedIndex);
        ctScrollPanel = sMAttributeEntryDataArray.getScrollPanel();
        jComponent = ctScrollPanel.getVerticalScrollBar();
        if (jComponent.isVisible()) {
            jComponent.setValue(0);
        }
        if ((jScrollBar = ctScrollPanel.getHorizontalScrollBar()).isVisible()) {
            jScrollBar.setValue(0);
        }
        if ((window = this.getTopWindow()) != null && (component = window.getFocusOwner()) instanceof CtFocusTraversable) {
            ((CtFocusTraversable)((Object)component)).notifyFocusChange();
        }
        this.validate();
    }

    void updateSaveData(SMAttributeUpdateData sMAttributeUpdateData) {
        if (this.alreadyEdited(sMAttributeUpdateData = new SMAttributeUpdateData(sMAttributeUpdateData.getGroup(), sMAttributeUpdateData.getKey(), sMAttributeUpdateData.getValue().trim())) == -1) {
            this.saveData.addElement(sMAttributeUpdateData);
        } else {
            this.saveData.setElementAt(sMAttributeUpdateData, this.alreadyEdited(sMAttributeUpdateData));
        }
    }

    void verifyRequiredData() throws CtEditorISDException {
        int n = 0;
        while (n < this.groupSize) {
            SMAttributeEntryData[] sMAttributeEntryDataArray = (SMAttributeEntryData[])this.allAttributes.elementAt(n);
            if (sMAttributeEntryDataArray.length != 0 && sMAttributeEntryDataArray != null && sMAttributeEntryDataArray[0] != null) {
                int n2 = 0;
                while (n2 < sMAttributeEntryDataArray.length) {
                    SMAttributeEntryData sMAttributeEntryData = sMAttributeEntryDataArray[n2];
                    boolean bl = sMAttributeEntryData.getRequired();
                    String string = sMAttributeEntryData.getValue();
                    String string2 = sMAttributeEntryData.getKey();
                    if (bl && (string == null || string.length() == 0)) {
                        this.tabPane.setSelectedIndex(n);
                        JComponent jComponent = this.currentPanel.getInvalidField(string2);
                        if (jComponent != null) {
                            jComponent.requestFocus();
                        }
                        throw new CtEditorISDException("\"" + sMAttributeEntryData.getDescId() + "\" " + this.requiredMesg, new SMAttributeUpdateData("", "", ""));
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    public String translate(String string) {
        return UcInternationalizer.translateKey((String)("base.console.tools.editor.Messages:" + string));
    }

    private JFrame getTopFrame() {
        Container container = this;
        while (container != null) {
            if (container instanceof JFrame) {
                return (JFrame)container;
            }
            container = container.getParent();
        }
        return null;
    }
}

