/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.logview;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRequestStatus;
import com.sun.symon.base.client.log.SMLogViewerRequest;
import com.sun.symon.base.client.log.SMLogViewerResponse;
import com.sun.symon.base.console.logview.LogPanel;
import com.sun.symon.base.console.logview.TailListener;
import com.sun.symon.base.utility.UcDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

class TailListener
extends JDialog
implements ActionListener {
    private LogPanel logPanel;
    private JCheckBox enableTail;
    private JCheckBox clearArea;
    private JTextField patternText;
    private boolean changed = false;
    private boolean enable = false;
    private boolean clear = false;
    private String pattern = "";
    private TailOKListener tailOKListener;
    private JLabel status;

    public SMLogViewerRequest getLogRequest() {
        return this.tailOKListener.getLogRequest();
    }

    public TailListener(LogPanel logPanel, Frame frame) {
        super(frame);
        this.logPanel = logPanel;
        this.setTitle(this.logPanel.translate("monitorFilterOptions"));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Container container = this.getContentPane();
        container.setLayout(gridBagLayout);
        this.enableTail = new JCheckBox(this.logPanel.translate("enableMonitoring"));
        this.enableTail.setSelected(this.enable);
        this.enableTail.setMnemonic(this.logPanel.translate("enableMonitoring.mnemonic").charAt(0));
        gridBagConstraints.insets = new Insets(17, 17, 0, 17);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        container.add((Component)this.enableTail, gridBagConstraints);
        this.clearArea = new JCheckBox(this.logPanel.translate("clearMessages"));
        this.clearArea.setSelected(this.clear);
        this.clearArea.setMnemonic(this.logPanel.translate("clearMessages.mnemonic").charAt(0));
        gridBagConstraints.insets = new Insets(10, 17, 0, 17);
        container.add((Component)this.clearArea, gridBagConstraints);
        JLabel jLabel = new JLabel(this.logPanel.translate("textToMatch"));
        jLabel.setForeground(Color.black);
        gridBagConstraints.insets = new Insets(21, 17, 0, 0);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 12;
        container.add((Component)jLabel, gridBagConstraints);
        this.patternText = new JTextField(15);
        this.patternText.setMargin(new Insets(1, 2, 1, 0));
        jLabel.setDisplayedMnemonic(this.logPanel.translate("textToMatch.mnemonic").charAt(0));
        jLabel.setLabelFor(this.patternText);
        if (this.changed) {
            this.patternText.setText(this.pattern);
        } else {
            this.patternText.setText(this.logPanel.getFilter().getPattern());
        }
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(17, 6, 0, 17);
        gridBagConstraints.anchor = 10;
        container.add((Component)this.patternText, gridBagConstraints);
        gridBagConstraints.insets = new Insets(17, 5, 0, 5);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        container.add((Component)new JSeparator(), gridBagConstraints);
        JPanel jPanel = new JPanel(new FlowLayout(2, 6, 0));
        JButton jButton = new JButton(this.logPanel.translate("ok"));
        JButton jButton2 = new JButton(this.logPanel.translate("apply"));
        jButton2.setMnemonic(this.logPanel.translate("apply.mnemonic").charAt(0));
        this.tailOKListener = new TailOKListener();
        jButton.addActionListener(this.tailOKListener);
        jButton2.addActionListener(this.tailOKListener);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jButton.setActionCommand("OK");
        JButton jButton3 = new JButton(this.logPanel.translate("cancel"));
        class TailCancelListener
        implements ActionListener {
            private final /* synthetic */ TailListener this$0;

            TailCancelListener(TailListener tailListener) {
                this.this$0 = tailListener;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)this.this$0).setVisible(false);
                this.this$0.initTailListener();
            }
        }
        jButton3.addActionListener(new TailCancelListener(this));
        jButton3.registerKeyboardAction(new TailCancelListener(this), KeyStroke.getKeyStroke(27, 0), 2);
        jPanel.add(jButton3);
        gridBagConstraints.insets = new Insets(10, 0, 10, 12);
        gridBagConstraints.gridwidth = 0;
        container.add((Component)jPanel, gridBagConstraints);
        this.getRootPane().setDefaultButton(jButton);
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isVisible()) {
            this.show();
            return;
        }
        ((Component)this).setVisible(true);
    }

    void initTailListener() {
        this.enableTail.setSelected(this.enable);
        this.clearArea.setSelected(this.clear);
        if (this.changed) {
            this.patternText.setText(this.pattern);
        } else {
            this.patternText.setText(this.logPanel.getFilter().getPattern());
        }
    }

    class TailOKListener
    implements ActionListener,
    SMLogViewerResponse {
        private SMLogViewerRequest tailReq = null;
        private boolean newPattern;
        private Object[] oneOption = new Object[]{TailListener.access$100(TailListener.this).translate("ok")};

        TailOKListener() {
        }

        private SMLogViewerRequest getLogRequest() {
            return this.tailReq;
        }

        public void logSearchResponse(SMRequestStatus sMRequestStatus, StringBuffer stringBuffer, Object object) {
            if (sMRequestStatus.getReturnCode() != 0) {
                UcDialog.showSMAPIerror((String)TailListener.this.logPanel.translate("logSearchError"), (SMRequestStatus)sMRequestStatus);
                return;
            }
            if (this.tailReq != null && stringBuffer != null) {
                TailListener.this.logPanel.setTailArea(stringBuffer.toString());
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component = (Component)actionEvent.getSource();
            TailListener.this.changed = true;
            if (TailListener.this.clearArea.isSelected()) {
                TailListener.this.clear = true;
                TailListener.this.logPanel.setTailArea("");
            } else {
                TailListener.this.clear = false;
            }
            String string = TailListener.this.patternText.getText().trim();
            this.newPattern = !string.equals(TailListener.this.pattern);
            TailListener.this.pattern = string;
            if (TailListener.this.enableTail.isSelected() && (this.tailReq == null || TailListener.this.logPanel.getNewFile()) || this.newPattern) {
                TailListener.this.enable = true;
                TailListener.this.logPanel.setNewFile(false);
                try {
                    if (this.tailReq != null) {
                        this.tailReq.closeConnection();
                    }
                    this.tailReq = new SMLogViewerRequest(TailListener.this.logPanel.getRawHandle(), TailListener.this.logPanel.getAgentHost(), TailListener.this.logPanel.getAgentPort());
                    this.tailReq.logSearch(TailListener.this.logPanel.getCurrentType(), TailListener.this.logPanel.getCurrentPath(), TailListener.this.pattern, (SMLogViewerResponse)this, new Object());
                }
                catch (SMAPIException sMAPIException) {
                    UcDialog.showSMAPIexception((String)TailListener.this.logPanel.translate("monitorReqFailed"), (SMAPIException)sMAPIException);
                    return;
                }
            }
            if (!TailListener.this.enableTail.isSelected()) {
                TailListener.this.enable = false;
                if (this.tailReq != null) {
                    try {
                        this.tailReq.closeConnection();
                    }
                    catch (SMAPIException sMAPIException) {
                        // empty catch block
                    }
                }
                this.tailReq = null;
            }
            if (actionEvent.getActionCommand().compareTo("OK") == 0) {
                ((Component)TailListener.this).setVisible(false);
            }
        }
    }
}

