/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.alarms;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.alarm.SMAlarmPageAsyncRequest;
import com.sun.symon.base.console.alarms.AlarmData;
import com.sun.symon.base.console.alarms.AlarmList;
import com.sun.symon.base.console.alarms.AlarmPanel;
import com.sun.symon.base.console.alarms.AlarmTable;
import com.sun.symon.base.console.alarms.FailedOperation;
import com.sun.symon.base.utility.UcDialog;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ListSelectionModel;

class DeleteListener
implements ActionListener {
    AlarmPanel ap;

    public DeleteListener(AlarmPanel alarmPanel) {
        this.ap = alarmPanel;
    }

    public void cleanUp() {
        this.ap = null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        AlarmTable alarmTable = this.ap.getAlarmTable();
        AlarmList alarmList = alarmTable.getAlarmList();
        AlarmData[] alarmDataArray = alarmTable.getAlarmData();
        String[] stringArray = alarmTable.getSelectedIDs();
        int n = alarmTable.getSelectedRowCount();
        int[] nArray = alarmTable.getSelectedRows();
        ListSelectionModel listSelectionModel = alarmTable.getSelectionModel();
        Vector vector = new Vector();
        Component component = (Component)actionEvent.getSource();
        Window window = this.ap.getAlarmWindow(component);
        SMAlarmPageAsyncRequest sMAlarmPageAsyncRequest = this.ap.getRequestHandle();
        if (sMAlarmPageAsyncRequest == null) {
            return;
        }
        if (n == 0) {
            UcDialog.showOk((String)this.ap.translate("pleaseSelectAnAlarm"));
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            AlarmData alarmData = (AlarmData)alarmList.get(nArray[n2]);
            if (!alarmData.isAcked() && alarmData.stateIndex != 1) {
                UcDialog.showOk((String)this.ap.translate("cannotDelUnackAlarms"));
                return;
            }
            ++n2;
        }
        int n3 = UcDialog.showOkCancel((String)this.ap.translate("okToDelete"));
        if (n3 == 1) {
            return;
        }
        try {
            vector = sMAlarmPageAsyncRequest.deleteAlarms(alarmTable.getSelectedIDs(), null);
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showSMAPIexception((String)this.ap.translate("deleteException"), (SMAPIException)sMAPIException);
            return;
        }
        if (vector != null) {
            FailedOperation.display(window, vector, alarmTable.getAlarmData(), this.ap.translate("unableToDelete"), this.ap);
        }
        this.ap.setClear(true);
        alarmTable.selectAlarms();
    }
}

