/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.view;

import com.sun.symon.base.client.service.SMDBChangeEvent;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMDBRemoteChangeListener;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.framework.MSBaseService;
import com.sun.symon.base.mgmtservice.framework.MSBaseServiceInterface;
import com.sun.symon.base.mgmtservice.framework.MSServiceLocator;
import com.sun.symon.base.mgmtservice.framework.MSServiceProvider;
import com.sun.symon.base.mgmtservice.view.MvMulticasterRecord;
import com.sun.symon.base.mgmtservice.view.MvViewConstants;
import com.sun.symon.base.mgmtservice.view.MvViewService;
import com.sun.symon.base.server.common.ScSecurityCredential;
import java.util.Hashtable;

public class MvViewController
implements MSServiceLocator,
MSServiceProvider,
MvViewConstants {
    private Hashtable securityMap;
    private Hashtable multicasters;
    private MSLogPrintWriter logWriter;
    private MSLogPrintWriter errorWriter;
    private static MvViewController controller;

    public static MvViewController getInstance() {
        return controller;
    }

    public MvViewController(String string) {
        controller = this;
        this.multicasters = new Hashtable();
        this.securityMap = new Hashtable();
        this.logWriter = MSLogPrintWriter.getInfoWriter();
        this.errorWriter = MSLogPrintWriter.getErrorWriter();
    }

    public MSLogPrintWriter getLogWriter() {
        return this.logWriter;
    }

    public MSLogPrintWriter getErrorWriter() {
        return this.errorWriter;
    }

    public void addViewChangeListener(MSBaseService mSBaseService, SMDBRemoteChangeListener sMDBRemoteChangeListener, int n) {
        MvMulticasterRecord mvMulticasterRecord = (MvMulticasterRecord)this.multicasters.get(new Integer(n));
        if (mvMulticasterRecord != null) {
            mvMulticasterRecord.addListener(mSBaseService, sMDBRemoteChangeListener);
        } else {
            mvMulticasterRecord = new MvMulticasterRecord(n);
            mvMulticasterRecord.addListener(mSBaseService, sMDBRemoteChangeListener);
            this.multicasters.put(new Integer(n), mvMulticasterRecord);
        }
    }

    public void removeViewChangeListener(MSBaseService mSBaseService, SMDBRemoteChangeListener sMDBRemoteChangeListener, int n) {
        MvMulticasterRecord mvMulticasterRecord = (MvMulticasterRecord)this.multicasters.get(new Integer(n));
        if (mvMulticasterRecord != null) {
            mvMulticasterRecord.removeListener(mSBaseService, sMDBRemoteChangeListener);
        }
    }

    public void notifyChanges(SMDBChangeEvent sMDBChangeEvent) {
    }

    public void notifyChanges(SMDBObjectID sMDBObjectID, int n, int n2) {
        SMDBChangeEvent sMDBChangeEvent = new SMDBChangeEvent(sMDBObjectID, n2);
        MvMulticasterRecord mvMulticasterRecord = (MvMulticasterRecord)this.multicasters.get(new Integer(n));
        if (mvMulticasterRecord != null) {
            mvMulticasterRecord.notify(sMDBChangeEvent);
        }
        if (n == 0) {
            return;
        }
        mvMulticasterRecord = (MvMulticasterRecord)this.multicasters.get(new Integer(0));
        if (mvMulticasterRecord != null) {
            mvMulticasterRecord.notify(sMDBChangeEvent);
        }
    }

    public MSServiceProvider register() {
        return this;
    }

    public MSBaseServiceInterface getService(ScSecurityCredential scSecurityCredential, String string) throws Exception {
        return new MvViewService(scSecurityCredential, string);
    }
}

