/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.task;

import com.sun.symon.base.client.SMMessageI18nKey;
import com.sun.symon.base.client.service.SMSecurityException;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.common.MSSecurity;
import com.sun.symon.base.server.common.ScSecurityCredential;
import java.util.Hashtable;

public class MtTaskSecurity {
    static final String EDIT = "edit";
    static final String DELETE = "delete";
    static final String EXECUTE = "execute";
    private static final String ANYUSER = "ANYUSER";
    private static final String ANYGROUP = "ANYGROUP";
    private static final String DENY_USER = ".denyUser";
    private static final String DENY_GROUP = ".denyGroup";
    private static final String ALLOW_USER = ".allowUser";
    private static final String ALLOW_GROUP = ".allowGroup";
    private static MtTaskSecurity instance_;
    private Hashtable acl_ = new Hashtable();
    private static String i18nBase_;
    static /* synthetic */ Class class$com$sun$symon$base$mgmtservice$task$MtTaskSecurity;

    static MtTaskSecurity getInstance() throws SMSecurityException {
        if (instance_ == null) {
            Class clazz = class$com$sun$symon$base$mgmtservice$task$MtTaskSecurity == null ? (class$com$sun$symon$base$mgmtservice$task$MtTaskSecurity = MtTaskSecurity.class$("com.sun.symon.base.mgmtservice.task.MtTaskSecurity")) : class$com$sun$symon$base$mgmtservice$task$MtTaskSecurity;
            synchronized (clazz) {
                if (instance_ == null) {
                    instance_ = new MtTaskSecurity();
                }
            }
        }
        return instance_;
    }

    private MtTaskSecurity() throws SMSecurityException {
        MSLogPrintWriter.getDebugWriter().println("Task Security: initialized");
    }

    void checkAccess(String string, String string2, ScSecurityCredential scSecurityCredential) throws SMSecurityException {
        this.checkValidOperation(string2);
        String string3 = string + "." + string2;
        String string4 = "," + scSecurityCredential.getUser() + ",";
        String string5 = string3 + DENY_USER;
        String string6 = (String)this.acl_.get(string5);
        if (string6 != null) {
            if (string6.equals(ANYUSER)) {
                SMSecurityException sMSecurityException = new SMSecurityException("All users denied access on " + string3);
                sMSecurityException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "allUsersDeniedAccess"));
                throw sMSecurityException;
            }
            if (string6.indexOf(string4) >= 0) {
                SMSecurityException sMSecurityException = new SMSecurityException("User denied access on " + string3);
                sMSecurityException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "userNotAllowed"));
                throw sMSecurityException;
            }
        }
        if ((string6 = (String)this.acl_.get(string5 = string3 + DENY_GROUP)) != null) {
            if (string6.equals(ANYGROUP)) {
                SMSecurityException sMSecurityException = new SMSecurityException("All groups denied access on " + string3);
                sMSecurityException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "allGroupsDeniedAccess"));
                throw sMSecurityException;
            }
            if (MSSecurity.areGroupsInList((String[])scSecurityCredential.getGroupArray(), (String)string6)) {
                SMSecurityException sMSecurityException = new SMSecurityException("Group access denied on " + string3);
                sMSecurityException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "groupAccessDenied"));
                throw sMSecurityException;
            }
        }
        if ((string6 = (String)this.acl_.get(string5 = string3 + ALLOW_USER)) != null) {
            if (string6.equals(ANYUSER)) {
                return;
            }
            if (string6.indexOf(string4) >= 0) {
                return;
            }
        }
        if ((string6 = (String)this.acl_.get(string5 = string3 + ALLOW_GROUP)) != null) {
            if (string6.equals(ANYGROUP)) {
                return;
            }
            if (MSSecurity.areGroupsInList((String[])scSecurityCredential.getGroupArray(), (String)string6)) {
                return;
            }
        }
        SMSecurityException sMSecurityException = new SMSecurityException("User not allowed on " + string3);
        sMSecurityException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "userNotAllowed"));
        throw sMSecurityException;
    }

    void defineDenyUser(String string, String string2, String string3) throws SMSecurityException {
        this.defineAccess(string, string2, DENY_USER, string3);
    }

    void defineDenyGroup(String string, String string2, String string3) throws SMSecurityException {
        this.defineAccess(string, string2, DENY_GROUP, string3);
    }

    void defineAllowUser(String string, String string2, String string3) throws SMSecurityException {
        this.defineAccess(string, string2, ALLOW_USER, string3);
    }

    void defineAllowGroup(String string, String string2, String string3) throws SMSecurityException {
        this.defineAccess(string, string2, ALLOW_GROUP, string3);
    }

    void defineAccess(String string, String string2, String string3, String string4) throws SMSecurityException {
        this.checkValidOperation(string2);
        String string5 = string + "." + string2 + string3;
        if (this.acl_.containsKey(string5)) {
            SMSecurityException sMSecurityException = new SMSecurityException("Duplicate ACL: " + string5);
            sMSecurityException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "duplicateACL"));
            throw sMSecurityException;
        }
        if (!(string4 = string4.trim()).equals(ANYUSER) && !string4.equals(ANYGROUP)) {
            string4 = "," + string4 + ",";
        }
        this.acl_.put(string5, string4);
    }

    private void checkValidOperation(String string) throws SMSecurityException {
        if (!(string.equals(EDIT) || string.equals(DELETE) || string.equals(EXECUTE))) {
            SMSecurityException sMSecurityException = new SMSecurityException("Invalid task operation: " + string);
            sMSecurityException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "invalidTaskOperation"));
            throw sMSecurityException;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        i18nBase_ = "com.sun.symon.base.client.ClientApiMessages";
    }
}

