/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.task;

import com.sun.symon.base.client.SMMessageI18nKey;
import com.sun.symon.base.client.group.SMObjectGroupData;
import com.sun.symon.base.client.mcp.SMParcelData;
import com.sun.symon.base.client.service.SMDatabaseException;
import com.sun.symon.base.client.service.SMSecurityException;
import com.sun.symon.base.client.task.SMTaskData;
import com.sun.symon.base.client.task.SMTaskOperationData;
import com.sun.symon.base.client.task.SMTaskRequestData;
import com.sun.symon.base.client.task.SMTaskRequestLogData;
import com.sun.symon.base.client.task.SMTaskRequestLogEvent;
import com.sun.symon.base.client.task.SMTaskType;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.common.MSProperties;
import com.sun.symon.base.mgmtservice.common.MSURLUTFConverter;
import com.sun.symon.base.mgmtservice.mcp.MmMCPImpl;
import com.sun.symon.base.mgmtservice.mcp.MmMCPService;
import com.sun.symon.base.mgmtservice.task.MtDefaultErrorInterpreter;
import com.sun.symon.base.mgmtservice.task.MtErrorInfo;
import com.sun.symon.base.mgmtservice.task.MtErrorInterpreter;
import com.sun.symon.base.mgmtservice.task.MtTaskCommand;
import com.sun.symon.base.mgmtservice.task.MtTaskDescriptor;
import com.sun.symon.base.mgmtservice.task.MtTaskRequestLogImpl;
import com.sun.symon.base.mgmtservice.task.MtTaskRequestLogRemover;
import com.sun.symon.base.mgmtservice.task.MtTaskRequestLogService;
import com.sun.symon.base.server.common.ScSecurityCredential;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.crimson.tree.XmlDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MtTaskRequestLog {
    protected SMTaskRequestData request_;
    protected SMObjectGroupData group_;
    protected SMTaskData task_;
    protected ScSecurityCredential user_;
    protected long startTime_;
    protected long stopTime_;
    protected int status_ = 0;
    protected SMTaskOperationData[] operations_;
    protected int errorCount_ = 0;
    protected TreeMap agentMap_ = new TreeMap();
    protected MtDefaultErrorInterpreter defaultErrorInterpreter_ = new MtDefaultErrorInterpreter();
    protected PrintWriter error_ = MSLogPrintWriter.getErrorWriter();
    protected String messageKey_ = "";
    protected String file_ = "";
    protected String relative_file_ = "";
    static MSLogPrintWriter errorWriter;
    private static final String CLASSNAME = "MtTaskRequestLog:: ";
    private static final String LOG_DIR = "log";
    private static final String TASKREQ_DIR = "taskreq";
    private static final String FILE_SEPARATOR;
    private static final String i18nBase_ = "com.sun.symon.base.client.ClientApiMessages";

    public MtTaskRequestLog(SMTaskRequestData sMTaskRequestData, SMObjectGroupData sMObjectGroupData, SMTaskData sMTaskData, ScSecurityCredential scSecurityCredential) {
        this.request_ = sMTaskRequestData;
        this.group_ = sMObjectGroupData;
        this.task_ = sMTaskData;
        this.user_ = scSecurityCredential;
        this.operations_ = this.task_.getOperations();
    }

    public void setTargetAgents(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            Result[] resultArray = new Result[this.operations_.length];
            int n2 = 0;
            while (n2 < resultArray.length) {
                resultArray[n2] = new Result();
                ++n2;
            }
            this.agentMap_.put(stringArray[n], resultArray);
            ++n;
        }
    }

    public void taskRequestStarted() {
        this.startTime_ = System.currentTimeMillis();
        this.status_ = 4;
        MtTaskRequestLogService.addCurrentLog(this.request_.getName(), this);
        this.fireEvent(new SMTaskRequestLogEvent(this.request_.getName(), this.status_, this.messageKey_, this.startTime_, this.stopTime_, TimeZone.getDefault()));
    }

    public void taskRequestStopped() {
        this.status_ = 1;
        this.stopTime_ = System.currentTimeMillis();
    }

    public void taskRequestStopped(int n, String string) {
        this.stopTime_ = System.currentTimeMillis();
        switch (n) {
            case 256: {
                this.status_ = 5;
                this.startTime_ = this.stopTime_;
                break;
            }
            case 16: {
                this.status_ = 2;
                break;
            }
            case 4: {
                this.status_ = 3;
                break;
            }
            default: {
                this.status_ = 0;
            }
        }
        this.messageKey_ = string;
    }

    public void taskOperationStarted(String string, int n) {
        try {
            Result[] resultArray = (Result[])this.agentMap_.get(string);
            resultArray[n].startTime = System.currentTimeMillis();
            this.fireEvent(new SMTaskRequestLogEvent(this.request_.getName(), string, n, 4, "", resultArray[n].startTime, 0L, TimeZone.getDefault()));
        }
        catch (Exception exception) {
            this.error_.println(exception);
        }
    }

    public void setOperationSuccess(String string, int n) {
        try {
            Result[] resultArray = (Result[])this.agentMap_.get(string);
            if (resultArray[n].stopTime == 0L) {
                resultArray[n].stopTime = System.currentTimeMillis();
            }
            resultArray[n].status = 1;
            this.fireEvent(new SMTaskRequestLogEvent(this.request_.getName(), string, n, 1, "", resultArray[n].startTime, resultArray[n].stopTime, TimeZone.getDefault()));
        }
        catch (Exception exception) {
            this.error_.println(exception);
        }
    }

    public void setOperationFailure(String string, int n, Throwable throwable) {
        try {
            Result[] resultArray = (Result[])this.agentMap_.get(string);
            resultArray[n].stopTime = System.currentTimeMillis();
            MtErrorInfo mtErrorInfo = new MtErrorInfo(string, this.task_, n, throwable);
            MtErrorInterpreter mtErrorInterpreter = this.getErrorInterpreter(this.operations_[n].getOperation());
            mtErrorInterpreter.handleError(mtErrorInfo);
            if (mtErrorInfo.isIgnoreError()) {
                this.setOperationSuccess(string, n);
                return;
            }
            resultArray[n].status = 2;
            resultArray[n].messageKey = mtErrorInfo.getErrorMessage();
            ++this.errorCount_;
            this.fireEvent(new SMTaskRequestLogEvent(this.request_.getName(), string, n, 2, resultArray[n].messageKey, resultArray[n].startTime, resultArray[n].stopTime, TimeZone.getDefault()));
        }
        catch (Exception exception) {
            this.error_.println(exception);
        }
    }

    public int getErrorCount() {
        return this.errorCount_;
    }

    public void close() {
        try {
            String string = MSURLUTFConverter.encode((String)this.request_.getName(), (char)'^');
            File file = new File(System.getProperty("ESDIR") + FILE_SEPARATOR + LOG_DIR + FILE_SEPARATOR + TASKREQ_DIR + FILE_SEPARATOR + string);
            file.mkdirs();
            String string2 = this.msecsToYYYYMMDDhhmmss(this.startTime_) + ".xml";
            this.file_ = file.getAbsolutePath() + FILE_SEPARATOR + string2;
            this.relative_file_ = string + FILE_SEPARATOR + string2;
            FileWriter fileWriter = new FileWriter(this.file_);
            fileWriter.write(this.toXML());
            fileWriter.close();
            SMTaskRequestLogData sMTaskRequestLogData = new SMTaskRequestLogData(null, this.request_.getName(), this.group_.getName(), this.group_.getDomain(), this.task_.getName(), this.startTime_, TimeZone.getDefault(), this.status_);
            sMTaskRequestLogData.setFile(this.relative_file_);
            sMTaskRequestLogData.setFileSize(new File(this.file_).length());
            this.saveToDatabase(sMTaskRequestLogData);
            MtTaskRequestLogService.removeCurrentLog(this.request_.getName());
            this.fireEvent(new SMTaskRequestLogEvent(this.request_.getName(), this.status_, this.messageKey_, this.startTime_, this.stopTime_, TimeZone.getDefault()));
            MtTaskRequestLogRemover.getInstance().checkTotalLogSize();
        }
        catch (Exception exception) {
            this.error_.println(exception);
        }
    }

    protected String toXML() {
        String string = "";
        try {
            Object object;
            Element element;
            int n;
            Element element2;
            int n2;
            Object object2;
            Object object3;
            int n3;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element3 = document.createElement("taskRequestLog");
            Element element4 = document.createElement("group");
            Element element5 = document.createElement("task");
            Element element6 = document.createElement("results");
            element3.setAttribute("startTime", "" + this.startTime_);
            element3.setAttribute("stopTime", "" + this.stopTime_);
            element3.setAttribute("timeZone", this.getTimeZoneString());
            element3.setAttribute("user", this.user_.getUser());
            element3.setAttribute("state", this.convertStatusToString(this.status_));
            element3.setAttribute("name", this.request_.getName());
            if (this.request_.getDescription() != null && !this.request_.getDescription().trim().equals("")) {
                element3.setAttribute("description", this.request_.getDescription());
            }
            if (this.status_ == 2 && !this.messageKey_.trim().equals("")) {
                element3.setAttribute("message", this.messageKey_);
            }
            element3.setAttribute("file", this.file_);
            element4.setAttribute("name", this.group_.getName());
            element4.setAttribute("domain", this.group_.getDomain());
            if (this.group_.getDescription() != null && !this.group_.getDescription().trim().equals("")) {
                element4.setAttribute("description", this.group_.getDescription());
            }
            Object object4 = "";
            String string2 = "";
            Iterator iterator = this.agentMap_.keySet().iterator();
            while (iterator.hasNext()) {
                n3 = 1;
                Object k = iterator.next();
                object3 = (String)k;
                object2 = (Result[])this.agentMap_.get(object3);
                int n4 = 0;
                while (n4 < ((E)object2).length) {
                    if (((Result)object2[n4]).status == 2) {
                        n3 *= 0;
                    }
                    ++n4;
                }
                if (n3 != 0) continue;
                n2 = ((String)object3).indexOf(":");
                if (n2 == -1) {
                    object4 = object3;
                    string2 = "161";
                } else {
                    object4 = ((String)object3).substring(0, n2);
                    string2 = ((String)object3).substring(n2 + 1);
                }
                element2 = document.createElement("agent");
                element2.setAttribute("host", (String)object4);
                element2.setAttribute("port", string2);
                element4.appendChild(element2);
                n = 0;
                while (n < ((E)object2).length) {
                    element = document.createElement("result");
                    element.setAttribute("host", (String)object4);
                    element.setAttribute("port", string2);
                    element.setAttribute("index", "" + n);
                    element.setAttribute("startTime", "" + ((Result)object2[n]).startTime);
                    element.setAttribute("stopTime", "" + ((Result)object2[n]).stopTime);
                    element.setAttribute("status", this.convertStatusToString(((Result)object2[n]).status));
                    if (((Result)object2[n]).status == 2 && ((Result)object2[n]).messageKey != null) {
                        element.setAttribute("message", ((Result)object2[n]).messageKey);
                    }
                    element6.appendChild(element);
                    ++n;
                }
            }
            object3 = this.agentMap_.keySet().iterator();
            while (object3.hasNext()) {
                n3 = 1;
                object2 = object3.next();
                String string3 = (String)object2;
                Result[] resultArray = (Result[])this.agentMap_.get(string3);
                n = 0;
                while (n < resultArray.length) {
                    if (resultArray[n].status == 2) {
                        n3 *= 0;
                    }
                    ++n;
                }
                if (n3 != 1) continue;
                int n5 = string3.indexOf(":");
                if (n5 == -1) {
                    object4 = string3;
                    string2 = "161";
                } else {
                    object4 = string3.substring(0, n5);
                    string2 = string3.substring(n5 + 1);
                }
                element2 = document.createElement("agent");
                element2.setAttribute("host", (String)object4);
                element2.setAttribute("port", string2);
                element4.appendChild(element2);
                int n6 = 0;
                while (n6 < resultArray.length) {
                    element = document.createElement("result");
                    element.setAttribute("host", (String)object4);
                    element.setAttribute("port", string2);
                    element.setAttribute("index", "" + n6);
                    element.setAttribute("startTime", "" + resultArray[n6].startTime);
                    element.setAttribute("stopTime", "" + resultArray[n6].stopTime);
                    element.setAttribute("status", this.convertStatusToString(resultArray[n6].status));
                    element6.appendChild(element);
                    ++n6;
                }
            }
            element5.setAttribute("size", "" + this.operations_.length);
            element5.setAttribute("typeID", this.task_.getTaskTypeString());
            SMTaskType sMTaskType = MtTaskDescriptor.getTaskType(this.task_.getTaskTypeString());
            if (sMTaskType != null) {
                element5.setAttribute("typeName", sMTaskType.getTaskTypeNameKey());
            } else {
                element5.setAttribute("typeName", this.task_.getTaskTypeString());
            }
            element5.setAttribute("name", this.task_.getName());
            if (this.task_.getDescription() != null && !this.task_.getDescription().trim().equals("")) {
                element5.setAttribute("description", this.task_.getDescription());
            }
            n2 = 0;
            while (n2 < this.operations_.length) {
                Element element7 = document.createElement("operation");
                element7.setAttribute("index", "" + n2);
                element7.setAttribute("command", this.operations_[n2].getOperation());
                String string4 = this.getExtraData();
                if (string4 != null) {
                    element7.setAttribute("operand", this.operations_[n2].getOperand() + string4);
                } else {
                    element7.setAttribute("operand", this.operations_[n2].getOperand());
                }
                element7.setAttribute("value", this.operations_[n2].getValue());
                element7.setAttribute("valueType", this.operations_[n2].getValueType());
                element7.setAttribute("userData", this.operations_[n2].getUserData());
                element7.setAttribute("async", "" + this.operations_[n2].isAsync());
                element5.appendChild(element7);
                ++n2;
            }
            element3.appendChild(element4);
            element3.appendChild(element5);
            element3.appendChild(element6);
            document.appendChild(element3);
            String string5 = "";
            try {
                object = MSProperties.getFile((String)"dtd/core/TaskRequestLog", (String)".dtd");
                string5 = ((File)object).getAbsolutePath();
            }
            catch (Exception exception) {
                errorWriter.println("MtTaskRequestLog:: toXML(): Exception", (Throwable)exception);
            }
            string5 = "file:///" + string5;
            object = new StringWriter();
            XmlDocument xmlDocument = (XmlDocument)document;
            xmlDocument.setDoctype(null, string5, null);
            xmlDocument.write((Writer)object, "UTF-8");
            string = ((StringWriter)object).toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public SMTaskRequestLogData getLogData() {
        SMTaskRequestLogData sMTaskRequestLogData = new SMTaskRequestLogData(null, this.request_.getName(), this.group_.getName(), this.group_.getDomain(), this.task_.getName(), this.startTime_, TimeZone.getDefault(), this.status_);
        sMTaskRequestLogData.setXML(this.toXML());
        return sMTaskRequestLogData;
    }

    protected String msecsToYYYYMMDDhhmmss(long l) {
        Date date = new Date(l);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String string = simpleDateFormat.format(date);
        return string;
    }

    protected String getTimeZoneString() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("zzz");
        String string = simpleDateFormat.format(date);
        return string;
    }

    protected String convertStateToString(int n) {
        String string = "";
        switch (n) {
            case 1: {
                string = "OK";
                break;
            }
            case 2: {
                string = "failure";
                break;
            }
            case 3: {
                string = "suspended";
                break;
            }
            default: {
                string = "unknown";
            }
        }
        return string;
    }

    protected String convertStatusToString(int n) {
        String string = "";
        switch (n) {
            case 1: {
                string = "OK";
                break;
            }
            case 2: {
                string = "failure";
                break;
            }
            case 5: {
                string = "notarget";
                break;
            }
            default: {
                string = "unknown";
            }
        }
        return string;
    }

    protected String convertStatusToChar(int n) {
        String string = "";
        switch (n) {
            case 1: {
                string = "1";
                break;
            }
            case 2: {
                string = "2";
                break;
            }
            case 3: {
                string = "3";
                break;
            }
            default: {
                string = "0";
            }
        }
        return string;
    }

    protected void fireEvent(SMTaskRequestLogEvent sMTaskRequestLogEvent) {
        MtTaskRequestLogService.getLogContentsChangeMulticaster().fireEvent(sMTaskRequestLogEvent);
    }

    protected void saveToDatabase(SMTaskRequestLogData sMTaskRequestLogData) throws SMDatabaseException, SMSecurityException {
        try {
            MtTaskRequestLogImpl mtTaskRequestLogImpl = MtTaskRequestLogService.getTaskRequestLogImpl(this.user_);
            mtTaskRequestLogImpl.save(sMTaskRequestLogData);
        }
        catch (Exception exception) {
            SMSecurityException sMSecurityException = new SMSecurityException((Throwable)exception);
            sMSecurityException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "securityException"));
            throw sMSecurityException;
        }
    }

    private MtErrorInterpreter getErrorInterpreter(String string) {
        MtTaskCommand mtTaskCommand = MtTaskDescriptor.getTaskCommand(string);
        if (mtTaskCommand == null) {
            return this.defaultErrorInterpreter_;
        }
        String string2 = mtTaskCommand.getErrorInterpreterClass();
        if (string2 == null) {
            return this.defaultErrorInterpreter_;
        }
        try {
            return (MtErrorInterpreter)Class.forName(string2).newInstance();
        }
        catch (Exception exception) {
            return this.defaultErrorInterpreter_;
        }
    }

    private String getExtraData() {
        if (!this.task_.getTaskTypeString().trim().equals("Core_MCP")) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            MmMCPImpl mmMCPImpl = MmMCPService.getMCPImpl((ScSecurityCredential)this.user_);
            SMParcelData sMParcelData = mmMCPImpl.load(this.operations_[0].getValue());
            String[] stringArray = sMParcelData.getModules();
            if (stringArray != null && stringArray.length > 0) {
                stringBuffer.append(";");
                n = 0;
                while (n < stringArray.length) {
                    stringBuffer.append(stringArray[n]);
                    if (n < stringArray.length - 1) {
                        stringBuffer.append(",");
                    }
                    ++n;
                }
            } else {
                stringBuffer.append(";");
                stringBuffer.append("");
            }
            String[] stringArray2 = sMParcelData.getScripts();
            if (stringArray2 != null && stringArray2.length > 0) {
                stringBuffer.append(";");
                n = 0;
                while (n < stringArray2.length) {
                    stringBuffer.append(stringArray2[n]);
                    if (n < stringArray2.length - 1) {
                        stringBuffer.append(",");
                    }
                    ++n;
                }
            } else {
                stringBuffer.append(";");
                stringBuffer.append("");
            }
        }
        catch (Exception exception) {
            return null;
        }
        return stringBuffer.toString();
    }

    static {
        FILE_SEPARATOR = System.getProperty("file.separator");
        errorWriter = MSLogPrintWriter.getErrorWriter();
    }

    class Result {
        protected int status = 0;
        protected String messageKey = "";
        protected long startTime = 0L;
        protected long stopTime = 0L;

        Result() {
        }
    }
}

