/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.group;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMMessageI18nKey;
import com.sun.symon.base.client.group.SMObjectGroupData;
import com.sun.symon.base.client.group.SMObjectGroupInfo;
import com.sun.symon.base.client.group.SMRemoteObjectGroup;
import com.sun.symon.base.client.service.SMDBChangeEvent;
import com.sun.symon.base.client.service.SMDBConcurrencyTimestamp;
import com.sun.symon.base.client.service.SMDBObject;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMDBRemoteChangeListener;
import com.sun.symon.base.client.service.SMDatabaseException;
import com.sun.symon.base.client.service.SMDuplicateException;
import com.sun.symon.base.client.service.SMNoSuchObjectException;
import com.sun.symon.base.client.service.SMSecurityException;
import com.sun.symon.base.client.service.SMStaleDataException;
import com.sun.symon.base.mgmtservice.common.MSDB;
import com.sun.symon.base.mgmtservice.common.MSSecurity;
import com.sun.symon.base.mgmtservice.framework.MSBaseService;
import com.sun.symon.base.mgmtservice.group.HostResolver;
import com.sun.symon.base.mgmtservice.group.MgObjectGroupService;
import com.sun.symon.base.server.common.ScSecurityCredential;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;
import oracle.jdbc.driver.OracleResultSet;

public class MgObjectGroupImpl
extends MSBaseService
implements SMRemoteObjectGroup {
    private static final String SP_DELETEGROUPBYOBJECT = "{call DELETEGROUPBYOBJECT(?)}";
    private static final int SP_DELETEGROUPBYOBJECT_OBJECT_GROUP_ID = 1;
    private static final String SP_DELETEOBJECTGROUP = "{call DELETEOBJECTGROUP(?)}";
    private static final int SP_DELETEOBJECTGROUP_OBJECT_GROUP_ID = 1;
    private static final String SP_GETALLOBJECTGROUPS = "{call GETALLOBJECTGROUPS(?)}";
    private static final int SP_GETALLOBJECTGROUPS_CSR = 1;
    private static final String SP_GETGROUPBYOBJECT = "{call GETGROUPBYOBJECT(?,?)}";
    private static final int SP_GETGROUPBYOBJECT_OBJECT_GROUP_ID = 1;
    private static final int SP_GETGROUPBYOBJECT_CSR = 2;
    private static final String SP_GETOBJECTGROUP = "{call GETOBJECTGROUP(?,?,?)}";
    private static final int SP_GETOBJECTGROUP_OBJECT_GROUP_ID = 1;
    private static final int SP_GETOBJECTGROUP_OBJECT_GROUP_NAME = 2;
    private static final int SP_GETOBJECTGROUP_CSR = 3;
    private static final String SP_UPDATEGROUPBYOBJECT = "{call UPDATEGROUPBYOBJECT(?,?)}";
    private static final int SP_UPDATEGROUPBYOBJECT_OBJECT_GROUP_ID = 1;
    private static final int SP_UPDATEGROUPBYOBJECT_NAME = 2;
    private static final String SP_UPDATEOBJECTGROUP = "{call UPDATEOBJECTGROUP(?,?,?,?,?,?,?,?,?,?)}";
    private static final int SP_UPDATEOBJECTGROUP_OBJECT_GROUP_ID = 1;
    private static final int SP_UPDATEOBJECTGROUP_NAME = 2;
    private static final int SP_UPDATEOBJECTGROUP_DESCRIPTION = 3;
    private static final int SP_UPDATEOBJECTGROUP_DOMAIN = 4;
    private static final int SP_UPDATEOBJECTGROUP_ALL_OBJECTS_IN_DOMAIN = 5;
    private static final int SP_UPDATEOBJECTGROUP_FILTER_ID = 6;
    private static final int SP_UPDATEOBJECTGROUP_USER_DATA = 7;
    private static final int SP_UPDATEOBJECTGROUP_UPDATED_BY = 8;
    private static final int SP_UPDATEOBJECTGROUP_TIMESTAMP = 9;
    private static final int SP_UPDATEOBJECTGROUP_CREATED_DATE = 10;
    private static final String SP_GETCHILDREN = "{call GETCHILDRENHOSTS(?,?)}";
    private static final int SP_GETCHILDREN_DOMAIN_ID = 1;
    private static final int SP_GETCHILDREN_CSR = 2;
    private static final String SP_GETMODULELIST = "{call GETMODULELISTBYLEAFID(?,?)}";
    private static final int SP_GETMODULELIST_LEAF_ID = 1;
    private static final int SP_GETMODULELIST_CSR = 2;
    private static String i18nBase_ = "com.sun.symon.base.client.ClientApiMessages";
    private String hostName_;
    private String ip_address_;

    public MgObjectGroupImpl(String string, ScSecurityCredential scSecurityCredential) throws RemoteException {
        super(string, scSecurityCredential);
        this.setHostIp();
    }

    public MgObjectGroupImpl(String string, ScSecurityCredential scSecurityCredential, String string2) throws RemoteException {
        super(string, scSecurityCredential, string2);
        this.setHostIp();
    }

    public void cleanup() {
        MgObjectGroupService.getObjectGroupChangeMulticaster().remove((MSBaseService)this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SMObjectGroupInfo[] getAll() throws SMSecurityException, SMDatabaseException {
        Object[] objectArray;
        MSSecurity.getInstance().checkAccess(this.getServiceName(), "getAll", this.getUserSecurityCredential());
        Connection connection = MSDB.getConnection();
        Vector<SMObjectGroupInfo> vector = new Vector<SMObjectGroupInfo>();
        try {
            try {
                CallableStatement callableStatement = connection.prepareCall(SP_GETALLOBJECTGROUPS);
                callableStatement.registerOutParameter(1, -10);
                callableStatement.execute();
                OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(1);
                while (true) {
                    if (!oracleResultSet.next()) {
                        callableStatement.close();
                        Object[] objectArray2 = new SMObjectGroupInfo[vector.size()];
                        vector.copyInto(objectArray2);
                        objectArray = objectArray2;
                        Object var12_14 = null;
                        break;
                    }
                    long l = oracleResultSet.getLong("FILTER_ID");
                    SMDBObjectID sMDBObjectID = null;
                    if (!oracleResultSet.wasNull()) {
                        sMDBObjectID = new SMDBObjectID(l, "FILTER");
                    }
                    SMObjectGroupInfo sMObjectGroupInfo = new SMObjectGroupInfo(new SMDBObjectID(oracleResultSet.getLong("OBJECT_GROUP_ID"), "OBJECT_GROUP"), oracleResultSet.getString("NAME"), oracleResultSet.getString("DESCRIPTION"), oracleResultSet.getString("DOMAIN"), sMDBObjectID, oracleResultSet.getString("FILTER_NAME"));
                    sMObjectGroupInfo.setChanged(false);
                    vector.addElement(sMObjectGroupInfo);
                }
            }
            catch (SQLException sQLException) {
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "databaseException"));
                throw sMDatabaseException;
            }
            catch (Exception exception) {
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)exception);
                sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "databaseException"));
                throw sMDatabaseException;
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        return objectArray;
    }

    public SMObjectGroupData load(SMDBObjectID sMDBObjectID) throws SMSecurityException, SMNoSuchObjectException, SMDatabaseException {
        if (!"OBJECT_GROUP".equals(sMDBObjectID.getType())) {
            SMDatabaseException sMDatabaseException = new SMDatabaseException(sMDBObjectID + " is meant for another table");
            sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "dataError"));
            throw sMDatabaseException;
        }
        return this.getObjectGroup(sMDBObjectID, null);
    }

    public SMObjectGroupData load(String string) throws SMSecurityException, SMNoSuchObjectException, SMDatabaseException {
        return this.getObjectGroup(null, string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SMObjectGroupInfo loadInfo(SMDBObjectID sMDBObjectID) throws SMSecurityException, SMNoSuchObjectException, SMDatabaseException {
        SMObjectGroupInfo sMObjectGroupInfo;
        if (!"OBJECT_GROUP".equals(sMDBObjectID.getType())) {
            SMDatabaseException sMDatabaseException = new SMDatabaseException(sMDBObjectID + " is meant for another table");
            sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "dataError"));
            throw sMDatabaseException;
        }
        MSSecurity.getInstance().checkAccess(this.getServiceName(), "load", this.getUserSecurityCredential(), sMDBObjectID);
        Connection connection = MSDB.getConnection();
        try {
            try {
                CallableStatement callableStatement = connection.prepareCall(SP_GETOBJECTGROUP);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMDBObjectID);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)2, (String)null);
                callableStatement.registerOutParameter(3, -10);
                callableStatement.execute();
                OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(3);
                if (!oracleResultSet.next()) {
                    callableStatement.close();
                    SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException("record not found: " + sMDBObjectID);
                    sMNoSuchObjectException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "database.rowNotFound"));
                    throw sMNoSuchObjectException;
                }
                callableStatement.close();
                long l = oracleResultSet.getLong("FILTER_ID");
                SMDBObjectID sMDBObjectID2 = null;
                if (!oracleResultSet.wasNull()) {
                    sMDBObjectID2 = new SMDBObjectID(l, "FILTER");
                }
                SMObjectGroupInfo sMObjectGroupInfo2 = new SMObjectGroupInfo(new SMDBObjectID(oracleResultSet.getLong("OBJECT_GROUP_ID"), "OBJECT_GROUP"), oracleResultSet.getString("NAME"), oracleResultSet.getString("DESCRIPTION"), oracleResultSet.getString("DOMAIN"), sMDBObjectID2, oracleResultSet.getString("FILTER_NAME"));
                sMObjectGroupInfo2.setChanged(false);
                sMObjectGroupInfo = sMObjectGroupInfo2;
                Object var11_15 = null;
            }
            catch (SQLException sQLException) {
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "databaseException"));
                throw sMDatabaseException;
            }
            catch (SMDatabaseException sMDatabaseException) {
                throw sMDatabaseException;
            }
            catch (Exception exception) {
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)exception);
                sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "databaseException"));
                throw sMDatabaseException;
            }
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        return sMObjectGroupInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SMObjectGroupData getObjectGroup(SMDBObjectID sMDBObjectID, String string) throws SMSecurityException, SMNoSuchObjectException, SMDatabaseException {
        SMObjectGroupData sMObjectGroupData;
        MSSecurity.getInstance().checkAccess(this.getServiceName(), "load", this.getUserSecurityCredential(), sMDBObjectID);
        Connection connection = MSDB.getConnection();
        try {
            try {
                CallableStatement callableStatement = connection.prepareCall(SP_GETOBJECTGROUP);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMDBObjectID);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)2, (String)string);
                callableStatement.registerOutParameter(3, -10);
                callableStatement.execute();
                OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(3);
                if (!oracleResultSet.next()) {
                    callableStatement.close();
                    SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException("record not found: " + sMDBObjectID + ", " + string);
                    sMNoSuchObjectException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "database.rowNotFound"));
                    throw sMNoSuchObjectException;
                }
                if (sMDBObjectID == null) {
                    sMDBObjectID = new SMDBObjectID(oracleResultSet.getLong("object_group_id"), "OBJECT_GROUP");
                }
                SMObjectGroupData sMObjectGroupData2 = new SMObjectGroupData(sMDBObjectID, oracleResultSet.getString("FILTER_NAME"));
                sMObjectGroupData2.setName(oracleResultSet.getString("NAME"));
                sMObjectGroupData2.setDescription(oracleResultSet.getString("DESCRIPTION"));
                sMObjectGroupData2.setDomain(oracleResultSet.getString("DOMAIN"));
                sMObjectGroupData2.setAllObjectsInDomain(oracleResultSet.getBoolean("ALL_OBJECTS_IN_DOMAIN"));
                long l = oracleResultSet.getLong("FILTER_ID");
                if (!oracleResultSet.wasNull()) {
                    sMObjectGroupData2.setFilter(new SMDBObjectID(l, "FILTER"));
                }
                sMObjectGroupData2.setUserData(oracleResultSet.getString("USER_DATA"));
                sMObjectGroupData2.setUpdatedBy(oracleResultSet.getString("UPDATED_BY"));
                sMObjectGroupData2.setTimestamp(new SMDBConcurrencyTimestamp(oracleResultSet.getTimestamp("TIMESTAMP")));
                sMObjectGroupData2.setCreatedDate(oracleResultSet.getTimestamp("CREATED_DATE"));
                callableStatement.close();
                Vector<String> vector = new Vector<String>();
                callableStatement = connection.prepareCall(SP_GETGROUPBYOBJECT);
                callableStatement.setLong(1, sMDBObjectID.getID());
                callableStatement.registerOutParameter(2, -10);
                callableStatement.execute();
                oracleResultSet = (OracleResultSet)callableStatement.getObject(2);
                while (true) {
                    if (!oracleResultSet.next()) {
                        callableStatement.close();
                        if (vector.size() > 0) {
                            sMObjectGroupData = new String[vector.size()];
                            vector.copyInto((Object[])sMObjectGroupData);
                            sMObjectGroupData2.setObjects((String[])sMObjectGroupData);
                        }
                        sMObjectGroupData2.setChanged(false);
                        sMObjectGroupData = sMObjectGroupData2;
                        Object var12_16 = null;
                        break;
                    }
                    vector.addElement(oracleResultSet.getString("NAME"));
                }
            }
            catch (SQLException sQLException) {
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "databaseException"));
                throw sMDatabaseException;
            }
            catch (SMDatabaseException sMDatabaseException) {
                throw sMDatabaseException;
            }
            catch (Exception exception) {
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)exception);
                sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "databaseException"));
                throw sMDatabaseException;
            }
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        return sMObjectGroupData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SMDBObject save(SMObjectGroupData sMObjectGroupData) throws SMSecurityException, SMStaleDataException, SMDatabaseException, SMNoSuchObjectException, SMDuplicateException {
        SMDBObject sMDBObject;
        Connection connection;
        block10: {
            SMDBObject sMDBObject2;
            block9: {
                MSSecurity.getInstance().checkAccess(this.getServiceName(), "save", this.getUserSecurityCredential());
                connection = MSDB.getConnection();
                try {
                    try {
                        CallableStatement callableStatement = connection.prepareCall(SP_UPDATEOBJECTGROUP);
                        MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMObjectGroupData.getObjectID());
                        callableStatement.setString(2, sMObjectGroupData.getName().trim());
                        callableStatement.setString(3, sMObjectGroupData.getDescription());
                        callableStatement.setString(4, sMObjectGroupData.getDomain());
                        callableStatement.setBoolean(5, sMObjectGroupData.isAllObjectsInDomain());
                        MSDB.setNullable((PreparedStatement)callableStatement, (int)6, (SMDBObjectID)sMObjectGroupData.getFilter());
                        MSDB.setNullable((PreparedStatement)callableStatement, (int)7, (String)sMObjectGroupData.getUserData());
                        callableStatement.setString(8, this.getUserSecurityCredential().getUser());
                        MSDB.setNullable((PreparedStatement)callableStatement, (int)9, (SMDBConcurrencyTimestamp)sMObjectGroupData.getTimestamp());
                        MSDB.setNullable((PreparedStatement)callableStatement, (int)10, (Timestamp)sMObjectGroupData.getCreatedDate());
                        callableStatement.registerOutParameter(1, 4);
                        callableStatement.registerOutParameter(9, 93);
                        callableStatement.registerOutParameter(10, 93);
                        callableStatement.execute();
                        SMDBObject sMDBObject3 = new SMDBObject(new SMDBObjectID(callableStatement.getLong(1), "OBJECT_GROUP"));
                        sMDBObject3.setUpdatedBy(this.getUserSecurityCredential().getUser());
                        sMDBObject3.setTimestamp(new SMDBConcurrencyTimestamp(callableStatement.getTimestamp(9)));
                        sMDBObject3.setCreatedDate(callableStatement.getTimestamp(10));
                        callableStatement.close();
                        this.deleteGroupByObject(connection, sMDBObject3.getObjectID());
                        String[] stringArray = sMObjectGroupData.getObjects();
                        if (stringArray == null) {
                            connection.commit();
                            this.fireEventForSave((SMDBObject)sMObjectGroupData, sMDBObject3);
                            sMDBObject2 = sMDBObject3;
                            Object var8_15 = null;
                            break block9;
                        }
                        this.updateGroupByObject(connection, sMDBObject3.getObjectID(), stringArray);
                        connection.commit();
                        this.fireEventForSave((SMDBObject)sMObjectGroupData, sMDBObject3);
                        sMDBObject = sMDBObject3;
                        break block10;
                    }
                    catch (SQLException sQLException) {
                        MSDB.rollback((Connection)connection);
                        if (sQLException.getMessage().indexOf("STALE_DATA") >= 0) {
                            SMStaleDataException sMStaleDataException = new SMStaleDataException((Throwable)sQLException);
                            sMStaleDataException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "database.stale"));
                            throw sMStaleDataException;
                        }
                        if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                            SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException((Throwable)sQLException);
                            sMNoSuchObjectException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "database.rowNotFound"));
                            throw sMNoSuchObjectException;
                        }
                        if (sQLException.getMessage().indexOf("DUPLICATE_INDEX") >= 0) {
                            SMDuplicateException sMDuplicateException = new SMDuplicateException((Throwable)sQLException);
                            sMDuplicateException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "database.duplicateIndex"));
                            throw sMDuplicateException;
                        }
                        SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                        sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "databaseException"));
                        throw sMDatabaseException;
                    }
                    catch (Exception exception) {
                        MSDB.rollback((Connection)connection);
                        SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)exception);
                        sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "databaseException"));
                        throw sMDatabaseException;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_17 = null;
                    MSDB.closeConnection((Connection)connection);
                    throw throwable;
                }
            }
            MSDB.closeConnection((Connection)connection);
            return sMDBObject2;
        }
        Object var8_16 = null;
        MSDB.closeConnection((Connection)connection);
        return sMDBObject;
    }

    private void fireEventForSave(SMDBObject sMDBObject, SMDBObject sMDBObject2) {
        int n = sMDBObject.getObjectID() == null ? 2 : 1;
        MgObjectGroupService.getObjectGroupChangeMulticaster().fireEvent(new SMDBChangeEvent(sMDBObject2.getObjectID(), n));
    }

    private void updateGroupByObject(Connection connection, SMDBObjectID sMDBObjectID, String[] stringArray) throws SQLException, SMDatabaseException {
        if (!"OBJECT_GROUP".equals(sMDBObjectID.getType())) {
            SMDatabaseException sMDatabaseException = new SMDatabaseException(sMDBObjectID + " is meant for another table");
            sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "dataError"));
            throw sMDatabaseException;
        }
        int n = 0;
        while (n < stringArray.length) {
            CallableStatement callableStatement = connection.prepareCall(SP_UPDATEGROUPBYOBJECT);
            callableStatement.setLong(1, sMDBObjectID.getID());
            callableStatement.setString(2, stringArray[n]);
            callableStatement.execute();
            callableStatement.close();
            ++n;
        }
    }

    private void deleteGroupByObject(Connection connection, SMDBObjectID sMDBObjectID) throws SQLException, SMDatabaseException {
        if (!"OBJECT_GROUP".equals(sMDBObjectID.getType())) {
            SMDatabaseException sMDatabaseException = new SMDatabaseException(sMDBObjectID + " is meant for another table");
            sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "dataError"));
            throw sMDatabaseException;
        }
        CallableStatement callableStatement = connection.prepareCall(SP_DELETEGROUPBYOBJECT);
        callableStatement.setLong(1, sMDBObjectID.getID());
        callableStatement.execute();
        callableStatement.close();
    }

    public void delete(SMDBObjectID sMDBObjectID) throws SMSecurityException, SMDatabaseException, SMNoSuchObjectException {
        if (!"OBJECT_GROUP".equals(sMDBObjectID.getType())) {
            SMDatabaseException sMDatabaseException = new SMDatabaseException(sMDBObjectID + " is meant for another table");
            sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "dataError"));
            throw sMDatabaseException;
        }
        MSSecurity.getInstance().checkAccess(this.getServiceName(), "delete", this.getUserSecurityCredential(), sMDBObjectID);
        Connection connection = MSDB.getConnection();
        try {
            try {
                CallableStatement callableStatement = connection.prepareCall(SP_DELETEOBJECTGROUP);
                callableStatement.setLong(1, sMDBObjectID.getID());
                callableStatement.execute();
                callableStatement.close();
                connection.commit();
            }
            catch (SQLException sQLException) {
                MSDB.rollback((Connection)connection);
                if (sQLException.getMessage().indexOf("STALE_DATA") >= 0) {
                    SMStaleDataException sMStaleDataException = new SMStaleDataException((Throwable)sQLException);
                    sMStaleDataException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "database.stale"));
                    throw sMStaleDataException;
                }
                if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                    SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException((Throwable)sQLException);
                    sMNoSuchObjectException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "database.rowNotFound"));
                    throw sMNoSuchObjectException;
                }
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "databaseException"));
                throw sMDatabaseException;
            }
            catch (Exception exception) {
                MSDB.rollback((Connection)connection);
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)exception);
                sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "databaseException"));
                throw sMDatabaseException;
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        MgObjectGroupService.getObjectGroupChangeMulticaster().fireEvent(new SMDBChangeEvent(sMDBObjectID, 3));
    }

    public String[] resolve(SMDBObjectID sMDBObjectID) throws SMAPIException, SMSecurityException, SMDatabaseException {
        if (!"OBJECT_GROUP".equals(sMDBObjectID.getType())) {
            SMDatabaseException sMDatabaseException = new SMDatabaseException(sMDBObjectID + " is meant for another table");
            sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "dataError"));
            throw sMDatabaseException;
        }
        MSSecurity.getInstance().checkAccess(this.getServiceName(), "resolve", this.getUserSecurityCredential(), sMDBObjectID);
        SMObjectGroupData sMObjectGroupData = this.load(sMDBObjectID);
        if (sMObjectGroupData == null) {
            SMDatabaseException sMDatabaseException = new SMDatabaseException("ID not found");
            sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "idNotFound"));
            throw sMDatabaseException;
        }
        return this.resolve(sMObjectGroupData);
    }

    public String[] resolve(SMObjectGroupData sMObjectGroupData) throws SMAPIException, SMSecurityException, SMDatabaseException {
        MSSecurity.getInstance().checkAccess(this.getServiceName(), "resolve", this.getUserSecurityCredential(), sMObjectGroupData.getObjectID());
        return new HostResolver(sMObjectGroupData, this.getUserSecurityCredential(), this.hostName_, this.ip_address_).resolve();
    }

    public void addEventListener(SMDBRemoteChangeListener sMDBRemoteChangeListener) {
        MgObjectGroupService.getObjectGroupChangeMulticaster().add((MSBaseService)this, sMDBRemoteChangeListener);
    }

    public void removeEventListener(SMDBRemoteChangeListener sMDBRemoteChangeListener) {
        MgObjectGroupService.getObjectGroupChangeMulticaster().remove((MSBaseService)this, sMDBRemoteChangeListener);
    }

    private void setHostIp() throws RemoteException {
        try {
            this.hostName_ = InetAddress.getLocalHost().getHostName();
            this.ip_address_ = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RemoteException(unknownHostException.getMessage());
        }
    }
}

