/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.group;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMMessageI18nKey;
import com.sun.symon.base.client.group.SMFilterCriteria;
import com.sun.symon.base.client.group.SMFilterData;
import com.sun.symon.base.client.group.SMIPRangeCriteria;
import com.sun.symon.base.client.group.SMModuleCriteria;
import com.sun.symon.base.client.group.SMNameCriteria;
import com.sun.symon.base.client.group.SMOSCriteria;
import com.sun.symon.base.client.group.SMObjectGroupData;
import com.sun.symon.base.client.group.SMPlatformCriteria;
import com.sun.symon.base.client.service.SMDatabaseException;
import com.sun.symon.base.mgmtservice.common.MSDB;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.group.MgFilterImpl;
import com.sun.symon.base.mgmtservice.group.MgFilterService;
import com.sun.symon.base.server.common.ScSecurityCredential;
import com.sun.symon.base.utility.UcListUtil;
import com.sun.symon.base.utility.UcURL;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;

class HostResolver {
    Connection con;
    static final String DOMAIN_BY_NAME = "select node_id from node where isDomain = 'T' and description=";
    static final String SELECT_NODE = "select node_id from node where description=";
    static final String SELECT_NAME_PORT = "select decode(hostname, NULL, ip_address, hostname), port  from leaf where leaf_id in ";
    static final String DOMAIN_NAME = "Default Domain";
    static final String LOAD_PLATFORMS = "select family, family_type_id from family_type where family is not null";
    static final String LOAD_IP_ADDRESSES = "select ip_address, entity_id from entity_info where entity_id in ";
    static final String SELECT_LEAF = "select leaf_id from node_entity_relator where entity_id in (";
    static final String FIND_ID_BY_MODULE_PART1 = "select entity_id from node_entity_relator where entity_id in (";
    static final String FIND_ID_BY_MODULE_PART2 = " and leaf_id in (select leaf_id from entity_moduleinstance where  module_instance_id in (select module_instance_id from moduleinstance where module_id in (select module_id from module where name in (";
    static final int SIZE = 20;
    HostTable result;
    SMObjectGroupData group;
    ScSecurityCredential security;
    boolean doLogSql = false;
    static Hashtable platform2id;
    MSLogPrintWriter errorWriter = MSLogPrintWriter.getErrorWriter();
    MSLogPrintWriter sqlWriter;
    private static String[] EMPTY;
    private static String i18nBase_;
    private String hostName;
    private String ip_address;

    protected HostResolver(SMObjectGroupData sMObjectGroupData, ScSecurityCredential scSecurityCredential, String string, String string2) {
        this.group = sMObjectGroupData;
        this.security = scSecurityCredential;
        this.hostName = string;
        this.ip_address = string2;
        try {
            this.sqlWriter = MSLogPrintWriter.getChannel((String)"sql");
        }
        catch (IOException iOException) {
            try {
                this.sqlWriter = MSLogPrintWriter.createChannel((String)"sql");
            }
            catch (IOException iOException2) {
                // empty catch block
            }
        }
        if (this.sqlWriter != null) {
            this.doLogSql = this.sqlWriter.isActive();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] resolve() throws SMAPIException, SMDatabaseException {
        String string = this.group.getDomain();
        if (string.equals("base.console.ConsoleTopology:domain.defaultdomain")) {
            string = DOMAIN_NAME;
        }
        string = this.escapeSpecial(string);
        String[] stringArray = null;
        try {
            try {
                this.con = MSDB.getConnection();
                long l = this.getDomainNodeId(string);
                this.result = new HostTable();
                if (this.group.isAllObjectsInDomain()) {
                    this.getAllObjectLeaves("", l);
                } else {
                    String[] stringArray2 = this.group.getObjects();
                    int n = 0;
                    if (stringArray2 != null) {
                        n = stringArray2.length;
                    }
                    int n2 = 0;
                    while (n2 < n) {
                        this.getAllObjectLeaves(stringArray2[n2], l);
                        ++n2;
                    }
                }
                stringArray = this.doFilter();
            }
            catch (Exception exception) {
                this.errorWriter.println((Throwable)exception);
                if (exception instanceof SMAPIException) {
                    throw (SMAPIException)((Object)exception);
                }
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)exception);
                sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "databaseException"));
                throw sMDatabaseException;
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                this.con.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                this.errorWriter.println((Throwable)sQLException);
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "databaseException"));
                throw sMDatabaseException;
            }
        }
        try {}
        catch (SQLException sQLException) {
            this.errorWriter.println((Throwable)sQLException);
            SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
            sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "databaseException"));
            throw sMDatabaseException;
        }
        this.con.close();
        return stringArray;
    }

    private String[] doFilter() throws SQLException, SMAPIException, SMDatabaseException {
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        SMFilterData sMFilterData = null;
        Statement statement = this.con.createStatement();
        if (this.result.size() == 0) {
            return EMPTY;
        }
        if (this.group.getFilter() != null) {
            object5 = null;
            try {
                object5 = MgFilterService.getFilterImpl(this.security);
            }
            catch (Exception exception) {
                this.errorWriter.println((Throwable)exception);
                throw new SMAPIException(exception.getMessage(), new SMMessageI18nKey(i18nBase_, "smApiException"));
            }
            if (object5 == null) {
                throw new SMAPIException("Cannot find MgFilterImpl", new SMMessageI18nKey(i18nBase_, "canNotFindMgFilterImpl"));
            }
            sMFilterData = ((MgFilterImpl)((Object)object5)).load(this.group.getFilter());
        }
        object5 = new StringBuffer();
        if (sMFilterData != null && (object4 = sMFilterData.getFilterCriteria()) != null) {
            int n2 = 0;
            while (n2 < ((SMFilterCriteria[])object4).length) {
                object3 = object4[n2];
                if (object3.isEnabled()) {
                    if (object3 instanceof SMNameCriteria) {
                        this.addNameCriteria((SMNameCriteria)object3, (StringBuffer)object5);
                        if (this.result.size() == 0) {
                            return EMPTY;
                        }
                    }
                    if (object3 instanceof SMOSCriteria) {
                        this.addOSCriteria((SMOSCriteria)object3, (StringBuffer)object5);
                        if (this.result.size() == 0) {
                            return EMPTY;
                        }
                    }
                    if (object3 instanceof SMPlatformCriteria) {
                        this.addPlatformCriteria((SMPlatformCriteria)object3, (StringBuffer)object5);
                    }
                    if (object3 instanceof SMIPRangeCriteria) {
                        this.addIPRangeCriteria((SMIPRangeCriteria)object3);
                        if (this.result.size() == 0) {
                            return EMPTY;
                        }
                    }
                    if (object3 instanceof SMModuleCriteria) {
                        this.addModuleCriteria((SMModuleCriteria)object3);
                    }
                }
                ++n2;
            }
        }
        if (this.result.size() == 0) {
            return EMPTY;
        }
        object4 = new Vector();
        if (!this.result.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer();
            object3 = this.result.keys();
            stringBuffer.append(SELECT_LEAF);
            boolean bl = true;
            while (object3.hasMoreElements()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(",");
                }
                stringBuffer.append(object3.nextElement());
            }
            stringBuffer.append(")");
            if (this.doLogSql) {
                this.sqlWriter.println(stringBuffer.toString());
            }
            object2 = statement.executeQuery(stringBuffer.toString());
            while (object2.next()) {
                ((Vector)object4).add(new Long(object2.getLong("leaf_id")));
            }
            object2.close();
        }
        int n3 = 0;
        int n4 = ((Vector)object4).size();
        Enumeration enumeration = ((Vector)object4).elements();
        object2 = new TreeSet();
        if (enumeration.hasMoreElements()) {
            while (true) {
                Object object6;
                object = new StringBuffer();
                ((StringBuffer)object).append(SELECT_NAME_PORT).append("(");
                int n5 = n3 + 20;
                if (n5 > n4) {
                    n5 = n4;
                }
                n = n3;
                while (n < n5) {
                    object6 = enumeration.nextElement();
                    if (n != n3) {
                        ((StringBuffer)object).append(",");
                    }
                    ((StringBuffer)object).append(object6);
                    ++n;
                }
                ((StringBuffer)object).append(")").append(object5).append(" order by hostname");
                if (this.doLogSql) {
                    this.sqlWriter.println(((StringBuffer)object).toString());
                }
                object6 = statement.executeQuery(((StringBuffer)object).toString());
                while (object6.next()) {
                    String string = object6.getString(1);
                    int n6 = object6.getInt(2);
                    String string2 = string;
                    if (n6 > 0) {
                        string2 = string + ":" + n6;
                    }
                    ((TreeSet)object2).add(string2);
                }
                object6.close();
                if (n5 == n4) break;
                n3 += 20;
            }
        }
        statement.close();
        n4 = ((TreeSet)object2).size();
        object = ((TreeSet)object2).iterator();
        String[] stringArray = new String[n4];
        n = 0;
        while (object.hasNext()) {
            stringArray[n++] = (String)object.next();
        }
        return stringArray;
    }

    private long getDomainNodeId(String string) throws SQLException, SMAPIException {
        ResultSet resultSet;
        long l = -1L;
        if (!UcListUtil.isAsciiString((String)string)) {
            string = UcListUtil.UnicodeToAscii((String)string);
        }
        Statement statement = this.con.createStatement();
        String string2 = "select node_id from node where isDomain = 'T' and description='" + string + "'";
        if (this.doLogSql) {
            this.sqlWriter.println(string2);
        }
        if (!(resultSet = statement.executeQuery(string2)).next()) {
            SMDatabaseException sMDatabaseException = new SMDatabaseException("Domain is not available");
            sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "domainIsNotAvailable"));
            throw sMDatabaseException;
        }
        l = resultSet.getLong(1);
        resultSet.close();
        statement.close();
        return l;
    }

    private void getAllObjectLeaves(String string, long l) throws SQLException, SMAPIException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            vector.addElement(string2);
        }
        int n = vector.size();
        long l2 = l;
        if (n > 1) {
            int n2 = 0;
            while (n2 < n - 1) {
                l2 = this.getViewByParentAndName((String)vector.elementAt(n2), l2);
                if (l2 < 0L) {
                    return;
                }
                ++n2;
            }
        }
        if (n > 0) {
            long l3 = this.getViewByParentAndName((String)vector.lastElement(), l2);
            if (l3 > 0L) {
                this.getAllEntitiesForView(l3);
            } else {
                this.getEntityByParentAndName((String)vector.lastElement(), l2);
            }
        } else {
            this.getAllEntitiesForView(l2);
        }
    }

    private long getViewByParentAndName(String string, long l) throws SQLException, SMAPIException {
        string = this.escapeSpecial(string);
        String string2 = "select description,entity_id,poll_type,url from entity_info where description='" + string + "' and entity_id " + "in (select entity_id from view_entity_relator where view_id=" + l + ")";
        Statement statement = this.con.createStatement();
        ResultSet resultSet = statement.executeQuery(string2);
        long l2 = -1L;
        while (resultSet.next()) {
            int n;
            String string3;
            UcURL ucURL;
            String string4;
            String string5 = resultSet.getString("poll_type");
            if (!string5.equals("aview") || !(string4 = (ucURL = new UcURL(string3 = resultSet.getString("url"))).getHost()).equals(this.hostName) && !string4.equals(this.ip_address) || (n = string3.lastIndexOf("view-")) == -1) continue;
            String string6 = string3.substring(n + 5);
            if ((n = string6.indexOf("/")) != -1) {
                string6 = string6.substring(0, n);
            }
            l2 = Long.parseLong(string6);
        }
        resultSet.close();
        statement.close();
        return l2;
    }

    private void getEntityByParentAndName(String string, long l) throws SQLException, SMAPIException {
        string = this.escapeSpecial(string);
        Statement statement = this.con.createStatement();
        if (!UcListUtil.isAsciiString((String)string)) {
            string = UcListUtil.UnicodeToAscii((String)string);
        }
        String string2 = "select entity_id from entity_info where description ='" + string + "'" + " and entity_id in (select entity_id from view_entity_relator where view_id =" + l + ")";
        ResultSet resultSet = statement.executeQuery(string2);
        if (this.doLogSql) {
            this.sqlWriter.println(string2);
        }
        while (resultSet.next()) {
            this.result.put(new Long(resultSet.getLong(1)));
        }
        resultSet.close();
        statement.close();
    }

    private void getAllEntitiesForView(long l) throws SQLException {
        String string = "select description,entity_id,poll_type,url from entity_info where  entity_id in (select entity_id from view_entity_relator where view_id=" + l + ")";
        if (this.doLogSql) {
            this.sqlWriter.println(string);
        }
        Statement statement = this.con.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        while (resultSet.next()) {
            String string2 = resultSet.getString("poll_type");
            if (string2.equals("aview")) {
                int n;
                String string3 = resultSet.getString("url");
                UcURL ucURL = new UcURL(string3);
                String string4 = ucURL.getHost();
                if (!string4.equals(this.hostName) && !string4.equals(this.ip_address) || (n = string3.lastIndexOf("view-")) == -1) continue;
                String string5 = string3.substring(n + 5);
                if ((n = string5.indexOf("/")) != -1) {
                    string5 = string5.substring(0, n);
                }
                long l2 = Long.parseLong(string5);
                this.getAllEntitiesForView(l2);
                continue;
            }
            this.result.put(new Long(resultSet.getLong("entity_id")));
        }
        resultSet.close();
        statement.close();
    }

    private void addNameCriteria(SMNameCriteria sMNameCriteria, StringBuffer stringBuffer) throws SQLException {
        HostTable hostTable = new HostTable();
        String string = this.escapeSpecial(sMNameCriteria.getPattern());
        if (string == null || string.trim().length() == 0) {
            this.result = new HostTable();
            return;
        }
        if (!UcListUtil.isAsciiString((String)string)) {
            string = UcListUtil.UnicodeToAscii((String)string);
        }
        String string2 = sMNameCriteria.getMatchType();
        Statement statement = this.con.createStatement();
        StringBuffer stringBuffer2 = new StringBuffer("select entity_id from entity_info where description ");
        if (string2.equals("X")) {
            stringBuffer2.append("='").append(string).append("' ");
        } else if (string2.equals("C")) {
            stringBuffer2.append("like '%").append(string).append("%' ");
        } else if (string2.equals("S")) {
            stringBuffer2.append("like '").append(string).append("%' ");
        } else if (string2.equals("E")) {
            stringBuffer2.append("like '%").append(string).append("' ");
        }
        if (this.doLogSql) {
            this.sqlWriter.println((Object)stringBuffer2);
        }
        ResultSet resultSet = statement.executeQuery(stringBuffer2.toString());
        Vector<Long> vector = new Vector<Long>();
        while (resultSet.next()) {
            vector.addElement(new Long(resultSet.getLong(1)));
        }
        resultSet.close();
        int n = vector.size();
        if (n == 0) {
            this.result = new HostTable();
            return;
        }
        boolean bl = false;
        Enumeration enumeration = this.result.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (vector.contains(k)) continue;
            this.result.remove(k);
        }
    }

    private void addOSCriteria(SMOSCriteria sMOSCriteria, StringBuffer stringBuffer) {
        String[] stringArray = sMOSCriteria.getList();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        stringBuffer.append(" and arch ");
        if (!sMOSCriteria.isInclude()) {
            stringBuffer.append(" not ");
        }
        stringBuffer.append(" in (");
        boolean bl = true;
        int n = 0;
        while (n < stringArray.length) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
            }
            stringBuffer.append("'").append(stringArray[n]).append("'");
            ++n;
        }
        stringBuffer.append(")");
    }

    private void loadPlatforms() throws SQLException {
        platform2id = new Hashtable();
        Statement statement = this.con.createStatement();
        if (this.doLogSql) {
            this.sqlWriter.println(LOAD_PLATFORMS);
        }
        ResultSet resultSet = statement.executeQuery(LOAD_PLATFORMS);
        while (resultSet.next()) {
            String string = resultSet.getString(1);
            platform2id.put(string, new Long(resultSet.getLong(2)));
        }
        resultSet.close();
        statement.close();
    }

    private void addPlatformCriteria(SMPlatformCriteria sMPlatformCriteria, StringBuffer stringBuffer) throws SQLException {
        String[] stringArray;
        if (platform2id == null) {
            this.loadPlatforms();
        }
        if ((stringArray = sMPlatformCriteria.getList()) == null || stringArray.length == 0) {
            return;
        }
        stringBuffer.append(" and family_type_id ");
        if (!sMPlatformCriteria.isInclude()) {
            stringBuffer.append(" not ");
        }
        stringBuffer.append(" in (");
        boolean bl = true;
        int n = 0;
        while (n < stringArray.length) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
            }
            Object v = platform2id.get(stringArray[n]);
            if (v != null) {
                stringBuffer.append(v);
            }
            ++n;
        }
        stringBuffer.append(")");
    }

    private void addIPRangeCriteria(SMIPRangeCriteria sMIPRangeCriteria) throws SQLException {
        HostTable hostTable = new HostTable();
        Statement statement = this.con.createStatement();
        int n = 0;
        int n2 = this.result.size();
        Enumeration enumeration = this.result.keys();
        while (true) {
            Object object;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(LOAD_IP_ADDRESSES).append("(");
            int n3 = n + 20;
            if (n3 > n2) {
                n3 = n2;
            }
            int n4 = n;
            while (n4 < n3) {
                object = enumeration.nextElement();
                if (n4 != n) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(object);
                ++n4;
            }
            stringBuffer.append(")");
            if (this.doLogSql) {
                this.sqlWriter.println(stringBuffer.toString());
            }
            object = statement.executeQuery(stringBuffer.toString());
            while (object.next()) {
                String string = object.getString(1);
                if (!sMIPRangeCriteria.isInRange(string)) continue;
                hostTable.put(new Long(object.getLong(2)));
            }
            object.close();
            if (n3 == n2) break;
            n += 20;
        }
        statement.close();
        this.result = hostTable;
    }

    private void addModuleCriteria(SMModuleCriteria sMModuleCriteria) throws SQLException {
        String[] stringArray = sMModuleCriteria.getList();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        HostTable hostTable = new HostTable();
        Statement statement = this.con.createStatement();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(FIND_ID_BY_MODULE_PART1);
        stringBuffer.append(this.result);
        stringBuffer.append(")");
        stringBuffer.append(FIND_ID_BY_MODULE_PART2);
        boolean bl = true;
        int n = 0;
        while (n < stringArray.length) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(",");
            }
            stringBuffer.append("'").append(stringArray[n]).append("'");
            ++n;
        }
        stringBuffer.append("))))");
        if (this.doLogSql) {
            this.sqlWriter.println(stringBuffer.toString());
        }
        ResultSet resultSet = statement.executeQuery(stringBuffer.toString());
        while (resultSet.next()) {
            hostTable.put(new Long(resultSet.getLong(1)));
        }
        if (sMModuleCriteria.isInclude()) {
            this.result = hostTable;
        } else {
            Enumeration enumeration = hostTable.keys();
            while (enumeration.hasMoreElements()) {
                this.result.remove(enumeration.nextElement());
            }
        }
        resultSet.close();
        statement.close();
    }

    private String escapeSpecial(String string) {
        int n = string.indexOf("'");
        if (n == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (n != -1) {
            stringBuffer.append(string.substring(0, n + 1));
            stringBuffer.append("'");
            string = string.substring(n + 1);
            n = string.indexOf("'");
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    static {
        EMPTY = new String[0];
        i18nBase_ = "com.sun.symon.base.client.ClientApiMessages";
    }

    class HostTable
    extends Hashtable {
        HostTable() {
        }

        public void put(Long l) {
            super.put(l, "");
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (HostResolver.this.result.size() == 0) {
                stringBuffer.append("No results");
            } else {
                boolean bl = true;
                Enumeration enumeration = this.keys();
                while (enumeration.hasMoreElements()) {
                    if (bl) {
                        bl = false;
                        stringBuffer.append(enumeration.nextElement());
                        continue;
                    }
                    stringBuffer.append(",").append(enumeration.nextElement());
                }
            }
            return stringBuffer.toString();
        }
    }
}

