/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.task;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.log.SMRemoteLogReader;
import com.sun.symon.base.client.service.SMDBObject;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMDBRemoteChangeListener;
import com.sun.symon.base.client.service.SMDatabaseException;
import com.sun.symon.base.client.service.SMLengthException;
import com.sun.symon.base.client.service.SMSecurityException;
import com.sun.symon.base.client.task.SMRemoteTaskRequest;
import com.sun.symon.base.client.task.SMTaskRequestData;
import com.sun.symon.base.client.task.SMTaskRequestInfo;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.common.MSLogReader;
import com.sun.symon.base.mgmtservice.common.MSSecurity;
import com.sun.symon.base.mgmtservice.framework.MSBaseService;
import com.sun.symon.base.mgmtservice.task.MtTaskConstants;
import com.sun.symon.base.mgmtservice.task.MtTaskRequestController;
import com.sun.symon.base.mgmtservice.task.MtTaskRequestDBAccess;
import com.sun.symon.base.server.common.ScSecurityCredential;
import java.rmi.RemoteException;

public class MtTaskRequestService
extends MSBaseService
implements SMRemoteTaskRequest,
MtTaskConstants {
    private ScSecurityCredential security;
    private String serverHost;
    static MSSecurity sService;
    static MtTaskRequestController controller;
    static MSLogPrintWriter logWriter;
    static MSLogPrintWriter errorWriter;
    static MtTaskRequestDBAccess dbAccess;
    static final String SECURITY_NOT_AVAILABLE = "Security service is not available.Task Service is unusable";

    public MtTaskRequestService(ScSecurityCredential scSecurityCredential, String string) throws RemoteException {
        super("Task_TaskRequest", scSecurityCredential, string);
        this.serverHost = string;
        this.security = scSecurityCredential;
        controller.addUser(scSecurityCredential);
    }

    public SMDBObject save(SMTaskRequestData sMTaskRequestData) throws RemoteException, SMDatabaseException, SMSecurityException {
        SMDBObjectID sMDBObjectID = sMTaskRequestData.getObjectID();
        if (sMDBObjectID == null) {
            try {
                sMTaskRequestData.setOwner(this.security.getUser());
            }
            catch (SMLengthException sMLengthException) {
                // empty catch block
            }
            this.checkAccess("save");
        } else {
            this.checkAccess("save", sMDBObjectID);
        }
        controller.save(sMTaskRequestData);
        return new SMDBObject((SMDBObject)sMTaskRequestData);
    }

    public SMTaskRequestInfo[] getAll() throws RemoteException, SMDatabaseException, SMSecurityException {
        this.checkAccess("getAll");
        return dbAccess.getAll();
    }

    public void suspend(SMDBObjectID sMDBObjectID) throws RemoteException, SMSecurityException, SMDatabaseException {
        this.checkAccess("suspend", sMDBObjectID);
        controller.suspend(sMDBObjectID);
    }

    public void resume(SMDBObjectID sMDBObjectID) throws RemoteException, SMSecurityException, SMDatabaseException {
        this.checkAccess("resume", sMDBObjectID);
        controller.resume(sMDBObjectID);
    }

    public void delete(SMDBObjectID sMDBObjectID) throws RemoteException, SMSecurityException, SMDatabaseException {
        this.checkAccess("delete", sMDBObjectID);
        controller.deleteRequest(sMDBObjectID);
    }

    public SMTaskRequestData load(SMDBObjectID sMDBObjectID) throws RemoteException, SMDatabaseException, SMSecurityException {
        this.checkAccess("load", sMDBObjectID);
        return controller.load(sMDBObjectID);
    }

    public SMTaskRequestInfo loadInfo(SMDBObjectID sMDBObjectID) throws RemoteException, SMDatabaseException, SMSecurityException {
        this.checkAccess("loadInfo", sMDBObjectID);
        return controller.loadInfo(sMDBObjectID);
    }

    public SMTaskRequestData load(String string) throws RemoteException, SMDatabaseException, SMSecurityException {
        this.checkAccess("load");
        return controller.load(string);
    }

    public void addEventListener(SMDBRemoteChangeListener sMDBRemoteChangeListener) throws RemoteException {
        controller.addTaskRequestListener(this, sMDBRemoteChangeListener);
    }

    public void removeEventListener(SMDBRemoteChangeListener sMDBRemoteChangeListener) throws RemoteException {
        controller.removeTaskRequestListener(this, sMDBRemoteChangeListener);
    }

    public SMRemoteLogReader getLogReader() throws RemoteException, SMAPIException {
        return new MSLogReader("taskreq", this.serverHost);
    }

    public void cleanup() {
        controller.removeSessionListeners(this);
    }

    static {
        try {
            sService = MSSecurity.getInstance();
            controller = MtTaskRequestController.getTaskRequestController();
            logWriter = controller.getRequestLogWriter();
            errorWriter = MSLogPrintWriter.getErrorWriter();
            dbAccess = MtTaskRequestDBAccess.getInstance();
        }
        catch (SMSecurityException sMSecurityException) {
            errorWriter.println(SECURITY_NOT_AVAILABLE);
            throw new RuntimeException(SECURITY_NOT_AVAILABLE);
        }
    }
}

