/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.task;

import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.task.MtExecPool;
import com.sun.symon.base.mgmtservice.task.MtTaskRequest;
import com.sun.symon.base.mgmtservice.task.MtTaskRequestController;
import com.sun.symon.base.mgmtservice.task.MtTaskRunner;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;

public class MtTaskRequestQueue {
    public static final int MAX_DELAY = 10000;
    public static final int MIN_DELAY = 400;
    public static final int MIN_DELAY_FOR_MSG = 120000;
    public static final MtTaskRequestQueue theTimerQueue = new MtTaskRequestQueue();
    private static MSLogPrintWriter logWriter = MtTaskRequestController.getInstance().getRequestLogWriter();
    private MtExecPool pool;
    private LinkedList timerQueue = new LinkedList();
    private ExecThread execThread = new ExecThread();
    private Hashtable executed;

    private MtTaskRequestQueue() {
        this.pool = MtExecPool.getExecPool();
        this.executed = new Hashtable();
    }

    public static MtTaskRequestQueue getTimerQueue() {
        return theTimerQueue;
    }

    public synchronized boolean suspend(SMDBObjectID sMDBObjectID) {
        MtTaskRequest mtTaskRequest;
        MtTaskRequest mtTaskRequest2 = null;
        ListIterator listIterator = this.timerQueue.listIterator(0);
        int n = 0;
        while (listIterator.hasNext()) {
            mtTaskRequest = (MtTaskRequest)((Object)listIterator.next());
            if (mtTaskRequest.equals(sMDBObjectID)) {
                mtTaskRequest2 = mtTaskRequest;
                this.timerQueue.remove(n);
                break;
            }
            ++n;
        }
        if (mtTaskRequest2 == null && (mtTaskRequest = this.executed.get(sMDBObjectID)) != null) {
            mtTaskRequest2 = mtTaskRequest;
        }
        if (mtTaskRequest2 != null) {
            mtTaskRequest2.setSuspended();
            return true;
        }
        return false;
    }

    public synchronized boolean resume(SMDBObjectID sMDBObjectID) {
        MtTaskRequest mtTaskRequest;
        MtTaskRequest mtTaskRequest2 = null;
        ListIterator listIterator = this.timerQueue.listIterator(0);
        int n = 0;
        while (listIterator.hasNext()) {
            mtTaskRequest = (MtTaskRequest)((Object)listIterator.next());
            if (mtTaskRequest.equals(sMDBObjectID)) {
                mtTaskRequest2 = mtTaskRequest;
                return true;
            }
            ++n;
        }
        mtTaskRequest = this.executed.get(sMDBObjectID);
        if (mtTaskRequest != null) {
            mtTaskRequest2 = mtTaskRequest;
            if (mtTaskRequest2.isSuspended()) {
                mtTaskRequest2.resetSuspended();
            }
            return true;
        }
        return false;
    }

    public synchronized void delete(SMDBObjectID sMDBObjectID) {
        if (this.remove(sMDBObjectID)) {
            return;
        }
        Object v = this.executed.get(sMDBObjectID);
        if (v != null) {
            MtTaskRequest mtTaskRequest = (MtTaskRequest)((Object)v);
            mtTaskRequest.setMarkForDeletion();
        }
    }

    public synchronized boolean remove(SMDBObjectID sMDBObjectID) {
        int n = 0;
        ListIterator listIterator = this.timerQueue.listIterator(0);
        while (listIterator.hasNext()) {
            MtTaskRequest mtTaskRequest = (MtTaskRequest)((Object)listIterator.next());
            if (mtTaskRequest.equals(sMDBObjectID)) {
                this.timerQueue.remove(n);
                return true;
            }
            ++n;
        }
        return false;
    }

    public synchronized void add(MtTaskRequest mtTaskRequest) {
        long l = new Date().getTime();
        boolean bl = false;
        boolean bl2 = false;
        if (!mtTaskRequest.reschedule()) {
            return;
        }
        long l2 = mtTaskRequest.getExecTime();
        if (mtTaskRequest.isScheduled() && !mtTaskRequest.isSuspended()) {
            if (this.timerQueue.size() == 0) {
                this.timerQueue.addFirst(mtTaskRequest);
                bl = true;
                bl2 = true;
            } else {
                ListIterator listIterator = this.timerQueue.listIterator(0);
                while (listIterator.hasNext()) {
                    MtTaskRequest mtTaskRequest2 = (MtTaskRequest)((Object)listIterator.next());
                    if (mtTaskRequest2.getExecTime() <= l2) continue;
                    int n = listIterator.previousIndex();
                    if (n < 0) {
                        bl = true;
                        bl2 = true;
                        this.timerQueue.addFirst(mtTaskRequest);
                        break;
                    }
                    this.timerQueue.add(n, mtTaskRequest);
                    bl = true;
                    break;
                }
                if (!bl) {
                    this.timerQueue.addLast(mtTaskRequest);
                }
            }
        }
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer("Timer Queue");
        ListIterator listIterator = this.timerQueue.listIterator(0);
        while (listIterator.hasNext()) {
            MtTaskRequest mtTaskRequest = (MtTaskRequest)((Object)listIterator.next());
            stringBuffer.append(mtTaskRequest.toString());
        }
        return stringBuffer.toString();
    }

    public synchronized void requestDone(SMDBObjectID sMDBObjectID) {
        this.executed.remove(sMDBObjectID);
    }

    class ExecThread
    extends Thread {
        ExecThread() {
            super("RequestThread");
            this.start();
        }

        public void run() {
            Date date = new Date();
            block7: while (true) {
                try {
                    while (true) {
                        int n = 10000;
                        long l = new Date().getTime();
                        boolean bl = true;
                        MtTaskRequestQueue mtTaskRequestQueue = theTimerQueue;
                        synchronized (mtTaskRequestQueue) {
                            MtTaskRequest mtTaskRequest;
                            if (MtTaskRequestQueue.this.timerQueue.size() > 0 && (mtTaskRequest = (MtTaskRequest)((Object)MtTaskRequestQueue.this.timerQueue.getFirst())).getExecTime() - l <= 0L) {
                                MtTaskRunner mtTaskRunner = MtTaskRequestQueue.this.pool.getTaskRunner();
                                if (mtTaskRunner != null) {
                                    MtTaskRequestQueue.this.timerQueue.removeFirst();
                                    MtTaskRequestQueue.this.executed.put(mtTaskRequest.getObjectID(), mtTaskRequest);
                                    mtTaskRunner.delegate(mtTaskRequest);
                                } else {
                                    bl = false;
                                    if (l - date.getTime() >= 120000L) {
                                        logWriter.println("There is no available execution thread");
                                        date = new Date();
                                        this.dumpQueueInfo();
                                    }
                                }
                            }
                            if (MtTaskRequestQueue.this.timerQueue.size() > 0) {
                                mtTaskRequest = (MtTaskRequest)((Object)MtTaskRequestQueue.this.timerQueue.getFirst());
                                long l2 = mtTaskRequest.getExecTime() - l;
                                if (l2 > 10000L) {
                                    n = 10000;
                                } else if (l2 <= 0L) {
                                    n = 0;
                                    if (!bl) {
                                        n = 400;
                                    }
                                } else {
                                    n = (int)l2;
                                }
                            }
                        }
                        try {
                            if (n <= 0) continue block7;
                            Thread.sleep(n);
                            continue block7;
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace((PrintWriter)logWriter);
                    continue;
                }
                break;
            }
        }

        private void dumpQueueInfo() {
            MtTaskRequestQueue.this.pool.info((PrintWriter)logWriter);
            logWriter.println("Queue size: " + MtTaskRequestQueue.this.timerQueue.size());
            int n = 1;
            ListIterator listIterator = MtTaskRequestQueue.this.timerQueue.listIterator(0);
            while (listIterator.hasNext()) {
                MtTaskRequest mtTaskRequest = (MtTaskRequest)((Object)listIterator.next());
                logWriter.println(n + ": " + mtTaskRequest.getName() + ": " + mtTaskRequest.getStartDate());
                ++n;
            }
        }
    }
}

