/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.config;

import com.sun.symon.base.mgmtservice.common.MSDB;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.common.MSProperties;
import com.sun.symon.base.utility.UcAgentURL;
import java.io.File;
import java.io.FileInputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.crimson.tree.XmlDocument;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class MnFeature {
    private static final String SP_DELETE_FEATURES = "{call SP_DELETE_FEATURES()}";
    private static final String SP_ADD_FEATURE = "{call SP_ADD_FEATURE(?,?,?,?,?,?,?)}";
    private static final int SP_ADD_FEATURE_FEATURE = 1;
    private static final int SP_ADD_FEATURE_FEATURE_VERSION = 2;
    private static final int SP_ADD_FEATURE_NAME = 3;
    private static final int SP_ADD_FEATURE_DESCRIPTION = 4;
    private static final int SP_ADD_FEATURE_VERSION_NAME = 5;
    private static final int SP_ADD_FEATURE_VERSION = 6;
    private static final int SP_ADD_FEATURE_FEATURE_ID = 7;
    private static final String SP_IS_FEATURE_SUPPORTED = "{call SP_IS_FEATURE_SUPPORTED(?,?,?,?)}";
    private static final int SP_IS_FEATURE_SUPPORTED_HOSTNAME = 1;
    private static final int SP_IS_FEATURE_SUPPORTED_PORT = 2;
    private static final int SP_IS_FEATURE_SUPPORTED_FEATURE_VERSION = 3;
    private static final int SP_IS_FEATURE_SUPPORTED_SUPPORTED = 4;
    private static Hashtable featureItem_ = new Hashtable();

    public static void init() {
        try {
            MnFeature.deleteAllFeatures();
        }
        catch (Exception exception) {
            MSLogPrintWriter.getErrorWriter().println("Unable to delete all features into database " + exception);
        }
        MnFeature.searchDir();
    }

    public static String[] getFeatureForAttribute(UcAgentURL ucAgentURL) {
        String string = ucAgentURL.getAttribute();
        Vector vector = (Vector)featureItem_.get("attribute:" + string);
        if (vector == null) {
            return null;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String[] getFeatureForAttribute(String string) {
        Vector vector = (Vector)featureItem_.get("attribute:" + string);
        if (vector == null) {
            return null;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static boolean isAttributeSupported(UcAgentURL ucAgentURL, String string) {
        String[] stringArray = MnFeature.getFeatureForAttribute(string);
        if (stringArray == null) {
            return true;
        }
        return MnFeature.isAttributeSupported(ucAgentURL.getHost(), ucAgentURL.getAgentPort(), stringArray);
    }

    public static boolean isAttributeSupported(UcAgentURL ucAgentURL) {
        String[] stringArray = MnFeature.getFeatureForAttribute(ucAgentURL);
        if (stringArray == null) {
            return true;
        }
        return MnFeature.isAttributeSupported(ucAgentURL.getHost(), ucAgentURL.getAgentPort(), stringArray);
    }

    private static boolean isAttributeSupported(String string, int n, String[] stringArray) {
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (MnFeature.isFeatureSupported(string, n, stringArray[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Loose catch block
     */
    private static boolean isFeatureSupported(String string, int n, String string2) {
        boolean bl;
        block12: {
            bl = false;
            Connection connection = null;
            connection = MSDB.getConnection();
            CallableStatement callableStatement = connection.prepareCall(SP_IS_FEATURE_SUPPORTED);
            callableStatement.setString(1, string);
            callableStatement.setInt(2, n);
            callableStatement.setString(3, string2);
            callableStatement.registerOutParameter(4, 4);
            callableStatement.execute();
            if (callableStatement.getInt(4) != 0) {
                bl = true;
            }
            callableStatement.close();
            Object var7_7 = null;
            try {
                if (connection != null) {
                    MSDB.closeConnection((Connection)connection);
                }
                break block12;
            }
            catch (Exception exception) {}
            break block12;
            {
                catch (Exception exception) {
                    Object var7_8 = null;
                    try {
                        if (connection != null) {
                            MSDB.closeConnection((Connection)connection);
                        }
                        break block12;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (connection != null) {
                        MSDB.closeConnection((Connection)connection);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return bl;
    }

    private static void searchDir() {
        String string = System.getProperty("ESROOT", "/opt/SUNWsymon");
        String string2 = string + "/AdvancedServices/features";
        File file = new File(string2);
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isFile() && fileArray[n].getName().endsWith(".xml")) {
                MnFeature.loadXML(fileArray[n]);
            }
            ++n;
        }
    }

    /*
     * Loose catch block
     */
    private static void loadXML(File file) {
        block11: {
            FileInputStream fileInputStream;
            try {
                fileInputStream = new FileInputStream(file);
            }
            catch (Exception exception) {
                MSLogPrintWriter.getErrorWriter().println("Unable to open + " + file.getAbsolutePath() + " " + exception);
                return;
            }
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource(fileInputStream);
            inputSource.setSystemId("");
            documentBuilder.setEntityResolver(new MyResolver());
            XmlDocument xmlDocument = (XmlDocument)documentBuilder.parse(inputSource);
            xmlDocument.getDocumentElement().normalize();
            MnFeature.readDocument(xmlDocument);
            Object var7_8 = null;
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {}
            break block11;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    MSLogPrintWriter.getErrorWriter().println("Unable to parse " + file.getAbsolutePath() + " " + exception);
                    Object var7_9 = null;
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private static void readDocument(XmlDocument xmlDocument) throws Exception {
        Element element = xmlDocument.getDocumentElement();
        Hashtable hashtable = MnFeature.getAttributes(element);
        String string = (String)hashtable.get("feature");
        String string2 = (String)hashtable.get("featureVersion");
        MSLogPrintWriter.getInfoWriter().println("Loading descriptor for feature: " + string2);
        try {
            MnFeature.saveFeature(string, string2, (String)hashtable.get("name"), (String)hashtable.get("description"), (String)hashtable.get("versionName"), Integer.parseInt((String)hashtable.get("version")));
        }
        catch (Exception exception) {
            MSLogPrintWriter.getErrorWriter().println("Unable to save features into database " + exception);
            return;
        }
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1) {
                hashtable = MnFeature.getAttributes(node);
                String string3 = (String)hashtable.get("type") + ":" + (String)hashtable.get("name");
                Vector<String> vector = (Vector<String>)featureItem_.get(string3);
                if (vector == null) {
                    vector = new Vector<String>();
                }
                vector.addElement(string2);
                featureItem_.put(string3, vector);
            }
            ++n;
        }
    }

    private static Hashtable getAttributes(Node node) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Attr attr = (Attr)namedNodeMap.item(n);
            hashtable.put(attr.getName(), attr.getValue());
            ++n;
        }
        return hashtable;
    }

    private static void deleteAllFeatures() throws Exception {
        Connection connection = MSDB.getConnection();
        try {
            try {
                CallableStatement callableStatement = connection.prepareCall(SP_DELETE_FEATURES);
                callableStatement.execute();
                connection.commit();
                callableStatement.close();
            }
            catch (Exception exception) {
                MSDB.rollback((Connection)connection);
                throw exception;
            }
            Object var3_3 = null;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
    }

    private static void saveFeature(String string, String string2, String string3, String string4, String string5, int n) throws Exception {
        Connection connection = MSDB.getConnection();
        try {
            try {
                CallableStatement callableStatement = connection.prepareCall(SP_ADD_FEATURE);
                callableStatement.setString(1, string);
                callableStatement.setString(2, string2);
                callableStatement.setString(3, string3);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)4, (String)string4);
                callableStatement.setString(5, string5);
                callableStatement.setInt(6, n);
                callableStatement.registerOutParameter(7, 4);
                callableStatement.execute();
                connection.commit();
                callableStatement.close();
            }
            catch (Exception exception) {
                MSDB.rollback((Connection)connection);
                throw exception;
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
    }

    static class MyResolver
    implements EntityResolver {
        MyResolver() {
        }

        public InputSource resolveEntity(String string, String string2) {
            if (!string2.endsWith("Feature.dtd")) {
                return null;
            }
            try {
                return new InputSource(new FileInputStream(MSProperties.getFile((String)"dtd/core/Feature", (String)".dtd")));
            }
            catch (Exception exception) {
                MSLogPrintWriter.getErrorWriter().println("Unable to open DTD: " + exception);
                return null;
            }
        }
    }
}

