/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.trap;

import com.sun.symon.base.server.trap.SrHandleThread;
import com.sun.symon.base.server.trap.SrTrapConstants;
import com.sun.symon.base.server.trap.SrTrapData;
import com.sun.symon.base.server.trap.SrTrapSubscriber;
import com.sun.symon.base.utility.UcDDL;
import java.util.HashSet;
import java.util.Vector;

class SrTrapDispatcher
implements SrTrapConstants {
    private static final int MAXTHREADS = 5;
    private HashSet trapSet = null;
    private SrHandleThread[] handlerPool = null;
    private Vector waitList = null;
    private SrTrapSubscriber trapSubscriber = null;
    private int counts = 0;

    SrTrapDispatcher(SrTrapSubscriber srTrapSubscriber) {
        this.trapSubscriber = srTrapSubscriber;
        this.handlerPool = new SrHandleThread[5];
        this.waitList = new Vector();
        this.trapSet = new HashSet();
    }

    void dispatch(SrTrapData srTrapData, Vector vector) {
        UcDDL.logDebugMessage((String)("dispatch trap: <" + srTrapData.getType() + ", " + srTrapData.getSourceIp() + "> to " + vector.size() + " handlers."));
        if (vector.size() == 0) {
            return;
        }
        SrHandleThread srHandleThread = this.getHandleThread(srTrapData);
        if (srHandleThread == null) {
            return;
        }
        srHandleThread.handle(srTrapData, vector);
    }

    synchronized void trapHandled(SrTrapData srTrapData) {
        this.trapSet.remove(srTrapData.getSourceIp());
    }

    synchronized boolean hasWaitTraps() {
        return this.waitList != null && this.waitList.size() > 0;
    }

    synchronized SrTrapData getNextWaitTrap() {
        int n = 0;
        while (n < this.waitList.size()) {
            SrTrapData srTrapData = (SrTrapData)this.waitList.elementAt(n);
            if (!this.trapSet.contains(srTrapData.getSourceIp())) {
                this.waitList.remove(n);
                this.trapSet.add(srTrapData.getSourceIp());
                return srTrapData;
            }
            ++n;
        }
        return null;
    }

    synchronized SrHandleThread getHandleThread(SrTrapData srTrapData) {
        SrHandleThread srHandleThread = null;
        int n = 0;
        n = 0;
        while (n < 5) {
            srHandleThread = this.handlerPool[n];
            if (srHandleThread == null) {
                this.handlerPool[n] = srHandleThread = new SrHandleThread(this.trapSubscriber, this);
                break;
            }
            if (srHandleThread.isAvailable()) break;
            ++n;
        }
        if (n == 5) {
            UcDDL.logInfoMessage((String)"getTrapHandler: no thread available, wait...");
            this.waitList.addElement(srTrapData);
            return null;
        }
        if (this.trapSet.contains(srTrapData.getSourceIp())) {
            this.waitList.addElement(srTrapData);
            return null;
        }
        this.trapSet.add(srTrapData.getSourceIp());
        srHandleThread.setAvailable(false);
        return srHandleThread;
    }

    private void dumpTrapHandlers() {
        UcDDL.logDebugMessage((String)"dumpTrapHandlers: ");
        int n = 0;
        while (n < 5) {
            SrHandleThread srHandleThread = this.handlerPool[n];
            if (srHandleThread == null) break;
            srHandleThread.dump();
            ++n;
        }
    }
}

