/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.emitters.snmp;

import com.sun.symon.base.server.common.ScRequestSinkInterface;
import com.sun.symon.base.server.emitters.snmp.SeSnmpException;
import com.sun.symon.base.server.emitters.snmp.SeSnmpFinder;
import com.sun.symon.base.server.emitters.snmp.SeSnmpRequestor;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.server.types.StSnmpOCTET_STRING;
import com.sun.symon.base.utility.UcURL;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.StringTokenizer;

class Resolver
implements ScRequestSinkInterface {
    private static final int TYPE_INT = 0;
    private static final int TYPE_STR = 1;
    private static final int TYPE_OID = 2;
    private static final int TYPE_IP = 3;
    private static final int TYPE_ZERO = 4;
    private static final int TYPE_WITH_LEN = 8;
    private static Hashtable typeLookup = new Hashtable();
    private SeSnmpFinder finder;
    private SeSnmpFinder.ResultCallback resultHandler;
    private InetAddress ip;
    private int port;
    private String context;
    private String[] oids;
    private String[] keys;
    private String[] queryUrls;
    private QueryResponseHandler[] queryResponseHandlers;
    private int numQueries;
    private ScRequestSinkInterface queryRequest;

    Resolver(SeSnmpFinder seSnmpFinder, String[] stringArray, int n, int n2, SeSnmpFinder.ResultCallback resultCallback) throws SeSnmpException {
        this.finder = seSnmpFinder;
        this.resultHandler = resultCallback;
        this.oids = new String[stringArray.length];
        this.keys = new String[stringArray.length];
        this.queryUrls = new String[stringArray.length];
        this.queryResponseHandlers = new QueryResponseHandler[stringArray.length];
        this.numQueries = 0;
        int n3 = 0;
        while (n3 < stringArray.length) {
            this.parseUrl(stringArray[n3], n3);
            ++n3;
        }
        this.queryRequestCreate(n, n2);
        this.queryUrls = null;
    }

    private void setIpAndPort(UcURL ucURL) throws SeSnmpException {
        try {
            this.ip = InetAddress.getByName(ucURL.getHost());
        }
        catch (UnknownHostException unknownHostException) {
            throw new SeSnmpException("invalid host", 0, 1000, unknownHostException);
        }
        String string = ucURL.getPort();
        if (string == null || string.equals("")) {
            this.port = 161;
        } else {
            try {
                this.port = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SeSnmpException("invalid port", 0, 1000, numberFormatException);
            }
        }
    }

    private void parseUrl(String string, int n) throws SeSnmpException {
        UcURL ucURL = new UcURL(string);
        if (n == 0) {
            this.setIpAndPort(ucURL);
        }
        String string2 = ucURL.getPath().substring(0, 3);
        String string3 = ucURL.getSubPath();
        String string4 = ucURL.getAttribute();
        String string5 = ucURL.getFragment();
        if (string2.equals("oid")) {
            string3 = string3.substring(4);
            this.setOid(n, string3, string5, null, string4);
        } else if (string2.equals("mod") || string2.equals("sym")) {
            this.parseUrlWithLookup(n, string3, string4, string5);
        } else {
            throw new SeSnmpException("unknown url type '" + string2 + "'", n, 1000);
        }
    }

    private void parseUrlWithLookup(final int n, String string, String string2, final String string3) throws SeSnmpException {
        String string4;
        String string5;
        final boolean bl = !string2.equals("");
        String string6 = this.ip.getHostAddress() + ":" + this.port + "/" + string;
        if (string.indexOf("STATE=") >= 0 && bl && string2.indexOf("tabledepth") >= 0 && string3 != null && string3.indexOf("index") >= 0) {
            string6 = string6 + "?tabledepth#index";
        }
        final String string7 = string6;
        String string8 = this.finder.cacheSubpathGet(string7, bl);
        int[] nArray = this.finder.cacheFragmentTypesGet(string7);
        if (bl) {
            string5 = string2;
            string4 = this.finder.cacheShadowGet(string5);
        } else {
            string5 = null;
            string4 = "";
        }
        if (string8 == null || string4 == null || nArray == null) {
            String string9 = string + string2 + string3;
            this.addQuery(string9, new QueryResponseHandler(){

                public void handleResponse(String string) {
                    try {
                        String string2;
                        UcURL ucURL = new UcURL(string);
                        String string32 = ucURL.getSubPath().substring(4);
                        Resolver.this.finder.cacheSubpathAdd(string7, bl, string32);
                        int[] nArray = Resolver.this.parseTypes(n, ucURL.getFragment());
                        Resolver.this.finder.cacheFragmentTypesAdd(string7, nArray);
                        if (bl) {
                            string2 = ucURL.getAttribute();
                            Resolver.this.finder.cacheShadowAdd(string5, string2);
                        } else {
                            string2 = "";
                        }
                        Resolver.this.setOid(n, string32, string3, nArray, string2);
                    }
                    catch (SeSnmpException seSnmpException) {
                        Resolver.this.resultHandler.handleException(seSnmpException);
                    }
                }

                public void handleException(SeSnmpException seSnmpException) {
                    SeSnmpException seSnmpException2 = new SeSnmpException(seSnmpException.getMessage(), n, seSnmpException.getErrorIndex(), seSnmpException.getException());
                    Resolver.this.resultHandler.handleException(seSnmpException2);
                }
            });
        } else {
            this.setOid(n, string8, string3, nArray, string4);
        }
    }

    private void addQuery(String string, QueryResponseHandler queryResponseHandler) {
        this.queryUrls[this.numQueries] = "snmp://" + this.ip.getHostAddress() + ":" + this.port + "/" + string;
        this.queryResponseHandlers[this.numQueries] = queryResponseHandler;
        ++this.numQueries;
    }

    private void setOid(int n, String string, String string2, int[] nArray, String string3) throws SeSnmpException {
        boolean bl = !string3.equals("");
        String string4 = this.extractLocation(string, n);
        if (n == 0) {
            this.context = this.extractContext(string);
        }
        String string5 = this.extractFragment(n, string2, nArray, bl);
        String string6 = this.cleanOid(string4 + string5 + string3);
        String string7 = this.createKey(string6, string4, bl);
        this.oids[n] = string6;
        this.keys[n] = string7;
    }

    private String extractContext(String string) {
        if (Character.isDigit(string.charAt(0))) {
            return null;
        }
        int n = string.indexOf(47);
        if (n > 0) {
            return string.substring(0, n);
        }
        return null;
    }

    private String extractLocation(String string, int n) throws SeSnmpException {
        if (Character.isDigit(string.charAt(0))) {
            return string;
        }
        int n2 = string.indexOf(47);
        if (n2 > 0) {
            return string.substring(n2 + 1);
        }
        throw new SeSnmpException("missing location in '" + string + "'", n, 1000);
    }

    private String extractFragment(int n, String string, int[] nArray, boolean bl) throws SeSnmpException {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        if (!string.equals("")) {
            string = string.substring(1);
            String[] stringArray = this.splitFragment(string);
            int n3 = stringArray.length;
            if (nArray != null && n3 != nArray.length) {
                throw new SeSnmpException("wrong number of indices in fragment (got " + n3 + ", expecting " + nArray.length + ")", n, 1000);
            }
            int n4 = 0;
            while (n4 < n3) {
                String string2 = stringArray[n4];
                string2 = this.removeHexEncodings(n, string2);
                int n5 = nArray == null ? 2 : nArray[n4];
                n2 += this.buildFragment(n, stringBuffer, string2, n5);
                ++n4;
            }
        }
        if (bl) {
            stringBuffer.append("." + n2);
        }
        return stringBuffer.toString();
    }

    private String[] splitFragment(String string) {
        int n;
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2 && (n4 = string.indexOf(44, n4)) != -1) {
            ++n3;
            ++n4;
        }
        String[] stringArray = new String[n3 + 1];
        n3 = 0;
        n4 = 0;
        while (n4 < n2 && (n = string.indexOf(44, n4)) != -1) {
            stringArray[n3] = n4 == n ? "" : string.substring(n4, n);
            n4 = n + 1;
            ++n3;
        }
        stringArray[n3] = n4 < n2 ? string.substring(n4) : "";
        return stringArray;
    }

    private int buildFragment(int n, StringBuffer stringBuffer, String string, int n2) throws SeSnmpException {
        boolean bl;
        int n3;
        if ((n2 & 8) != 0) {
            n3 = n2 - 8;
            bl = true;
        } else {
            n3 = n2;
            bl = false;
        }
        int n4 = 0;
        switch (n3) {
            case 4: {
                if (!string.equals("0")) {
                    throw new SeSnmpException("bad scalar fragment: '" + string + "'", n, 1000);
                }
                stringBuffer.append(".0");
                ++n4;
                break;
            }
            case 0: 
            case 2: 
            case 3: {
                int n5 = string.equals("") ? 0 : 1;
                int n6 = 0;
                while ((n6 = string.indexOf(".", n6)) != -1) {
                    ++n5;
                    if (++n6 < string.length()) continue;
                }
                if (n3 == 0 && n5 != 1) {
                    throw new SeSnmpException("bad integer fragment: '" + string + "'", n, 1000);
                }
                if (n3 == 3 && n5 != 4) {
                    throw new SeSnmpException("bad ip fragment: '" + string + "'", n, 1000);
                }
                if (bl) {
                    stringBuffer.append("." + n5);
                    ++n4;
                }
                if (!string.equals("")) {
                    stringBuffer.append('.');
                    stringBuffer.append(string);
                }
                n4 += n5;
                break;
            }
            case 1: {
                char[] cArray = string.toCharArray();
                if (bl) {
                    stringBuffer.append('.');
                    stringBuffer.append(Integer.toString(cArray.length));
                    ++n4;
                }
                int n7 = 0;
                while (n7 < cArray.length) {
                    stringBuffer.append('.');
                    stringBuffer.append(Integer.toString(cArray[n7]));
                    ++n4;
                    ++n7;
                }
                break;
            }
            default: {
                throw new SeSnmpException("bad fragment type: " + n2, n, 1000);
            }
        }
        return n4;
    }

    private int[] parseTypes(int n, String string) throws SeSnmpException {
        if (!string.equals("")) {
            string = string.substring(1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n2 = stringTokenizer.countTokens();
        int[] nArray = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            String string2 = stringTokenizer.nextToken();
            nArray[n3] = this.parseType(n, string2);
            ++n3;
        }
        return nArray;
    }

    private int parseType(int n, String string) throws SeSnmpException {
        String string2;
        int n2;
        if (string.startsWith("+")) {
            n2 = 8;
            string2 = string.substring(1);
        } else {
            n2 = 0;
            string2 = string;
        }
        Integer n3 = (Integer)typeLookup.get(string2.toLowerCase());
        if (n3 == null) {
            throw new SeSnmpException("invalid type: '" + string + "'", n, 1000);
        }
        return n2 += n3.intValue();
    }

    private String removeHexEncodings(int n, String string) throws SeSnmpException {
        StringBuffer stringBuffer;
        block6: {
            int n2 = string.indexOf(37);
            if (n2 == -1) {
                return string;
            }
            int n3 = 0;
            int n4 = string.length();
            stringBuffer = new StringBuffer(n4 - 2);
            do {
                char c;
                stringBuffer.append(string.substring(n3, n2));
                n3 = n2 + 3;
                if (n3 > n4) {
                    throw new SeSnmpException("Can't parse fragment '" + string + "'", n, 1000);
                }
                String string2 = string.substring(n2 + 1, n3);
                if (string2.startsWith("-")) {
                    throw new SeSnmpException("Can't parse fragment '" + string + "'", n, 1000);
                }
                try {
                    c = (char)Integer.parseInt(string2, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SeSnmpException("Can't parse fragment '" + string + "'", n, 1000);
                }
                stringBuffer.append(c);
                if (n3 == n4) break block6;
            } while ((n2 = string.indexOf(37, n3)) != -1);
            stringBuffer.append(string.substring(n3));
        }
        return stringBuffer.toString();
    }

    private String cleanOid(String string) {
        int n;
        string = string.replace('/', '.');
        string = string.replace('#', '.');
        string = string.replace('?', '.');
        int n2 = 0;
        while ((n = string.indexOf("..", n2)) != -1) {
            int n3 = string.length();
            int n4 = n + 2;
            while (n4 < n3 && string.charAt(n4) == '.') {
                ++n4;
            }
            String string2 = string.substring(0, n + 1);
            if (n4 < n3) {
                string2 = string2 + string.substring(n4);
            }
            string = string2;
            n2 = n + 2;
        }
        return string;
    }

    private String createKey(String string, String string2, boolean bl) {
        String string3;
        if (bl) {
            string3 = this.cleanOid(string2);
            if (string3.startsWith("2.")) {
                string3 = "1" + string3.substring(1);
            }
        } else {
            string3 = string;
            if (string3.endsWith(".0")) {
                string3 = string3.substring(0, string3.length() - 2);
            }
        }
        String string4 = this.ip.getHostAddress() + ":" + (this.context == null ? "" : this.context) + ":" + string3;
        return string4;
    }

    public void delete() {
        this.queryRequestDelete();
    }

    public void emit() {
        if (this.queryRequestEmit()) {
            this.resultHandler.handleResult(this.ip, this.port, this.context, this.oids, this.keys);
        }
    }

    public String[][] getCacheKeys() {
        return null;
    }

    private void queryRequestCreate(int n, int n2) throws SeSnmpException {
        if (this.numQueries == 0) {
            this.queryRequest = null;
        } else {
            String[] stringArray = new String[this.numQueries];
            StObject[] stObjectArray = new StSnmpOCTET_STRING[this.numQueries];
            String string = this.finder.getFinderOid();
            string = "2" + string.substring(1) + ".5000.1";
            int n3 = 0;
            while (n3 < this.numQueries) {
                stringArray[n3] = string;
                stObjectArray[n3] = new StSnmpOCTET_STRING(this.queryUrls[n3]);
                ++n3;
            }
            this.queryRequest = this.finder.getSnmpRequestor().createRequestByOid(this.ip, this.port, 0, null, n, n2, null, stringArray, stObjectArray, new SeSnmpRequestor.ResultCallback(){

                public void handleResult(StObject[] stObjectArray) {
                    Resolver.this.queryRequestHandleResults(stObjectArray);
                }

                public void handleResultBulk(StObject[][] stObjectArray) {
                }

                public void handleException(SeSnmpException seSnmpException) {
                    Resolver.this.queryRequestHandleException(seSnmpException);
                }
            });
        }
    }

    private boolean queryRequestEmit() {
        ScRequestSinkInterface scRequestSinkInterface;
        Resolver resolver = this;
        synchronized (resolver) {
            scRequestSinkInterface = this.queryRequest;
        }
        if (scRequestSinkInterface == null) {
            return true;
        }
        scRequestSinkInterface.emit();
        return false;
    }

    private void queryRequestDelete() {
        ScRequestSinkInterface scRequestSinkInterface;
        Resolver resolver = this;
        synchronized (resolver) {
            scRequestSinkInterface = this.queryRequest;
            this.queryRequest = null;
        }
        if (scRequestSinkInterface != null) {
            scRequestSinkInterface.delete();
        }
    }

    private void queryRequestHandleResults(StObject[] stObjectArray) {
        if (this.queryRequestAutoDelete()) {
            return;
        }
        int n = 0;
        while (n < stObjectArray.length) {
            QueryResponseHandler queryResponseHandler = this.queryResponseHandlers[n];
            String string = stObjectArray[n].toString();
            if (string.indexOf("ERROR") != -1) {
                queryResponseHandler.handleException(new SeSnmpException("Finder returned error '" + string + "' (invalid URL?)", n, 1000));
                return;
            }
            queryResponseHandler.handleResponse(string);
            ++n;
        }
        this.resultHandler.handleResult(this.ip, this.port, this.context, this.oids, this.keys);
    }

    private void queryRequestHandleException(SeSnmpException seSnmpException) {
        if (this.queryRequestAutoDelete()) {
            return;
        }
        int n = seSnmpException.getUrlOrOidIndex();
        QueryResponseHandler queryResponseHandler = this.queryResponseHandlers[n];
        queryResponseHandler.handleException(seSnmpException);
    }

    private boolean queryRequestAutoDelete() {
        boolean bl;
        ScRequestSinkInterface scRequestSinkInterface;
        Resolver resolver = this;
        synchronized (resolver) {
            scRequestSinkInterface = this.queryRequest;
            bl = this.queryRequest == null;
            this.queryRequest = null;
        }
        if (!bl) {
            scRequestSinkInterface.delete();
        }
        return bl;
    }

    static {
        typeLookup.put("int", new Integer(0));
        typeLookup.put("str", new Integer(1));
        typeLookup.put("oid", new Integer(2));
        typeLookup.put("ip", new Integer(3));
        typeLookup.put("0", new Integer(4));
    }

    static interface QueryResponseHandler {
        public void handleResponse(String var1);

        public void handleException(SeSnmpException var1);
    }
}

