/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.common;

import com.sun.symon.base.client.SMMessageI18nKey;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMSecurityException;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.common.MSProperties;
import com.sun.symon.base.server.common.ScSecurityCredential;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class MSSecurity {
    private static MSSecurity instance_;
    private static ScSecurityCredential master;
    private static String i18nBase_;
    private static String ANYUSER;
    private static String ANYGROUP;
    private static String aclFile_;
    private MSProperties acl_ = this.loadAcl(aclFile_);
    static /* synthetic */ Class class$com$sun$symon$base$mgmtservice$common$MSSecurity;

    public static void init(String string) throws SMSecurityException {
        aclFile_ = string;
        MSLogPrintWriter.getDebugWriter().println("MSSecurity: init() called");
        instance_ = new MSSecurity();
    }

    public static MSSecurity getInstance() throws SMSecurityException {
        if (instance_ == null) {
            Class clazz = class$com$sun$symon$base$mgmtservice$common$MSSecurity == null ? (class$com$sun$symon$base$mgmtservice$common$MSSecurity = MSSecurity.class$("com.sun.symon.base.mgmtservice.common.MSSecurity")) : class$com$sun$symon$base$mgmtservice$common$MSSecurity;
            synchronized (clazz) {
                if (instance_ == null) {
                    instance_ = new MSSecurity();
                }
            }
        }
        return instance_;
    }

    public static ScSecurityCredential getMasterUser() {
        if (master == null) {
            master = new ScSecurityCredential("esmaster", "other, esadm, esdomadm, esops", null, null, null, null, null);
        }
        return master;
    }

    private MSSecurity() throws SMSecurityException {
        this.searchDirs();
        this.postProcessAcl();
        MSLogPrintWriter.getDebugWriter().println("Security: initialized");
    }

    public void checkAccess(String string, String string2, ScSecurityCredential scSecurityCredential) throws SMSecurityException {
        this.checkAccess(string, string2, scSecurityCredential, null);
    }

    public void checkAccess(String string, String string2, ScSecurityCredential scSecurityCredential, SMDBObjectID sMDBObjectID) throws SMSecurityException {
        if (scSecurityCredential == null) {
            return;
        }
        String string3 = string + "." + string2;
        String string4 = "," + scSecurityCredential.getUser() + ",";
        String string5 = string3 + ".denyUser";
        String string6 = this.acl_.getProperty(string5);
        if (string6 != null) {
            if (string6.equals(ANYUSER)) {
                SMSecurityException sMSecurityException = new SMSecurityException("All users denied access on " + string3);
                sMSecurityException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "allUsersDeniedAccess"));
                throw sMSecurityException;
            }
            if (string6.indexOf(string4) >= 0) {
                SMSecurityException sMSecurityException = new SMSecurityException("All users denied access on " + string3);
                sMSecurityException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "allUsersDeniedAccess"));
                throw sMSecurityException;
            }
        }
        if ((string6 = this.acl_.getProperty(string5 = string3 + ".denyGroup")) != null) {
            if (string6.equals(ANYGROUP)) {
                SMSecurityException sMSecurityException = new SMSecurityException("All groups denied access on " + string3);
                sMSecurityException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "allGroupsDeniedAccess"));
                throw sMSecurityException;
            }
            if (MSSecurity.areGroupsInList(scSecurityCredential.getGroupArray(), string6)) {
                SMSecurityException sMSecurityException = new SMSecurityException("Group access denied on " + string3);
                sMSecurityException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "groupAccessDenied"));
                throw sMSecurityException;
            }
        }
        if ((string6 = this.acl_.getProperty(string5 = string3 + ".allowUser")) != null) {
            if (string6.equals(ANYUSER)) {
                return;
            }
            if (string6.indexOf(string4) >= 0) {
                return;
            }
        }
        if ((string6 = this.acl_.getProperty(string5 = string3 + ".allowGroup")) != null) {
            if (string6.equals(ANYGROUP)) {
                return;
            }
            if (MSSecurity.areGroupsInList(scSecurityCredential.getGroupArray(), string6)) {
                return;
            }
        }
        SMSecurityException sMSecurityException = new SMSecurityException("User not allowed on " + string3);
        sMSecurityException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "userNotAllowed"));
        throw sMSecurityException;
    }

    private MSProperties loadAcl(String string) throws SMSecurityException {
        MSProperties mSProperties = new MSProperties();
        try {
            mSProperties.load(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            SMSecurityException sMSecurityException = new SMSecurityException("Unable to open " + aclFile_, (Throwable)iOException);
            sMSecurityException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "unableToOpenFile"));
            throw sMSecurityException;
        }
        return mSProperties;
    }

    private void searchDirs() {
        String string = System.getProperty("ESDIR", "/var/opt/SUNWsymon");
        String string2 = string + "/AdvancedServices/services/";
        File file = new File(string2);
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isDirectory() && !fileArray[n].getName().startsWith("core") && !fileArray[n].getName().startsWith("tasks") && !fileArray[n].getName().startsWith("classes")) {
                this.searchDir(fileArray[n].getAbsoluteFile());
            }
            ++n;
        }
    }

    private void searchDir(File file) {
        MSLogPrintWriter.getDebugWriter().println("MSSecurity : SearchDir(File dir) : " + file.getName());
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        int n = 0;
        while (n < fileArray.length) {
            block7: {
                if (fileArray[n].isFile() && fileArray[n].getName().endsWith("-acls.properties")) {
                    MSProperties mSProperties = new MSProperties();
                    try {
                        MSLogPrintWriter.getDebugWriter().println("Loading " + fileArray[n].getAbsolutePath());
                        mSProperties.load(new FileInputStream(fileArray[n]));
                    }
                    catch (Exception exception) {
                        MSLogPrintWriter.getErrorWriter().println("Unable to load " + fileArray[n].getAbsolutePath());
                        break block7;
                    }
                    if (this.hasDuplicate(mSProperties, this.acl_)) {
                        MSLogPrintWriter.getErrorWriter().println("Duplicate ACL keys found in " + fileArray[n].getAbsolutePath());
                    } else {
                        ((Hashtable)this.acl_).putAll(mSProperties);
                    }
                }
            }
            ++n;
        }
    }

    private boolean hasDuplicate(Hashtable hashtable, Hashtable hashtable2) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!hashtable2.containsKey(string)) continue;
            return true;
        }
        return false;
    }

    private void postProcessAcl() {
        if (this.acl_ == null) {
            return;
        }
        Enumeration<?> enumeration = this.acl_.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.acl_.getProperty(string).trim();
            if (string2.equals(ANYUSER) || string2.equals(ANYGROUP)) continue;
            if (!string2.startsWith(",")) {
                string2 = "," + string2;
            }
            if (!string2.endsWith(",")) {
                string2 = string2 + ",";
            }
            ((Hashtable)this.acl_).put(string, string2);
        }
    }

    public static boolean areGroupsInList(String[] stringArray, String string) {
        if (stringArray == null) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (string.indexOf("," + stringArray[n] + ",") >= 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        master = null;
        i18nBase_ = "com.sun.symon.base.client.ClientApiMessages";
        ANYUSER = "ANYUSER";
        ANYGROUP = "ANYGROUP";
        aclFile_ = "AdvancedServices/services/core/service-acls";
    }
}

