/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.table;

import com.sun.symon.base.client.console.SMTblSelectionInfo;
import com.sun.symon.base.console.views.table.CvCommonTable;
import com.sun.symon.base.console.views.table.CvTblTableColumn;
import com.sun.symon.base.console.views.table.CvTblTableEvent;
import com.sun.symon.base.console.views.table.CvTblTableModel;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class CvTblTableHeader
extends JTableHeader
implements MouseListener,
MouseMotionListener {
    private boolean pressPending = false;

    public CvTblTableHeader(TableColumnModel tableColumnModel) {
        super(tableColumnModel);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public Dimension getMaximumSize() {
        Dimension dimension = ((JComponent)this).getPreferredSize();
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = ((JComponent)this).getPreferredSize();
        return dimension;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Serializable serializable;
        if (this.getTable() instanceof CvCommonTable) {
            serializable = (CvTblTableModel)this.getTable().getModel();
            if (!((CvTblTableModel)serializable).getVertical()) {
                ((CvCommonTable)this.getTable()).clearSelection();
            }
            if (this.getTable().getCellEditor() != null) {
                this.getTable().getCellEditor().stopCellEditing();
            }
        }
        if ((mouseEvent.getModifiers() & 0x10) != 0) {
            CvTblTableModel cvTblTableModel;
            if (this.getTable() instanceof CvCommonTable && !(cvTblTableModel = (CvTblTableModel)((JTable)(serializable = (CvCommonTable)this.getTable())).getModel()).getVertical()) {
                Point point = mouseEvent.getPoint();
                int n = this.columnAtPoint(point);
                this.getTable().setColumnSelectionInterval(n, n);
                ((CvCommonTable)this.getTable()).setSelectedCol(n);
                SMTblSelectionInfo sMTblSelectionInfo = new SMTblSelectionInfo(3, n);
                ((CvCommonTable)serializable).setContextSelection(sMTblSelectionInfo);
                CvTblTableEvent cvTblTableEvent = new CvTblTableEvent(serializable, 5, "", "", 0, 0);
                ((CvCommonTable)serializable).sendTableEvent(cvTblTableEvent);
            }
            this.pressPending = false;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.pressPending = true;
        CvTblTableModel cvTblTableModel = (CvTblTableModel)this.getTable().getModel();
        if (!mouseEvent.isPopupTrigger() && !cvTblTableModel.getVertical()) {
            ((CvCommonTable)this.getTable()).clearSelection();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Serializable serializable;
        if (this.pressPending && this.getTable() instanceof CvCommonTable) {
            serializable = (CvTblTableModel)this.getTable().getModel();
            if (this.getTable().getCellEditor() != null) {
                this.getTable().getCellEditor().stopCellEditing();
            }
        }
        if (this.pressPending && (mouseEvent.getModifiers() & 0x10) != 0 && this.getTable() instanceof CvCommonTable) {
            serializable = (CvCommonTable)this.getTable();
            if (this.pressPending && mouseEvent.getClickCount() == 1) {
                CvTblTableModel cvTblTableModel = (CvTblTableModel)((JTable)serializable).getModel();
                if (!cvTblTableModel.getVertical()) {
                    Point point = mouseEvent.getPoint();
                    int n = this.columnAtPoint(point);
                    this.getTable().setColumnSelectionInterval(n, n);
                    ((CvCommonTable)this.getTable()).setSelectedCol(n);
                    SMTblSelectionInfo sMTblSelectionInfo = new SMTblSelectionInfo(3, n);
                    ((CvCommonTable)serializable).setContextSelection(sMTblSelectionInfo);
                    CvTblTableEvent cvTblTableEvent = new CvTblTableEvent(serializable, 5, "", "", 0, 0);
                    ((CvCommonTable)serializable).sendTableEvent(cvTblTableEvent);
                }
                this.pressPending = false;
            } else if (mouseEvent.getClickCount() == 2) {
                TableColumnModel tableColumnModel = ((JTable)serializable).getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                this.sortColumn(n);
            }
        }
        this.pressPending = false;
    }

    public void sortColumn(int n) {
        if (n < 0) {
            return;
        }
        CvCommonTable cvCommonTable = (CvCommonTable)this.getTable();
        CvTblTableModel cvTblTableModel = (CvTblTableModel)cvCommonTable.getModel();
        if (cvTblTableModel.getIsLarge() || cvTblTableModel.getVertical()) {
            return;
        }
        TableColumnModel tableColumnModel = cvCommonTable.getColumnModel();
        CvTblTableColumn cvTblTableColumn = (CvTblTableColumn)tableColumnModel.getColumn(n);
        if ((n = cvCommonTable.convertColumnIndexToModel(n)) != -1) {
            int n2 = cvTblTableColumn.getStatus();
            boolean bl = true;
            if (n2 == CvTblTableColumn.ASCENDING) {
                n2 = CvTblTableColumn.DESCENDING;
                bl = false;
            } else {
                n2 = CvTblTableColumn.ASCENDING;
            }
            cvTblTableColumn.setStatus(n2);
            Vector vector = cvTblTableModel.getSortingColumns();
            if (vector != null) {
                int n3 = 0;
                while (n3 < vector.size()) {
                    int n4 = (Integer)vector.get(n3);
                    if (n4 != n) {
                        n4 = cvCommonTable.convertColumnIndexToView(n4);
                        cvTblTableColumn = (CvTblTableColumn)tableColumnModel.getColumn(n4);
                        cvTblTableColumn.setStatus(CvTblTableColumn.NORMAL);
                    }
                    ++n3;
                }
            }
            cvTblTableModel.sortByColumn(n, bl, cvCommonTable);
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }
}

