/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.tools.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import javax.swing.text.DefaultCaret;

class OurTextField
extends JTextField
implements FocusListener {
    private boolean hasFocus = false;

    public OurTextField() {
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.setCaret(new DefaultCaret());
        this.addFocusListener(this);
    }

    public OurTextField(String string) {
        super(string);
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.setCaret(new DefaultCaret());
        this.addFocusListener(this);
    }

    public OurTextField(String string, int n) {
        super(string, n);
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.setCaret(new DefaultCaret());
        this.addFocusListener(this);
    }

    public void focusGained(FocusEvent focusEvent) {
        this.selectAll();
        this.requestFocus();
        this.setForeground(Color.blue);
        this.getCaret().setVisible(true);
        this.hasFocus = true;
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.setSelectionStart(0);
        this.setSelectionEnd(0);
        this.setForeground(Color.black);
        this.getCaret().setVisible(false);
        this.hasFocus = false;
        this.repaint();
    }

    public Insets getInsets() {
        return new Insets(4, 5, 4, 4);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isRequestFocusEnabled() {
        return true;
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        super.paint(graphics);
        if (this.hasFocus) {
            graphics.setColor(Color.blue);
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

