/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.alarms;

import com.sun.symon.base.client.SMResourceAccess;
import com.sun.symon.base.client.SMUtility;
import com.sun.symon.base.client.alarm.SMAlarmObjectData;
import com.sun.symon.base.console.alarms.AlarmPanel;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcListUtil;
import java.util.Date;
import javax.swing.ImageIcon;

class AlarmData {
    static final int NO_ACTION = 0;
    static final int PENDING = 1;
    static final int EXECUTED = 2;
    final String[] actionStatus = new String[]{"no action", "pending", "executed"};
    Object alarmId;
    Object start;
    Object action;
    Object host;
    Object message;
    Object[] cell;
    private int sevIndex;
    int stateIndex;
    int actionStatusIndex = 0;
    String ruleId;
    String fixUser;
    String longMessage;
    private String Url;
    private String ackUser;
    long startTime;
    long endTime;
    long fixTime;
    private long ackTime;
    private boolean bIsAcked = false;

    String getId() {
        return (String)this.alarmId;
    }

    String getHost() {
        return (String)this.host;
    }

    String getMessage() {
        return (String)this.message;
    }

    String getAction() {
        return (String)this.action;
    }

    void setAction(String string) {
        this.action = string;
    }

    String getActionStatus() {
        return this.actionStatus[this.actionStatusIndex];
    }

    int getActionStatusIndex() {
        return this.actionStatusIndex;
    }

    int getSevIndex() {
        return this.sevIndex;
    }

    void setSevIndex(int n) {
        this.sevIndex = n;
    }

    boolean isAcked() {
        return this.bIsAcked;
    }

    String getAckUser() {
        return this.ackUser;
    }

    void setAckUser(String string) {
        this.bIsAcked = true;
        this.ackUser = string;
    }

    long getAckTime() {
        return this.ackTime;
    }

    void setAckTime(long l) {
        this.bIsAcked = true;
        this.ackTime = l;
    }

    String getUrl() {
        return this.Url;
    }

    public AlarmData() {
        this.alarmId = "";
        this.start = "";
        this.action = "";
        this.host = "";
        this.message = "";
        this.ruleId = "";
        this.stateIndex = -1;
        this.sevIndex = -1;
        this.fixTime = 0L;
        this.ackTime = 0L;
        this.endTime = 0L;
        this.startTime = 0L;
    }

    public AlarmData(AlarmPanel alarmPanel, int n) {
        SMResourceAccess sMResourceAccess = new SMResourceAccess(alarmPanel.getRawRequestHandle());
        this.cell = new Object[n];
        this.cell[0] = new ImageIcon(sMResourceAccess.getImage("stdimages/alarmSev1Ack.gif"));
        this.cell[1] = UcInternationalizer.getFormatedShortDate((Date)new Date());
        this.cell[2] = new ImageIcon(sMResourceAccess.getImage("stdimages/alarmOpen.gif"));
        this.cell[3] = " ";
        this.cell[4] = new String(new char[100]);
    }

    public AlarmData(SMAlarmObjectData sMAlarmObjectData) {
        this.start = UcInternationalizer.getFormatedShortDate((Date)new Date(sMAlarmObjectData.getOpenTimestamp() * 1000L));
        this.alarmId = sMAlarmObjectData.getAlarmId();
        this.Url = sMAlarmObjectData.getMoURL();
        this.host = sMAlarmObjectData.getHost();
        this.action = sMAlarmObjectData.getActionName();
        this.actionStatusIndex = sMAlarmObjectData.getActionStatus();
        String string = sMAlarmObjectData.getAlarmShortText();
        this.message = SMUtility.e2Dot((String)UcListUtil.AsciiToUnicode((String)string));
        this.message = this.replaceTab((String)this.message);
        String string2 = sMAlarmObjectData.getSeverity();
        this.bIsAcked = sMAlarmObjectData.isAcked();
        this.sevIndex = string2.compareTo("DWN") == 0 ? (this.bIsAcked ? 1 : 0) : (string2.compareTo("ERR") == 0 ? (this.bIsAcked ? 3 : 2) : (string2.compareTo("WRN") == 0 ? (this.bIsAcked ? 5 : 4) : (string2.compareTo("INF") == 0 ? (this.bIsAcked ? 7 : 6) : (this.bIsAcked ? 9 : 8))));
        this.stateIndex = sMAlarmObjectData.isClosed() ? 1 : 0;
        this.ruleId = sMAlarmObjectData.getAlarmRuleId();
        this.startTime = sMAlarmObjectData.getOpenTimestamp() * 1000L;
        this.endTime = sMAlarmObjectData.getCloseTimestamp() * 1000L;
        this.fixTime = sMAlarmObjectData.getFixTimestamp() * 1000L;
        this.fixUser = sMAlarmObjectData.getFixOperator();
        this.ackTime = sMAlarmObjectData.getAckTimestamp() * 1000L;
        this.ackUser = sMAlarmObjectData.getAckOperator();
    }

    private String replaceTab(String string) {
        if (string.indexOf("\t") < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\t') {
                stringBuffer.append("    ");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

