/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.task;

import com.sun.symon.base.beans.BcTreeNode;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.common.MSProperties;
import com.sun.symon.base.mgmtservice.task.MtTaskRunner;
import java.io.PrintWriter;
import javax.swing.tree.MutableTreeNode;

public class MtExecPool {
    private static final int POOL_SIZE = 6;
    private static int poolSize = 6;
    private static MtExecPool thePool = new MtExecPool();
    private MtTaskRunner[] pool;

    private MtExecPool() {
        try {
            MSProperties mSProperties = new MSProperties();
            mSProperties.load("AdvancedServices/cfg/core/taskreq");
            poolSize = Integer.parseInt(mSProperties.getProperty("thread.maxRequests"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        MSLogPrintWriter.getDebugWriter().println("thread.maxRequests: " + poolSize);
        this.pool = new MtTaskRunner[poolSize];
        int n = 0;
        while (n < poolSize) {
            this.pool[n] = new MtTaskRunner();
            ++n;
        }
        boolean bl = BcTreeNode.isDebugOn();
        Object var3_5 = null;
        if (bl) {
            BcTreeNode bcTreeNode = BcTreeNode.getRootNode();
            bcTreeNode.add((MutableTreeNode)new BcTreeNode("request_exec", (Object)this));
        }
    }

    public static MtExecPool getExecPool() {
        return thePool;
    }

    public MtTaskRunner getTaskRunner() {
        int n = 0;
        while (n < poolSize) {
            if (this.pool[n].isAvailable()) {
                return this.pool[n];
            }
            ++n;
        }
        return null;
    }

    private int countAvailable() {
        int n = 0;
        int n2 = 0;
        while (n2 < poolSize) {
            if (this.pool[n2].isAvailable()) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public synchronized void info(BcTreeNode bcTreeNode, String[] stringArray) {
        this.info(bcTreeNode.getOut());
    }

    public synchronized void info(PrintWriter printWriter) {
        printWriter.println("Allocated request threads: " + poolSize + " Available: " + this.countAvailable());
        int n = 0;
        while (n < poolSize) {
            if (!this.pool[n].isAvailable()) {
                printWriter.println("Thread " + n + " taken by request: " + this.pool[n].getRequest().getName() + ": " + this.pool[n].getRequest().getStartDate());
            }
            ++n;
        }
    }

    public synchronized void details(BcTreeNode bcTreeNode, String[] stringArray) {
        this.details(bcTreeNode.getOut());
    }

    public synchronized void details(PrintWriter printWriter) {
        if (this.countAvailable() == poolSize) {
            printWriter.println("All execution threads are available");
            return;
        }
        int n = 0;
        while (n < poolSize) {
            if (!this.pool[n].isAvailable()) {
                printWriter.println("Thread " + n + " taken + by request:" + (Object)((Object)this.pool[n].getRequest()));
            }
            ++n;
        }
    }
}

