/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.task;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.task.SMTaskData;
import com.sun.symon.base.client.task.SMTaskOperationData;
import com.sun.symon.base.mgmtservice.task.MtErrorInfo;
import com.sun.symon.base.mgmtservice.task.MtErrorInterpreter;

public class MtDefaultErrorInterpreter
implements MtErrorInterpreter {
    public void handleError(MtErrorInfo mtErrorInfo) {
        int n = mtErrorInfo.getIndex();
        SMTaskData sMTaskData = mtErrorInfo.getTask();
        SMTaskOperationData[] sMTaskOperationDataArray = sMTaskData.getOperations();
        SMTaskOperationData sMTaskOperationData = sMTaskOperationDataArray[n];
        Throwable throwable = mtErrorInfo.getThrowable();
        if (!(throwable instanceof SMAPIException)) {
            mtErrorInfo.setErrorMessage(throwable.getMessage());
            return;
        }
        SMAPIException sMAPIException = (SMAPIException)throwable;
        String string = sMAPIException.getMessageI18nKey();
        if (string == null) {
            string = "";
        }
        if (!string.equals("") && !string.endsWith(":smApiException")) {
            mtErrorInfo.setErrorMessage(string);
            return;
        }
        switch (sMAPIException.getReasonCode()) {
            case 1: {
                string = "TaskRequestLog.InsufficientSecurityPrivilege";
                break;
            }
            case 2: {
                string = "TaskRequestLog.UrlNotValid";
                break;
            }
            case 3: {
                String string2 = sMAPIException.getMessage();
                if (string2 == null) {
                    string = "TaskRequestLog.GenericError";
                    break;
                }
                if (string2.startsWith("Finder query error")) {
                    string = "TaskRequestLog.moduleMayNotLoaded";
                    break;
                }
                string = "TaskRequestLog.SetRequestError";
                break;
            }
            case 4: {
                string = "TaskRequestLog.ConnectionTimeout";
                break;
            }
            case 5: {
                string = "TaskRequestLog.InvalidType";
                break;
            }
            case 6: {
                string = "TaskRequestLog.TargetNotWriteable";
                break;
            }
            case 7: {
                string = "TaskRequestLog.ObjectNotExist";
                break;
            }
            default: {
                if (sMAPIException.getMessage() != null && !sMAPIException.getMessage().equals("")) {
                    mtErrorInfo.setErrorMessage(sMAPIException.getMessage());
                    return;
                }
                string = "TaskRequestLog.GenericError";
            }
        }
        mtErrorInfo.setErrorMessage("com.sun.symon.base.client.ClientApiMessages:" + string);
    }
}

