/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.tools.editor;

import com.sun.symon.base.client.attribute.SMAttributeEntryData;
import com.sun.symon.base.client.attribute.SMAttributeUpdateData;
import com.sun.symon.base.console.tools.editor.CtAttributeEditor;
import com.sun.symon.base.console.tools.editor.CtSchedulerTimex;
import com.sun.symon.base.console.tools.editor.CtTextField;
import com.sun.symon.base.utility.UcDialog;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CtTimexField
extends JPanel {
    private CtAttributeEditor theEditor;
    private String key;
    private String currentGroupKey;
    private String currentValue;
    private boolean changed = false;
    private boolean hasFocus = false;
    private CtSchedulerTimex dialog = null;
    private CtTextField textField;
    private JButton button;
    private GridBagLayout gridbag = new GridBagLayout();
    private GridBagConstraints c = new GridBagConstraints();
    private boolean isTimeWindow = false;

    public CtTimexField(SMAttributeEntryData sMAttributeEntryData, String string, CtAttributeEditor ctAttributeEditor, boolean bl) {
        this.isTimeWindow = bl;
        this.setLayout(this.gridbag);
        this.theEditor = ctAttributeEditor;
        this.currentGroupKey = string;
        this.key = sMAttributeEntryData.getKey();
        String string2 = "base.console.tools.editor.TimexLabels:scheduler_" + this.key;
        String string3 = UcInternationalizer.translateKey((String)string2);
        if (string3 == null || string3.equals(string2)) {
            string2 = "base.console.tools.editor.TimexLabels:scheduler";
            string3 = UcInternationalizer.translateKey((String)string2);
        }
        this.button = new JButton(string3);
        String string4 = UcInternationalizer.translateKey((String)(string2 + ".mnemonic"));
        this.button.setMnemonic(string4.charAt(0));
        this.textField = new CtTextField(sMAttributeEntryData, string, ctAttributeEditor);
        this.addRow(this.textField, this.button);
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFrame jFrame = CtTimexField.this.getTopFrame();
                JDialog jDialog = CtTimexField.this.getTopDialog();
                String string = UcInternationalizer.translateKey((String)"base.console.tools.editor.TimexLabels:dialogtitle");
                if (jFrame != null || jDialog != null) {
                    if (jFrame != null) {
                        CtTimexField.this.dialog = new CtSchedulerTimex((Frame)jFrame, string, CtTimexField.this);
                    } else {
                        CtTimexField.this.dialog = new CtSchedulerTimex((Dialog)jDialog, string, CtTimexField.this);
                    }
                    if (CtTimexField.this.dialog.isParseError()) {
                        if (UcDialog.showYesNo((String)UcInternationalizer.translateKey((String)"base.console.tools.editor.TimexLabels:unableToEditTimexAskNew")) == 0) {
                            CtTimexField.this.getTextField().setText("");
                            if (jFrame != null) {
                                CtTimexField.this.dialog = new CtSchedulerTimex((Frame)jFrame, "Scheduler", CtTimexField.this);
                            } else {
                                CtTimexField.this.dialog = new CtSchedulerTimex((Dialog)jDialog, "Scheduler", CtTimexField.this);
                            }
                        } else {
                            CtTimexField.this.dialog = null;
                            return;
                        }
                    }
                    CtTimexField.this.dialog.pack();
                    CtTimexField.this.dialog.show();
                    CtTimexField.this.dialog.setSchedulerInitialFocus();
                } else {
                    Toolkit.getDefaultToolkit().beep();
                    System.out.println("Cannot bring up the timex editor, since attribute editor is not in a JFrame");
                }
            }
        });
    }

    public CtAttributeEditor getAttributeEditor() {
        return this.theEditor;
    }

    private void addRow(Component component, Component component2) {
        this.c.insets = new Insets(0, 0, 0, 4);
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.fill = 2;
        this.c.gridwidth = 1;
        this.gridbag.setConstraints(component, this.c);
        this.add(component);
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.gridwidth = 0;
        this.gridbag.setConstraints(component2, this.c);
        this.add(component2);
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public JFrame getTopFrame() {
        Container container = this;
        while (container != null) {
            if (container instanceof JFrame) {
                return (JFrame)container;
            }
            container = container.getParent();
        }
        return null;
    }

    public JDialog getTopDialog() {
        Container container = this;
        while (container != null) {
            if (container instanceof JDialog) {
                return (JDialog)container;
            }
            container = container.getParent();
        }
        return null;
    }

    void resetDialog() {
        this.dialog = null;
    }

    void timexChanged(String string) {
        this.currentValue = string;
        this.textField.setText(this.currentValue);
        SMAttributeUpdateData sMAttributeUpdateData = new SMAttributeUpdateData(this.currentGroupKey, this.key, string);
        this.theEditor.updateSaveData(sMAttributeUpdateData);
        this.changed = true;
        this.theEditor.notifyEdited();
        this.textField.setForeground(this.theEditor.getEditedForeground());
    }
}

