/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.tools.editor;

import com.sun.symon.base.client.attribute.SMAttributeEntryData;
import com.sun.symon.base.client.attribute.SMAttributeUpdateData;
import com.sun.symon.base.console.tools.editor.CtAttributeEditor;
import com.sun.symon.base.console.tools.editor.CtFocusChangeEvent;
import com.sun.symon.base.console.tools.editor.CtFocusChangeListener;
import com.sun.symon.base.console.tools.editor.CtFocusTraversable;
import com.sun.symon.base.console.tools.editor.CtResetEvent;
import com.sun.symon.base.console.tools.editor.CtResetListener;
import com.sun.symon.base.console.tools.editor.CtSaveEvent;
import com.sun.symon.base.console.tools.editor.CtSaveListener;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CtTextArea
extends JTextArea
implements FocusListener,
DocumentListener,
CtFocusTraversable,
CtResetListener,
CtSaveListener {
    private CtAttributeEditor theEditor;
    private String key;
    private boolean access;
    private String originalValue = "";
    private String currentValue = "";
    private String currentGroupKey = "";
    private boolean lastEditable = false;
    private boolean changed = false;
    private boolean hasFocus = false;
    private Vector focusListener = new Vector();
    private Vector textListener = new Vector();

    public CtTextArea(SMAttributeEntryData sMAttributeEntryData, String string, CtAttributeEditor ctAttributeEditor) {
        this.theEditor = ctAttributeEditor;
        this.originalValue = sMAttributeEntryData.getValue();
        this.currentValue = this.originalValue = this.originalValue.replace('\t', ' ');
        this.currentGroupKey = string;
        this.key = sMAttributeEntryData.getKey();
        this.access = sMAttributeEntryData.getAccess();
        this.setText(this.currentValue);
        this.setEditable(this.access);
        if (!this.access) {
            this.setBackground(this.theEditor.getBackground());
            this.getCaret().setVisible(false);
        } else {
            this.setBackground(this.theEditor.getAttValueBackground());
        }
        this.addFocusListener(this);
        if (this.access) {
            this.getDocument().addDocumentListener(this);
            this.theEditor.addCtResetListener(this);
            this.theEditor.addCtSaveListener(this);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateSaveData();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateSaveData();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateSaveData();
    }

    private void updateSaveData() {
        this.changed = true;
        this.setForeground(this.theEditor.getEditedForeground());
        this.theEditor.notifyEdited();
        this.currentValue = this.getText();
        SMAttributeUpdateData sMAttributeUpdateData = new SMAttributeUpdateData(this.currentGroupKey, this.key, this.currentValue);
        this.theEditor.updateSaveData(sMAttributeUpdateData);
        this.setForeground(this.theEditor.getEditedForeground());
        this.repaint();
    }

    public synchronized void addCtFocusChangeListener(CtFocusChangeListener ctFocusChangeListener) {
        if (!this.focusListener.contains(ctFocusChangeListener)) {
            this.focusListener.addElement(ctFocusChangeListener);
        }
    }

    public void attributeReset(CtResetEvent ctResetEvent) {
        this.currentValue = this.originalValue;
        this.setText(this.currentValue);
        this.setFont(this.theEditor.getAttValueFont());
        this.setForeground(this.theEditor.getAttValueForeground());
        this.changed = false;
    }

    public void attributeSaved(CtSaveEvent ctSaveEvent) {
        this.currentValue = this.getText();
        this.originalValue = this.getText();
        this.setFont(this.theEditor.getAttValueFont());
        this.setForeground(this.theEditor.getAttValueForeground());
        this.changed = false;
        this.validate();
        this.repaint();
        super.repaint();
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.access) {
            this.selectAll();
            this.requestFocus();
            this.getCaret().setVisible(true);
            this.notifyFocusChange();
            this.hasFocus = true;
            this.repaint();
        } else {
            this.notifyFocusChange();
            this.requestFocus();
            this.hasFocus = true;
            this.repaint();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.changed) {
            this.currentValue = this.getText();
            SMAttributeUpdateData sMAttributeUpdateData = new SMAttributeUpdateData(this.currentGroupKey, this.key, this.currentValue);
            this.theEditor.updateSaveData(sMAttributeUpdateData);
            this.setForeground(this.theEditor.getEditedForeground());
        } else {
            this.setForeground(this.theEditor.getAttValueForeground());
        }
        this.getCaret().setVisible(false);
        this.hasFocus = false;
        this.repaint();
    }

    public Insets getInsets() {
        return new Insets(4, 4, 4, 4);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isRequestFocusEnabled() {
        return true;
    }

    public void notifyFocusChange() {
        Vector vector;
        CtFocusChangeEvent ctFocusChangeEvent = new CtFocusChangeEvent(this);
        CtTextArea ctTextArea = this;
        synchronized (ctTextArea) {
            vector = (Vector)this.focusListener.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            CtFocusChangeListener ctFocusChangeListener = (CtFocusChangeListener)vector.elementAt(n);
            ctFocusChangeListener.attributeFocusChanged(ctFocusChangeEvent);
            ++n;
        }
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        super.paint(graphics);
        if (this.hasFocus) {
            graphics.setColor(this.theEditor.getFocusedBorderColor());
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

