/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.remitters.snmpjob;

import com.sun.symon.base.beans.BcTreeNode;
import com.sun.symon.base.server.common.ScPortAllocator;
import com.sun.symon.base.server.common.ScRequestDispatchException;
import com.sun.symon.base.server.common.ScRequestSink;
import com.sun.symon.base.server.emitters.control.SeControlEmitter;
import com.sun.symon.base.server.events.SvRequestEvent;
import com.sun.symon.base.server.remitters.SmRemitter;
import com.sun.symon.base.server.remitters.cache.SmCacheRemitter;
import com.sun.symon.base.server.trap.SrTrapConstants;
import com.sun.symon.base.server.trap.SrTrapData;
import com.sun.symon.base.server.trap.SrTrapHandlerInterface;
import com.sun.symon.base.server.trap.SrTrapSubscriber;
import com.sun.symon.base.utility.UcDDL;

public class SmSnmpJobRemitter
extends SmRemitter
implements SrTrapConstants,
SrTrapHandlerInterface {
    private static final int PACKET_SIZE = 65536;
    private boolean Initd;
    private SmCacheRemitter Cache;
    private SeControlEmitter Controller;
    private SrTrapSubscriber trapSubscriber = null;
    private ScPortAllocator portAlloc = null;
    private boolean isSubscribed = false;
    private int[] trapList = new int[]{1, 2, 10, 21};

    public SmSnmpJobRemitter() {
        super(null);
        this.trapSubscriber = SrTrapSubscriber.getInstance();
        this.Cache = new SmCacheRemitter(){

            protected void jobAdded() {
                SmSnmpJobRemitter.this.subscribeTrap();
            }

            protected void cacheEmpty() {
                UcDDL.logInfoMessage((String)"trap writer stopped");
                SmSnmpJobRemitter.this.unsubscribeTrap();
            }
        };
        this.pushRemitter(this.Cache);
        this.Initd = false;
    }

    public synchronized boolean canHandle(SvRequestEvent svRequestEvent) {
        if (!this.Initd) {
            this.Initd = true;
            this.init();
        }
        return true;
    }

    public String getTrapCommunity() {
        return this.trapSubscriber.getTrapCommunity();
    }

    public String getTrapEnterprise() {
        return this.trapSubscriber.getTrapEnterprise();
    }

    public int getTrapFreq() {
        return this.trapSubscriber.getTrapFreq();
    }

    public String getTrapHost() {
        return this.trapSubscriber.getTrapHost();
    }

    public int getTrapPort() {
        return this.trapSubscriber.getTrapPort();
    }

    public void handleTrap(SrTrapData srTrapData) {
        int n = srTrapData.getType();
        String string = srTrapData.getSourceIp();
        String string2 = srTrapData.getContext();
        String string3 = srTrapData.getVarValue();
        if (n == 21) {
            this.emit(string, n);
            if (this.Controller != null) {
                this.Controller.handleWarmStartTrap(string);
            }
        } else if (n == 10) {
            if (this.Controller != null) {
                this.Controller.handleMibRestructureTrap(string);
            }
        } else {
            this.emit(string + ":" + string2 + ":" + string3.toString(), n);
        }
    }

    public void dumpCache(BcTreeNode bcTreeNode, String[] stringArray) {
        this.Cache.dumpCache(bcTreeNode, stringArray);
    }

    private void emit(final String string, final int n) {
        UcDDL.logDebugMessage((String)("trap key = '" + string + "'"));
        this.Cache.emit(new SmCacheRemitter.Matcher(){

            public boolean doEmit(String string2) {
                if (string2.compareTo(string) == 0) {
                    UcDDL.logInfoMessage((String)("remitting job, exact match for job key = " + string2));
                    return true;
                }
                if (n == 2) {
                    if (string2.startsWith(string) && string2.charAt(string.length()) == '.') {
                        UcDDL.logInfoMessage((String)("remitting job, partial refresh match for job key = " + string2 + " trap key = " + string));
                        return true;
                    }
                } else if (n == 1) {
                    if (string.startsWith(string2) && string.charAt(string2.length()) == '.') {
                        UcDDL.logInfoMessage((String)("remitting job, partial status match for job key = " + string2 + " trap key = " + string));
                        return true;
                    }
                } else if (n == 21 && string2.startsWith(string)) {
                    UcDDL.logInfoMessage((String)("remitting job, warm start match for job key = " + string2 + " trap key = " + string));
                    return true;
                }
                return false;
            }
        });
    }

    private void init() {
    }

    protected ScRequestSink newSink(SvRequestEvent svRequestEvent) throws ScRequestDispatchException {
        return null;
    }

    public void registerController(SeControlEmitter seControlEmitter) {
        this.Controller = seControlEmitter;
    }

    protected void finalize() throws Throwable {
        UcDDL.logInfoMessage((String)"SmSnmpJobRemiiter : FINALIZE() is called");
        this.unsubscribeTrap();
    }

    private synchronized void subscribeTrap() {
        if (!this.isSubscribed) {
            this.trapSubscriber.addHandler(this, this.trapList);
            this.isSubscribed = true;
        }
    }

    private synchronized void unsubscribeTrap() {
        if (this.isSubscribed) {
            this.trapSubscriber.removeHandler(this, this.trapList);
            this.isSubscribed = false;
        }
    }
}

