/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.receptors.rmi;

import com.sun.symon.base.server.common.ScPortAllocator;
import com.sun.symon.base.server.events.SvRequestListener;
import com.sun.symon.base.server.lookup.SlRMIRegistry;
import com.sun.symon.base.server.receptors.SrBaseReceptor;
import com.sun.symon.base.server.receptors.rmi.RMIResponseInterface;
import com.sun.symon.base.server.receptors.rmi.RMIServer;
import com.sun.symon.base.server.receptors.rmi.RMIServerException;
import com.sun.symon.base.server.receptors.rmi.RMIServerSession;
import com.sun.symon.base.server.receptors.rmi.SrRMIHttpReceptor;
import com.sun.symon.base.server.receptors.rmi.SrRMISecurity;
import com.sun.symon.base.server.receptors.rmi.SrRMISession;
import com.sun.symon.base.server.receptors.rmi.SrRMISessionService;
import com.sun.symon.base.utility.UcDDL;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class SrRMIReceptor
extends SrBaseReceptor {
    private String RmiHost = null;
    private int RmiPort = -1;
    private Vector alternateRmiHosts = new Vector();
    private SlRMIRegistry rmiRegistry;
    private Vector alternateRmiRegistries = new Vector();
    private SrRMIHttpReceptor ClassHandler = new SrRMIHttpReceptor();
    private SrRMISecurity rmiSecurity = null;
    public static SrRMIReceptor theReceptor;

    public SrRMIReceptor() throws RMIServerException {
        String string = this.ClassHandler.getCodeBase();
        Properties properties = System.getProperties();
        ((Hashtable)properties).put("java.rmi.server.codebase", string);
        System.setProperties(properties);
        UcDDL.logInfoMessage((String)("RMI HTTP server listening at codebase " + string));
        theReceptor = this;
    }

    public void addSvRequestListener(SvRequestListener svRequestListener) {
        super.addSvRequestListener(svRequestListener);
        this.ClassHandler.addSvRequestListener(svRequestListener);
    }

    public void removeSvRequestListener(SvRequestListener svRequestListener) {
        super.removeSvRequestListener(svRequestListener);
        this.ClassHandler.removeSvRequestListener(svRequestListener);
    }

    protected void restart() {
        if (this.RmiHost != null && this.RmiPort != -1 && this.securityURL != null && this.securityFlag != -1 && this.privateKey != null && this.privatePassword != null && this.configurationPort > 0 && this.configurationHost != null && !this.configurationHost.equals("")) {
            this.startServer();
        }
    }

    public void setRmiHost(String string) {
        this.RmiHost = string;
        if (this.RmiHost != null && this.RmiPort != -1) {
            this.rmiRegistry = new SlRMIRegistry(this.RmiHost, this.RmiPort);
            UcDDL.logInfoMessage((String)"SrRMIReceptor: Created RMIRegistry");
            this.setAlternateRmiHosts();
        }
        this.restart();
    }

    private void setAlternateRmiHosts() {
        int n;
        this.alternateRmiHosts = ScPortAllocator.getInstance().getIpAddresses();
        if (this.alternateRmiHosts.size() <= 1) {
            return;
        }
        try {
            String string = InetAddress.getByName(this.RmiHost).getHostAddress();
            n = 0;
            while (n < this.alternateRmiHosts.size()) {
                String string2 = InetAddress.getByName((String)this.alternateRmiHosts.elementAt(n)).getHostName();
                if (string2.equals(this.RmiHost) && ((String)this.alternateRmiHosts.elementAt(n)).equals(string)) {
                    this.alternateRmiHosts.removeElementAt(n);
                    break;
                }
                ++n;
            }
        }
        catch (UnknownHostException unknownHostException) {
            UcDDL.logErrorMessage((String)"SrRMIReceptor: Unable to start registry at alternate IP");
            unknownHostException.printStackTrace();
        }
        int n2 = this.RmiPort;
        n = 0;
        while (n < this.alternateRmiHosts.size()) {
            this.alternateRmiRegistries.addElement(new SlRMIRegistry((String)this.alternateRmiHosts.elementAt(n), n2));
            UcDDL.logInfoMessage((String)("SrRMIReceptor: Created alternate RMIRegistry at host = " + (String)this.alternateRmiHosts.elementAt(n) + "at port = " + n2));
            ++n;
        }
    }

    public void setRmiPort(int n) {
        this.RmiPort = n;
        if (this.RmiHost != null && this.RmiPort != -1) {
            this.rmiRegistry = new SlRMIRegistry(this.RmiHost, this.RmiPort);
            UcDDL.logInfoMessage((String)("SrRMIReceptor: Created RMIRegistry at host " + this.RmiHost + " and at port = " + this.RmiPort));
            this.setAlternateRmiHosts();
        }
        this.restart();
    }

    public boolean isAlternateHostAvailable() {
        return this.alternateRmiHosts.size() > 0;
    }

    public Vector getAlternateRmiHosts() {
        return this.alternateRmiHosts;
    }

    public SlRMIRegistry getRegistry() {
        return this.rmiRegistry;
    }

    public Vector getAlternateRegistries() {
        return this.alternateRmiRegistries;
    }

    protected void startServer() {
        try {
            new Server(this.RmiHost, this.RmiPort, this);
        }
        catch (RMIServerException rMIServerException) {
            UcDDL.logErrorMessage((String)("RMI host = " + this.RmiHost));
            UcDDL.logErrorMessage((String)("RMI port = " + this.RmiPort));
            UcDDL.logErrorMessage((String)"RMI init", (Throwable)rMIServerException);
        }
        if (this.securityURL.compareTo("") == 0) {
            this.securityURL = this.getConfigurationBaseURL() + "oid/1.3.6.1.4.1.42.2.12.2.2.34.1.0";
        }
        this.rmiSecurity = this.securityFlag == 0 ? new SrRMISecurity(this, "", this.privatePassword) : new SrRMISecurity(this, this.securityURL, this.privatePassword);
        if (this.sessionLimit == 0) {
            String string = null;
            try {
                string = System.getProperty("NUM_FDS");
                int n = Integer.parseInt(string);
                this.sessionLimit = (n - 30) / 4;
                if (this.sessionLimit < 1) {
                    this.sessionLimit = 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                UcDDL.logErrorMessage((String)("can't parse NUM_FDS: '" + string + "'"), (Throwable)numberFormatException);
                this.sessionLimit = -1;
            }
        }
        UcDDL.logInfoMessage((String)("Number of client sessions that will be allowed to connect: " + (this.sessionLimit == -1 ? "unlimited" : "" + this.sessionLimit)));
    }

    public RMIServerSession createSession(RMIResponseInterface rMIResponseInterface, String string) throws RemoteException {
        if (string != null) {
            return new SrRMISession(this.sySecurity, this, rMIResponseInterface, this.rmiSecurity, this.privateKey, string);
        }
        return new SrRMISession(this.sySecurity, this, rMIResponseInterface, this.rmiSecurity, this.privateKey);
    }

    public SrRMISessionService createSessionV3(RMIResponseInterface rMIResponseInterface, String string) throws RemoteException {
        if (string != null) {
            return new SrRMISessionService(this.sySecurity, this, rMIResponseInterface, this.rmiSecurity, this.privateKey, string);
        }
        return new SrRMISessionService(this.sySecurity, this, rMIResponseInterface, this.rmiSecurity, this.privateKey);
    }

    public static void init() throws Exception {
        new SrRMIReceptor().initialize();
    }

    private class Server
    extends RMIServer {
        Server(String string, int n, SrRMIReceptor srRMIReceptor2) throws RMIServerException {
            super(string, n, srRMIReceptor2);
        }

        protected RMIServerSession newSessionInterface(RMIResponseInterface rMIResponseInterface, String string) throws RemoteException {
            RMIServerSession rMIServerSession = SrRMIReceptor.this.addNewSession() ? SrRMIReceptor.this.createSession(rMIResponseInterface, string) : null;
            return rMIServerSession;
        }

        protected SrRMISessionService newSessionServiceInterface(RMIResponseInterface rMIResponseInterface, String string) throws RemoteException {
            SrRMISessionService srRMISessionService = SrRMIReceptor.this.addNewSession() ? SrRMIReceptor.this.createSessionV3(rMIResponseInterface, string) : null;
            return srRMISessionService;
        }
    }
}

