/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.receptors.rmi;

import com.sun.symon.base.server.common.ScSecurityCredential;
import com.sun.symon.base.server.receptors.SrRequest;
import com.sun.symon.base.server.receptors.SrSession;
import com.sun.symon.base.server.receptors.rmi.SrRMIHttpReceptor;
import com.sun.symon.base.server.types.StBytes;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.utility.UcDDL;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class SrRMIHttpSession
extends SrSession {
    private OutputStream output;
    private InputStream input;
    private String InputBuffer;

    public SrRMIHttpSession(Socket socket, SrRMIHttpReceptor srRMIHttpReceptor) {
        super(srRMIHttpReceptor);
        try {
            this.output = socket.getOutputStream();
            this.input = socket.getInputStream();
        }
        catch (IOException iOException) {
            UcDDL.logErrorMessage((String)"failed to get socket streams", (Throwable)iOException);
            return;
        }
        String string = this.readRequest();
        if (string == null) {
            this.cleanup();
        }
        this.processRequest(string);
    }

    private void cleanup() {
        if (this.output != null) {
            try {
                this.output.close();
            }
            catch (IOException iOException) {
                UcDDL.logErrorMessage((String)"failed to close output stream", (Throwable)iOException);
            }
        }
    }

    public ScSecurityCredential getUserTicket() {
        return null;
    }

    private void processRequest(String string) {
        String[] stringArray = new String[]{"cfile:" + string};
        this.requestCreate(1, stringArray, null, null).emit();
    }

    private String readRequest() {
        Object object;
        String string = null;
        byte[] byArray = new byte[500];
        do {
            int n;
            try {
                n = this.input.read(byArray);
                if (n == -1) {
                    UcDDL.logErrorMessage((String)"failed to read data");
                    return null;
                }
            }
            catch (IOException iOException) {
                UcDDL.logErrorMessage((String)"failed to read data", (Throwable)iOException);
                return null;
            }
            object = new byte[n];
            System.arraycopy(byArray, 0, object, 0, n);
        } while (!(string = string == null ? new String((byte[])object) : string + new String((byte[])object)).endsWith("\r\n\r\n"));
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        object = null;
        try {
            stringTokenizer.nextToken();
            object = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            UcDDL.logErrorMessage((String)("Can't find class name in request '" + string + "'"));
        }
        UcDDL.logInfoMessage((String)("RMI HTTP request for class '" + (String)object + "'"));
        return object;
    }

    public void requestResponse(SrRequest srRequest, StObject[][] stObjectArray) {
        byte[] byArray = ((StBytes)stObjectArray[0][0]).getValue();
        try {
            String string = "HTTP/1.0 200 ok\r\nContent-length: " + byArray.length + "\r\n" + "Content-type: application/octet-stream\r\n" + "\r\n";
            this.output.write(string.getBytes());
            this.output.write(byArray);
            this.output.flush();
        }
        catch (IOException iOException) {
            UcDDL.logErrorMessage((String)"write socket failed", (Throwable)iOException);
        }
        this.cleanup();
    }

    protected void requestResponse(SrRequest srRequest, String string, Exception exception) {
        UcDDL.logErrorMessage((String)("request failed for url '" + string + "'"), (Throwable)exception);
        this.cleanup();
    }
}

