/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.receptors.rmi;

import com.sun.symon.base.server.lookup.SlRMIClientSocket;
import com.sun.symon.base.server.lookup.SlRMIRegistry;
import com.sun.symon.base.server.lookup.SlRMIServerSocket;
import com.sun.symon.base.server.receptors.rmi.RMICollectorInterface;
import com.sun.symon.base.server.receptors.rmi.RMIResponseInterface;
import com.sun.symon.base.server.receptors.rmi.RMIServerException;
import com.sun.symon.base.server.receptors.rmi.RMIServerSession;
import com.sun.symon.base.server.receptors.rmi.RMIServiceCollectorInterface;
import com.sun.symon.base.server.receptors.rmi.RMISessionInterface;
import com.sun.symon.base.server.receptors.rmi.RMISessionServiceInterface;
import com.sun.symon.base.server.receptors.rmi.SrRMIReceptor;
import com.sun.symon.base.server.receptors.rmi.SrRMISessionService;
import com.sun.symon.base.utility.UcDDL;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Vector;

public abstract class RMIServer {
    public RMIServer(String string, int n, SrRMIReceptor srRMIReceptor) throws RMIServerException {
        try {
            SlRMIRegistry slRMIRegistry = srRMIReceptor.getRegistry();
            slRMIRegistry.bind("RMIClientServer", new Collector(this));
            slRMIRegistry.bind("RMIClientServerV3", new CollectorV3(this));
            if (srRMIReceptor.isAlternateHostAvailable()) {
                Vector vector = srRMIReceptor.getAlternateRegistries();
                Vector vector2 = srRMIReceptor.getAlternateRmiHosts();
                int n2 = 0;
                while (n2 < vector.size()) {
                    ((SlRMIRegistry)vector.elementAt(n2)).bind("RMIClientServer", new Collector(this, (String)vector2.elementAt(n2)));
                    ((SlRMIRegistry)vector.elementAt(n2)).bind("RMIClientServerV3", new CollectorV3(this, (String)vector2.elementAt(n2)));
                    ++n2;
                }
            }
            UcDDL.logInfoMessage((String)"RMIServer: Bound the remote objects to the registry");
        }
        catch (RemoteException remoteException) {
            UcDDL.logErrorMessage((String)"can't start and bind registry", (Throwable)remoteException);
            System.err.println("can't start and bind registry\n" + remoteException);
            UcDDL.logErrorMessage((String)"*** terminating execution ***");
            System.err.println("*** terminating execution ***");
            System.exit(1);
        }
        int n3 = UcDDL.createChannel((String)"snmp");
        if (UcDDL.channelIsActive((int)n3)) {
            System.err.println("The snmp DDL channel is active.  This may");
            System.err.println("cause the server to fail to process snmp");
            System.err.println("responses.  It is recommended that the");
            System.err.println("snmp channel be deactivated by editing");
            System.err.println("the configuration files.");
        }
    }

    protected abstract RMIServerSession newSessionInterface(RMIResponseInterface var1, String var2) throws RemoteException;

    protected abstract SrRMISessionService newSessionServiceInterface(RMIResponseInterface var1, String var2) throws RemoteException;

    private class CollectorV3
    extends UnicastRemoteObject
    implements RMIServiceCollectorInterface {
        private RMIServer server = null;
        private String host = null;

        public CollectorV3(RMIServer rMIServer2) throws RemoteException {
            this.server = rMIServer2;
        }

        public CollectorV3(RMIServer rMIServer2, String string) throws RemoteException {
            super(0, new SlRMIClientSocket(string), new SlRMIServerSocket(string));
            this.server = rMIServer2;
            this.host = string;
        }

        public RMISessionServiceInterface getSessionObject(RMIResponseInterface rMIResponseInterface) throws RemoteException {
            return this.server.newSessionServiceInterface(rMIResponseInterface, this.host);
        }
    }

    private class Collector
    extends UnicastRemoteObject
    implements RMICollectorInterface {
        private RMIServer server = null;
        private String host = null;

        public Collector(RMIServer rMIServer2) throws RemoteException {
            this.server = rMIServer2;
        }

        public Collector(RMIServer rMIServer2, String string) throws RemoteException {
            super(0, new SlRMIClientSocket(string), new SlRMIServerSocket(string));
            this.server = rMIServer2;
            this.host = string;
        }

        public RMISessionInterface getSessionObject(RMIResponseInterface rMIResponseInterface) throws RemoteException {
            return this.server.newSessionInterface(rMIResponseInterface, this.host);
        }
    }
}

