/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.emitters.snmp;

import com.sun.symon.base.server.common.ScRequestSinkInterface;
import com.sun.symon.base.server.emitters.snmp.SeSnmpEmitter;
import com.sun.symon.base.server.emitters.snmp.SeSnmpException;
import com.sun.symon.base.server.emitters.snmp.SeSnmpRequestor;
import com.sun.symon.base.server.trap.SrTrapData;
import com.sun.symon.base.server.trap.SrTrapHandlerInterface;
import com.sun.symon.base.server.trap.SrTrapSubscriber;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.utility.UcDDL;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SeSnmpPrivCache
implements SrTrapHandlerInterface {
    static int cnt = 0;
    static SeSnmpPrivCache instance = null;
    public static final int NEED_DOWNGRADE = 0;
    public static final int DONT_DOWNGRADE = 1;
    public static final int UNKNOWN_REMOTE = 2;
    Map priv_oid;
    Map priv_wait;
    String privReqOid;
    SeSnmpRequestor snmpReq;

    private SeSnmpPrivCache() {
    }

    public static synchronized SeSnmpPrivCache getInstance(String string, SeSnmpRequestor seSnmpRequestor) {
        if (instance != null) {
            return instance;
        }
        instance = new SeSnmpPrivCache();
        SeSnmpPrivCache.instance.priv_oid = new HashMap();
        SeSnmpPrivCache.instance.priv_wait = new HashMap();
        SeSnmpPrivCache.instance.privReqOid = string + ".0";
        SeSnmpPrivCache.instance.snmpReq = seSnmpRequestor;
        SrTrapSubscriber srTrapSubscriber = SrTrapSubscriber.getInstance();
        int[] nArray = new int[]{22};
        srTrapSubscriber.addHandler(instance, nArray);
        return instance;
    }

    public int resolveRemote(InetAddress inetAddress, int n, int n2, int n3, int n4) throws SeSnmpException {
        Object object;
        WaitObject waitObject;
        String string = inetAddress.getHostAddress() + ":" + n;
        int n5 = this.downgradeSecurityLevel(string, n2, n3, n4);
        if (n5 != 2) {
            return n5;
        }
        SeSnmpPrivCache seSnmpPrivCache = this;
        synchronized (seSnmpPrivCache) {
            waitObject = (WaitObject)this.priv_wait.get(string);
        }
        if (waitObject == null) {
            object = new PrivOIDRequest(inetAddress, n, n4, this);
            waitObject = ((PrivOIDRequest)object).waitThis;
        }
        try {
            object = waitObject;
            synchronized (object) {
                while (!waitObject.done) {
                    waitObject.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (waitObject.ex == null) {
            n5 = this.downgradeSecurityLevel(string, n2, n3, n4);
            return n5;
        }
        throw waitObject.ex;
    }

    private int downgradeSecurityLevel(String string, int n, int n2, int n3) {
        String string2;
        if (n2 != 3) {
            return 1;
        }
        if (n3 != 4 && n3 != 5) {
            return 1;
        }
        if (n != 0 && n != 1 && n != 2 && n != 6) {
            return 1;
        }
        SeSnmpPrivCache seSnmpPrivCache = this;
        synchronized (seSnmpPrivCache) {
            string2 = (String)this.priv_oid.get(string);
        }
        if (string2 == null) {
            return 2;
        }
        if (string2.equals(SeSnmpEmitter.DESCBC_OID)) {
            return 1;
        }
        return 0;
    }

    public String dumpCaches() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n*** Privacy OID Cache ***\n");
        SeSnmpPrivCache seSnmpPrivCache = this;
        synchronized (seSnmpPrivCache) {
            Set set = this.priv_oid.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)this.priv_oid.get(string);
                stringBuffer.append(string + " " + string2 + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public void clearHost(String string) {
        SeSnmpPrivCache seSnmpPrivCache = this;
        synchronized (seSnmpPrivCache) {
            Set set = this.priv_oid.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!string2.startsWith(string)) continue;
                UcDDL.logInfoMessage((String)("PrivOIDCache: remove " + string2));
                iterator.remove();
            }
        }
    }

    public void clearHostPort(String string, String string2) {
        String string3 = string + ":" + string2;
        SeSnmpPrivCache seSnmpPrivCache = this;
        synchronized (seSnmpPrivCache) {
            Object v = this.priv_oid.remove(string3);
            if (v != null) {
                UcDDL.logInfoMessage((String)("PrivOIDCache: remove " + string3));
            }
        }
    }

    public void wipeCaches() {
        SeSnmpPrivCache seSnmpPrivCache = this;
        synchronized (seSnmpPrivCache) {
            UcDDL.logInfoMessage((String)"PrivOIDCache: clear cache");
            this.priv_oid.clear();
        }
    }

    public void handleTrap(SrTrapData srTrapData) {
        Object object;
        Object object2;
        ArrayList arrayList = new ArrayList();
        SeSnmpPrivCache seSnmpPrivCache = this;
        synchronized (seSnmpPrivCache) {
            object2 = this.priv_wait.keySet();
            object = object2.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                if (!string.startsWith(srTrapData.getSourceIp())) continue;
                arrayList.add(this.priv_wait.get(string));
            }
            this.clearHost(srTrapData.getSourceIp());
        }
        if (arrayList.size() == 0) {
            return;
        }
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            object = (WaitObject)object2.next();
            try {
                new PrivOIDRequest(((WaitObject)object).ip, ((WaitObject)object).port, ((WaitObject)object).model, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class PrivOIDRequest
    implements SeSnmpRequestor.ResultCallback {
        ScRequestSinkInterface _req;
        SeSnmpPrivCache privCache;
        WaitObject waitThis;
        String address;
        int id;

        PrivOIDRequest(InetAddress inetAddress, int n, int n2, SeSnmpPrivCache seSnmpPrivCache2) throws SeSnmpException {
            this.privCache = seSnmpPrivCache2;
            this.waitThis = new WaitObject();
            this.waitThis.model = n2;
            this.waitThis.ip = inetAddress;
            this.waitThis.port = n;
            this.id = this.waitThis.id;
            String[] stringArray = new String[]{SeSnmpPrivCache.this.privReqOid};
            this._req = seSnmpPrivCache2.snmpReq.createRequestByOid(inetAddress, n, 1, null, 2, n2, null, stringArray, null, this);
            this.address = inetAddress.getHostAddress() + ":" + n;
            SeSnmpPrivCache seSnmpPrivCache3 = seSnmpPrivCache2;
            synchronized (seSnmpPrivCache3) {
                WaitObject waitObject = (WaitObject)seSnmpPrivCache2.priv_wait.get(this.address);
                if (waitObject != null) {
                    waitObject.id = this.id;
                    this.waitThis = waitObject;
                } else {
                    seSnmpPrivCache2.priv_wait.put(this.address, this.waitThis);
                }
            }
            this._req.emit();
        }

        public void handleResultBulk(StObject[][] stObjectArray) {
        }

        public synchronized void handleResult(StObject[] stObjectArray) {
            this._req.delete();
            SeSnmpPrivCache seSnmpPrivCache = this.privCache;
            synchronized (seSnmpPrivCache) {
                WaitObject waitObject = (WaitObject)this.privCache.priv_wait.get(this.address);
                if (waitObject != null && this.id == waitObject.id) {
                    String string = stObjectArray[0].toString();
                    UcDDL.logInfoMessage((String)("PrivOIDCache: add " + this.address + "=" + string));
                    this.privCache.priv_oid.put(this.address, string);
                    this.privCache.priv_wait.remove(this.address);
                    waitObject.done();
                }
            }
        }

        public synchronized void handleException(SeSnmpException seSnmpException) {
            this._req.delete();
            SeSnmpPrivCache seSnmpPrivCache = this.privCache;
            synchronized (seSnmpPrivCache) {
                WaitObject waitObject = (WaitObject)this.privCache.priv_wait.get(this.address);
                if (waitObject != null && this.id == waitObject.id) {
                    UcDDL.logInfoMessage((String)("PrivOIDCache: error " + this.address), (Throwable)seSnmpException);
                    this.privCache.priv_wait.remove(this.address);
                    waitObject.done(seSnmpException);
                }
            }
        }
    }

    class WaitObject {
        int id;
        int model;
        boolean done;
        InetAddress ip;
        int port;
        SeSnmpException ex;
        static /* synthetic */ Class class$com$sun$symon$base$server$emitters$snmp$SeSnmpPrivCache;

        WaitObject() {
            Class clazz = class$com$sun$symon$base$server$emitters$snmp$SeSnmpPrivCache == null ? (class$com$sun$symon$base$server$emitters$snmp$SeSnmpPrivCache = WaitObject.class$("com.sun.symon.base.server.emitters.snmp.SeSnmpPrivCache")) : class$com$sun$symon$base$server$emitters$snmp$SeSnmpPrivCache;
            synchronized (clazz) {
                this.id = cnt++;
            }
            this.done = false;
            this.ex = null;
        }

        synchronized void done() {
            this.done = true;
            this.notifyAll();
        }

        synchronized void done(SeSnmpException seSnmpException) {
            this.ex = seSnmpException;
            this.done();
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

