/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.emitters.snmp;

import com.sun.symon.base.server.common.ScPortAllocator;
import com.sun.symon.base.server.snmp.SsDecodeException;
import com.sun.symon.base.server.snmp.SsEncodeException;
import com.sun.symon.base.server.snmp.SsMessage;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcQueueProcessor;
import java.io.IOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Hashtable;

public class SeSnmpPortal {
    private static int id = 0;
    private DatagramSocket socket;
    private Thread reader = null;
    private Hashtable listeners = null;
    private int size;
    private UcQueueProcessor processor;
    private ScPortAllocator portAlloc = ScPortAllocator.getInstance();

    public SeSnmpPortal(int n) throws SocketException {
        try {
            this.socket = this.portAlloc.getUDPSocket();
        }
        catch (SocketException socketException) {
            if (socketException instanceof BindException) {
                UcDDL.logErrorMessage((String)"SeSnmpPortal : port BUSY");
            }
            UcDDL.logErrorMessage((String)"SeSnmpPortal : Scoket creation Exception ");
        }
        UcDDL.logDebugMessage((String)("SeSnmpPortal : UDP Scoket Created : Local Port = " + this.socket.getLocalPort()));
        this.listeners = new Hashtable();
        this.size = n;
        this.reader = new Thread(new Runnable(){

            public void run() {
                SeSnmpPortal.this.readMsgThread();
            }
        }, "UDP Reader");
        this.reader.setPriority(10);
        this.reader.start();
        this.processor = new UcQueueProcessor("UDP Processor");
    }

    public synchronized void unregister(int n) {
        this.listeners.remove(new Integer(n));
        UcDDL.logDebugMessage((String)("# outstanding packet listeners = " + this.listeners.size()));
    }

    private static synchronized int getId() {
        return id++;
    }

    private SsMessage receive() throws IOException, SsDecodeException {
        byte[] byArray = new byte[this.size];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
        this.socket.receive(datagramPacket);
        UcDDL.logDebugMessage((String)("receive packet length = " + datagramPacket.getLength()));
        byte[] byArray2 = new byte[datagramPacket.getLength()];
        System.arraycopy(byArray, 0, byArray2, 0, datagramPacket.getLength());
        return SsMessage.toMessage(byArray2);
    }

    public synchronized int register(ResponseHandler responseHandler) {
        int n;
        Integer n2;
        while (this.listeners.get(n2 = new Integer(n = SeSnmpPortal.getId())) != null) {
        }
        this.listeners.put(n2, responseHandler);
        UcDDL.logDebugMessage((String)("# outstanding packet listeners = " + this.listeners.size()));
        UcDDL.logDebugMessage((String)("new portal response listener added: sendId = " + n));
        return n;
    }

    private void readMsgThread() {
        while (true) {
            try {
                while (true) {
                    SsMessage ssMessage;
                    if ((ssMessage = this.receive()) == null) {
                        UcDDL.logErrorMessage((String)"received NULL message");
                        continue;
                    }
                    this.queueMsg(ssMessage);
                    ssMessage = null;
                }
            }
            catch (IOException iOException) {
                UcDDL.logErrorMessage((String)"receive() failed", (Throwable)iOException);
                continue;
            }
            catch (SsDecodeException ssDecodeException) {
                UcDDL.logErrorMessage((String)"receive() failed", (Throwable)ssDecodeException);
                continue;
            }
            break;
        }
    }

    private void queueMsg(final SsMessage ssMessage) {
        this.processor.add(new Runnable(){

            public void run() {
                SeSnmpPortal.this.processMsg(ssMessage);
            }
        });
    }

    private void processMsg(SsMessage ssMessage) {
        ResponseHandler responseHandler;
        switch (ssMessage.getVersion()) {
            case 1: {
                if (ssMessage.getType() != 4) break;
                UcDDL.logWarningMessage((String)"SeDatagramPortal ignoring version 1 traps");
                return;
            }
            case 3: {
                if (ssMessage.getType() != 3) break;
                UcDDL.logWarningMessage((String)"SeDatagramPortal ignoring version 2u traps");
                return;
            }
        }
        int n = ssMessage.getSendId();
        UcDDL.logDebugMessage((String)("received send id = " + n));
        SeSnmpPortal seSnmpPortal = this;
        synchronized (seSnmpPortal) {
            responseHandler = (ResponseHandler)this.listeners.get(new Integer(n));
        }
        if (responseHandler == null) {
            UcDDL.logWarningMessage((String)"SeDatagramPortal no listener, discarding message");
        } else {
            responseHandler.handleResponse(ssMessage);
        }
        responseHandler = null;
    }

    public synchronized void sendMsg(SsMessage ssMessage, InetAddress inetAddress, int n) throws IOException, SsEncodeException {
        UcDDL.logDebugMessage((String)"sending packet");
        ssMessage.setRequestId(SeSnmpPortal.getId());
        byte[] byArray = ssMessage.toBytestreamAndDump();
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, n);
        UcDDL.logDebugMessage((String)("send packet length = " + datagramPacket.getLength()));
        this.socket.send(datagramPacket);
    }

    public static interface ResponseHandler {
        public void handleResponse(SsMessage var1);
    }
}

