/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.common;

import com.sun.symon.base.client.service.SMDatabaseException;
import com.sun.symon.base.mgmtservice.common.MSDB;
import com.sun.symon.base.utility.UcBeanIntrospector;
import com.sun.symon.base.utility.UcDDL;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ScPortAllocator {
    private static final int MAX_PORT = 65535;
    private static final int MIN_PORT = 1100;
    private int maxTCPPort = -1;
    private int minTCPPort = -1;
    private int maxUDPPort = -1;
    private int minUDPPort = -1;
    private static ScPortAllocator _instance = null;
    private Vector ipAddresses = new Vector();
    private Hashtable agentAndTrap = new Hashtable();
    private static final String AGENT_TRAP_QUERY = "select trapdest from entity_info where IP_ADDRESS =";
    private static final String AGENT_TRAP_QUERY_1 = " and topo_parse_url(url) =";
    private static String multiIPFile = "/var/opt/SUNWsymon/cfg/multiip.dat";
    private String serverMode = "ip";
    private String topologyHost;
    private static int lastTCPPortUsed = -1;
    private static int lastUDPPortUsed = -1;
    private static int tcpPortListSize = -1;
    private static int udpPortListSize = -1;
    private boolean tcpFirewallEnabled = false;
    private boolean udpFirewallEnabled = false;

    private ScPortAllocator() {
        try {
            this.topologyHost = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        multiIPFile = System.getProperty("ESDIR", "/var/opt/SUNWsymon/") + "/cfg/multiip.dat";
        UcDDL.logDebugMessage((String)("ScPortAllocator: multiIPFile = " + multiIPFile));
        try {
            UcDDL.logDebugMessage((String)"UcBeanIntrospector called");
            UcBeanIntrospector ucBeanIntrospector = new UcBeanIntrospector();
            ucBeanIntrospector.readProperties("domain-config.x", 0);
            ucBeanIntrospector.readProperties("javaserver.properties");
            ucBeanIntrospector.apply((Object)this);
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)("ScPortAllocator : Constructor  FAILED" + exception.getMessage()));
        }
        int n = this.maxTCPPort;
        this.maxTCPPort = Math.max(this.minTCPPort, this.maxTCPPort);
        this.minTCPPort = Math.min(this.minTCPPort, n);
        n = this.maxUDPPort;
        this.maxUDPPort = Math.max(this.minUDPPort, this.maxUDPPort);
        this.minUDPPort = Math.min(this.minUDPPort, n);
        if (this.maxTCPPort == -1 || this.minTCPPort == -1) {
            tcpPortListSize = 0;
        } else {
            tcpPortListSize = this.maxTCPPort - this.minTCPPort + 1;
            this.tcpFirewallEnabled = true;
        }
        if (this.maxUDPPort == -1 || this.minUDPPort == -1) {
            udpPortListSize = 0;
        } else {
            udpPortListSize = this.maxUDPPort - this.minUDPPort + 1;
            this.udpFirewallEnabled = true;
        }
        this.readServerAddress();
        UcDDL.logDebugMessage((String)("ScPortAllocator: minTCPPort = " + this.minTCPPort + " maxTCPPort = " + this.maxTCPPort + " minUDPPort = " + this.minUDPPort + " maxUDPPort = " + this.maxUDPPort));
        UcDDL.logDebugMessage((String)("ScPortAllocator: TCP Firewall Enabled = " + this.tcpFirewallEnabled));
        UcDDL.logDebugMessage((String)("ScPortAllocator: UDP Firewall Enabled = " + this.udpFirewallEnabled));
        UcDDL.logDebugMessage((String)("ScPortAllocator: tcpPortListSize = " + tcpPortListSize + " udpPortListSize = " + udpPortListSize));
    }

    public String getPortRange() {
        return this.getTCPPortRange();
    }

    public String getTCPPortRange() {
        return this.getMinTCPPort() + ":" + this.getMaxTCPPort();
    }

    public String getUDPPortRange() {
        return this.getMinUDPPort() + ":" + this.getMaxUDPPort();
    }

    public int getMaxPort() {
        return this.getMaxTCPPort();
    }

    public int getMinPort() {
        return this.getMinTCPPort();
    }

    public int getMaxTCPPort() {
        if (this.tcpFirewallEnabled) {
            return this.maxTCPPort;
        }
        return 65535;
    }

    public int getMinTCPPort() {
        if (this.tcpFirewallEnabled) {
            return this.minTCPPort;
        }
        return 1100;
    }

    public int getMaxUDPPort() {
        if (this.udpFirewallEnabled) {
            return this.maxUDPPort;
        }
        return 65535;
    }

    public int getMinUDPPort() {
        if (this.udpFirewallEnabled) {
            return this.minUDPPort;
        }
        return 1100;
    }

    public static ScPortAllocator getInstance() {
        if (_instance == null) {
            UcDDL.logDebugMessage((String)"ScPortAllocator INSTANCE == NULLL:  ");
            _instance = new ScPortAllocator();
        }
        return _instance;
    }

    public void setMaxPort(int n) {
        UcDDL.logInfoMessage((String)("ScPortAlloc: setMaxPort is called : MaxPort = " + n));
        this.setMaxTCPPort(n);
        this.setMaxUDPPort(n);
    }

    public void setMinPort(int n) {
        UcDDL.logInfoMessage((String)("ScPortAlloc: setMinPort is called : MinPort = " + n));
        this.setMinTCPPort(n);
        this.setMinUDPPort(n);
    }

    public void setMaxTCPPort(int n) {
        UcDDL.logInfoMessage((String)("ScPortAlloc: setMaxTCPPort is called : MaxPort = " + n));
        if (n < 1100 || n > 65535) {
            n = 65535;
        }
        this.maxTCPPort = n;
    }

    public void setMinTCPPort(int n) {
        UcDDL.logInfoMessage((String)("ScPortAlloc: setMinTCPPort is called : MinPort = " + n));
        if (n < 1100 || n > 65535) {
            n = 1100;
        }
        this.minTCPPort = n;
    }

    public void setMaxUDPPort(int n) {
        UcDDL.logInfoMessage((String)("ScPortAlloc: setMaxUDPPort is called : MaxPort = " + n));
        if (n < 1100 || n > 65535) {
            n = 65535;
        }
        this.maxUDPPort = n;
    }

    public void setMinUDPPort(int n) {
        UcDDL.logInfoMessage((String)("ScPortAlloc: setMinUDPPort is called : MinPort = " + n));
        if (n < 1100 || n > 65535) {
            n = 1100;
        }
        this.minUDPPort = n;
    }

    public void donePort(int n) {
    }

    private synchronized void setLastTCPPortUsed(int n) {
        if (n < this.minTCPPort || n > this.maxTCPPort) {
            lastTCPPortUsed = this.minTCPPort;
            return;
        }
        lastTCPPortUsed = n;
        UcDDL.logDebugMessage((String)("ScPortAllocator: Seting lastTCPPortUsed to " + lastTCPPortUsed));
    }

    private synchronized int getTCPPort(int n) {
        if (!this.tcpFirewallEnabled) {
            return -1;
        }
        if (n == this.maxTCPPort || n == 0 && lastTCPPortUsed == -1) {
            return this.minTCPPort;
        }
        if (n == 0) {
            return lastTCPPortUsed + 1;
        }
        return ++n;
    }

    private int getUDPPort() {
        if (!this.udpFirewallEnabled) {
            return -1;
        }
        if (lastUDPPortUsed == -1 || lastUDPPortUsed == this.maxUDPPort) {
            lastUDPPortUsed = this.minUDPPort;
            return lastUDPPortUsed;
        }
        return ++lastUDPPortUsed;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized DatagramSocket[] getUDPSockets() throws SocketException {
        UcDDL.logDebugMessage((String)"ScPortAllocator.getUDPSockets() called");
        var1_1 = new DatagramSocket[this.ipAddresses.size()];
        var2_2 = 0;
        while (var2_2 < this.ipAddresses.size()) {
            block8: {
                var1_1[var2_2] = null;
                try {
                    var1_1[var2_2] = this.getUDPSocket(InetAddress.getByName((String)this.ipAddresses.elementAt(var2_2)));
                    break block8;
                }
                catch (UnknownHostException var3_3) {
                    UcDDL.logErrorMessage((String)("ScPortAllocator.getUDPSockets: UnknownHost Exception for " + (String)this.ipAddresses.elementAt(var2_2)));
                    break block8;
                }
                catch (SocketException var4_4) {
                    var5_5 = var2_2;
                    ** while (var5_5 >= 0)
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        if (var1_1[var5_5] != null) {
                            var1_1[var5_5].close();
                        }
                    }
                    catch (Exception var6_6) {
                        // empty catch block
                    }
                    --var5_5;
                    continue;
                }
lbl23:
                // 1 sources

                throw var4_4;
            }
            ++var2_2;
        }
        return var1_1;
    }

    public synchronized DatagramSocket getUDPSocket(InetAddress inetAddress) throws SocketException {
        UcDDL.logDebugMessage((String)("ScPortAllocator : getUDPScoket with addr " + inetAddress));
        DatagramSocket datagramSocket = null;
        SocketException socketException = null;
        int n = -1;
        if (!this.udpFirewallEnabled) {
            UcDDL.logDebugMessage((String)"ScPortAllocator : firewall is not enabled.");
            try {
                datagramSocket = inetAddress == null ? new DatagramSocket() : new DatagramSocket(0, inetAddress);
                UcDDL.logDebugMessage((String)"ScPortAllocator : Successfully created datagram socket.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                UcDDL.logErrorMessage((String)"ScPortAllocator : Got IllegalArgumentException, this must not have happened.");
            }
            return datagramSocket;
        }
        n = this.getUDPPort();
        UcDDL.logDebugMessage((String)"ScPortAllocator : Firewall enabled.");
        int n2 = 0;
        do {
            UcDDL.logDebugMessage((String)("ScPortAllocator : Trying to get datagram socket with port " + n));
            ++n2;
            datagramSocket = null;
            try {
                datagramSocket = inetAddress == null ? new DatagramSocket(n) : new DatagramSocket(n, inetAddress);
                UcDDL.logDebugMessage((String)"ScPortAllocator : Successfully created datagram socket.");
                return datagramSocket;
            }
            catch (SocketException socketException2) {
                UcDDL.logDebugMessage((String)("ScPortAllocator : Could not get datagram socket for port " + n));
                socketException = socketException2;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                UcDDL.logErrorMessage((String)"ScPortAllocator : Got IllegalArgumentException, this must not have happened.");
            }
            n = this.getUDPPort();
        } while (n2 < udpPortListSize);
        UcDDL.logDebugMessage((String)"ScPortAllocator : Could not get datagram socket on any of the allowed ports.");
        if (socketException == null) {
            throw new SocketException("either no availble ports or some problem in creating UDP socket.");
        }
        throw socketException;
    }

    public synchronized DatagramSocket getUDPSocket() throws SocketException {
        UcDDL.logDebugMessage((String)"ScPortAllocator : getUDPScoket() called with no argument");
        return this.getUDPSocket(null);
    }

    public Socket getTCPSocket(String string, int n, InetAddress inetAddress) throws Throwable {
        UcDDL.logDebugMessage((String)("ScPortAllocator : getTCPSocket called with new class host = " + string + " local addr = " + inetAddress));
        Socket socket = null;
        int n2 = -1;
        if (!this.tcpFirewallEnabled) {
            UcDDL.logDebugMessage((String)"ScPortAllocator : Firewall is not enabled.");
            try {
                try {
                    socket = new Socket(string, n, inetAddress, 0);
                    UcDDL.logDebugMessage((String)"ScPortAllocator : Successfully created the stream socket.");
                    Socket socket2 = socket;
                    Object var10_9 = null;
                    return socket2;
                }
                catch (UnknownHostException unknownHostException) {
                    UcDDL.logDebugMessage((String)("ScPortAllocator : UnknownHostException occured while creating socket. Message = " + unknownHostException.getMessage()));
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw unknownHostException;
                }
                catch (IOException iOException) {
                    UcDDL.logDebugMessage((String)("ScPortAllocator : IOException occured while creating socket. Message = " + iOException.getMessage()));
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                throw throwable;
            }
        }
        UcDDL.logDebugMessage((String)"ScPortAllocator : Firewall is enabled.");
        IOException iOException = null;
        int n3 = 0;
        n2 = this.getTCPPort(0);
        do {
            Object var12_21;
            UcDDL.logDebugMessage((String)("ScPortAllocator : Trying to get connected strem socket for port " + n2));
            ++n3;
            socket = null;
            try {
                try {
                    socket = new Socket(string, n, inetAddress, n2);
                    UcDDL.logDebugMessage((String)"ScPortAllocator : Successfully created the stream socket.");
                    this.setLastTCPPortUsed(n2);
                    Socket socket3 = socket;
                    var12_21 = null;
                    return socket3;
                }
                catch (UnknownHostException unknownHostException) {
                    UcDDL.logDebugMessage((String)("ScPortAllocator : UnknownHostException occured while creating socket. Message = " + unknownHostException.getMessage()));
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw unknownHostException;
                }
                catch (IOException iOException2) {
                    UcDDL.logDebugMessage((String)("ScPortAllocator : IOException occured while creating socket. Message = " + iOException2.getMessage()));
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    iOException = iOException2;
                    var12_21 = null;
                }
            }
            catch (Throwable throwable) {
                var12_21 = null;
                throw throwable;
            }
            n2 = this.getTCPPort(n2);
        } while (n3 < tcpPortListSize);
        UcDDL.logDebugMessage((String)"ScPortAllocator : Could not get stream socket on any interface for any allowed port.");
        if (iOException == null) {
            throw new SocketException("either no availble ports or some problem in creating TCP socket.");
        }
        throw iOException;
    }

    public void unregister(Object object, int n) {
        this.donePort(n);
    }

    public void setTopologyHost(String string) {
        UcDDL.logDebugMessage((String)("ScPortAllocator: topoHost " + string));
        this.topologyHost = string;
    }

    public void setTopologyMode(String string) {
        this.serverMode = string;
        UcDDL.logDebugMessage((String)("ScPortAllocator: server mode is  " + this.serverMode));
    }

    public Vector getLogicalHostname() {
        if (this.serverMode.equals("ip")) {
            return this.getIpAddresses();
        }
        Vector<String> vector = new Vector<String>();
        vector.add(this.topologyHost);
        return vector;
    }

    public Vector getIpAddresses() {
        Vector vector = new Vector();
        if (this.ipAddresses.size() > 0) {
            Object object = this.ipAddresses.clone();
            if (object instanceof Vector) {
                vector = (Vector)object;
            } else {
                UcDDL.logErrorMessage((String)"ScPortAllocator: getIpAddresses: Fatal error in cloning");
            }
        } else {
            try {
                String string = InetAddress.getLocalHost().getHostAddress();
                vector.add(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return vector;
    }

    /*
     * Loose catch block
     */
    private void readServerAddress() {
        Object object;
        block18: {
            InputStreamReader inputStreamReader;
            block17: {
                if (this.ipAddresses.size() > 0) {
                    return;
                }
                File file = null;
                inputStreamReader = null;
                file = new File(multiIPFile);
                if (!file.exists()) {
                    UcDDL.logErrorMessage((String)("ScPortAllocator: " + multiIPFile + "does not exist. Using the primary interface"));
                    object = InetAddress.getLocalHost().getHostAddress();
                    this.ipAddresses.add(object);
                    break block17;
                }
                inputStreamReader = new FileReader(file);
                object = new BufferedReader(inputStreamReader);
                String string = ((BufferedReader)object).readLine();
                String string2 = string.substring(string.indexOf("\"") + 1, string.lastIndexOf("\""));
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    try {
                        String string4 = InetAddress.getByName(string3).getHostAddress();
                        if (this.ipAddresses.contains(string4)) continue;
                        this.ipAddresses.add(string4);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            Object var10_12 = null;
            try {
                inputStreamReader.close();
            }
            catch (Exception exception) {}
            break block18;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var10_13 = null;
                    try {
                        inputStreamReader.close();
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                try {
                    inputStreamReader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (this.ipAddresses.size() == 0) {
            try {
                object = InetAddress.getLocalHost().getHostAddress();
                if (!this.ipAddresses.contains(object)) {
                    this.ipAddresses.add(object);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        UcDDL.logDebugMessage((String)("ScPortAllocator: The server ips are " + this.ipAddresses.toString()));
    }

    public InetAddress getAgentTrapAddress(String string, int n) throws UnknownHostException {
        String string2 = string + ":" + n;
        InetAddress inetAddress = null;
        String string3 = null;
        UcDDL.logDebugMessage((String)("ScPortAllocator: agent = " + string + " port = " + n));
        if (this.agentAndTrap.containsKey(string2)) {
            string3 = (String)this.agentAndTrap.get(string2);
        } else {
            try {
                String string4 = this.getFromDatabase(string, n);
                int n2 = string4.indexOf(58);
                string3 = n2 > 0 ? string4.substring(0, n2) : string4;
                this.agentAndTrap.put(string2, string3);
            }
            catch (SMDatabaseException sMDatabaseException) {
                string3 = (String)this.ipAddresses.elementAt(0);
                this.agentAndTrap.put(string2, string3);
            }
        }
        inetAddress = InetAddress.getByName(string3);
        return inetAddress;
    }

    public void addAgent(String string, String string2) {
        this.agentAndTrap.put(string, string2);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getFromDatabase(String var1_1, int var2_2) throws SMDatabaseException {
        block14: {
            var3_3 = null;
            var4_4 = null;
            var5_5 = null;
            try {
                try {
                    var4_4 = MSDB.getConnection();
                    var5_5 = var4_4.createStatement();
                    var6_6 = "select trapdest from entity_info where IP_ADDRESS ='" + var1_1 + "'" + " and topo_parse_url(url) =" + "'" + var2_2 + "'";
                    var3_3 = var5_5.executeQuery(var6_6);
                    if (var3_3.next() == false) throw new SMDatabaseException();
                    var7_8 = var3_3.getString(1);
                    if (var7_8 == null) {
                        throw new SMDatabaseException();
                    }
                    var8_10 = var7_8;
                    var10_12 = null;
                }
                catch (SQLException var6_7) {
                    throw new SMDatabaseException((Throwable)var6_7);
                }
                catch (SMDatabaseException var7_9) {
                    throw var7_9;
                }
                catch (Exception var8_11) {
                    throw new SMDatabaseException((Throwable)var8_11);
                }
            }
            catch (Throwable var9_16) {
                var10_13 = null;
                try {
                    if (var5_5 != null) {
                        var5_5.close();
                    }
                }
                catch (SQLException var11_15) {
                    // empty catch block
                }
                MSDB.closeConnection(var4_4);
                throw var9_16;
            }
            ** try [egrp 2[TRYBLOCK] [4 : 165->180)] { 
lbl38:
            // 1 sources

            if (var5_5 != null) {
                var5_5.close();
            }
            break block14;
lbl41:
            // 1 sources

            catch (SQLException var11_14) {
                // empty catch block
            }
        }
        MSDB.closeConnection(var4_4);
        return var8_10;
    }

    public static void main(String[] stringArray) {
        ScPortAllocator scPortAllocator = ScPortAllocator.getInstance();
        System.out.println("MinUDPPort = " + scPortAllocator.getMinUDPPort() + " MaxUDPPort = " + scPortAllocator.getMaxUDPPort() + " PortRange = " + scPortAllocator.getPortRange() + " TCPPortRange = " + scPortAllocator.getTCPPortRange() + " UDPPortRange = " + scPortAllocator.getUDPPortRange() + " MaxPort = " + scPortAllocator.getMaxPort() + " MinPort = " + scPortAllocator.getMinPort() + " MaxTCPPort = " + scPortAllocator.getMaxTCPPort() + " MinTCPPort = " + scPortAllocator.getMinTCPPort());
        Object var2_2 = null;
        Socket socket = null;
        Socket socket2 = null;
        Socket socket3 = null;
        Socket socket4 = null;
        Socket socket5 = null;
        Socket socket6 = null;
        try {
            socket = scPortAllocator.getTCPSocket("smtg-dev22", 23, null);
            socket2 = scPortAllocator.getTCPSocket("smtg-dev22", 23, null);
            socket3 = scPortAllocator.getTCPSocket("smtg-dev22", 23, null);
            socket4 = scPortAllocator.getTCPSocket("smtg-dev22", 23, null);
            socket5 = scPortAllocator.getTCPSocket("smtg-dev22", 23, null);
            socket.setSoLinger(true, 0);
            socket2.setSoLinger(true, 0);
            socket3.setSoLinger(true, 0);
            socket4.setSoLinger(true, 0);
            socket5.setSoLinger(true, 0);
            socket6 = scPortAllocator.getTCPSocket("smtg-dev22", 23, null);
            socket6.setSoLinger(true, 0);
            Thread.sleep(5000L);
            socket.close();
            socket2.close();
            socket3.close();
            socket4.close();
            socket5.close();
        }
        catch (Throwable throwable) {
            try {
                socket.close();
                socket2.close();
                socket3.close();
                socket4.close();
                socket5.close();
            }
            catch (Exception exception) {}
        }
    }
}

