/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.task;

import com.sun.symon.base.client.SMMessageI18nKey;
import com.sun.symon.base.client.service.SMDBChangeEvent;
import com.sun.symon.base.client.service.SMDatabaseException;
import com.sun.symon.base.mgmtservice.common.MSDB;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.common.MSProperties;
import com.sun.symon.base.mgmtservice.task.MtTaskRequestLogService;
import java.io.IOException;
import java.sql.Connection;
import java.util.Vector;
import oracle.jdbc.driver.OracleResultSet;

public class MtTaskRequestLogRemover
implements Runnable {
    private static MtTaskRequestLogRemover instance_ = new MtTaskRequestLogRemover();
    static MSLogPrintWriter errorWriter;
    private static final String SP_DELETE_TASK_REQUEST_LOG_BY_SIZE = "{call DELETETASKREQUESTLOGBYSIZE(?,?)}";
    private static final int TASK_REQUEST_LOG_SIZE = 1;
    private static final int TASK_REQUEST_LOG_CSR = 2;
    private static final int TASK_REQUEST_LOG_FILE_NAME = 1;
    private static final String SP_DELETE_TASK_REQUEST_LOG_BY_DAYS = "{call DELETETASKREQUESTLOGBYDAYS(?,?)}";
    private static final int TASK_REQUEST_LOG_DAYS = 1;
    private static String i18nBase_;
    private boolean deleteByDays_ = true;
    private boolean deleteBySize_ = true;
    private int days_ = 30;
    private long megaBytes_ = 50L;

    public static MtTaskRequestLogRemover getInstance() {
        return instance_;
    }

    protected MtTaskRequestLogRemover() {
        try {
            MSProperties mSProperties = new MSProperties();
            mSProperties.load("AdvancedServices/cfg/core/taskreq");
            this.deleteBySize_ = mSProperties.getProperty("log.bySize").equals("true");
            this.deleteByDays_ = mSProperties.getProperty("log.byDays").equals("true");
            this.days_ = Integer.parseInt(mSProperties.getProperty("log.days"));
            this.megaBytes_ = Long.parseLong(mSProperties.getProperty("log.size"));
            MSLogPrintWriter mSLogPrintWriter = MSLogPrintWriter.getDebugWriter();
            mSLogPrintWriter.println("log.bySize: " + this.deleteBySize_);
            mSLogPrintWriter.println("log.byDays: " + this.deleteByDays_);
            mSLogPrintWriter.println("log.days: " + this.days_);
            mSLogPrintWriter.println("log.size: " + this.megaBytes_);
        }
        catch (IOException iOException) {
            errorWriter.println("MtTaskRequestLogRemover:: loadProperties(): IOException", (Throwable)iOException);
        }
    }

    public void run() {
        long l = 43200000L;
        while (true) {
            this.checkOldLogs();
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
            }
        }
    }

    public void checkTotalLogSize() {
        if (!this.deleteBySize_) {
            return;
        }
        this.deleteFiles(this.getDeletedLogsBySize(this.megaBytes_));
        MtTaskRequestLogService.getLogChangeMulticaster().fireEvent(new SMDBChangeEvent(null, 4));
    }

    public void checkOldLogs() {
        if (!this.deleteByDays_) {
            return;
        }
        this.deleteFiles(this.getDeletedLogsByDays(this.days_));
        MtTaskRequestLogService.getLogChangeMulticaster().fireEvent(new SMDBChangeEvent(null, 4));
    }

    private void deleteFiles(String[] stringArray) {
        if (stringArray.length == 0) {
            return;
        }
        String string = System.getProperty("ESDIR") + "/log/taskreq/";
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(string + stringArray[n]);
            stringBuffer.append(" ");
            ++n;
        }
        String string2 = System.getProperty("ESDIR") + "/AdvancedServices/bin/rm_taskreq_log.sh";
        String string3 = string2 + " " + stringBuffer;
        MSLogPrintWriter.getInfoWriter().println(string3);
        try {
            Runtime.getRuntime().exec(string3);
        }
        catch (IOException iOException) {
            errorWriter.println("MtTaskRequestLogRemover:: deleteFiles(): IOException", (Throwable)iOException);
        }
    }

    /*
     * Loose catch block
     */
    private String[] getDeletedLogsBySize(long l) {
        Object[] objectArray;
        Vector<String> vector;
        block11: {
            vector = new Vector<String>();
            Connection connection = null;
            connection = MSDB.getConnection();
            objectArray = connection.prepareCall(SP_DELETE_TASK_REQUEST_LOG_BY_SIZE);
            objectArray.setLong(1, l);
            objectArray.registerOutParameter(2, -10);
            objectArray.execute();
            OracleResultSet oracleResultSet = (OracleResultSet)objectArray.getObject(2);
            while (oracleResultSet.next()) {
                String string = oracleResultSet.getString(1);
                vector.addElement(string);
            }
            objectArray.close();
            connection.commit();
            Object var9_10 = null;
            try {
                MSDB.closeConnection((Connection)connection);
            }
            catch (SMDatabaseException sMDatabaseException) {
                errorWriter.println("MtTaskRequestLogRemover:: getDeletedLogsBySize(): Database exception in closeConnection", (Throwable)sMDatabaseException);
            }
            break block11;
            {
                catch (Exception exception) {
                    errorWriter.println("MtTaskRequestLogRemover:: getDeletedLogsBySize():", (Throwable)exception);
                    try {
                        MSDB.rollback((Connection)connection);
                    }
                    catch (SMDatabaseException sMDatabaseException) {
                        errorWriter.println("MtTaskRequestLogRemover:: getDeletedLogsBySize(): Database exception in rollback", (Throwable)sMDatabaseException);
                    }
                    SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)exception);
                    sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "databaseException"));
                    Object var9_11 = null;
                    try {
                        MSDB.closeConnection((Connection)connection);
                    }
                    catch (SMDatabaseException sMDatabaseException2) {
                        errorWriter.println("MtTaskRequestLogRemover:: getDeletedLogsBySize(): Database exception in closeConnection", (Throwable)sMDatabaseException2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                try {
                    MSDB.closeConnection((Connection)connection);
                }
                catch (SMDatabaseException sMDatabaseException) {
                    errorWriter.println("MtTaskRequestLogRemover:: getDeletedLogsBySize(): Database exception in closeConnection", (Throwable)sMDatabaseException);
                }
                throw throwable;
            }
        }
        MtTaskRequestLogService.getLogChangeMulticaster().fireEvent(new SMDBChangeEvent(null, 4));
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    /*
     * Loose catch block
     */
    private String[] getDeletedLogsByDays(int n) {
        Object[] objectArray;
        Vector<String> vector;
        block11: {
            vector = new Vector<String>();
            Connection connection = null;
            connection = MSDB.getConnection();
            objectArray = connection.prepareCall(SP_DELETE_TASK_REQUEST_LOG_BY_DAYS);
            objectArray.setInt(1, n);
            objectArray.registerOutParameter(2, -10);
            objectArray.execute();
            OracleResultSet oracleResultSet = (OracleResultSet)objectArray.getObject(2);
            while (oracleResultSet.next()) {
                String string = oracleResultSet.getString(1);
                vector.addElement(string);
            }
            objectArray.close();
            connection.commit();
            Object var8_10 = null;
            try {
                MSDB.closeConnection((Connection)connection);
            }
            catch (SMDatabaseException sMDatabaseException) {
                errorWriter.println("MtTaskRequestLogRemover:: getDeletedLogsByDays(): Database exception in closeConnection", (Throwable)sMDatabaseException);
            }
            break block11;
            {
                catch (Exception exception) {
                    errorWriter.println("MtTaskRequestLogRemover:: getDeletedLogsByDays():", (Throwable)exception);
                    try {
                        MSDB.rollback((Connection)connection);
                    }
                    catch (SMDatabaseException sMDatabaseException) {
                        errorWriter.println("MtTaskRequestLogRemover:: getDeletedLogsByDays(): Database exception in rollback", (Throwable)sMDatabaseException);
                    }
                    SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)exception);
                    sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "databaseException"));
                    Object var8_11 = null;
                    try {
                        MSDB.closeConnection((Connection)connection);
                    }
                    catch (SMDatabaseException sMDatabaseException2) {
                        errorWriter.println("MtTaskRequestLogRemover:: getDeletedLogsByDays(): Database exception in closeConnection", (Throwable)sMDatabaseException2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                try {
                    MSDB.closeConnection((Connection)connection);
                }
                catch (SMDatabaseException sMDatabaseException) {
                    errorWriter.println("MtTaskRequestLogRemover:: getDeletedLogsByDays(): Database exception in closeConnection", (Throwable)sMDatabaseException);
                }
                throw throwable;
            }
        }
        MtTaskRequestLogService.getLogChangeMulticaster().fireEvent(new SMDBChangeEvent(null, 4));
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    static {
        i18nBase_ = "com.sun.symon.base.client.ClientApiMessages";
        errorWriter = MSLogPrintWriter.getErrorWriter();
        Thread thread = new Thread(instance_);
        thread.start();
    }
}

