/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.task;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMMessageI18nKey;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.group.SMObjectGroupData;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMDatabaseException;
import com.sun.symon.base.client.service.SMInvalidTypeException;
import com.sun.symon.base.client.service.SMLengthException;
import com.sun.symon.base.client.task.SMTaskData;
import com.sun.symon.base.client.task.SMTaskOperationData;
import com.sun.symon.base.client.task.SMTaskRequestData;
import com.sun.symon.base.client.task.SMTaskRequestInfo;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.common.MSProperties;
import com.sun.symon.base.mgmtservice.group.MgObjectGroupImpl;
import com.sun.symon.base.mgmtservice.group.MgObjectGroupService;
import com.sun.symon.base.mgmtservice.task.MtBaseCommand;
import com.sun.symon.base.mgmtservice.task.MtOperation;
import com.sun.symon.base.mgmtservice.task.MtTaskImpl;
import com.sun.symon.base.mgmtservice.task.MtTaskRequestController;
import com.sun.symon.base.mgmtservice.task.MtTaskRequestLog;
import com.sun.symon.base.mgmtservice.task.MtTaskRequestQueue;
import com.sun.symon.base.mgmtservice.task.MtTaskRunner;
import com.sun.symon.base.mgmtservice.task.MtTaskSecurity;
import com.sun.symon.base.mgmtservice.task.MtTaskService;
import com.sun.symon.base.server.common.ScSecurityCredential;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;

public class MtTaskRequest
extends SMTaskRequestData {
    int testValue = 25;
    long executionTime;
    static final int LIMIT = 2000;
    boolean isMarkedForDeletion = false;
    boolean isCompleted;
    boolean isPerformed;
    Date completeDate;
    static MSLogPrintWriter logWriter;
    static MSLogPrintWriter errorWriter;
    static MtTaskRequestController controller;
    static MtTaskRequestQueue queue;
    static final int THREAD_LIMIT = 3;
    static final int OP_NOT_INITIALIZED = 0;
    static final int OP_FAILURE = 1;
    static final int OP_SUCCESS = 2;
    static final int OP_FIRED = 3;
    static final int OP_SKIPPED = 4;
    private static String i18nBase_;
    SMRawDataRequest request;
    SMTaskData task;
    SMTaskRequestData data;
    MtTaskRunner runner;
    MtTaskRequestLog taskRequestLog;
    MtOperation[] operations;
    String[] targets;
    boolean[] targetStatus;
    int[][] targetOperationStatus;
    SMTaskOperationData[] ops;
    private Hashtable indexMap = new Hashtable();

    public void setCompleteDate(Date date) {
        this.completeDate = date;
    }

    public Date getCompleteDate() {
        return this.completeDate;
    }

    public MtTaskRequest(SMTaskRequestData sMTaskRequestData) {
        this.data = sMTaskRequestData;
        this.setObjectID(sMTaskRequestData.getObjectID());
        try {
            this.setName(sMTaskRequestData.getName());
            this.setDescription(sMTaskRequestData.getDescription());
            this.setObjectGroupName(sMTaskRequestData.getObjectGroupName());
            this.setTaskName(sMTaskRequestData.getTaskName());
            this.setScheduled(sMTaskRequestData.isScheduled());
            this.setPeriod(sMTaskRequestData.getPeriod());
            this.setPeriodUnits(sMTaskRequestData.getPeriodUnits());
            this.setStartDate(sMTaskRequestData.getStartDate());
            this.setStatus(sMTaskRequestData.getStatus());
            this.setOwner(sMTaskRequestData.getOwner());
            this.setObjectID(sMTaskRequestData.getObjectID());
            this.setUpdatedBy(sMTaskRequestData.getUpdatedBy());
            this.setTimestamp(sMTaskRequestData.getTimestamp());
            this.setCreatedDate(sMTaskRequestData.getCreatedDate());
        }
        catch (SMLengthException sMLengthException) {
            // empty catch block
        }
    }

    public void setMarkForDeletion() {
        this.isMarkedForDeletion = true;
    }

    public MtTaskRequest(String string) {
        try {
            this.setName(string);
        }
        catch (SMLengthException sMLengthException) {
            // empty catch block
        }
        this.setScheduled(true);
    }

    public long getExecTime() {
        return this.executionTime;
    }

    public void setExecTime(long l) {
        this.executionTime = l;
    }

    public void setExecTime(Date date) {
        this.executionTime = date.getTime();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append(" Exec.Time:" + this.executionTime + "\n");
        return stringBuffer.toString();
    }

    private void instantiateRequest() throws SMAPIException {
        logWriter.println("Start request:" + this.getName() + " task:" + this.getTaskName() + " objectGroup:" + this.getObjectGroupName() + " Owner:" + this.getOwner());
        ScSecurityCredential scSecurityCredential = controller.getSecurity(this.getOwner());
        try {
            MtTaskImpl mtTaskImpl = MtTaskService.getTaskImpl(scSecurityCredential);
            this.task = mtTaskImpl.load(this.getTaskName());
            MtTaskSecurity.getInstance().checkAccess(this.task.getTaskTypeString(), "execute", scSecurityCredential);
            MgObjectGroupImpl mgObjectGroupImpl = MgObjectGroupService.getObjectGroupImpl(scSecurityCredential);
            SMObjectGroupData sMObjectGroupData = mgObjectGroupImpl.load(this.getObjectGroupName());
            this.taskRequestLog = new MtTaskRequestLog(this.data, sMObjectGroupData, this.task, scSecurityCredential);
            this.clearNoTarget();
            this.targets = mgObjectGroupImpl.resolve(sMObjectGroupData);
            this.taskRequestLog.setTargetAgents(this.targets);
            this.taskRequestLog.taskRequestStarted();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (throwable instanceof SMAPIException) {
                throw (SMAPIException)throwable;
            }
            SMMessageI18nKey sMMessageI18nKey = new SMMessageI18nKey(i18nBase_, "resolveException");
            throw new SMAPIException("Could not resolve task/group", throwable, sMMessageI18nKey);
        }
    }

    public void execute(MtTaskRunner mtTaskRunner) throws SMAPIException {
        Object object;
        int n;
        this.runner = mtTaskRunner;
        this.isCompleted = false;
        this.isPerformed = false;
        this.setRunning();
        logWriter.println("Request " + this.getName() + " started");
        try {
            this.instantiateRequest();
        }
        catch (Exception exception) {
            SMAPIException sMAPIException;
            logWriter.print("Request " + this.getName() + " has failed.");
            logWriter.print(" Exception was thrown: " + exception.getMessage());
            errorWriter.println("Could not construct request", (Throwable)exception);
            if (exception instanceof SMAPIException) {
                String string = ((SMAPIException)((Object)exception)).getMessageI18nKey();
                if (string.equals("com.sun.symon.base.client.ClientApiMessages:domainIsNotAvailable")) {
                    this.setNoTarget();
                    this.complete();
                    mtTaskRunner.done();
                    mtTaskRunner = null;
                    SMAPIException sMAPIException2 = (SMAPIException)((Object)exception);
                    throw sMAPIException2;
                }
            } else {
                Exception exception2 = exception;
                sMAPIException = new SMAPIException((Throwable)exception2);
            }
            this.setFailure();
            this.complete();
            mtTaskRunner.done();
            mtTaskRunner = null;
            throw sMAPIException;
        }
        if (this.targets != null && this.targets.length != 0) {
            logWriter.print(" Result of resolve operation:\n");
            n = 0;
            while (n < this.targets.length) {
                logWriter.print("\t\t" + this.targets[n]);
                ++n;
            }
        } else {
            logWriter.print("Request " + this.getName() + " has no targets.");
            this.setNoTarget();
            this.complete();
            mtTaskRunner.done();
            mtTaskRunner = null;
            return;
        }
        logWriter.println("");
        try {
            this.buildOperations();
        }
        catch (Exception exception) {
            logWriter.print("Request " + this.getName() + " has failed.");
            logWriter.print(" Exception was thrown: " + exception.getMessage());
            errorWriter.println("Could not construct request", (Throwable)exception);
            this.setFailure();
            this.complete();
            mtTaskRunner.done();
            mtTaskRunner = null;
            if (exception instanceof SMAPIException) {
                SMAPIException sMAPIException = (SMAPIException)((Object)exception);
                throw sMAPIException;
            }
            throw new SMAPIException((Throwable)exception);
        }
        this.targetStatus = new boolean[this.targets.length];
        this.targetOperationStatus = new int[this.targets.length][this.operations.length];
        n = 0;
        while (n < this.targets.length) {
            int n2 = 0;
            while (n2 < this.operations.length) {
                this.targetOperationStatus[n][n2] = 0;
                ++n2;
            }
            ++n;
        }
        int n3 = 3;
        try {
            MSProperties mSProperties = new MSProperties();
            mSProperties.load("AdvancedServices/cfg/core/taskreq");
            n3 = Integer.parseInt(mSProperties.getProperty("thread.maxTargetsPerRequest"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n4 = n3;
        if (n3 > this.targets.length) {
            n4 = this.targets.length;
        }
        logWriter.println("Threads: " + n4 + " Max: " + n3);
        TargetThread[] targetThreadArray = new TargetThread[n4];
        int n5 = 0;
        while (n5 < n4) {
            targetThreadArray[n5] = new TargetThread(n5);
            ++n5;
        }
        int n6 = 0;
        while (n6 < this.targets.length) {
            String string = this.targets[n6];
            object = null;
            while (true) {
                int n7 = 0;
                while (n7 < n4) {
                    if (targetThreadArray[n7].isAvailable()) {
                        object = targetThreadArray[n7];
                        break;
                    }
                    ++n7;
                }
                if (object != null) break;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            ((TargetThread)object).exec(string, n6);
            ++n6;
        }
        int n8 = 0;
        while (n8 < n4) {
            targetThreadArray[n8].markForDelete();
            ++n8;
        }
        object = this;
        synchronized (object) {
            this.isPerformed = true;
            if (this.isCompleted) {
                this.complete();
                mtTaskRunner.done();
                mtTaskRunner = null;
            }
        }
    }

    private boolean isTargetError(int n) {
        int n2 = 0;
        while (n2 < this.operations.length) {
            if (this.targetOperationStatus[n][n2] == 1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void executeTarget(String string, int n) {
        int n2 = 0;
        while (this.operations != null && n2 < this.operations.length) {
            MtOperation mtOperation = this.operations[n2];
            try {
                mtOperation.validate(string, n);
            }
            catch (SMAPIException sMAPIException) {
                this.operationComplete(n2, n, sMAPIException);
                return;
            }
            ++n2;
        }
        int n3 = 0;
        int n4 = 0;
        while (this.operations != null && n4 < this.operations.length) {
            MtOperation mtOperation = this.operations[n4];
            try {
                if (this.isTargetError(n)) {
                    this.targetOperationStatus[n][n4] = 4;
                } else {
                    this.targetOperationStatus[n][n4] = 3;
                    this.taskRequestLog.taskOperationStarted(this.targets[n], this.indexConvert(n4));
                    mtOperation.doit(string, n);
                    if (mtOperation.getCommand().isSynchronized()) {
                        n3 = 0;
                    } else if ((n3 += this.getOperationSize(this.ops[n4])) > 4000) {
                        n3 = 0;
                        Thread.sleep(10000L);
                    }
                }
            }
            catch (Exception exception) {
                this.logOperationFailure(n4, n, exception);
            }
            ++n4;
        }
        this.verifyTarget(n);
    }

    private int getOperationSize(SMTaskOperationData sMTaskOperationData) {
        int n = 59;
        n += sMTaskOperationData.getOperand().length();
        return n += sMTaskOperationData.getValue().length();
    }

    synchronized void checkStatus() {
        int n = 0;
        while (n < this.targetStatus.length) {
            if (!this.targetStatus[n]) {
                return;
            }
            ++n;
        }
        this.isCompleted = true;
        if (this.isPerformed) {
            this.complete();
            this.runner.done();
            this.runner = null;
        }
    }

    void buildOperations() throws SMAPIException {
        this.ops = this.task.getOperations();
        Vector<Object> vector = new Vector<Object>();
        int n = 0;
        int n2 = 0;
        while (n2 < this.ops.length) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            this.indexMap.put(new Integer(n), new Integer(n2));
            String string = this.ops[n2].getOperation();
            String string2 = controller.getClassName(string);
            if (string2 == null) {
                object4 = new SMInvalidTypeException();
                object4.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "invalidTypeException"));
                throw object4;
            }
            try {
                object4 = Class.forName(string2.trim());
                object3 = ((Class)object4).newInstance();
                if (!(object3 instanceof MtBaseCommand)) {
                    object2 = new SMInvalidTypeException("Class does not extend base command class");
                    object2.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "invalidTypeException"));
                    throw object2;
                }
                object2 = (MtBaseCommand)object3;
                object = new MtOperation((MtBaseCommand)object2);
                ((MtOperation)object).setIndex(n);
                ((MtOperation)object).setRequest(this);
                vector.addElement(object);
                n2 = ((MtBaseCommand)object2).consume(this.ops, n2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                object3 = new SMInvalidTypeException();
                object3.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "invalidTypeException"));
                throw object3;
            }
            catch (InstantiationException instantiationException) {
                object2 = new SMInvalidTypeException();
                object2.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "invalidTypeException"));
                throw object2;
            }
            catch (IllegalAccessException illegalAccessException) {
                object = new SMInvalidTypeException();
                object.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "invalidTypeException"));
                throw object;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                SMInvalidTypeException sMInvalidTypeException = new SMInvalidTypeException();
                sMInvalidTypeException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "invalidTypeException"));
                throw sMInvalidTypeException;
            }
            catch (InvocationTargetException invocationTargetException) {
                SMInvalidTypeException sMInvalidTypeException = new SMInvalidTypeException();
                sMInvalidTypeException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "invalidTypeException"));
                throw sMInvalidTypeException;
            }
            ++n;
        }
        int n3 = vector.size();
        this.operations = new MtOperation[n3];
        int n4 = 0;
        while (n4 < n3) {
            this.operations[n4] = (MtOperation)vector.elementAt(n4);
            ++n4;
        }
    }

    void simulate() {
        try {
            this.task = new SMTaskData();
            this.task.setName("foo");
            this.task.setDescription("foo description");
            SMTaskOperationData[] sMTaskOperationDataArray = new SMTaskOperationData[2];
            int n = -1;
            sMTaskOperationDataArray[++n] = new SMTaskOperationData();
            sMTaskOperationDataArray[n].setOperation("set");
            sMTaskOperationDataArray[n].setValue(Integer.toString(this.testValue++));
            sMTaskOperationDataArray[n].setValueType("com.sun.symon.base.server.types.StString");
            sMTaskOperationDataArray[n].setOperand("/mod/kernel-reader/user/numUsers?alarmlimits.warning-gt#0");
            sMTaskOperationDataArray[++n] = new SMTaskOperationData();
            sMTaskOperationDataArray[n].setOperation("set");
            sMTaskOperationDataArray[n].setValue(Integer.toString(10 + this.testValue++));
            sMTaskOperationDataArray[n].setValueType("com.sun.symon.base.server.types.StString");
            sMTaskOperationDataArray[n].setOperand("/mod/mib2-simple/system/sysContact#0");
            this.task.setOperations(sMTaskOperationDataArray);
            this.targets = new String[1];
            this.targets[0] = "hermitage:161";
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void complete() {
        this.setCompleteDate(new Date());
        this.isCompleted = true;
        queue.requestDone(this.getObjectID());
        if (this.request != null) {
            this.request.disconnect();
            this.request = null;
        }
        logWriter.print("Request " + this.getName() + " completed with status ");
        if (!this.isFailure() && this.hasTarget()) {
            this.taskRequestLog.taskRequestStopped();
            this.taskRequestLog.close();
            logWriter.println("- SUCCESS");
        } else {
            if (!this.hasTarget()) {
                this.taskRequestLog.taskRequestStopped(256, "");
                logWriter.println("- NOTARGET");
            } else {
                if (this.taskRequestLog.getErrorCount() > 0) {
                    this.taskRequestLog.taskRequestStopped(16, "");
                } else {
                    this.taskRequestLog.taskRequestStopped();
                }
                logWriter.println("- FAILURE");
            }
            this.taskRequestLog.close();
        }
        try {
            this.resetRunning();
        }
        catch (SMDatabaseException sMDatabaseException) {
            errorWriter.println(" Database exception: " + (Object)((Object)sMDatabaseException));
        }
        if (this.isPeriodic()) {
            controller.addRequest(this);
        }
    }

    public void initiate() {
        this.reschedule();
    }

    public boolean reschedule() {
        if (!this.isScheduled() || this.isSuspended() || this.isMarkedForDeletion) {
            return false;
        }
        Date date = this.getStartDate();
        if (date == null) {
            return false;
        }
        long l = date.getTime();
        long l2 = new Date().getTime();
        if (!this.isPeriodic()) {
            if (!this.isCompleted()) {
                this.setExecTime(l);
                if (this.isMissed()) {
                    this.clearMissed();
                }
                logWriter.println("Request:" + ((SMTaskRequestInfo)this).name + " Next exec.time is:" + new Date(l));
                return true;
            }
            return false;
        }
        if (this.isMissed()) {
            this.clearMissed();
        }
        long l3 = this.getStartTime();
        int n = this.getPeriodUnits();
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = 60000;
                break;
            }
            case 2: {
                n2 = 3600000;
                break;
            }
            case 3: {
                n2 = 86400000;
                break;
            }
            case 4: {
                n2 = 604800000;
                break;
            }
            case 5: {
                Date date2;
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(this.getStartDate());
                while (true) {
                    if ((date2 = gregorianCalendar.getTime()).getTime() > l2) break;
                    gregorianCalendar.add(2, (int)this.getPeriod());
                }
                this.setExecTime(date2.getTime());
                logWriter.println("Request:" + ((SMTaskRequestInfo)this).name + " Next exec.time is:" + new Date(this.executionTime));
                return true;
            }
        }
        if (n2 > 0) {
            if (l2 > l3) {
                long l4 = (l2 - l3) / (this.getPeriod() * (long)n2) + 1L;
                this.setExecTime(l3 + l4 * this.getPeriod() * (long)n2);
            } else {
                this.setExecTime(l3);
            }
            logWriter.println("Request:" + ((SMTaskRequestInfo)this).name + " Next exec.time is:" + new Date(this.executionTime));
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof MtTaskRequest) {
            MtTaskRequest mtTaskRequest = (MtTaskRequest)((Object)object);
            return this.getObjectID().equals((Object)mtTaskRequest.getObjectID());
        }
        if (object instanceof SMDBObjectID) {
            return this.getObjectID().equals(object);
        }
        return false;
    }

    public void setSuspended() {
        if (this.taskRequestLog != null) {
            this.taskRequestLog.taskRequestStopped(4, "");
            this.taskRequestLog.close();
        }
        ((SMTaskRequestInfo)this).status |= 4;
        controller.setStatus(this);
    }

    public void resetSuspended(boolean bl) {
        ((SMTaskRequestInfo)this).status &= 0xFFFFFFFB;
        if (bl) {
            controller.setStatus(this);
        }
    }

    public void resetSuspended() {
        this.resetSuspended(true);
    }

    public void setRunning() {
        ((SMTaskRequestInfo)this).status |= 2;
        ((SMTaskRequestInfo)this).status &= 0xFFFFFFE7;
        controller.setStatus(this);
    }

    public void setMissed() {
        ((SMTaskRequestInfo)this).status |= 0x20;
        this.setScheduled(false);
        controller.setScheduled(this);
        controller.setStatus(this);
    }

    public void clearMissed() {
        ((SMTaskRequestInfo)this).status ^= 0x20;
        controller.setStatus(this);
    }

    public boolean isCompleted() {
        if ((((SMTaskRequestInfo)this).status & 0x10) != 0) {
            return true;
        }
        return (((SMTaskRequestInfo)this).status & 8) != 0;
    }

    public void resetRunning() throws SMDatabaseException {
        if (!this.isFailure()) {
            ((SMTaskRequestInfo)this).status |= 8;
        }
        ((SMTaskRequestInfo)this).status ^= 2;
        if (!this.isPeriodic()) {
            this.setScheduled(false);
            controller.setScheduled(this);
        }
        controller.setStatus(this);
    }

    public void setFailure() {
        ((SMTaskRequestInfo)this).status |= 0x10;
        controller.setStatus(this);
    }

    public void setNoTarget() {
        ((SMTaskRequestInfo)this).status |= 0x100;
        controller.setStatus(this);
    }

    public void clearNoTarget() {
        ((SMTaskRequestInfo)this).status &= 0xFFFFFEFF;
    }

    private void logOperationFailure(int n, int n2, Throwable throwable) {
        logWriter.print("Operation " + this.ops[this.indexConvert(n)].getOperation());
        logWriter.print(" has failed on target:" + this.targets[n2]);
        String string = throwable.getMessage();
        logWriter.println(" Exception was thrown: " + throwable);
        if (string != null) {
            logWriter.println(" Exception message: " + string);
        }
        errorWriter.println("Operation failed on target:" + this.targets[n2], throwable);
        this.setFailure();
    }

    public synchronized void operationComplete(int n, int n2, SMAPIException sMAPIException) {
        int n3 = this.indexConvert(n);
        if (sMAPIException != null) {
            this.targetOperationStatus[n2][n] = 1;
            this.logOperationFailure(n, n2, sMAPIException);
            this.taskRequestLog.setOperationFailure(this.targets[n2], n3, sMAPIException);
        } else {
            this.targetOperationStatus[n2][n] = 2;
            this.taskRequestLog.setOperationSuccess(this.targets[n2], n3);
        }
        this.verifyTarget(n2);
    }

    synchronized void verifyTarget(int n) {
        boolean bl = true;
        if (this.isCompleted) {
            return;
        }
        int n2 = 0;
        while (n2 < this.operations.length) {
            int n3 = this.targetOperationStatus[n][n2];
            if (n3 == 3 || n3 == 0) {
                bl = false;
                break;
            }
            ++n2;
        }
        if (bl) {
            this.targetStatus[n] = true;
            this.checkStatus();
        }
    }

    public SMRawDataRequest getRawDataRequest() throws SMAPIException {
        if (this.request == null) {
            this.request = controller.getRequestHandle(this.getOwner());
        }
        return this.request;
    }

    public SMTaskRequestData export2Client() {
        SMTaskRequestData sMTaskRequestData = new SMTaskRequestData(this.getObjectID());
        try {
            sMTaskRequestData.setName(this.getName());
            sMTaskRequestData.setDescription(this.getDescription());
            sMTaskRequestData.setObjectGroupName(this.getObjectGroupName());
            sMTaskRequestData.setTaskName(this.getTaskName());
            sMTaskRequestData.setScheduled(this.isScheduled());
            sMTaskRequestData.setPeriod(this.getPeriod());
            sMTaskRequestData.setPeriodUnits(this.getPeriodUnits());
            sMTaskRequestData.setStartDate(this.getStartDate());
            sMTaskRequestData.setStatus(this.getStatus());
        }
        catch (SMLengthException sMLengthException) {
            // empty catch block
        }
        return sMTaskRequestData;
    }

    private int indexConvert(int n) {
        return (Integer)this.indexMap.get(new Integer(n));
    }

    static {
        i18nBase_ = "com.sun.symon.base.client.ClientApiMessages";
        logWriter = MtTaskRequestController.getInstance().getRequestLogWriter();
        controller = MtTaskRequestController.getInstance();
        queue = MtTaskRequestQueue.getTimerQueue();
        errorWriter = MSLogPrintWriter.getErrorWriter();
    }

    class TargetThread
    extends Thread {
        boolean isAvailable = true;
        boolean isRunning = false;
        String target;
        int targetIndex;
        boolean isDeleted = false;

        TargetThread(int n) {
            super("Parallel:" + n);
        }

        boolean isAvailable() {
            return this.isAvailable;
        }

        void exec(String string, int n) {
            this.targetIndex = n;
            this.isAvailable = false;
            this.target = string;
            if (!this.isRunning) {
                this.start();
            }
        }

        void markForDelete() {
            this.isDeleted = true;
        }

        public void run() {
            this.isRunning = true;
            block2: while (true) {
                MtTaskRequest.this.executeTarget(this.target, this.targetIndex);
                this.target = null;
                this.isAvailable = true;
                do {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    if (!this.isAvailable) continue block2;
                } while (!this.isDeleted);
                break;
            }
        }
    }
}

