/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.task;

import com.sun.symon.base.client.SMMessageI18nKey;
import com.sun.symon.base.client.log.SMRemoteLogReader;
import com.sun.symon.base.client.service.SMDBChangeEvent;
import com.sun.symon.base.client.service.SMDBConcurrencyTimestamp;
import com.sun.symon.base.client.service.SMDBObject;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMDBRemoteChangeListener;
import com.sun.symon.base.client.service.SMDatabaseException;
import com.sun.symon.base.client.service.SMDuplicateException;
import com.sun.symon.base.client.service.SMLengthException;
import com.sun.symon.base.client.service.SMNoSuchObjectException;
import com.sun.symon.base.client.service.SMSecurityException;
import com.sun.symon.base.client.service.SMStaleDataException;
import com.sun.symon.base.client.task.SMRemoteTask;
import com.sun.symon.base.client.task.SMTaskData;
import com.sun.symon.base.client.task.SMTaskInfo;
import com.sun.symon.base.client.task.SMTaskOperationData;
import com.sun.symon.base.client.task.SMTaskType;
import com.sun.symon.base.mgmtservice.common.MSDB;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.common.MSLogReader;
import com.sun.symon.base.mgmtservice.common.MSSecurity;
import com.sun.symon.base.mgmtservice.framework.MSBaseService;
import com.sun.symon.base.mgmtservice.task.MtTaskDescriptor;
import com.sun.symon.base.mgmtservice.task.MtTaskSecurity;
import com.sun.symon.base.mgmtservice.task.MtTaskService;
import com.sun.symon.base.server.common.ScSecurityCredential;
import java.rmi.RemoteException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;
import oracle.jdbc.driver.OracleResultSet;

public class MtTaskImpl
extends MSBaseService
implements SMRemoteTask {
    private static boolean migrate_ = true;
    private static final String SP_DELETETASK = "{call DELETETASK(?)}";
    private static final int SP_DELETETASK_TASK_ID = 1;
    private static final String SP_DELETETASKOPERATION = "{call DELETETASKOPERATION(?)}";
    private static final int SP_DELETETASKOPERATION_TASK_ID = 1;
    private static final String SP_GETALLTASKS = "{call GETALLTASKS(?)}";
    private static final int SP_GETALLTASKS_CSR = 1;
    private static final String SP_GETTASK = "{call GETTASK(?,?,?)}";
    private static final int SP_GETTASK_TASK_ID = 1;
    private static final int SP_GETTASK_NAME = 2;
    private static final int SP_GETTASK_CSR = 3;
    private static final String SP_GETTASKOPERATION = "{call GETTASKOPERATION(?,?)}";
    private static final int SP_GETTASKOPERATION_TASK_ID = 1;
    private static final int SP_GETTASKOPERATION_CSR = 2;
    private static final String SP_UPDATETASK = "{call UPDATETASK(?,?,?,?,?,?,?)}";
    private static final int SP_UPDATETASK_TASK_ID = 1;
    private static final int SP_UPDATETASK_TASK_TYPE = 2;
    private static final int SP_UPDATETASK_NAME = 3;
    private static final int SP_UPDATETASK_DESCRIPTION = 4;
    private static final int SP_UPDATETASK_UPDATED_BY = 5;
    private static final int SP_UPDATETASK_TIMESTAMP = 6;
    private static final int SP_UPDATETASK_CREATED_DATE = 7;
    private static final String SP_UPDATETASKOPERATION = "{call UPDATETASKOPERATION(?,?,?,?,?,?,?,?)}";
    private static final int SP_UPDATETASKOPERATION_TASK_ID = 1;
    private static final int SP_UPDATETASKOPERATION_TASK_ORDER = 2;
    private static final int SP_UPDATETASKOPERATION_OPERATION = 3;
    private static final int SP_UPDATETASKOPERATION_OPERAND = 4;
    private static final int SP_UPDATETASKOPERATION_VALUE = 5;
    private static final int SP_UPDATETASKOPERATION_VALUE_TYPE = 6;
    private static final int SP_UPDATETASKOPERATION_USER_DATA = 7;
    private static final int SP_UPDATETASKOPERATION_ASYNC = 8;
    private ScSecurityCredential security_;
    private String name_;
    private static String i18nBase_ = "com.sun.symon.base.client.ClientApiMessages";

    public MtTaskImpl(String string, ScSecurityCredential scSecurityCredential) throws RemoteException {
        super(string, scSecurityCredential);
        this.name_ = string;
        this.security_ = scSecurityCredential;
        this.migrate();
    }

    public MtTaskImpl(String string, ScSecurityCredential scSecurityCredential, String string2) throws RemoteException {
        super(string, scSecurityCredential, string2);
        this.name_ = string;
        this.security_ = scSecurityCredential;
        this.migrate();
    }

    public void cleanup() {
        MtTaskService.getTaskChangeMulticaster().remove((MSBaseService)this);
    }

    public SMTaskInfo[] getAll() throws SMSecurityException, SMDatabaseException {
        return this.getAll(true);
    }

    private SMTaskInfo[] getAll(boolean bl) throws SMSecurityException, SMDatabaseException {
        Object[] objectArray;
        if (bl) {
            MSSecurity.getInstance();
            MSSecurity.getInstance().checkAccess(this.getServiceName(), "getAll", this.getUserSecurityCredential());
        }
        Vector<SMTaskInfo> vector = new Vector<SMTaskInfo>();
        Connection connection = MSDB.getConnection();
        try {
            try {
                objectArray = connection.prepareCall(SP_GETALLTASKS);
                objectArray.registerOutParameter(1, -10);
                objectArray.execute();
                OracleResultSet oracleResultSet = (OracleResultSet)objectArray.getObject(1);
                while (oracleResultSet.next()) {
                    SMTaskInfo sMTaskInfo = new SMTaskInfo(new SMDBObjectID(oracleResultSet.getLong("TASK_ID"), "TASK"), oracleResultSet.getString("NAME"), oracleResultSet.getString("DESCRIPTION"), oracleResultSet.getString("S_TASK_TYPE"));
                    if (bl) {
                        try {
                            MtTaskSecurity.getInstance().checkAccess(sMTaskInfo.getTaskTypeString(), "edit", this.security_);
                        }
                        catch (Exception exception) {
                            continue;
                        }
                    }
                    vector.addElement(sMTaskInfo);
                }
                objectArray.close();
            }
            catch (SQLException sQLException) {
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "databaseException"));
                throw sMDatabaseException;
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        objectArray = new SMTaskInfo[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public SMTaskInfo[] getAll(String string) throws SMSecurityException, SMDatabaseException {
        return this.getAll(string, true);
    }

    private SMTaskInfo[] getAll(String string, boolean bl) throws SMSecurityException, SMDatabaseException {
        if (bl) {
            MtTaskSecurity.getInstance().checkAccess(string, "edit", this.security_);
        }
        SMTaskInfo[] sMTaskInfoArray = this.getAll(bl);
        Vector<SMTaskInfo> vector = new Vector<SMTaskInfo>();
        int n = 0;
        while (n < sMTaskInfoArray.length) {
            if (sMTaskInfoArray[n].getTaskTypeString().equals(string)) {
                vector.addElement(sMTaskInfoArray[n]);
            }
            ++n;
        }
        Object[] objectArray = new SMTaskInfo[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public SMTaskData load(SMDBObjectID sMDBObjectID) throws SMSecurityException, SMNoSuchObjectException, SMDatabaseException {
        if (!"TASK".equals(sMDBObjectID.getType())) {
            SMDatabaseException sMDatabaseException = new SMDatabaseException(sMDBObjectID + " is meant for another table");
            sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "dataError"));
            throw sMDatabaseException;
        }
        return this.getTask(sMDBObjectID, null, true);
    }

    public SMTaskData load(String string) throws SMSecurityException, SMNoSuchObjectException, SMDatabaseException {
        return this.getTask(null, string.trim(), true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SMTaskInfo loadInfo(SMDBObjectID sMDBObjectID) throws SMSecurityException, SMNoSuchObjectException, SMDatabaseException {
        SMTaskInfo sMTaskInfo;
        if (!"TASK".equals(sMDBObjectID.getType())) {
            SMDatabaseException sMDatabaseException = new SMDatabaseException(sMDBObjectID + " is meant for another table");
            sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "dataError"));
            throw sMDatabaseException;
        }
        MSSecurity.getInstance().checkAccess(this.getServiceName(), "load", this.getUserSecurityCredential(), sMDBObjectID);
        Connection connection = MSDB.getConnection();
        try {
            try {
                CallableStatement callableStatement = connection.prepareCall(SP_GETTASK);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMDBObjectID);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)2, (String)null);
                callableStatement.registerOutParameter(3, -10);
                callableStatement.execute();
                OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(3);
                if (!oracleResultSet.next()) {
                    callableStatement.close();
                    SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException("record not found: " + sMDBObjectID);
                    sMNoSuchObjectException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "database.rowNotFound"));
                    throw sMNoSuchObjectException;
                }
                SMTaskInfo sMTaskInfo2 = new SMTaskInfo(new SMDBObjectID(oracleResultSet.getLong("TASK_ID"), "TASK"), oracleResultSet.getString("NAME"), oracleResultSet.getString("DESCRIPTION"), oracleResultSet.getString("S_TASK_TYPE"));
                MtTaskSecurity.getInstance().checkAccess(sMTaskInfo2.getTaskTypeString(), "edit", this.security_);
                sMTaskInfo = sMTaskInfo2;
                Object var8_14 = null;
            }
            catch (SQLException sQLException) {
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "databaseException"));
                throw sMDatabaseException;
            }
            catch (SMDatabaseException sMDatabaseException) {
                throw sMDatabaseException;
            }
            catch (Exception exception) {
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)exception);
                sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "databaseException"));
                throw sMDatabaseException;
            }
        }
        catch (Throwable throwable) {
            Object var8_15 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        return sMTaskInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SMTaskData getTask(SMDBObjectID sMDBObjectID, String string, boolean bl) throws SMSecurityException, SMNoSuchObjectException, SMDatabaseException {
        SMTaskData sMTaskData;
        if (bl) {
            MSSecurity.getInstance().checkAccess(this.getServiceName(), "load", this.getUserSecurityCredential(), sMDBObjectID);
        }
        Connection connection = MSDB.getConnection();
        try {
            try {
                CallableStatement callableStatement = connection.prepareCall(SP_GETTASK);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMDBObjectID);
                MSDB.setNullable((PreparedStatement)callableStatement, (int)2, (String)string);
                callableStatement.registerOutParameter(3, -10);
                callableStatement.execute();
                OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(3);
                if (!oracleResultSet.next()) {
                    callableStatement.close();
                    SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException("record not found: " + sMDBObjectID + ", " + string);
                    sMNoSuchObjectException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "database.rowNotFound"));
                    throw sMNoSuchObjectException;
                }
                if (sMDBObjectID == null) {
                    sMDBObjectID = new SMDBObjectID(oracleResultSet.getLong("TASK_ID"), "TASK");
                }
                SMTaskData sMTaskData2 = new SMTaskData(sMDBObjectID);
                sMTaskData2.setTaskType(oracleResultSet.getString("S_TASK_TYPE"));
                sMTaskData2.setName(oracleResultSet.getString("NAME"));
                sMTaskData2.setDescription(oracleResultSet.getString("DESCRIPTION"));
                sMTaskData2.setUpdatedBy(oracleResultSet.getString("UPDATED_BY"));
                sMTaskData2.setTimestamp(new SMDBConcurrencyTimestamp(oracleResultSet.getTimestamp("TIMESTAMP")));
                sMTaskData2.setCreatedDate(oracleResultSet.getTimestamp("CREATED_DATE"));
                callableStatement.close();
                if (bl) {
                    MtTaskSecurity.getInstance().checkAccess(sMTaskData2.getTaskTypeString(), "edit", this.security_);
                }
                callableStatement = connection.prepareCall(SP_GETTASKOPERATION);
                callableStatement.setLong(1, sMDBObjectID.getID());
                callableStatement.registerOutParameter(2, -10);
                callableStatement.execute();
                oracleResultSet = (OracleResultSet)callableStatement.getObject(2);
                Vector<SMTaskOperationData> vector = new Vector<SMTaskOperationData>();
                while (true) {
                    if (!oracleResultSet.next()) {
                        Object[] objectArray = new SMTaskOperationData[vector.size()];
                        vector.copyInto(objectArray);
                        sMTaskData2.setOperations((SMTaskOperationData[])objectArray);
                        callableStatement.close();
                        sMTaskData2.setChanged(false);
                        sMTaskData = sMTaskData2;
                        Object var13_20 = null;
                        break;
                    }
                    SMTaskOperationData sMTaskOperationData = new SMTaskOperationData();
                    sMTaskOperationData.setOperation(oracleResultSet.getString("OPERATION"));
                    sMTaskOperationData.setOperand(oracleResultSet.getString("OPERAND"));
                    sMTaskOperationData.setValue(oracleResultSet.getString("VALUE"));
                    sMTaskOperationData.setValueType(oracleResultSet.getString("VALUE_TYPE"));
                    sMTaskOperationData.setUserData(oracleResultSet.getString("USER_DATA"));
                    sMTaskOperationData.setAsync(oracleResultSet.getBoolean("ASYNC"));
                    vector.addElement(sMTaskOperationData);
                }
            }
            catch (SQLException sQLException) {
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "databaseException"));
                throw sMDatabaseException;
            }
            catch (SMLengthException sMLengthException) {
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sMLengthException);
                sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "databaseException"));
                throw sMDatabaseException;
            }
            catch (SMDatabaseException sMDatabaseException) {
                throw sMDatabaseException;
            }
            catch (Exception exception) {
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)exception);
                sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "databaseException"));
                throw sMDatabaseException;
            }
        }
        catch (Throwable throwable) {
            Object var13_21 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        return sMTaskData;
    }

    public SMDBObject save(SMTaskData sMTaskData) throws SMSecurityException, SMStaleDataException, SMNoSuchObjectException, SMDatabaseException, SMDuplicateException {
        return this.save(sMTaskData, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SMDBObject save(SMTaskData sMTaskData, boolean bl) throws SMSecurityException, SMStaleDataException, SMNoSuchObjectException, SMDatabaseException, SMDuplicateException {
        SMDBObject sMDBObject;
        Connection connection;
        block17: {
            SMDBObject sMDBObject2;
            block16: {
                if (bl) {
                    MSSecurity.getInstance().checkAccess(this.getServiceName(), "save", this.getUserSecurityCredential());
                    MtTaskSecurity.getInstance().checkAccess(sMTaskData.getTaskTypeString(), "edit", this.security_);
                }
                connection = MSDB.getConnection();
                try {
                    try {
                        CallableStatement callableStatement = connection.prepareCall(SP_UPDATETASK);
                        MSDB.setNullable((PreparedStatement)callableStatement, (int)1, (SMDBObjectID)sMTaskData.getObjectID());
                        callableStatement.setString(2, sMTaskData.getTaskTypeString());
                        callableStatement.setString(3, sMTaskData.getName());
                        MSDB.setNullable((PreparedStatement)callableStatement, (int)4, (String)sMTaskData.getDescription());
                        String string = null;
                        if (this.getUserSecurityCredential() == null && !bl) {
                            string = sMTaskData.getUpdatedBy();
                            MSDB.setNullable((PreparedStatement)callableStatement, (int)5, (String)sMTaskData.getUpdatedBy());
                        } else {
                            MSDB.setNullable((PreparedStatement)callableStatement, (int)5, (String)this.getUserSecurityCredential().getUser());
                        }
                        MSDB.setNullable((PreparedStatement)callableStatement, (int)6, (SMDBConcurrencyTimestamp)sMTaskData.getTimestamp());
                        MSDB.setNullable((PreparedStatement)callableStatement, (int)7, (Timestamp)sMTaskData.getCreatedDate());
                        callableStatement.registerOutParameter(1, 4);
                        callableStatement.registerOutParameter(6, 93);
                        callableStatement.registerOutParameter(7, 93);
                        callableStatement.execute();
                        SMDBObjectID sMDBObjectID = new SMDBObjectID(callableStatement.getLong(1), "TASK");
                        SMDBObject sMDBObject3 = new SMDBObject(sMDBObjectID);
                        if (string != null) {
                            sMDBObject3.setUpdatedBy(string);
                        } else {
                            sMDBObject3.setUpdatedBy(this.getUserSecurityCredential().getUser());
                        }
                        sMDBObject3.setTimestamp(new SMDBConcurrencyTimestamp(callableStatement.getTimestamp(6)));
                        sMDBObject3.setCreatedDate(callableStatement.getTimestamp(7));
                        callableStatement.close();
                        if (!sMTaskData.isOperationChanged() && sMTaskData.getObjectID() != null) {
                            connection.commit();
                            this.fireEventForSave((SMDBObject)sMTaskData, sMDBObject3);
                            sMDBObject2 = sMDBObject3;
                            Object var12_17 = null;
                            break block16;
                        }
                        this.deleteOperations(connection, sMDBObject3.getObjectID());
                        SMTaskOperationData[] sMTaskOperationDataArray = sMTaskData.getOperations();
                        if (sMTaskOperationDataArray != null) {
                            int n = 0;
                            while (n < sMTaskOperationDataArray.length) {
                                sMDBObject = sMTaskOperationDataArray[n];
                                callableStatement = connection.prepareCall(SP_UPDATETASKOPERATION);
                                callableStatement.setLong(1, sMDBObject3.getObjectID().getID());
                                callableStatement.setInt(2, n + 1);
                                callableStatement.setString(3, sMDBObject.getOperation());
                                MSDB.setNullable((PreparedStatement)callableStatement, (int)4, (String)sMDBObject.getOperand());
                                MSDB.setNullable((PreparedStatement)callableStatement, (int)5, (String)sMDBObject.getValue());
                                MSDB.setNullable((PreparedStatement)callableStatement, (int)6, (String)sMDBObject.getValueType());
                                callableStatement.setString(7, sMDBObject.getUserData());
                                callableStatement.setBoolean(8, sMDBObject.isAsync());
                                callableStatement.execute();
                                callableStatement.close();
                                ++n;
                            }
                        }
                        connection.commit();
                        this.fireEventForSave((SMDBObject)sMTaskData, sMDBObject3);
                        sMDBObject = sMDBObject3;
                        break block17;
                    }
                    catch (SQLException sQLException) {
                        MSDB.rollback((Connection)connection);
                        if (sQLException.getMessage().indexOf("STALE_DATA") >= 0) {
                            SMStaleDataException sMStaleDataException = new SMStaleDataException((Throwable)sQLException);
                            sMStaleDataException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "database.stale"));
                            throw sMStaleDataException;
                        }
                        if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                            SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException((Throwable)sQLException);
                            sMNoSuchObjectException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "database.rowNotFound"));
                            throw sMNoSuchObjectException;
                        }
                        if (sQLException.getMessage().indexOf("DUPLICATE_INDEX") >= 0) {
                            SMDuplicateException sMDuplicateException = new SMDuplicateException((Throwable)sQLException);
                            sMDuplicateException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "database.duplicateIndex"));
                            throw sMDuplicateException;
                        }
                        SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                        sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "databaseException"));
                        throw sMDatabaseException;
                    }
                    catch (Exception exception) {
                        MSDB.rollback((Connection)connection);
                        SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)exception);
                        sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "databaseException"));
                        throw sMDatabaseException;
                    }
                }
                catch (Throwable throwable) {
                    Object var12_19 = null;
                    MSDB.closeConnection((Connection)connection);
                    throw throwable;
                }
            }
            MSDB.closeConnection((Connection)connection);
            return sMDBObject2;
        }
        Object var12_18 = null;
        MSDB.closeConnection((Connection)connection);
        return sMDBObject;
    }

    private void fireEventForSave(SMDBObject sMDBObject, SMDBObject sMDBObject2) {
        if (migrate_) {
            return;
        }
        int n = sMDBObject.getObjectID() == null ? 2 : 1;
        MtTaskService.getTaskChangeMulticaster().fireEvent(new SMDBChangeEvent(sMDBObject2.getObjectID(), n));
    }

    private void deleteOperations(Connection connection, SMDBObjectID sMDBObjectID) throws SMStaleDataException, SMNoSuchObjectException, SMDatabaseException {
        try {
            CallableStatement callableStatement = connection.prepareCall(SP_DELETETASKOPERATION);
            callableStatement.setLong(1, sMDBObjectID.getID());
            callableStatement.execute();
            callableStatement.close();
        }
        catch (SQLException sQLException) {
            if (sQLException.getMessage().indexOf("STALE_DATA") >= 0) {
                SMStaleDataException sMStaleDataException = new SMStaleDataException((Throwable)sQLException);
                sMStaleDataException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "database.stale"));
                throw sMStaleDataException;
            }
            if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException((Throwable)sQLException);
                sMNoSuchObjectException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "database.rowNotFound"));
                throw sMNoSuchObjectException;
            }
            SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
            sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "databaseException"));
            throw sMDatabaseException;
        }
    }

    public void delete(SMDBObjectID sMDBObjectID) throws SMSecurityException, SMDatabaseException, SMNoSuchObjectException {
        if (!"TASK".equals(sMDBObjectID.getType())) {
            SMDatabaseException sMDatabaseException = new SMDatabaseException(sMDBObjectID + " is meant for another table");
            sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "dataError"));
            throw sMDatabaseException;
        }
        MSSecurity.getInstance().checkAccess(this.getServiceName(), "delete", this.getUserSecurityCredential(), sMDBObjectID);
        MtTaskSecurity.getInstance().checkAccess(this.getTaskTypeID(sMDBObjectID), "delete", this.security_);
        Connection connection = MSDB.getConnection();
        try {
            try {
                CallableStatement callableStatement = connection.prepareCall(SP_DELETETASK);
                callableStatement.setLong(1, sMDBObjectID.getID());
                callableStatement.execute();
                connection.commit();
                callableStatement.close();
            }
            catch (SQLException sQLException) {
                MSDB.rollback((Connection)connection);
                if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
                    SMNoSuchObjectException sMNoSuchObjectException = new SMNoSuchObjectException((Throwable)sQLException);
                    sMNoSuchObjectException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "database.rowNotFound"));
                    throw sMNoSuchObjectException;
                }
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)sQLException);
                sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "databaseException"));
                throw sMDatabaseException;
            }
            catch (Exception exception) {
                MSDB.rollback((Connection)connection);
                SMDatabaseException sMDatabaseException = new SMDatabaseException((Throwable)exception);
                sMDatabaseException.setMessageI18nKey(new SMMessageI18nKey(i18nBase_, "databaseException"));
                throw sMDatabaseException;
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        MtTaskService.getTaskChangeMulticaster().fireEvent(new SMDBChangeEvent(sMDBObjectID, 3));
    }

    public void addEventListener(SMDBRemoteChangeListener sMDBRemoteChangeListener) {
        MtTaskService.getTaskChangeMulticaster().add((MSBaseService)this, sMDBRemoteChangeListener);
    }

    public void removeEventListener(SMDBRemoteChangeListener sMDBRemoteChangeListener) {
        MtTaskService.getTaskChangeMulticaster().remove((MSBaseService)this, sMDBRemoteChangeListener);
    }

    public SMTaskType[] getTaskTypes() throws SMSecurityException {
        return MtTaskDescriptor.getTaskTypes(this.security_);
    }

    private String getTaskTypeID(SMDBObjectID sMDBObjectID) throws SMSecurityException, SMNoSuchObjectException, SMDatabaseException {
        SMTaskInfo sMTaskInfo = this.loadInfo(sMDBObjectID);
        return sMTaskInfo.getTaskTypeString();
    }

    public SMRemoteLogReader getLogReader(String string) throws Exception {
        MSLogReader mSLogReader = new MSLogReader(string);
        return mSLogReader;
    }

    private void migrate() {
        if (!migrate_) {
            return;
        }
        this.migrateTaskTypes();
        this.migratePropertyTasks();
        migrate_ = false;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void migrateTaskTypes() {
        boolean bl = false;
        Connection connection = null;
        connection = MSDB.getConnection();
        CallableStatement callableStatement = connection.prepareCall(SP_GETALLTASKS);
        callableStatement.registerOutParameter(1, -10);
        callableStatement.execute();
        OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(1);
        while (oracleResultSet.next()) {
            String string = oracleResultSet.getString("S_TASK_TYPE");
            if (string != null) continue;
            int n = oracleResultSet.getInt("TASK_TYPE");
            SMTaskData sMTaskData = this.getTask(new SMDBObjectID(oracleResultSet.getLong("TASK_ID"), "TASK"), null, bl);
            switch (n) {
                case 3: {
                    sMTaskData.setTaskType("Core_Generic");
                    break;
                }
                case 1: {
                    sMTaskData.setTaskType("Core_Module");
                    break;
                }
                case 0: {
                    sMTaskData.setTaskType("Core_DataProperty");
                    break;
                }
                case 2: {
                    sMTaskData.setTaskType("Core_MCP");
                    break;
                }
                case 4: {
                    sMTaskData.setTaskType("Core_Table");
                    break;
                }
                case 8: {
                    sMTaskData.setTaskType("ichange");
                    break;
                }
                case 9: {
                    sMTaskData.setTaskType("9");
                }
            }
            this.save(sMTaskData, bl);
        }
        callableStatement.close();
        Object var9_9 = null;
        if (connection == null) return;
        try {
            MSDB.closeConnection((Connection)connection);
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (Exception exception) {
                MSLogPrintWriter.getErrorWriter().println("Unable to migrate task types " + exception);
                Object var9_10 = null;
                if (connection == null) return;
                try {
                    MSDB.closeConnection((Connection)connection);
                    return;
                }
                catch (Exception exception2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (connection == null) throw throwable;
            try {
                MSDB.closeConnection((Connection)connection);
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void migratePropertyTasks() {
        try {
            boolean bl = false;
            SMTaskInfo[] sMTaskInfoArray = this.getAll("Core_DataProperty", bl);
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            int n = 0;
            while (n < sMTaskInfoArray.length) {
                SMTaskData sMTaskData = this.getTask(sMTaskInfoArray[n].getObjectID(), null, bl);
                int n2 = this.splitTableOperations(sMTaskData.getOperations(), vector, vector2);
                if (n2 != 0) {
                    if (n2 == sMTaskData.getOperations().length) {
                        sMTaskData.setTaskType("Core_Table");
                        this.save(sMTaskData, bl);
                    } else {
                        Object[] objectArray = new SMTaskOperationData[vector.size()];
                        vector.copyInto(objectArray);
                        sMTaskData.setOperations((SMTaskOperationData[])objectArray);
                        this.save(sMTaskData, bl);
                        SMTaskData sMTaskData2 = new SMTaskData();
                        String string = sMTaskData.getName();
                        if (sMTaskData.getName().length() > 32 - "-table".length()) {
                            string = string.substring(0, 32 - "-table".length());
                        }
                        sMTaskData2.setName(string + "-table");
                        sMTaskData2.setDescription(sMTaskData.getDescription());
                        sMTaskData2.setTaskType("Core_Table");
                        objectArray = new SMTaskOperationData[vector2.size()];
                        vector2.copyInto(objectArray);
                        sMTaskData2.setOperations((SMTaskOperationData[])objectArray);
                        this.save(sMTaskData2, bl);
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            MSLogPrintWriter.getErrorWriter().println("Unable to migrate property task" + exception);
        }
    }

    private int splitTableOperations(SMTaskOperationData[] sMTaskOperationDataArray, Vector vector, Vector vector2) {
        vector.removeAllElements();
        vector2.removeAllElements();
        int n = 0;
        while (n < sMTaskOperationDataArray.length) {
            if (sMTaskOperationDataArray[n].getOperation().equals("set")) {
                vector.addElement(sMTaskOperationDataArray[n]);
            } else {
                vector2.addElement(sMTaskOperationDataArray[n]);
            }
            ++n;
        }
        return vector2.size();
    }

    boolean isTypeOfTaskRegistered(String string) {
        try {
            SMTaskData sMTaskData = this.getTask(null, string, false);
            if (MtTaskDescriptor.getTaskType(sMTaskData.getTaskTypeString()) == null) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }
}

