/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.task;

import com.sun.symon.base.client.task.SMTaskType;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.common.MSProperties;
import com.sun.symon.base.mgmtservice.task.MtTaskCommand;
import com.sun.symon.base.mgmtservice.task.MtTaskSecurity;
import com.sun.symon.base.server.common.ScSecurityCredential;
import java.io.File;
import java.io.FileInputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.crimson.tree.XmlDocument;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class MtTaskDescriptor {
    private static Hashtable taskCommands_ = new Hashtable();
    private static Vector vTaskTypes_ = new Vector();
    private static Hashtable hTaskTypes_ = new Hashtable();
    private static boolean inited_ = false;

    static synchronized void init() {
        if (!inited_) {
            MtTaskDescriptor.searchDirs();
            inited_ = true;
        }
    }

    private static void searchDirs() {
        String string = System.getProperty("ESDIR", "/var/opt/SUNWsymon");
        String string2 = string + "/AdvancedServices/tasks/";
        File file = new File(string2);
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        MtTaskDescriptor.searchDir(new File(string2 + "core"), true);
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isDirectory() && !fileArray[n].getName().equals("core")) {
                MtTaskDescriptor.searchDir(fileArray[n].getAbsoluteFile(), false);
            }
            ++n;
        }
    }

    private static void searchDir(File file, boolean bl) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isFile() && fileArray[n].getName().endsWith(".xml")) {
                MtTaskDescriptor.loadXML(fileArray[n], bl);
            }
            ++n;
        }
    }

    /*
     * Loose catch block
     */
    private static void loadXML(File file, boolean bl) {
        block11: {
            FileInputStream fileInputStream;
            try {
                fileInputStream = new FileInputStream(file);
            }
            catch (Exception exception) {
                MSLogPrintWriter.getErrorWriter().println("Unable to open + " + file.getAbsolutePath() + " " + exception);
                return;
            }
            MSLogPrintWriter.getInfoWriter().println("MtTaskDescriptor : loadXML() File = " + file.getName());
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new MyResolver());
            InputSource inputSource = new InputSource(fileInputStream);
            inputSource.setSystemId("");
            XmlDocument xmlDocument = (XmlDocument)documentBuilder.parse(inputSource);
            xmlDocument.getDocumentElement().normalize();
            MtTaskDescriptor.readDocument(xmlDocument, bl);
            Object var8_9 = null;
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {}
            break block11;
            {
                catch (Exception exception) {
                    MSLogPrintWriter.getErrorWriter().println("Unable to parse " + file.getAbsolutePath() + " " + exception);
                    Object var8_10 = null;
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void readDocument(XmlDocument var0, boolean var1_1) throws Exception {
        var2_2 = var0.getDocumentElement();
        var3_3 = var2_2.getChildNodes();
        var4_4 = var2_2.getChildNodes();
        var12_5 = 0;
        while (var12_5 < var4_4.getLength()) {
            var6_7 = var4_4.item(var12_5);
            if (var6_7.getNodeType() == 1) {
                var9_10 = MtTaskDescriptor.handleTypeElement(var6_7, var1_1);
                var11_12 = var9_10.getTaskTypeString();
                var5_6 = var6_7.getChildNodes();
                var13_13 = 0;
                while (var13_13 < var5_6.getLength()) {
                    var7_8 = var5_6.item(var13_13);
                    if (var7_8.getNodeType() == 1) {
                        var8_9 = (Element)var7_8;
                        if (var8_9.getTagName().equals("editor")) {
                            var10_11 = MtTaskDescriptor.getAttributes(var7_8);
                            var14_14 = (String)var10_11.get("presentation");
                            var15_15 = (String)var10_11.get("class");
                            var9_10.setPresentationClass(var14_14, var15_15);
                        } else if (var8_9.getTagName().equals("log")) {
                            var10_11 = MtTaskDescriptor.getAttributes(var7_8);
                            var14_14 = (String)var10_11.get("presentation");
                            var15_15 = (String)var10_11.get("class");
                            var9_10.setLogPresentationClass(var14_14, var15_15);
                        } else if (var8_9.getTagName().equals("ACL")) {
                            var10_11 = MtTaskDescriptor.getAttributes(var7_8);
                            var14_14 = (String)var10_11.get("operation");
                            var15_15 = (String)var10_11.get("allowUser");
                            var16_16 = (String)var10_11.get("allowGroup");
                            var17_17 = (String)var10_11.get("denyUser");
                            var18_18 = (String)var10_11.get("denyGroup");
                            try {
                                MtTaskSecurity.getInstance().defineAllowUser(var11_12, var14_14, var15_15);
                                MtTaskSecurity.getInstance().defineAllowGroup(var11_12, var14_14, var16_16);
                                if (var17_17 != null) {
                                    MtTaskSecurity.getInstance().defineDenyUser(var11_12, var14_14, var17_17);
                                }
                                if (var18_18 == null) ** GOTO lbl54
                                MtTaskSecurity.getInstance().defineDenyGroup(var11_12, var14_14, var18_18);
                            }
                            catch (Exception var19_19) {
                                throw new Exception("Unable to define ACL for type ID " + var11_12 + " " + var19_19);
                            }
                        } else if (var8_9.getTagName().equals("command")) {
                            var10_11 = MtTaskDescriptor.getAttributes(var7_8);
                            var14_14 = (String)var10_11.get("name");
                            var15_15 = (String)var10_11.get("class");
                            var16_16 = (String)var10_11.get("errorClass");
                            if (MtTaskDescriptor.taskCommands_.containsKey(var14_14)) {
                                throw new Exception("Already defined task command: " + var14_14);
                            }
                            MtTaskDescriptor.taskCommands_.put(var14_14, new MtTaskCommand(var14_14, var15_15, var16_16));
                        }
                    }
lbl54:
                    // 9 sources

                    ++var13_13;
                }
            }
            ++var12_5;
        }
    }

    private static SMTaskType handleTypeElement(Node node, boolean bl) throws Exception {
        Hashtable hashtable = MtTaskDescriptor.getAttributes(node);
        String string = (String)hashtable.get("ID");
        String string2 = (String)hashtable.get("name");
        String string3 = (String)hashtable.get("description");
        String string4 = (String)hashtable.get("hidden");
        if (string4 == null) {
            string4 = "false";
        }
        if (hTaskTypes_.containsKey(string)) {
            throw new Exception("Task type ID " + string + " is already defined");
        }
        boolean bl2 = false;
        if (string4.equalsIgnoreCase("true")) {
            bl2 = true;
        }
        SMTaskType sMTaskType = new SMTaskType(string, string2, string3, bl2);
        vTaskTypes_.addElement(sMTaskType);
        hTaskTypes_.put(string, sMTaskType);
        return sMTaskType;
    }

    private static Hashtable getAttributes(Node node) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Attr attr = (Attr)namedNodeMap.item(n);
            hashtable.put(attr.getName(), attr.getValue());
            ++n;
        }
        return hashtable;
    }

    public static SMTaskType getTaskType(int n) {
        return (SMTaskType)hTaskTypes_.get(n + "");
    }

    public static SMTaskType getTaskType(String string) {
        return (SMTaskType)hTaskTypes_.get(string);
    }

    public static SMTaskType[] getTaskTypes(ScSecurityCredential scSecurityCredential) {
        Vector<SMTaskType> vector = new Vector<SMTaskType>();
        int n = 0;
        while (n < vTaskTypes_.size()) {
            SMTaskType sMTaskType = (SMTaskType)vTaskTypes_.elementAt(n);
            try {
                MtTaskSecurity.getInstance().checkAccess(sMTaskType.getTaskTypeString(), "edit", scSecurityCredential);
                vector.addElement(sMTaskType);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
        Object[] objectArray = new SMTaskType[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static MtTaskCommand getTaskCommand(String string) {
        return (MtTaskCommand)taskCommands_.get(string);
    }

    static {
        MtTaskDescriptor.init();
    }

    static class MyResolver
    implements EntityResolver {
        MyResolver() {
        }

        public InputSource resolveEntity(String string, String string2) {
            if (!string2.endsWith("TaskType.dtd")) {
                return null;
            }
            try {
                MSLogPrintWriter.getInfoWriter().println("MtTaskDescriptor: MyResolver: Send TaskType.dtd file...");
                return new InputSource(new FileInputStream(MSProperties.getFile((String)"dtd/core/TaskType", (String)".dtd")));
            }
            catch (Exception exception) {
                MSLogPrintWriter.getErrorWriter().println("Unable to open DTD: " + exception);
                return null;
            }
        }
    }
}

