/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.trap;

import com.sun.symon.base.server.common.ScPortAllocator;
import com.sun.symon.base.server.snmp.SsDecodeException;
import com.sun.symon.base.server.snmp.SsEncodeException;
import com.sun.symon.base.server.snmp.SsMessage;
import com.sun.symon.base.server.snmp.v1.SsTrap;
import com.sun.symon.base.server.snmp.v2.SsRequest;
import com.sun.symon.base.server.snmp.v2u.SsResponse;
import com.sun.symon.base.server.trap.SrTrapConstants;
import com.sun.symon.base.server.trap.SrTrapData;
import com.sun.symon.base.server.trap.SrTrapDispatcher;
import com.sun.symon.base.server.trap.SrTrapHandlerInterface;
import com.sun.symon.base.server.trap.SrTrapSubscriberInterface;
import com.sun.symon.base.server.types.StSnmpOBJECT_IDENTIFIER;
import com.sun.symon.base.server.types.StSnmpOCTET_STRING;
import com.sun.symon.base.server.types.StString;
import com.sun.symon.base.utility.UcBeanIntrospector;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcPeriodicException;
import com.sun.symon.base.utility.UcTickerTimer;
import com.sun.symon.base.utility.UcTickerTimerResponse;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Vector;

public class SrTrapSubscriber
implements SrTrapSubscriberInterface,
SrTrapConstants {
    private static final String TRAPADDRPORT = "1.3.6.1.6.3.1.1.4.6.0";
    private DatagramSocket socket;
    private String trapHost = "localhost";
    private int trapPort = 162;
    private String trapCommunity = "public";
    private String trapEnterprise = "1.3.6.1.4.1.42.2.12.2";
    private int trapFreq = 300;
    private UcTickerTimer ticker;
    private ScPortAllocator portAlloc = null;
    private static SrTrapSubscriber trapSubscriber = null;
    private SrTrapDispatcher dispatcher = null;
    private int maxTrapTypes;
    private Vector[] handlers = null;

    public static synchronized SrTrapSubscriber getInstance() {
        if (trapSubscriber == null) {
            trapSubscriber = new SrTrapSubscriber();
        }
        return trapSubscriber;
    }

    SrTrapSubscriber() {
        UcBeanIntrospector ucBeanIntrospector = new UcBeanIntrospector();
        try {
            ucBeanIntrospector.readProperties("domain-config.x", 0);
            ucBeanIntrospector.readProperties("javaserver.properties");
            ucBeanIntrospector.apply((Object)this);
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)("SrTrapSubscriber: " + exception.getMessage()));
        }
        UcDDL.logInfoMessage((String)("SrTrapSubscriber: " + this.trapHost + ":" + this.trapPort));
        this.init();
    }

    protected void finalize() throws Throwable {
        UcDDL.logInfoMessage((String)"TrapHandler : FINALIZE() is called");
        UcDDL.logInfoMessage((String)("TrapHandler :  RELEASING port : " + this.socket.getLocalPort()));
        this.unsubscribeTrap();
        this.portAlloc.donePort(this.socket.getLocalPort());
        this.socket.close();
    }

    public synchronized void addHandler(SrTrapHandlerInterface srTrapHandlerInterface) {
        this.addHandler(srTrapHandlerInterface, SrTrapConstants.trapTypes);
    }

    public synchronized void addHandler(SrTrapHandlerInterface srTrapHandlerInterface, int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            if (n2 < 0 || n2 > 30) {
                UcDDL.logErrorMessage((String)("addHandler: on unknown type " + nArray[n]));
            } else {
                if (this.handlers[n2] == null) {
                    this.handlers[n2] = new Vector();
                }
                this.handlers[n2].addElement(srTrapHandlerInterface);
                UcDDL.logInfoMessage((String)("addHandler: on type " + nArray[n]));
            }
            ++n;
        }
        if (!this.isEmpty()) {
            this.subscribeTrap();
        }
    }

    public synchronized void removeHandler(SrTrapHandlerInterface srTrapHandlerInterface) {
        this.removeHandler(srTrapHandlerInterface, SrTrapConstants.trapTypes);
    }

    public synchronized void removeHandler(SrTrapHandlerInterface srTrapHandlerInterface, int[] nArray) {
        UcDDL.logInfoMessage((String)("removeHandler with num of types: " + nArray.length));
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            if (n2 < 0 || n2 > 30) {
                UcDDL.logErrorMessage((String)("removeHandler: on unknown type " + nArray[n]));
            } else if (this.handlers[n2] != null && this.handlers[n2].size() != 0) {
                this.handlers[n2].removeElement(srTrapHandlerInterface);
            }
            ++n;
        }
        if (this.isEmpty()) {
            this.unsubscribeTrap();
        }
    }

    private synchronized boolean isEmpty() {
        int n = 0;
        while (n < SrTrapConstants.trapTypes.length) {
            int n2 = SrTrapConstants.trapTypes[n];
            if (this.handlers[n2] != null && this.handlers[n2].size() != 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public synchronized Vector getHandlers(int n) {
        if (n < 0 || n > 30) {
            UcDDL.logErrorMessage((String)("getHandlers: on unknown type " + n));
            return null;
        }
        if (this.handlers[n] == null || this.handlers[n].size() == 0) {
            return null;
        }
        Vector vector = (Vector)this.handlers[n].clone();
        return vector;
    }

    public String getTrapCommunity() {
        return this.trapCommunity;
    }

    public String getTrapEnterprise() {
        return this.trapEnterprise;
    }

    public int getTrapFreq() {
        return this.trapFreq;
    }

    public String getTrapHost() {
        return this.trapHost;
    }

    public int getTrapPort() {
        return this.trapPort;
    }

    public void setTrapCommunity(String string) {
        this.trapCommunity = string;
    }

    public void setTrapEnterprise(String string) {
        this.trapEnterprise = string;
    }

    public void setTrapFreq(int n) {
        if (n <= 0) {
            UcDDL.logErrorMessage((String)("Invalid trap freq: " + n));
            this.trapFreq = 300;
        } else {
            this.trapFreq = n;
        }
    }

    public void setTrapHost(String string) {
        this.trapHost = string;
        if (this.trapPort != -1) {
            try {
                String string2 = InetAddress.getByName(this.trapHost).getHostAddress();
                UcDDL.logInfoMessage((String)("trap handler host and port = " + this.trapHost + " (" + string2 + ") port " + this.trapPort));
            }
            catch (UnknownHostException unknownHostException) {
                UcDDL.logErrorMessage((String)("Error setting trap host " + unknownHostException.getMessage()));
            }
        }
    }

    public void setTrapPort(int n) {
        this.trapPort = n;
        if (this.trapHost != null) {
            try {
                String string = InetAddress.getByName(this.trapHost).getHostAddress();
                UcDDL.logInfoMessage((String)("trap handler host and port = " + this.trapHost + " (" + string + ") port " + this.trapPort));
            }
            catch (UnknownHostException unknownHostException) {
                UcDDL.logErrorMessage((String)("Error setting trap port " + unknownHostException.getMessage()));
            }
        }
    }

    private void subscribeTrap() {
        if (this.ticker.start()) {
            UcDDL.logInfoMessage((String)"trap writer started");
            this.sendTrap();
        }
    }

    private void unsubscribeTrap() {
        UcDDL.logInfoMessage((String)"trap writer stopped");
        this.ticker.stop();
    }

    private void dispatchTrap(SrTrapData srTrapData) {
        if (srTrapData == null) {
            return;
        }
        Vector vector = this.getHandlers(srTrapData.getType());
        if (vector == null) {
            return;
        }
        this.dispatcher.dispatch(srTrapData, vector);
    }

    private void handleV1Trap(SsTrap ssTrap) {
        Object object;
        Object object2;
        int n;
        StString stString;
        int n2;
        String string;
        String string2;
        block21: {
            int n3;
            block20: {
                n3 = ssTrap.getGenericTrap();
                int n4 = ssTrap.getSpecificTrap();
                string2 = ssTrap.getAgentAddress();
                string = ssTrap.getContextName();
                n2 = 1;
                stString = null;
                UcDDL.logDebugMessage((String)("V1: Generic=" + n3 + ", Specific=" + n4 + ", ip=" + string2 + ", context=" + string));
                n = 0;
                if (n3 != 6) break block20;
                object2 = (StSnmpOCTET_STRING)ssTrap.getVariable(TRAPADDRPORT);
                if (object2 != null) {
                    object = ((StString)object2).toString();
                    n = (0xFF00 & ((String)object).charAt(4) << 8) + (0xFF & ((String)object).charAt(5));
                }
                switch (n4) {
                    case 1: {
                        n2 = 1;
                        UcDDL.logDebugMessage((String)"process status trap");
                        stString = (StSnmpOBJECT_IDENTIFIER)ssTrap.getVariable(this.trapEnterprise + ".1.3.1.0");
                        if (stString == null) {
                            UcDDL.logErrorMessage((String)"can't find status oid");
                            return;
                        }
                        break block21;
                    }
                    case 10: {
                        n2 = 10;
                        break;
                    }
                    case 2: {
                        UcDDL.logDebugMessage((String)"process refresh trap");
                        n2 = 2;
                        stString = (StSnmpOBJECT_IDENTIFIER)ssTrap.getVariable(this.trapEnterprise + ".1.3.2.0");
                        if (stString == null) {
                            UcDDL.logErrorMessage((String)"can't find refresh oid");
                            return;
                        }
                        break block21;
                    }
                    case 4: {
                        UcDDL.logDebugMessage((String)"process module loaded trap");
                        n2 = 4;
                        break;
                    }
                    case 5: {
                        UcDDL.logDebugMessage((String)"process module unloaded trap");
                        n2 = 5;
                        break;
                    }
                    case 3: {
                        UcDDL.logDebugMessage((String)"process event trap");
                        n2 = 3;
                        break;
                    }
                    case 6: {
                        UcDDL.logDebugMessage((String)"process user config trap");
                        n2 = 3;
                        break;
                    }
                    case 7: {
                        UcDDL.logDebugMessage((String)"process trap client trap");
                        n2 = 7;
                        break;
                    }
                    case 8: {
                        UcDDL.logDebugMessage((String)"process user update trap");
                        n2 = 8;
                        break;
                    }
                    case 9: {
                        UcDDL.logDebugMessage((String)"process topo lic refersh trap");
                        n2 = 9;
                        break;
                    }
                    default: {
                        UcDDL.logDebugMessage((String)("process trap: " + n4));
                        n2 = n4;
                        break;
                    }
                }
                break block21;
            }
            if (n3 == 1) {
                UcDDL.logDebugMessage((String)"process warm start trap");
                n2 = 21;
            } else if (n3 == 0) {
                UcDDL.logDebugMessage((String)"process cold start trap");
                n2 = 22;
            } else {
                return;
            }
        }
        object2 = null;
        if (stString != null) {
            object2 = stString.toString();
        }
        UcDDL.logDebugMessage((String)("V1: trapType:" + n2 + ", " + (String)object2));
        object = new SrTrapData(n2, string2, n, string, (String)object2);
        this.dispatchTrap((SrTrapData)object);
    }

    private void handleV2Trap(SsMessage ssMessage) {
        StSnmpOCTET_STRING stSnmpOCTET_STRING;
        UcDDL.logDebugMessage((String)"handle V2 trap");
        String string = ssMessage.getContextName();
        StSnmpOBJECT_IDENTIFIER stSnmpOBJECT_IDENTIFIER = (StSnmpOBJECT_IDENTIFIER)ssMessage.getVariable("1.3.6.1.6.3.1.1.4.1.0");
        UcDDL.logDebugMessage((String)("V2: value=" + stSnmpOBJECT_IDENTIFIER));
        int n = 1;
        if (stSnmpOBJECT_IDENTIFIER == null) {
            UcDDL.logErrorMessage((String)"can't find trap type");
            return;
        }
        if (stSnmpOBJECT_IDENTIFIER.toString().compareTo(this.trapEnterprise + ".0.1") == 0) {
            UcDDL.logDebugMessage((String)"process status trap");
            stSnmpOBJECT_IDENTIFIER = (StSnmpOBJECT_IDENTIFIER)ssMessage.getVariable(this.trapEnterprise + ".1.3.1.0");
            if (stSnmpOBJECT_IDENTIFIER == null) {
                UcDDL.logErrorMessage((String)"can't find status oid");
                return;
            }
        } else if (stSnmpOBJECT_IDENTIFIER.toString().compareTo(this.trapEnterprise + ".0.10") == 0) {
            UcDDL.logDebugMessage((String)"process mib restructure trap");
            n = 10;
        } else if (stSnmpOBJECT_IDENTIFIER.toString().compareTo(this.trapEnterprise + ".0.2") == 0) {
            UcDDL.logDebugMessage((String)"process refresh trap");
            n = 2;
            stSnmpOBJECT_IDENTIFIER = (StSnmpOBJECT_IDENTIFIER)ssMessage.getVariable(this.trapEnterprise + ".1.3.2.0");
            if (stSnmpOBJECT_IDENTIFIER == null) {
                UcDDL.logErrorMessage((String)"can't find refresh oid");
                return;
            }
        } else if (stSnmpOBJECT_IDENTIFIER.toString().compareTo("1.3.6.1.6.3.1.1.5.2") == 0) {
            UcDDL.logDebugMessage((String)"process warm start trap");
            n = 21;
        } else {
            return;
        }
        if ((stSnmpOCTET_STRING = (StSnmpOCTET_STRING)ssMessage.getVariable(TRAPADDRPORT)) == null) {
            UcDDL.logErrorMessage((String)"can't find trap address");
            return;
        }
        String string2 = stSnmpOCTET_STRING.toString();
        String string3 = "" + (0xFF & string2.charAt(0)) + "." + (0xFF & string2.charAt(1)) + "." + (0xFF & string2.charAt(2)) + "." + (0xFF & string2.charAt(3));
        int n2 = (0xFF00 & string2.charAt(4) << 8) + (0xFF & string2.charAt(5));
        String string4 = null;
        if (stSnmpOBJECT_IDENTIFIER != null) {
            string4 = stSnmpOBJECT_IDENTIFIER.toString();
        }
        SrTrapData srTrapData = new SrTrapData(n, string3, n2, string, string4);
        this.dispatchTrap(srTrapData);
    }

    private void init() {
        this.maxTrapTypes = SrTrapConstants.trapTypes.length;
        this.dispatcher = new SrTrapDispatcher(this);
        if (this.portAlloc == null) {
            this.portAlloc = ScPortAllocator.getInstance();
        }
        try {
            this.ticker = new UcTickerTimer((long)this.trapFreq, new UcTickerTimerResponse(){

                public void processTick() {
                    SrTrapSubscriber.this.sendTrap();
                }

                public void processTickEnd() {
                }
            });
        }
        catch (UcPeriodicException ucPeriodicException) {
            // empty catch block
        }
        try {
            this.socket = this.portAlloc.getUDPSocket();
        }
        catch (SocketException socketException) {
            UcDDL.logErrorMessage((String)"socket creation failed", (Throwable)socketException);
            return;
        }
        Thread thread = new Thread("Trap UDP Reader"){

            public void run() {
                try {
                    SrTrapSubscriber.this.readTraps();
                }
                catch (Throwable throwable) {
                    UcDDL.logErrorMessage((String)"Error in reading in trap");
                }
            }
        };
        this.handlers = new Vector[30];
        thread.setPriority(10);
        thread.start();
    }

    private void readTraps() {
        byte[] byArray = new byte[65536];
        while (true) {
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            try {
                this.socket.receive(datagramPacket);
            }
            catch (IOException iOException) {
                UcDDL.logErrorMessage((String)"receive() failed", (Throwable)iOException);
                return;
            }
            this.readTrapProcess(byArray, datagramPacket.getLength(), datagramPacket.getAddress(), datagramPacket.getPort());
        }
    }

    private void readTrapProcess(byte[] byArray, int n, InetAddress inetAddress, int n2) {
        UcDDL.logDebugMessage((String)("readTrapProcess: " + n + " port=" + n2));
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        SsMessage ssMessage = null;
        try {
            ssMessage = SsMessage.toMessage(byArray2);
        }
        catch (SsDecodeException ssDecodeException) {
            UcDDL.logErrorMessage((String)"Invalid snmp packet received", (Throwable)ssDecodeException);
            return;
        }
        if (ssMessage.getVersion() == 1 && ssMessage.getType() == 4) {
            this.handleV1Trap((SsTrap)ssMessage);
        } else if (ssMessage.getVersion() == 2 && ssMessage.getType() == 3 || ssMessage.getVersion() == 3 && ssMessage.getType() == 3) {
            this.handleV2Trap(ssMessage);
        } else if (ssMessage.getVersion() == 2 && ssMessage.getType() == 4 || ssMessage.getVersion() == 3 && ssMessage.getType() == 4) {
            this.confirmInform(ssMessage, inetAddress, n2);
            this.handleV2Trap(ssMessage);
        } else {
            UcDDL.logErrorMessage((String)"wrong type of snmp packet received");
        }
    }

    private SsMessage makeConfirmation(SsMessage ssMessage) throws SsEncodeException {
        SsRequest ssRequest;
        switch (ssMessage.getVersion()) {
            case 2: {
                ssRequest = new com.sun.symon.base.server.snmp.v2.SsResponse();
                break;
            }
            case 3: {
                ssRequest = new SsResponse();
                break;
            }
            default: {
                throw new SsEncodeException("Invalid request version");
            }
        }
        ssRequest.setState(ssMessage.getState());
        ssRequest.setContextName(ssMessage.getContextName());
        ssRequest.setSecurityName(ssMessage.getSecurityName());
        ssRequest.setSecurityLevel(ssMessage.getSecurityLevel());
        ssRequest.setSecurityModel(ssMessage.getSecurityModel());
        ssRequest.setSendId(ssMessage.getSendId());
        ssRequest.setRequestId(ssMessage.getRequestId());
        ssRequest.setVariableNames(ssMessage.getVariableNames());
        ssRequest.setVariableValues(ssMessage.getVariableTypes(), ssMessage.getVariableValues());
        return ssRequest;
    }

    private void confirmInform(SsMessage ssMessage, InetAddress inetAddress, int n) {
        byte[] byArray;
        try {
            byArray = this.makeConfirmation(ssMessage).toBytestream();
        }
        catch (SsEncodeException ssEncodeException) {
            UcDDL.logErrorMessage((String)"invalid packet", (Throwable)ssEncodeException);
            return;
        }
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, n);
        try {
            this.socket.send(datagramPacket);
            UcDDL.logDebugMessage((String)("response sent to " + inetAddress + ":" + n));
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"send() failed", (Throwable)exception);
        }
    }

    private void sendTrap() {
        SsTrap ssTrap = new SsTrap();
        ssTrap.setSecurityName(this.trapCommunity);
        ssTrap.setEnterprise(this.trapEnterprise);
        try {
            ssTrap.setAgentAddress(InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            UcDDL.logErrorMessage((String)"can't get local host address", (Throwable)unknownHostException);
            return;
        }
        ssTrap.setGenericTrap(6);
        ssTrap.setSpecificTrap(7);
        DatagramPacket datagramPacket = null;
        try {
            byte[] byArray = ssTrap.toBytestreamAndDump();
            datagramPacket = new DatagramPacket(byArray, byArray.length, InetAddress.getByName(this.trapHost), this.trapPort);
        }
        catch (UnknownHostException unknownHostException) {
            UcDDL.logErrorMessage((String)("invalid host: '" + this.trapHost + "'"), (Throwable)unknownHostException);
            return;
        }
        catch (SsEncodeException ssEncodeException) {
            UcDDL.logErrorMessage((String)"invalid packet", (Throwable)ssEncodeException);
            return;
        }
        try {
            this.socket.send(datagramPacket);
            UcDDL.logDebugMessage((String)("trap sent to " + this.trapHost + ":" + this.trapPort));
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"send() failed", (Throwable)exception);
        }
    }
}

