/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.trap;

import com.sun.symon.base.server.trap.SrTrapData;
import com.sun.symon.base.server.trap.SrTrapDispatcher;
import com.sun.symon.base.server.trap.SrTrapHandlerInterface;
import com.sun.symon.base.server.trap.SrTrapSubscriber;
import com.sun.symon.base.utility.UcDDL;
import java.util.Vector;

class SrHandleThread
extends Thread {
    private boolean available;
    private SrTrapDispatcher dispatcher;
    private SrTrapSubscriber subscriber;
    private SrTrapData data = null;
    private Vector handlers;
    private static int index = 0;
    private int myIndex = index++;

    public SrHandleThread(SrTrapSubscriber srTrapSubscriber, SrTrapDispatcher srTrapDispatcher) {
        super("HandlerThread-" + index);
        this.dispatcher = srTrapDispatcher;
        this.subscriber = srTrapSubscriber;
        this.available = true;
        this.start();
    }

    public void setAvailable(boolean bl) {
        SrHandleThread srHandleThread = this;
        synchronized (srHandleThread) {
            this.available = bl;
        }
    }

    public boolean isAvailable() {
        boolean bl;
        SrHandleThread srHandleThread = this;
        synchronized (srHandleThread) {
            bl = this.available;
        }
        return bl;
    }

    public void run() {
        while (true) {
            SrHandleThread srHandleThread = this;
            synchronized (srHandleThread) {
                try {
                    if (this.data == null) {
                        this.wait();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            try {
                this.handleTrap(this.data, this.handlers);
                this.handleWaitList();
            }
            catch (Throwable throwable) {
                UcDDL.logErrorMessage((String)"HandleTrap: Error/Exception");
            }
            SrHandleThread srHandleThread2 = this;
            synchronized (srHandleThread2) {
                this.data = null;
                this.handlers = null;
                this.available = true;
            }
        }
    }

    public void handle(SrTrapData srTrapData, Vector vector) {
        SrHandleThread srHandleThread = this;
        synchronized (srHandleThread) {
            this.data = srTrapData;
            this.handlers = vector;
            this.available = false;
            this.notify();
        }
    }

    private void handleWaitList() {
        if (!this.dispatcher.hasWaitTraps()) {
            return;
        }
        SrTrapData srTrapData;
        while ((srTrapData = this.dispatcher.getNextWaitTrap()) != null) {
            Vector vector = this.subscriber.getHandlers(srTrapData.getType());
            if (vector == null) continue;
            this.handleTrap(srTrapData, vector);
        }
        return;
    }

    public void dump() {
        UcDDL.logDebugMessage((String)("handlerThread: avail=" + this.available));
    }

    private void handleTrap(SrTrapData srTrapData, Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            SrTrapHandlerInterface srTrapHandlerInterface = (SrTrapHandlerInterface)vector.elementAt(n);
            srTrapHandlerInterface.handleTrap(srTrapData);
            ++n;
        }
        this.dispatcher.trapHandled(srTrapData);
    }
}

