/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.receptors.rmi;

import com.sun.symon.base.security.SySecurity;
import com.sun.symon.base.server.common.ScSecurityCredential;
import com.sun.symon.base.server.receptors.SrReceptor;
import com.sun.symon.base.server.receptors.SrSessionByHandle;
import com.sun.symon.base.server.receptors.rmi.RMILoginException;
import com.sun.symon.base.server.receptors.rmi.RMIResponseInterface;
import com.sun.symon.base.server.receptors.rmi.RMISecurityException;
import com.sun.symon.base.server.receptors.rmi.RMIServerSession;
import com.sun.symon.base.server.receptors.rmi.SrRMIReceptor;
import com.sun.symon.base.server.receptors.rmi.SrRMISecurity;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.server.types.StString;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcPeriodicException;
import com.sun.symon.base.utility.UcTickerTimer;
import com.sun.symon.base.utility.UcTickerTimerResponse;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.rmi.RemoteException;

public class SrRMISession
extends RMIServerSession {
    protected SrRMIReceptor Receptor;
    private RMIResponseInterface Resp;
    private ScSecurityCredential UserTicket;
    private SrSessionByHandle session;
    private SrRMISecurity Security;
    private String UserId;
    private UcTickerTimer Ticker;
    private boolean waitMode = false;
    protected String alternateHost = null;

    SrRMISession(SySecurity sySecurity, SrRMIReceptor srRMIReceptor, RMIResponseInterface rMIResponseInterface, SrRMISecurity srRMISecurity, String string) throws RemoteException {
        super(sySecurity, string);
        this.init(srRMIReceptor, rMIResponseInterface, srRMISecurity);
    }

    SrRMISession(SySecurity sySecurity, SrRMIReceptor srRMIReceptor, RMIResponseInterface rMIResponseInterface, SrRMISecurity srRMISecurity, String string, String string2) throws RemoteException {
        super(sySecurity, string, string2);
        this.alternateHost = string2;
        this.init(srRMIReceptor, rMIResponseInterface, srRMISecurity);
    }

    public void init(SrRMIReceptor srRMIReceptor, RMIResponseInterface rMIResponseInterface, SrRMISecurity srRMISecurity) {
        this.Receptor = srRMIReceptor;
        this.Resp = rMIResponseInterface;
        this.UserTicket = null;
        this.session = new Session(srRMIReceptor);
        this.Security = srRMISecurity;
        this.UserId = null;
        try {
            this.Ticker = new UcTickerTimer(60L, new UcTickerTimerResponse(){
                Pinger clientPingerThread;

                public void processTick() {
                    if (this.clientPingerThread == null || this.clientPingerThread.isDone()) {
                        this.clientPingerThread = new Pinger(SrRMISession.this.Resp, SrRMISession.this.session);
                        this.clientPingerThread.start();
                    }
                }

                public void processTickEnd() {
                }
            });
            UcDDL.logDebugMessage((String)"SrRMISession - pinger thread created");
        }
        catch (UcPeriodicException ucPeriodicException) {
            // empty catch block
        }
        if (this.Ticker.start()) {
            UcDDL.logDebugMessage((String)"Client pinger started");
        }
    }

    protected void clientDied() {
        RMISecurityException rMISecurityException = new RMISecurityException(2);
        this.setSecurityException(rMISecurityException);
        this.Ticker.stop();
        this.Receptor.clientDied();
    }

    protected synchronized void doAuthenticate(String string, String string2) throws RMILoginException {
        UcDDL.logDebugMessage((String)("authenticate user " + string));
        if (this.session.isDead()) {
            throw new RMILoginException(3);
        }
        this.UserTicket = this.Security.getCredentials(string, string2);
        this.UserId = string;
    }

    protected ScSecurityCredential getUserSecurityCredential() {
        return this.UserTicket;
    }

    protected void doDeleteRequest(String string) throws RMISecurityException {
        this.session.requestDeleteByHandle(string);
    }

    protected void doNewRequest(int n, String[] stringArray, StObject[][] stObjectArray, String string, String string2) throws RMISecurityException {
        if (stringArray != null && stringArray.length == 1 && stringArray[0] != null && stringArray[0].equals("exit://clientIsExiting/") && stObjectArray != null && stObjectArray.length == 1 && stObjectArray[0].length == 1 && stObjectArray[0][0] != null && stObjectArray[0][0].toString().equals("goodbye")) {
            UcDDL.logInfoMessage((String)"Received disconnect signal from a client");
            this.session.died(new Exception("Client is disconnecting"));
        } else if (stringArray != null && stringArray.length == 1 && stringArray[0] != null && stringArray[0].startsWith("getIPAddress://")) {
            String string3 = stringArray[0].substring(15);
            UcDDL.logInfoMessage((String)("getIPAddress for " + string3));
            try {
                String string4 = InetAddress.getByName(string3).getHostAddress();
                StObject[][] stObjectArray2 = new StObject[1][1];
                StString stString = new StString(string4);
                stObjectArray2[0][0] = stString;
                this.handleResponse(string2, stObjectArray2);
            }
            catch (Exception exception) {
                UcDDL.logWarningMessage((String)("Unable to get IP Address for " + string3));
                this.handleResponse(string2, stringArray[0], exception);
            }
        } else {
            this.session.requestCreateByHandle(string2, n, stringArray, stObjectArray, string).emit();
        }
    }

    protected String doGetURL(int n) {
        String string;
        switch (n) {
            case 0: {
                string = this.Receptor.getConfigurationBaseURL();
                break;
            }
            case 1: {
                string = this.Receptor.getEventBaseURL();
                break;
            }
            case 2: {
                string = this.Receptor.getTopologyBaseURL();
                break;
            }
            case 3: {
                string = this.Receptor.getESDIR();
                break;
            }
            case 4: {
                string = this.Receptor.getImageSubpath();
                break;
            }
            case 5: {
                string = this.Receptor.getMDRBaseURL();
                break;
            }
            case 6: {
                string = this.Receptor.getCSTBaseURL();
                break;
            }
            default: {
                UcDDL.logErrorMessage((String)("invalid urlType: " + n));
                string = null;
            }
        }
        return string;
    }

    private void handleResponse(String string, StObject[][] stObjectArray) {
        block3: {
            try {
                boolean bl = this.respond(this.Resp, string, stObjectArray);
                if (!bl) {
                    this.session.requestDeleteByHandle(string);
                }
                this.waitMode = false;
            }
            catch (RemoteException remoteException) {
                if (this.waitMode) break block3;
                UcDDL.logWarningMessage((String)("Client callback failed: " + remoteException));
                this.waitMode = true;
            }
        }
    }

    private void handleResponse(String string, String string2, Exception exception) {
        block3: {
            try {
                boolean bl = this.respond(this.Resp, string, string2, exception);
                if (!bl) {
                    this.session.requestDeleteByHandle(string);
                }
                this.waitMode = false;
            }
            catch (RemoteException remoteException) {
                if (this.waitMode) break block3;
                UcDDL.logWarningMessage((String)("Client callback failed: " + remoteException));
                this.waitMode = true;
            }
        }
    }

    private class Pinger
    extends Thread {
        RMIResponseInterface response;
        SrSessionByHandle session;
        boolean flag;

        Pinger(RMIResponseInterface rMIResponseInterface, SrSessionByHandle srSessionByHandle) {
            this.response = rMIResponseInterface;
            this.session = srSessionByHandle;
            this.flag = false;
        }

        public boolean isDone() {
            return this.flag;
        }

        public void run() {
            try {
                this.response.ping();
                ((Session)this.session).resetCounter();
            }
            catch (RemoteException remoteException) {
                UcDDL.logWarningMessage((String)("Client ping failed: " + remoteException));
                ((Session)this.session).handleRemoteException(remoteException);
            }
            this.flag = true;
        }
    }

    private class Session
    extends SrSessionByHandle {
        private int retries = 0;
        private int MAX_RETRIES = 5;

        Session(SrReceptor srReceptor) {
            super(srReceptor);
        }

        protected ScSecurityCredential getUserTicket() {
            return SrRMISession.this.UserTicket;
        }

        protected void requestResponse(String string, StObject[][] stObjectArray) {
            SrRMISession.this.handleResponse(string, stObjectArray);
        }

        protected void dump(PrintWriter printWriter) {
            printWriter.println("  user=" + SrRMISession.this.UserId);
            super.dump(printWriter);
        }

        protected void requestResponse(String string, String string2, Exception exception) {
            SrRMISession.this.handleResponse(string, string2, exception);
        }

        public boolean died(Exception exception) {
            boolean bl = super.died(exception);
            if (bl) {
                SrRMISession.this.clientDied();
            }
            return bl;
        }

        public void handleRemoteException(Exception exception) {
            ++this.retries;
            UcDDL.logWarningMessage((String)("Client ping failed. Attempt " + this.retries + " of " + this.MAX_RETRIES));
            if (this.retries >= this.MAX_RETRIES) {
                this.died(exception);
            }
        }

        public void resetCounter() {
            this.retries = 0;
        }
    }
}

