/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.receptors.rmi;

import com.sun.symon.base.security.SyCoderInterface;
import com.sun.symon.base.security.SySecurityException;
import com.sun.symon.base.utility.UcDDL;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.rmi.RemoteException;

class RMIDataDecomposer {
    private ByteArrayInputStream bs;
    private OurObjectInputStream is;

    RMIDataDecomposer(byte[] byArray, SyCoderInterface syCoderInterface, boolean bl) throws RemoteException {
        try {
            byArray = syCoderInterface.decode(byArray, bl);
            this.bs = new ByteArrayInputStream(byArray);
            this.is = new OurObjectInputStream(this.bs);
        }
        catch (SySecurityException sySecurityException) {
            this.handleEx((Exception)((Object)sySecurityException));
        }
        catch (IOException iOException) {
            this.handleEx(iOException);
        }
    }

    private void handleEx(Exception exception) throws RemoteException {
        UcDDL.logErrorMessage((String)"Error decoding data", (Throwable)exception);
        throw new RemoteException(exception.getMessage());
    }

    boolean readBoolean() throws RemoteException {
        try {
            return this.is.readBoolean();
        }
        catch (IOException iOException) {
            this.handleEx(iOException);
            return false;
        }
    }

    int readInt() throws RemoteException {
        try {
            return this.is.readInt();
        }
        catch (IOException iOException) {
            this.handleEx(iOException);
            return 0;
        }
    }

    Object readObject() throws RemoteException {
        try {
            return this.is.readObject();
        }
        catch (OptionalDataException optionalDataException) {
            this.handleEx(optionalDataException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.handleEx(classNotFoundException);
        }
        catch (IOException iOException) {
            this.handleEx(iOException);
        }
        return null;
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        return this.is.defaultResolveClass(objectStreamClass);
    }

    class OurObjectInputStream
    extends ObjectInputStream {
        public OurObjectInputStream(InputStream inputStream) throws IOException, StreamCorruptedException {
            super(inputStream);
        }

        protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            return RMIDataDecomposer.this.resolveClass(objectStreamClass);
        }

        Class defaultResolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            return super.resolveClass(objectStreamClass);
        }
    }
}

