/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.lookup;

import com.sun.symon.base.utility.UcDDL;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.NoSuchObjectException;
import java.rmi.server.RemoteObject;
import java.util.Hashtable;

public class SlRMIRegistry
implements Runnable {
    Hashtable registry;
    private String rmiHost;
    private int rmiPort;

    public SlRMIRegistry(int n) {
        try {
            this.rmiHost = InetAddress.getLocalHost().getHostName();
            this.init(n);
        }
        catch (UnknownHostException unknownHostException) {
            UcDDL.logErrorMessage((String)("RMIRegistry:Got exception: " + unknownHostException.getMessage()));
        }
    }

    public SlRMIRegistry(String string, int n) {
        this.rmiHost = string;
        this.init(n);
    }

    public void init(int n) {
        this.registry = new Hashtable();
        this.rmiPort = n;
        Thread thread = new Thread(this);
        thread.start();
    }

    public void bind(String string, RemoteObject remoteObject) {
        this.registry.put(string, remoteObject);
    }

    public void run() {
        try {
            InetAddress inetAddress = InetAddress.getByName(this.rmiHost);
            ServerSocket serverSocket = new ServerSocket(this.rmiPort, 0, inetAddress);
            UcDDL.logInfoMessage((String)("RMIRegistry: Created server socket at port " + this.rmiPort + " and at IP " + inetAddress));
            UcDDL.logInfoMessage((String)"RMIRegistry: Listening to clients....");
            while (true) {
                Socket socket = serverSocket.accept();
                try {
                    UcDDL.logInfoMessage((String)"RMIRegistry: Got a socket connection request from the client");
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
                    ObjectInputStream objectInputStream = new ObjectInputStream(socket.getInputStream());
                    Object object = objectInputStream.readObject();
                    if (object instanceof String) {
                        UcDDL.logInfoMessage((String)("RMIRegistry: Got " + object.toString() + " from the client"));
                        RemoteObject remoteObject = (RemoteObject)this.registry.get(object.toString());
                        if (remoteObject == null) {
                            ClassNotFoundException classNotFoundException = new ClassNotFoundException("class not found in the registry");
                            objectOutputStream.writeObject(classNotFoundException);
                            continue;
                        }
                        objectOutputStream.writeObject(RemoteObject.toStub(remoteObject));
                        continue;
                    }
                    UcDDL.logErrorMessage((String)"RMIRegistry : Got incorrect handshake from client");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    UcDDL.logErrorMessage((String)"RMIRegistry: Class not found.");
                }
                catch (Throwable throwable) {
                    UcDDL.logErrorMessage((String)"RMIRegistry: Got throwable exception");
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            UcDDL.logErrorMessage((String)("RMIRegistry: Got exception: " + unknownHostException.getMessage()));
        }
        catch (NoSuchObjectException noSuchObjectException) {
            UcDDL.logErrorMessage((String)"RMIRegistry: Remote object not found in the registry");
        }
        catch (IOException iOException) {
            UcDDL.logErrorMessage((String)("RMIRegisry: Got exception: " + iOException.getMessage()));
        }
    }
}

