/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.emitters.snmp;

import com.sun.symon.base.server.common.ScRequestSinkInterface;
import com.sun.symon.base.server.emitters.snmp.Resolver;
import com.sun.symon.base.server.emitters.snmp.SeSnmpException;
import com.sun.symon.base.server.emitters.snmp.SeSnmpRequestor;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;

public class SeSnmpFinder {
    private String finderOid;
    private SeSnmpRequestor snmpRequestor;
    private Hashtable cacheSubpathWithShadow;
    private Hashtable cacheSubpathWithoutShadow;
    private Hashtable cacheShadow;
    private Hashtable cacheFragmentTypes;

    public SeSnmpFinder(String string, long l, int n, SeSnmpRequestor seSnmpRequestor) {
        this.finderOid = string;
        this.snmpRequestor = seSnmpRequestor;
        this.cacheSubpathWithShadow = new Hashtable();
        this.cacheSubpathWithoutShadow = new Hashtable();
        this.cacheShadow = new Hashtable();
        this.cacheFragmentTypes = new Hashtable();
    }

    public ScRequestSinkInterface resolveUrlList(String[] stringArray, int n, int n2, ResultCallback resultCallback) throws SeSnmpException {
        return new Resolver(this, stringArray, n, n2, resultCallback);
    }

    public SeSnmpRequestor getSnmpRequestor() {
        return this.snmpRequestor;
    }

    public String getFinderOid() {
        return this.finderOid;
    }

    public void cacheSubpathAdd(String string, boolean bl, String string2) {
        if (bl) {
            this.cacheSubpathWithShadow.put(string, string2);
        } else {
            this.cacheSubpathWithoutShadow.put(string, string2);
        }
    }

    public void cacheShadowAdd(String string, String string2) {
        this.cacheShadow.put(string, string2);
    }

    public void cacheFragmentTypesAdd(String string, int[] nArray) {
        this.cacheFragmentTypes.put(string, nArray);
    }

    public String cacheSubpathGet(String string, boolean bl) {
        if (bl) {
            return (String)this.cacheSubpathWithShadow.get(string);
        }
        return (String)this.cacheSubpathWithoutShadow.get(string);
    }

    public String cacheShadowGet(String string) {
        return (String)this.cacheShadow.get(string);
    }

    public int[] cacheFragmentTypesGet(String string) {
        return (int[])this.cacheFragmentTypes.get(string);
    }

    public void dumpCaches(PrintWriter printWriter) {
        printWriter.println(this.dumpCaches());
    }

    public String dumpCaches() {
        String string = "*** Subpath Cache with Shadow ***\n";
        Enumeration enumeration = this.cacheSubpathWithShadow.keys();
        Enumeration enumeration2 = this.cacheSubpathWithShadow.elements();
        while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
            string = string + enumeration.nextElement() + " " + enumeration2.nextElement() + "\n";
        }
        string = string + "\n*** Subpath Cache without Shadow ***\n";
        enumeration = this.cacheSubpathWithoutShadow.keys();
        enumeration2 = this.cacheSubpathWithoutShadow.elements();
        while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
            string = string + enumeration.nextElement() + " " + enumeration2.nextElement() + "\n";
        }
        string = string + "\n*** Shadow Oid Cache ***\n";
        enumeration = this.cacheShadow.keys();
        enumeration2 = this.cacheShadow.elements();
        while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
            string = string + enumeration.nextElement() + " " + enumeration2.nextElement() + "\n";
        }
        return string;
    }

    public void wipeCaches() {
        String string;
        Enumeration enumeration = this.cacheSubpathWithShadow.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            this.cacheSubpathWithShadow.remove(string);
        }
        enumeration = this.cacheSubpathWithoutShadow.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            this.cacheSubpathWithoutShadow.remove(string);
        }
        enumeration = this.cacheShadow.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            this.cacheShadow.remove(string);
        }
        enumeration = this.cacheFragmentTypes.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            this.cacheFragmentTypes.remove(string);
        }
    }

    public void clearHostOidsFromCache(String string) {
        String string2;
        Enumeration enumeration = this.cacheSubpathWithShadow.keys();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            this.cacheSubpathWithShadow.remove(string2);
        }
        enumeration = this.cacheSubpathWithoutShadow.keys();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            this.cacheSubpathWithoutShadow.remove(string2);
        }
    }

    public static interface ResultCallback {
        public void handleResult(InetAddress var1, int var2, String var3, String[] var4, String[] var5);

        public void handleException(SeSnmpException var1);
    }
}

