/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.common;

import com.sun.symon.base.server.common.ScRequestConnector;
import com.sun.symon.base.server.common.ScRequestConnectorInterface;
import com.sun.symon.base.server.common.ScRequestDispatchException;
import com.sun.symon.base.server.common.ScRequestSink;
import com.sun.symon.base.server.common.ScRequestSinkInterface;
import com.sun.symon.base.server.common.ScRequestSource;
import com.sun.symon.base.server.common.ScRequestSourceInterface;
import com.sun.symon.base.server.common.ScResponseException;
import com.sun.symon.base.server.events.SvRequestDispatcher;
import com.sun.symon.base.server.events.SvRequestEvent;
import com.sun.symon.base.server.types.StObject;
import java.util.Vector;

public abstract class ScRequestSplitterSink
extends ScRequestSink {
    private ScRequestSource[] Children;
    private StObject[][][] ChildResponses;
    private int ResponseCnt;
    private boolean GotException;

    private void childResponse(int n, StObject[][] stObjectArray) {
        boolean bl = false;
        StObject[][] stObjectArray2 = null;
        ScRequestSplitterSink scRequestSplitterSink = this;
        synchronized (scRequestSplitterSink) {
            if (!this.GotException) {
                this.ChildResponses[n] = stObjectArray;
                ++this.ResponseCnt;
                if (this.ResponseCnt == this.ChildResponses.length) {
                    stObjectArray2 = this.joinResponseData(this.ChildResponses);
                    this.clearResponses();
                    bl = true;
                }
            }
        }
        if (bl) {
            this.respond(stObjectArray2);
        }
    }

    private void childResponse(int n, String string, ScResponseException scResponseException) {
        boolean bl;
        ScRequestSplitterSink scRequestSplitterSink = this;
        synchronized (scRequestSplitterSink) {
            bl = this.GotException;
            if (!bl) {
                this.GotException = true;
                this.clearResponses();
            }
        }
        if (!bl) {
            this.respond(string, scResponseException);
        }
    }

    public ScRequestConnectorInterface createConnector(int n) {
        return new Connector(n);
    }

    public boolean dispatch(SvRequestDispatcher svRequestDispatcher, SvRequestEvent svRequestEvent) throws ScRequestDispatchException {
        Vector vector = this.splitEvent(svRequestEvent);
        int n = vector.size();
        this.Children = new ScRequestSource[n];
        this.ChildResponses = new StObject[n][][];
        this.ResponseCnt = 0;
        int n2 = 0;
        while (n2 < n) {
            SvRequestEvent svRequestEvent2 = (SvRequestEvent)vector.elementAt(n2);
            try {
                this.Children[n2] = (ScRequestSource)ScRequestConnector.dispatch(svRequestDispatcher, svRequestEvent2);
                if (this.Children[n2] == null) {
                    int n3 = 0;
                    while (n3 < n2) {
                        this.Children[n3].delete();
                        ++n3;
                    }
                    return false;
                }
            }
            catch (ScRequestDispatchException scRequestDispatchException) {
                ScRequestDispatchException scRequestDispatchException2;
                if (scRequestDispatchException.getUrl() == null) {
                    String[] stringArray = svRequestEvent2.getURL();
                    String string = stringArray == null || stringArray.length == 0 ? null : stringArray[0];
                    scRequestDispatchException2 = new ScRequestDispatchException(scRequestDispatchException.getMessage(), string);
                }
                throw scRequestDispatchException2;
            }
            ++n2;
        }
        return true;
    }

    protected void doDelete() {
        int n = this.Children.length;
        int n2 = 0;
        while (n2 < n) {
            ScRequestSource scRequestSource = this.Children[n2];
            scRequestSource.delete();
            ++n2;
        }
    }

    protected void doEmit() {
        ScRequestSplitterSink scRequestSplitterSink = this;
        synchronized (scRequestSplitterSink) {
            this.GotException = false;
            this.clearResponses();
        }
        int n = this.Children.length;
        int n2 = 0;
        while (n2 < n) {
            this.Children[n2].emit();
            ++n2;
        }
    }

    private synchronized void clearResponses() {
        int n = this.Children.length;
        int n2 = 0;
        while (n2 < n) {
            this.ChildResponses[n2] = null;
            ++n2;
        }
        this.ResponseCnt = 0;
    }

    public String[][] getCacheKeys() {
        int n = this.Children.length;
        String[][][] stringArray = new String[n][][];
        int n2 = 0;
        while (n2 < n) {
            ScRequestSource scRequestSource = this.Children[n2];
            stringArray[n2] = scRequestSource.getCacheKeys();
            ++n2;
        }
        return this.joinCacheKeys(stringArray);
    }

    protected abstract String[][] joinCacheKeys(String[][][] var1);

    protected abstract StObject[][] joinResponseData(StObject[][][] var1);

    protected abstract Vector splitEvent(SvRequestEvent var1);

    private class Child
    extends ScRequestSource {
        private int index;

        Child(ScRequestSinkInterface scRequestSinkInterface, int n) {
            super(scRequestSinkInterface);
            this.index = n;
        }

        public void respond(StObject[][] stObjectArray) {
            ScRequestSplitterSink.this.childResponse(this.index, stObjectArray);
        }

        public void respond(String string, ScResponseException scResponseException) {
            ScRequestSplitterSink.this.childResponse(this.index, string, scResponseException);
        }
    }

    private class Connector
    extends ScRequestConnector {
        private int index;

        Connector(int n) {
            this.index = n;
        }

        public ScRequestSourceInterface doConnect(ScRequestSinkInterface scRequestSinkInterface) {
            return new Child(scRequestSinkInterface, this.index);
        }
    }
}

