/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.framework;

import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMSecurityException;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.common.MSSecurity;
import com.sun.symon.base.mgmtservice.framework.MSBaseFactory;
import com.sun.symon.base.mgmtservice.framework.MSBaseServiceInterface;
import com.sun.symon.base.server.common.ScSecurityCredential;
import com.sun.symon.base.server.lookup.SlRMIClientSocket;
import com.sun.symon.base.server.lookup.SlRMIServerSocket;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.server.Unreferenced;
import java.util.Hashtable;
import java.util.Locale;

public class MSBaseService
extends UnicastRemoteObject
implements MSBaseServiceInterface,
Unreferenced {
    private String serviceName;
    private Locale locale = null;
    private String userSession = null;
    private ScSecurityCredential securityCredential = null;
    private static MSSecurity scService;
    private static MSLogPrintWriter errorWriter;
    private static Hashtable clientSocketFactory;
    private static Hashtable serverSocketFactory;

    public MSBaseService(String string, ScSecurityCredential scSecurityCredential) throws RemoteException {
        this.init(string, scSecurityCredential);
    }

    public MSBaseService(String string, ScSecurityCredential scSecurityCredential, String string2) throws RemoteException {
        super(0, MSBaseService.getClientSocketFactory(string2), MSBaseService.getServerSocketFactory(string2));
        this.init(string, scSecurityCredential);
    }

    private static SlRMIClientSocket getClientSocketFactory(String string) {
        SlRMIClientSocket slRMIClientSocket = (SlRMIClientSocket)clientSocketFactory.get(string);
        if (slRMIClientSocket != null) {
            return slRMIClientSocket;
        }
        slRMIClientSocket = new SlRMIClientSocket(string);
        clientSocketFactory.put(string, slRMIClientSocket);
        return slRMIClientSocket;
    }

    private static SlRMIServerSocket getServerSocketFactory(String string) {
        SlRMIServerSocket slRMIServerSocket = (SlRMIServerSocket)serverSocketFactory.get(string);
        if (slRMIServerSocket != null) {
            return slRMIServerSocket;
        }
        slRMIServerSocket = new SlRMIServerSocket(string);
        serverSocketFactory.put(string, slRMIServerSocket);
        return slRMIServerSocket;
    }

    public void init(String string, ScSecurityCredential scSecurityCredential) {
        this.serviceName = string;
        this.userSession = null;
        this.securityCredential = scSecurityCredential;
    }

    public void setLocale(Locale locale) throws RemoteException {
        this.locale = locale;
    }

    public Locale getLocale() throws RemoteException {
        return this.locale;
    }

    public void close() throws RemoteException {
        this.closeService();
    }

    public void unreferenced() {
        MSBaseFactory.removeService(this);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public ScSecurityCredential getUserSecurityCredential() {
        return this.securityCredential;
    }

    public String getUserSession() {
        return this.userSession;
    }

    public void setUserSecurityCredential(ScSecurityCredential scSecurityCredential) {
        this.securityCredential = scSecurityCredential;
    }

    public void setUserSession(String string) {
        this.userSession = string;
    }

    protected void checkAccess(String string) throws SMSecurityException {
        this.checkAccess(string, null);
    }

    protected void checkAccess(String string, SMDBObjectID sMDBObjectID) throws SMSecurityException {
        try {
            if (sMDBObjectID == null) {
                scService.checkAccess(this.serviceName, string, this.securityCredential);
            } else {
                scService.checkAccess(this.serviceName, string, this.securityCredential, sMDBObjectID);
            }
        }
        catch (SMSecurityException sMSecurityException) {
            errorWriter.println("User " + this.securityCredential.getUser() + " does not have priviliges to execute " + string);
            throw sMSecurityException;
        }
    }

    public void cleanup() {
    }

    public void closeService() {
        MSBaseFactory.removeService(this);
    }

    static {
        clientSocketFactory = new Hashtable();
        serverSocketFactory = new Hashtable();
        errorWriter = MSLogPrintWriter.getErrorWriter();
        try {
            scService = MSSecurity.getInstance();
        }
        catch (SMSecurityException sMSecurityException) {
            errorWriter.println("Security service is not available.\nExiting...");
            System.exit(1);
        }
    }
}

