/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.main;

import com.sun.symon.base.bootstrap.BsRMIBootstrap;
import com.sun.symon.base.bootstrap.BsRMIBootstrapException;
import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMResourceAccess;
import com.sun.symon.base.console.main.ConsoleLoginController;
import com.sun.symon.base.console.main.ConsoleLoginPanel;
import com.sun.symon.base.console.main.ConsoleVersion;
import com.sun.symon.base.console.main.SymonConsoleLoginPanel;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcDialog;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.Cursor;
import java.util.StringTokenizer;
import javax.swing.text.JTextComponent;

public class ConsoleLoginRunner
extends Thread {
    protected BsRMIBootstrap Bootstrap;
    protected SMRawDataRequest rawHandle;
    protected String baseXFile;
    protected ConsoleLoginController LoginController;
    static final String consolePkg = "base.console.main.ConsoleLogin:";

    public ConsoleLoginRunner(ConsoleLoginController consoleLoginController) {
        super("console-runner");
        this.LoginController = consoleLoginController;
        this.Bootstrap = consoleLoginController.getBootstrap();
        this.baseXFile = consoleLoginController.getBaseXFile();
    }

    public void run() {
        try {
            String string = this.LoginController.getPassword();
            String string2 = string.length() > 8 ? string.substring(0, 8) : string;
            this.Bootstrap.authenticate(this.LoginController.getLoginID(), string2, this.LoginController.getPublicKey(), this.LoginController.getSecurityScheme(), this.LoginController.getEncryption());
        }
        catch (BsRMIBootstrapException bsRMIBootstrapException) {
            if (this.LoginController.isAutomaticLogin()) {
                System.err.println(this.LoginController.getLoginStatusMessage((Exception)((Object)bsRMIBootstrapException)));
                System.exit(1);
            } else {
                ConsoleLoginPanel.showInvalidInfoDialog(this.LoginController.getLoginStatusMessage((Exception)((Object)bsRMIBootstrapException)));
                ((SymonConsoleLoginPanel)this.LoginController).enableButtons(true);
            }
            return;
        }
        if (!this.LoginController.isAutomaticLogin()) {
            ((SymonConsoleLoginPanel)this.LoginController).statusMesg.setText(UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:loginok", (boolean)true));
            ((SymonConsoleLoginPanel)this.LoginController).statusBox.validate();
            ((SymonConsoleLoginPanel)this.LoginController).frame.repaint();
            ((JTextComponent)((SymonConsoleLoginPanel)this.LoginController).passwordField).setText("");
            ((SymonConsoleLoginPanel)this.LoginController).frame.repaint();
        }
        this.rawHandle = new SMRawDataRequest(this.Bootstrap.getServerConn());
        UcDDL.logInfoMessage((String)("Sun Management Center Console " + ConsoleVersion.getVersion("desc")));
        ConsoleLoginRunner.checkVersion(this.rawHandle);
        this.baseXFile = ConsoleLoginRunner.getBaseXFile(this.rawHandle);
        ConsoleLoginRunner.checkLicense(this.rawHandle);
        try {
            this.Bootstrap.launch(this.baseXFile);
            if (!this.LoginController.isAutomaticLogin()) {
                ((SymonConsoleLoginPanel)this.LoginController).loadComplete();
            }
        }
        catch (BsRMIBootstrapException bsRMIBootstrapException) {
            if (!this.LoginController.isAutomaticLogin()) {
                ((SymonConsoleLoginPanel)this.LoginController).handleBootException(bsRMIBootstrapException);
                ((SymonConsoleLoginPanel)this.LoginController).loginButt.setEnabled(true);
                ConsoleLoginPanel.showInvalidInfoDialog(this.LoginController.getLoginStatusMessage((Exception)((Object)bsRMIBootstrapException)));
            }
            System.err.println(this.LoginController.getLoginStatusMessage((Exception)((Object)bsRMIBootstrapException)));
            System.exit(1);
        }
        if (!this.LoginController.isAutomaticLogin()) {
            ((SymonConsoleLoginPanel)this.LoginController).frame.setCursor(Cursor.getPredefinedCursor(0));
            ((SymonConsoleLoginPanel)this.LoginController).frame.getToolkit().sync();
            ((SymonConsoleLoginPanel)this.LoginController).frame.setCursor(Cursor.getPredefinedCursor(0));
            ((SymonConsoleLoginPanel)this.LoginController).frame.getToolkit().sync();
        }
    }

    public static void checkLicense(SMRawDataRequest sMRawDataRequest) {
        int n = 0;
        String string = null;
        String string2 = sMRawDataRequest.getServerVersion("revision");
        if (!string2.startsWith("2_0_00")) {
            SMResourceAccess sMResourceAccess = new SMResourceAccess(sMRawDataRequest);
            boolean bl = false;
            if (bl) {
                try {
                    n = sMRawDataRequest.getModuleLicense();
                    if (n == 1) {
                        string = UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:licenseMissing", (boolean)true) + "\n" + UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:licenseRequired", (boolean)true);
                    } else if (n == 2) {
                        string = UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:licenseExpired", (boolean)true) + "\n" + UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:licenseRequired", (boolean)true);
                    }
                }
                catch (SMAPIException sMAPIException) {
                    string = UcInternationalizer.translateKey((String)"base.console.main.ConsoleLogin:licenseError", (boolean)true);
                }
            }
            if (string != null) {
                ConsoleLoginPanel.showInvalidInfoDialog(string);
            }
        }
    }

    public static String getBaseXFile(SMRawDataRequest sMRawDataRequest) {
        String string = null;
        sMRawDataRequest.versionCheck(ConsoleVersion.getVersion("overall"));
        String string2 = ConsoleVersion.getVersion("revision");
        String string3 = sMRawDataRequest.getServerVersion("revision");
        if (string3 != null && !string3.equals("2_0_00_00") && !string2.equals(string3)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "_");
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "_");
            if (stringTokenizer.countTokens() == stringTokenizer2.countTokens()) {
                while (stringTokenizer.hasMoreTokens() || stringTokenizer2.hasMoreTokens()) {
                    String string4;
                    String string5 = stringTokenizer.nextToken();
                    if (string5.compareTo(string4 = stringTokenizer2.nextToken()) < 0) {
                        string = "base-console_" + string2 + ".x";
                    } else {
                        if (string5.compareTo(string4) <= 0) continue;
                        string = "base-console_" + string3 + ".x";
                    }
                    break;
                }
            }
        } else if (string2.equals(string3)) {
            string = "base-console_" + string3 + ".x";
        }
        return string;
    }

    private static void checkVersion(SMRawDataRequest sMRawDataRequest) {
        String string;
        String string2 = ConsoleVersion.getVersion("overall");
        if (!string2.equals(string = sMRawDataRequest.getServerVersion("overall"))) {
            UcDialog.showOk((String)(UcInternationalizer.translateKey((String)("base.console.main.ConsoleLogin:versionMismatch.server(" + string + ")")) + "\n" + UcInternationalizer.translateKey((String)("base.console.main.ConsoleLogin:versionMismatch.console(" + string2 + ")"))));
            sMRawDataRequest.disconnect();
            System.exit(0);
        }
    }
}

