/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.grouping.table;

import com.sun.symon.base.console.grouping.CgUtility;
import com.sun.symon.base.console.grouping.table.CgCancelRowSaveEvent;
import com.sun.symon.base.console.grouping.table.CgCancelRowSaveListener;
import com.sun.symon.base.console.grouping.table.CgComboBox;
import com.sun.symon.base.console.grouping.table.CgData;
import com.sun.symon.base.console.grouping.table.CgRowSaveEvent;
import com.sun.symon.base.console.grouping.table.CgRowSaveListener;
import com.sun.symon.base.console.grouping.table.CgTblModel;
import com.sun.symon.base.console.grouping.table.CgTblSelectEvent;
import com.sun.symon.base.console.grouping.table.CgTblSelectListener;
import com.sun.symon.base.console.grouping.table.CgTblUpdateEvent;
import com.sun.symon.base.console.grouping.table.CgTblUpdateListener;
import com.sun.symon.base.console.views.table.CvBaseTable;
import com.sun.symon.base.utility.UcCommon;
import com.sun.symon.base.utility.UcDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class CgTable
extends CvBaseTable {
    boolean isEditable = true;
    boolean updated = false;
    boolean customUpdated = false;
    Vector oldRowValue;
    Vector lastRowData = new Vector();
    int previousSelectRow = -1;
    int workingRow = -1;
    int rowForInput = -1;
    int columnForInput = -1;
    Object editingCellValue = null;
    boolean noNewRow = false;
    int preEditingRow = -1;
    int preEditingColumn = -1;
    private boolean confirmRow = true;
    static Color TBL_BACKGROUND = Color.white;
    Vector saveListener = new Vector();
    Vector cancelListener = new Vector();
    Vector selectListeners = new Vector();
    Vector updateListeners = new Vector();

    public CgTable() {
        this(null, false);
    }

    public CgTable(TableModel tableModel) {
        this(tableModel, false);
    }

    public CgTable(TableModel tableModel, boolean bl) {
        super(tableModel, false);
        Object object;
        CgTblCellRender cgTblCellRender = new CgTblCellRender();
        HeaderRenderer headerRenderer = new HeaderRenderer();
        int n = 0;
        while (n < this.getColumnCount()) {
            object = this.getColumnModel().getColumn(n);
            ((TableColumn)object).setHeaderRenderer(headerRenderer);
            ((TableColumn)object).setCellRenderer(cgTblCellRender);
            int n2 = this.columnHeaderWidth((TableColumn)object, n == 0);
            ((TableColumn)object).setPreferredWidth(n2);
            ++n;
        }
        this.setColumnSelectionAllowed(false);
        object = this.getSelectionModel();
        object.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                CgTable.this.fireTblSelect(listSelectionEvent);
            }
        });
    }

    void fireTblSelect(ListSelectionEvent listSelectionEvent) {
        if (this.getSelectedRowCount() == 0) {
            CgTblSelectEvent cgTblSelectEvent = new CgTblSelectEvent(this, CgTblSelectEvent.DESELECT, -1);
            int n = 0;
            while (n < this.selectListeners.size()) {
                ((CgTblSelectListener)this.selectListeners.get(n)).selectionOccurred(cgTblSelectEvent);
                ++n;
            }
            this.previousSelectRow = -1;
            return;
        }
        int n = this.getSelectedRow();
        if (n == this.previousSelectRow) {
            return;
        }
        this.previousSelectRow = n;
        CgTblSelectEvent cgTblSelectEvent = new CgTblSelectEvent(this, CgTblSelectEvent.SELECT, this.getSelectedRow());
        int n2 = 0;
        while (n2 < this.selectListeners.size()) {
            ((CgTblSelectListener)this.selectListeners.get(n2)).selectionOccurred(cgTblSelectEvent);
            ++n2;
        }
    }

    public int columnHeaderWidth(TableColumn tableColumn, boolean bl) {
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        Object object = bl ? CgUtility.getI18nMsg("standard.click") : tableColumn.getHeaderValue();
        Component component = tableCellRenderer.getTableCellRendererComponent(this, object, false, false, 0, 0);
        if (bl) {
            return component.getPreferredSize().width + 30;
        }
        return component.getPreferredSize().width;
    }

    public void addCgTblUpdateListener(CgTblUpdateListener cgTblUpdateListener) {
        this.updateListeners.add(cgTblUpdateListener);
    }

    public void removeCgTblUpdateListener(CgTblUpdateListener cgTblUpdateListener) {
        this.updateListeners.remove(cgTblUpdateListener);
    }

    public void fireUpdateEvent(CgTblUpdateEvent cgTblUpdateEvent) {
        if (this.updateListeners == null) {
            return;
        }
        int n = 0;
        while (n < this.updateListeners.size()) {
            ((CgTblUpdateListener)this.updateListeners.get(n)).tblDataUpdated(cgTblUpdateEvent);
            ++n;
        }
    }

    protected ListSelectionModel createDefaultSelectionModel() {
        CgTblSelectionModel cgTblSelectionModel = new CgTblSelectionModel(this);
        return cgTblSelectionModel;
    }

    public void addCgRowSaveListener(CgRowSaveListener cgRowSaveListener) {
        this.saveListener.add(cgRowSaveListener);
    }

    public void removeCgRowSaveListener(CgRowSaveListener cgRowSaveListener) {
        this.saveListener.remove(cgRowSaveListener);
    }

    public void addCgCancelRowSaveListener(CgCancelRowSaveListener cgCancelRowSaveListener) {
        this.cancelListener.add(cgCancelRowSaveListener);
    }

    public void removeCgCancelRowSaveListener(CgCancelRowSaveListener cgCancelRowSaveListener) {
        this.cancelListener.remove(cgCancelRowSaveListener);
    }

    public void addCgTblSelectListener(CgTblSelectListener cgTblSelectListener) {
        this.selectListeners.add(cgTblSelectListener);
    }

    public void removeCgTblSelectListener(CgTblSelectListener cgTblSelectListener) {
        this.selectListeners.remove(cgTblSelectListener);
    }

    public boolean isTableUpdated() {
        boolean bl = false;
        if (this.isEditing()) {
            CgData cgData = (CgData)this.getCurrentValueAt(this.editingRow, this.editingColumn);
            String string = cgData == null ? "" : cgData.toString().trim();
            String string2 = this.editingCellValue == null || ((CgData)this.editingCellValue).isDummy() ? "" : ((CgData)this.editingCellValue).toString().trim();
            bl = string.compareTo(string2) != 0;
        }
        return this.updated || this.customUpdated || bl;
    }

    public boolean isDataUpdated() {
        return this.updated || this.customUpdated;
    }

    public void setDataUpdated(boolean bl) {
        this.customUpdated = bl;
    }

    public TableCellEditor getCellEditor(int n, int n2) {
        int n3 = this.convertColumnIndexToModel(n2);
        TableCellEditor tableCellEditor = ((CgTblModel)this.getModel()).getColumnEditor(n3);
        return tableCellEditor;
    }

    public void newCreatingRow() {
        String string;
        CgTblModel cgTblModel = (CgTblModel)this.getModel();
        if (cgTblModel.getColumnDefaultVal(0) != null) {
            string = cgTblModel.getColumnDefaultVal(0).getLabel();
            if (string.trim().equals("")) {
                string = CgUtility.getI18nMsg("standard.click");
            }
        } else {
            string = CgUtility.getI18nMsg("standard.click");
        }
        CgData cgData = new CgData(string, true);
        this.lastRowData = new Vector();
        this.lastRowData.add(cgData);
        Vector<CgData> vector = new Vector<CgData>();
        vector.add(cgData);
        int n = 1;
        while (n < this.getColumnCount()) {
            vector.add(new CgData(" ", true));
            this.lastRowData.add(new CgData(" ", true));
            ++n;
        }
        cgTblModel.resetLastRowCellEditable();
        cgTblModel.finishCreating();
        cgTblModel.addRow(vector);
        this.rowForInput = this.getRowCount() - 1;
        this.columnForInput = 0;
    }

    public void setLastRowCellEditable(int n, boolean bl) {
        int n2 = this.convertColumnIndexToModel(n);
        ((CgTblModel)this.getModel()).setLastRowCellEditable(n2, bl);
    }

    public void setCellEditable(int n, int n2, boolean bl) {
        if (n < 0 || n >= this.getRowCount() || n2 < 0 || n2 >= this.getColumnCount()) {
            return;
        }
        Object object = this.getValueAt(n, n2);
        if (object instanceof CgData) {
            CgData cgData = (CgData)object;
            ((CgData)object).setIsEditable(bl);
        }
    }

    public void setIsEditable(boolean bl) {
        this.isEditable = bl;
        ((CgTblModel)this.getModel()).setTableEditable(bl);
        if (!bl) {
            this.setColumnSelectionAllowed(false);
            this.setRowSelectionAllowed(false);
            this.setCellSelectionEnabled(false);
        }
    }

    public boolean isInputCell(int n, int n2) {
        return n == this.rowForInput && n2 == this.columnForInput;
    }

    public void editingStopped(ChangeEvent changeEvent) {
        CgData cgData;
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor == null) {
            return;
        }
        Object object = tableCellEditor.getCellEditorValue();
        if (this.workingRow != this.editingRow) {
            this.oldRowValue = ((CgTblModel)this.getModel()).getValueOfRow(this.editingRow);
        }
        boolean bl = true;
        this.notifyCreatingRow();
        int n = this.editingRow;
        int n2 = this.editingColumn;
        if (object != null && !this.valueIsEqual(object, (CgData)this.getValueAt(this.editingRow, this.editingColumn))) {
            CgData cgData2;
            bl = false;
            if (object instanceof CgData) {
                cgData2 = (CgData)object;
            } else if ((CgData)this.getValueAt(this.editingRow, this.editingColumn) != null) {
                cgData = (CgData)this.getValueAt(this.editingRow, this.editingColumn);
                cgData2 = new CgData(object.toString(), cgData.getIcon(), cgData.getUserData());
                cgData2.setIsEditable(cgData.getEditStatus());
            } else {
                cgData2 = new CgData(object.toString());
            }
            this.updated = true;
            this.setValueAt(cgData2, this.editingRow, this.editingColumn);
        }
        if (n == this.getModel().getRowCount() - 1 && !this.noNewRow && !bl) {
            this.rowForInput = -1;
            this.columnForInput = -1;
            if (this.convertColumnIndexToModel(n2) == 0) {
                ((CgTblModel)this.getModel()).finishCreating();
            }
            if (n2 != this.getColumnCount() - 1) {
                int n3 = n2 + 1;
                if (this.convertColumnIndexToModel(n2) == 0) {
                    ((CgTblModel)this.getModel()).beginCreateRow();
                }
                while (n3 < this.getColumnCount() && !this.isCellEditable(n, n3)) {
                    cgData = ((CgTblModel)this.getModel()).getColumnDefaultVal(this.convertColumnIndexToModel(n3));
                    this.setValueAt(cgData, n, n3);
                    ++n3;
                }
                if (n3 < this.getColumnCount()) {
                    this.rowForInput = n;
                    this.columnForInput = n3;
                }
            }
        }
        this.removeEditor();
    }

    public void clearSelection() {
        this.previousSelectRow = -1;
        super.clearSelection();
    }

    private boolean valueIsEqual(Object object, CgData cgData) {
        if (object == null) {
            return true;
        }
        if (object != null && cgData == null) {
            return false;
        }
        if (object instanceof CgData) {
            CgData cgData2 = (CgData)object;
            if (cgData.isDummy() && ((CgData)object).getLabel().equals("") && ((CgData)object).getUserData() == null) {
                return true;
            }
            if (cgData2.getLabel() == null && cgData.getLabel() != null || cgData2.getLabel() != null && cgData.getLabel() == null) {
                return false;
            }
            if (cgData2.getLabel() != null && !cgData2.getLabel().trim().equals(cgData.getLabel().trim())) {
                return false;
            }
            if (cgData2.getIcon() == null && cgData.getIcon() != null || cgData2.getIcon() != null && cgData.getIcon() == null) {
                return false;
            }
            if (cgData2.getIcon() != null && !cgData2.getIcon().equals(cgData.getIcon())) {
                return false;
            }
            if (cgData2.getUserData() == null && cgData.getUserData() != null || cgData2.getUserData() != null && cgData.getUserData() == null) {
                return false;
            }
            return cgData2.getUserData() == null || cgData2.getUserData().toString().equals(cgData.getUserData().toString());
        }
        if (cgData.getLabel() == null) {
            return false;
        }
        if (object.toString().equals("")) {
            return cgData instanceof CgData && cgData.isDummy();
        }
        return cgData.getLabel().trim().equals(object.toString().trim());
    }

    private void notifyCreatingRow() {
        if (this.workingRow != this.editingRow) {
            this.workingRow = this.editingRow;
        }
    }

    public boolean isTableEditable() {
        return this.isEditable;
    }

    public void resetStatus() {
        this.updated = false;
        this.customUpdated = false;
        this.workingRow = -1;
        this.previousSelectRow = -1;
    }

    public void submitted() {
        if (this.getRowCount() > 0 && this.workingRow == this.getRowCount() - 1) {
            ((CgTblModel)this.getModel()).finishCreating();
            if (!this.noNewRow) {
                this.newCreatingRow();
            }
        }
        this.updated = false;
        this.workingRow = -1;
    }

    public void setConfirmRow(boolean bl) {
        this.confirmRow = bl;
    }

    public boolean isShowConfirmRow() {
        return this.confirmRow;
    }

    private int showConfirmationDialog(int n) {
        if (this.workingRow == -1 && !this.customUpdated) {
            return this.workingRow;
        }
        if (this.isEditing() && this.editingRow == n) {
            this.removeEditor();
        }
        String string = CgUtility.getI18nMsg("table.confirmSave");
        String string2 = CgUtility.getI18nMsg("table.cancelSave");
        int n2 = UcDialog.showOkCancel((String)(string + string2));
        if (n2 == 0) {
            int n3 = 0;
            while (n3 < this.saveListener.size()) {
                CgRowSaveEvent cgRowSaveEvent = new CgRowSaveEvent(((CgTblModel)this.getModel()).getValueOfRow(this.workingRow));
                ((CgRowSaveListener)this.saveListener.get(n3)).saveData(cgRowSaveEvent);
                ++n3;
            }
            return this.workingRow;
        }
        if (this.updated) {
            this.resetWorkingRow();
        }
        this.setRowSelectionInterval(n, n);
        CgCancelRowSaveEvent cgCancelRowSaveEvent = new CgCancelRowSaveEvent();
        int n4 = 0;
        while (n4 < this.cancelListener.size()) {
            ((CgCancelRowSaveListener)this.cancelListener.get(n4)).cancelSaveOccured(cgCancelRowSaveEvent);
            ++n4;
        }
        return n;
    }

    public int getPreEditingRow() {
        return this.preEditingRow;
    }

    public int getPreEditingColumn() {
        return this.preEditingColumn;
    }

    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        boolean bl;
        Component component;
        Object object;
        this.preEditingRow = n;
        this.preEditingColumn = n2;
        this.editingCellValue = object = this.getValueAt(n, n2);
        if (object instanceof CgData && ((CgData)object).isDummy()) {
            object = new CgData(" ");
        }
        if ((component = tableCellEditor.getTableCellEditorComponent(this, object, bl = this.isCellSelected(n, n2), n, n2)) instanceof JComboBox && !(component instanceof CgComboBox) && object instanceof CgData && object.toString() != null) {
            ((JComboBox)component).setSelectedItem(object.toString().trim());
        }
        if (component != null && component.getFont() == null) {
            component.setFont(this.getFont());
        }
        if (component instanceof JComponent) {
            ((JComponent)component).setNextFocusableComponent(this);
        }
        this.fireUpdateEvent(new CgTblUpdateEvent(this.editingRow, this.editingColumn));
        return component;
    }

    public void setNoNewRow(boolean bl) {
        this.noNewRow = bl;
    }

    public void resetWorkingCell() {
        this.editingCanceled(new ChangeEvent(this));
        if (this.preEditingRow < 0 || this.preEditingRow >= this.getRowCount() || this.preEditingColumn < 0 || this.preEditingColumn >= this.getColumnCount() || this.editingCellValue == null) {
            return;
        }
        this.setValueAt(this.editingCellValue, this.preEditingRow, this.preEditingColumn);
    }

    public Object getWorkingCellValue() {
        return this.editingCellValue;
    }

    public void resetWorkingRow() {
        if (this.isEditing()) {
            this.removeEditor();
        }
        if (this.updated) {
            if (this.workingRow == this.getRowCount() - 1) {
                if (this.lastRowData != null) {
                    Vector<CgData> vector = new Vector<CgData>();
                    int n = 0;
                    while (n < this.lastRowData.size()) {
                        CgData cgData = (CgData)this.lastRowData.get(n);
                        CgData cgData2 = new CgData(cgData.getLabel(), true);
                        vector.add(cgData2);
                        ++n;
                    }
                    ((CgTblModel)this.getModel()).modifyRow(this.workingRow, vector);
                }
            } else if (this.oldRowValue != null) {
                ((CgTblModel)this.getModel()).modifyRow(this.workingRow, this.oldRowValue);
            }
            ((CgTblModel)this.getModel()).finishCreating();
            this.updated = false;
        }
        if (this.workingRow == this.getRowCount() - 1) {
            this.rowForInput = this.getRowCount() - 1;
            this.columnForInput = 0;
        }
        this.workingRow = -1;
    }

    public void addRow(Vector vector) {
        ((CgTblModel)this.getModel()).addRow(vector);
        this.rowForInput = this.getRowCount() - 1;
    }

    public void insertRow(Vector vector, int n) {
        ((CgTblModel)this.getModel()).insertRow(vector, n);
        this.rowForInput = this.getRowCount() - 1;
    }

    public Object getCurrentValueAt(int n, int n2) {
        if (n < 0 || n >= this.getRowCount() || n2 < 0 || n2 >= this.getColumnCount()) {
            return null;
        }
        Object object = this.getValueAt(n, n2);
        if (this.isEditing() && n == this.editingRow && n2 == this.editingColumn) {
            Component component;
            TableCellEditor tableCellEditor = this.getCellEditor();
            if (tableCellEditor == null) {
                return null;
            }
            if (tableCellEditor instanceof DefaultCellEditor && ((component = ((DefaultCellEditor)tableCellEditor).getComponent()) instanceof JTextField || component instanceof JComboBox)) {
                Object object2 = tableCellEditor.getCellEditorValue();
                if (object2 == null) {
                    return null;
                }
                if (object2 instanceof CgData) {
                    object = (CgData)object2;
                } else {
                    CgData cgData = (CgData)object;
                    object = new CgData(object2.toString(), cgData.getIcon(), cgData.getUserData());
                }
            }
        }
        return object;
    }

    public void deleteRow(int n) {
        if (n < 0 || n >= this.getRowCount()) {
            return;
        }
        if (this.isEditing() && n == this.editingRow) {
            this.removeEditor();
        }
        if (n == this.getSelectedRow()) {
            this.clearSelection();
        }
        ((CgTblModel)this.getModel()).deleteRow(n);
        this.rowForInput = this.getRowCount() - 1;
    }

    class HeaderRenderer
    extends JLabel
    implements TableCellRenderer {
        JLabel label = new JLabel("");
        JLabel label1 = new JLabel(" ");
        boolean isBold = false;

        public HeaderRenderer() {
            this.label.setHorizontalAlignment(0);
        }

        public HeaderRenderer(boolean bl) {
            this.isBold = bl;
            this.label.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JTableHeader jTableHeader = jTable.getTableHeader();
            Font font = jTableHeader.getFont();
            this.label.setForeground(Color.black);
            this.label.setBorder(BorderFactory.createMatteBorder(2, 5, 2, 5, jTableHeader.getBackground()));
            this.label.setText(object.toString());
            this.label.setOpaque(true);
            this.label.setFont(font);
            this.setLayout(new BorderLayout());
            this.add(this.label);
            this.add((Component)this.label1, "East");
            this.setText(object.toString());
            this.setHorizontalAlignment(0);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setFont(font);
            Dimension dimension = new Dimension();
            dimension = this.getPreferredSize();
            this.setPreferredSize(new Dimension(dimension.width, 23));
            return this;
        }
    }

    class CgTblCellRender
    implements TableCellRenderer {
        private Border focusBorder = BorderFactory.createLineBorder(new Color(102, 102, 153), 1);
        private Border noFocusBorder = new EmptyBorder(1, 3, 1, 1);

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            CgTable cgTable = (CgTable)jTable;
            if (object == null) {
                return new JLabel(" ");
            }
            if (object instanceof CgData) {
                JLabel jLabel = new JLabel();
                jLabel.setOpaque(true);
                jLabel.setFont(jTable.getFont());
                String string = ((CgData)object).getLabel();
                jLabel.setText(string == null ? " " : string);
                CgTblModel cgTblModel = (CgTblModel)cgTable.getModel();
                int n3 = cgTable.convertColumnIndexToModel(n2);
                String string2 = cgTblModel.getColumnToolTip(n3);
                if (string2 != null && cgTable.isTableEditable() && n == CgTable.this.getRowCount() - 1) {
                    jLabel.setToolTipText(string2);
                } else if (string != null && !string.trim().equals("")) {
                    jLabel.setToolTipText(string);
                }
                jLabel.setIcon(((CgData)object).getIcon());
                if (bl) {
                    if (CgTable.this.isInputCell(n, n2)) {
                        jLabel.setForeground(Color.blue.darker());
                    } else {
                        jLabel.setForeground(jTable.getSelectionForeground());
                    }
                    jLabel.setBackground(jTable.getSelectionBackground());
                } else if (cgTable.isTableEditable()) {
                    if (CgTable.this.isCellEditable(n, n2)) {
                        jLabel.setBackground(Color.white);
                        if (CgTable.this.isInputCell(n, n2)) {
                            jLabel.setForeground(Color.blue.darker());
                        } else {
                            jLabel.setForeground(cgTable.getForeground());
                        }
                    } else {
                        jLabel.setBackground(UcCommon.getLightGrayColor());
                        jLabel.setForeground(cgTable.getForeground());
                    }
                } else {
                    jLabel.setBackground(new Color(204, 204, 204));
                    jLabel.setForeground(cgTable.getForeground());
                }
                if (bl2) {
                    jLabel.setBorder(this.focusBorder);
                    if (CgTable.this.isCellEditable(n, n2)) {
                        jLabel.setBackground(Color.white);
                    }
                } else {
                    jLabel.setBorder(this.noFocusBorder);
                }
                return jLabel;
            }
            if (object instanceof JLabel) {
                JLabel jLabel = (JLabel)object;
                return jLabel;
            }
            if (object instanceof String) {
                JLabel jLabel = new JLabel();
                jLabel.setFont(jTable.getFont());
                jLabel.setBorder(this.noFocusBorder);
                jLabel.setForeground(Color.black);
                jLabel.setText(" " + (String)object);
                jLabel.setHorizontalTextPosition(0);
                jLabel.setBorder(BorderFactory.createEtchedBorder());
                if (!cgTable.isTableEditable()) {
                    jLabel.setBackground(Color.lightGray);
                }
                return jLabel;
            }
            JLabel jLabel = new JLabel(object.toString());
            return jLabel;
        }
    }

    class CgTblSelectionModel
    extends DefaultListSelectionModel {
        CgTable table;
        int previousIndex = -1;

        public CgTblSelectionModel(CgTable cgTable2) {
            this.setSelectionMode(0);
            this.table = cgTable2;
        }

        public void setSelectionInterval(int n, int n2) {
            boolean bl = false;
            if (this.previousIndex == n) {
                bl = true;
            } else {
                this.previousIndex = n;
            }
            if (this.table.isDataUpdated() && this.table.isShowConfirmRow() && !bl) {
                this.previousIndex = this.table.showConfirmationDialog(n);
            } else {
                super.setSelectionInterval(n, n2);
            }
        }
    }
}

