/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.awx;

import com.sun.symon.base.console.awx.AwxComponent;
import com.sun.symon.base.console.awx.AwxContainer;
import com.sun.symon.base.console.awx.AwxSelectPanel;
import com.sun.symon.base.console.awx.AwxTreeNodeInfo;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.xobject.XObjectBase;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class AwxTreeBranch
extends AwxContainer {
    protected DefaultMutableTreeNode MyNode = null;

    public void activate() {
        AwxTreeNodeInfo awxTreeNodeInfo = new AwxTreeNodeInfo(this);
        this.MyNode = new DefaultMutableTreeNode(awxTreeNodeInfo, true);
        String string = this.lookup("awx", "parent", null);
        try {
            XObjectBase xObjectBase = null;
            if (string != null) {
                try {
                    xObjectBase = this.locate(string, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (xObjectBase == null) {
                    UcDDL.logErrorMessage((String)("[" + this.fullName() + "] Invalid parent specified - " + string));
                    return;
                }
            } else {
                xObjectBase = this.superior();
            }
            while (xObjectBase != null) {
                try {
                    AwxTreeBranch awxTreeBranch = (AwxTreeBranch)xObjectBase;
                    awxTreeBranch.addChildNode(this.MyNode);
                    return;
                }
                catch (Exception exception) {
                    string = xObjectBase.lookup("awx", "parent", null);
                    if (string != null) {
                        xObjectBase = this.locate(string, true);
                        if (xObjectBase != null) continue;
                        UcDDL.logErrorMessage((String)("[" + xObjectBase.fullName() + "] Invalid parent " + "specified - " + string));
                        return;
                    }
                    xObjectBase = xObjectBase.superior();
                }
            }
            UcDDL.logErrorMessage((String)("[" + this.fullName() + "] No valid tree parent found"));
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)("[" + this.fullName() + "] Error locating tree parent - " + exception));
        }
    }

    public boolean addChildComponent(AwxComponent awxComponent) {
        try {
            AwxSelectPanel awxSelectPanel = (AwxSelectPanel)awxComponent;
            AwxTreeNodeInfo awxTreeNodeInfo = new AwxTreeNodeInfo(awxComponent);
            this.MyNode.add(new DefaultMutableTreeNode(awxTreeNodeInfo, false));
        }
        catch (ClassCastException classCastException) {
            UcDDL.logErrorMessage((String)("[" + awxComponent.fullName() + "] Invalid tree branch/leaf addition " + "in " + this.fullName()));
            return false;
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)("[" + this.fullName() + "] Error adding child component - " + exception));
            return false;
        }
        return true;
    }

    public void addChildNode(MutableTreeNode mutableTreeNode) {
        this.MyNode.add(mutableTreeNode);
    }

    public void destruct() {
        if (this.MyNode != null) {
            this.MyNode.removeFromParent();
            this.MyNode.setUserObject(null);
        }
        super.destruct();
    }

    public int getAwxType() {
        return 4;
    }

    public void removeChildComponent(AwxComponent awxComponent) {
        Enumeration<TreeNode> enumeration = this.MyNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            AwxTreeNodeInfo awxTreeNodeInfo = (AwxTreeNodeInfo)defaultMutableTreeNode.getUserObject();
            if (awxTreeNodeInfo.ParentComponent != awxComponent) continue;
            this.MyNode.remove(defaultMutableTreeNode);
            defaultMutableTreeNode.setUserObject(null);
        }
    }

    public TreePath findChildLeaf(String string) {
        int n = 0;
        while (n < this.MyNode.getChildCount()) {
            String string2;
            Object object;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.MyNode.getChildAt(n);
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (object2 instanceof AwxTreeBranch) {
                object = ((AwxTreeBranch)object2).findChildLeaf(string);
                if (object != null) {
                    return object;
                }
            } else if (object2 instanceof AwxSelectPanel ? (object = ((AwxSelectPanel)object2).lookup("res", "nodeKey", null)) != null && ((String)object).equals(string) : object2 instanceof AwxTreeNodeInfo && (string2 = (object = ((AwxTreeNodeInfo)object2).ParentComponent).lookup("res", "nodeKey", null)) != null && string2.equals(string)) {
                return new TreePath(defaultMutableTreeNode.getPath());
            }
            ++n;
        }
        return null;
    }
}

