/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.config.util;

import com.sun.portal.config.util.ExtensionFilter;
import com.sun.portal.config.util.ProcessStreamBuffer;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;

public class Util {
    protected static String name_ = System.getProperty("os.name");

    public static void debug(String string) {
        String string2 = System.getProperty("PS_CONFIG_DEBUG");
        if (string2 != null && string2.equals("y")) {
            System.out.println(string);
        }
    }

    public static boolean isRoot() {
        String string = System.getProperty("user.name");
        if (Util.is_windows()) {
            return true;
        }
        return string.equals("root");
    }

    public static boolean fileExists(String string) {
        try {
            File file = new File(string);
            if (file.exists()) {
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (SecurityException securityException) {
            return false;
        }
        return false;
    }

    public static FilenameFilter getExtensionFilter(String string) {
        ExtensionFilter extensionFilter = new ExtensionFilter(string);
        return extensionFilter;
    }

    public static void getFiles(File file, Vector vector) throws NullPointerException {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isFile()) {
                vector.add(file2);
                continue;
            }
            if (!file2.isDirectory()) continue;
            vector.add(file2);
            Util.getFiles(file2, vector);
        }
    }

    public static void getFilteredFiles(File file, Vector vector, String string) throws NullPointerException {
        FilenameFilter filenameFilter = Util.getExtensionFilter(string);
        File[] fileArray = file.listFiles(filenameFilter);
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isFile()) {
                vector.add(file2);
                continue;
            }
            if (!file2.isDirectory()) continue;
            vector.add(file2);
            Util.getFiles(file2, vector);
        }
    }

    public static void moveFile(String string, String string2) throws FileNotFoundException, IOException {
        Util.copyFile(new File(string), new File(string2), true);
    }

    public static void moveFile(File file, File file2) throws FileNotFoundException, IOException {
        Util.copyFile(file, file2, true);
    }

    public static void copyFile(String string, String string2) throws FileNotFoundException, IOException {
        Util.copyFile(new File(string), new File(string2), false);
    }

    public static void copyFile(File file, File file2) throws FileNotFoundException, IOException {
        Util.copyFile(file, file2, false);
    }

    private static byte[] getByteData(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        try {
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException(nullPointerException.toString());
        }
        catch (IOException iOException) {
            throw new IOException(iOException.toString());
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void copyFile(File file, File file2, boolean bl) throws FileNotFoundException, IOException {
        if (file != null && file2 != null) {
            File file3;
            if (!file.exists()) {
                file.createNewFile();
            } else if (file.isDirectory()) {
                file.mkdirs();
                return;
            }
            if (file2.exists() && !file2.isDirectory()) {
                file2.delete();
            }
            if ((file3 = file2.getParentFile()) != null) {
                file3.mkdirs();
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = Util.getByteData(fileInputStream);
            fileInputStream.close();
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
            if (bl) {
                file.delete();
            }
        }
    }

    public static boolean deleteFile(String string) {
        return Util.deleteFile(new File(string));
    }

    public static boolean deleteFile(File file) {
        return file.delete();
    }

    public static boolean directoryExists(String string) {
        try {
            File file = new File(string);
            if (file.exists() && file.isDirectory()) {
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (SecurityException securityException) {
            return false;
        }
        return false;
    }

    public static boolean makeDir(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return file.mkdirs();
        }
        return true;
    }

    public static void renameDir(String string, String string2) throws FileNotFoundException, IOException {
        Vector vector = new Vector();
        try {
            Util.getFiles(new File(string), vector);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Util.makeDir(string2);
        for (int i = 0; i < vector.size(); ++i) {
            File file = (File)vector.get(i);
            String string3 = file.getAbsolutePath();
            String string4 = string3.substring(string.length(), string3.length());
            String string5 = string2 + string4;
            Util.copyFile(file, new File(string5));
        }
    }

    public static void copyDir(String string, String string2) throws FileNotFoundException, IOException {
        Vector vector = new Vector();
        try {
            Util.getFiles(new File(string), vector);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Util.makeDir(string2);
        for (int i = 0; i < vector.size(); ++i) {
            File file = (File)vector.get(i);
            String string3 = file.getAbsolutePath();
            String string4 = string3.substring(string.length(), string3.length());
            String string5 = string2 + string4;
            Util.copyFile(file, new File(string5));
        }
    }

    public static boolean deleteDir(String string) {
        Util.debug("Deleting dir:" + string);
        File file = new File(string);
        if (!file.isDirectory()) {
            return Util.deleteFile(file);
        }
        return Util.deleteDir(file);
    }

    public static boolean deleteDir(File file) {
        if (!file.isDirectory()) {
            return Util.deleteFile(file);
        }
        boolean bl = false;
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isFile()) {
                bl = Util.deleteFile(file2);
            } else if (file2.isDirectory()) {
                bl = Util.deleteDir(file2);
            }
            if (bl) continue;
            return false;
        }
        return file.delete();
    }

    public static boolean isOS(String string) {
        Properties properties = System.getProperties();
        String string2 = properties.getProperty("os.name");
        return string2.equals(string);
    }

    public static void createSymbolicLink(String string, String string2) throws Exception {
        if (Util.isOS("SunOS")) {
            String string3 = "/usr/bin/ln";
            String[] stringArray = new String[]{"-fs", string, string2};
            Util.runCommandLine(string3, stringArray);
        } else if (Util.isOS("Linux")) {
            String string4 = "/bin/ln";
            String[] stringArray = new String[]{"-fs", string, string2};
            Util.runCommandLine(string4, stringArray);
        } else if (Util.is_windows()) {
            File file = new File(string);
            if (file.exists()) {
                if (file.isDirectory()) {
                    Util.copyDir(string, string2);
                } else {
                    Util.copyFile(string, string2);
                }
            }
        } else {
            Util.debug("Util:createSymbolicLink error - unsupported OS");
        }
    }

    public static void changeFilePermission(String string, String string2) throws Exception {
        if (Util.isOS("SunOS")) {
            String string3 = "/usr/bin/chmod";
            String[] stringArray = new String[]{string2, string};
            Util.runCommandLine(string3, stringArray);
        } else if (Util.isOS("Linux")) {
            String string4 = "/bin/chmod";
            String[] stringArray = new String[]{string2, string};
            Util.runCommandLine(string4, stringArray);
        } else {
            Util.debug("Util:changeFilePermission error - unsupported OS");
        }
    }

    public static String decoratePath(String string) {
        if (Util.is_windows() && string != null && string.indexOf(32) != -1) {
            StringBuffer stringBuffer = new StringBuffer("\"" + string + "\"");
            return stringBuffer.toString();
        }
        return string;
    }

    public static void appendLineInFile(File file, String string, StringBuffer stringBuffer) throws IOException, FileNotFoundException {
        File file2 = null;
        try {
            file2 = File.createTempFile("appendlineinfile", ".tmp");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(illegalArgumentException.toString());
        }
        catch (SecurityException securityException) {
            throw new IOException(securityException.toString());
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8"));
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            bufferedWriter.write(string2);
            bufferedWriter.newLine();
            if (string2.indexOf(string) == -1) continue;
            bufferedWriter.write(stringBuffer.toString());
            bufferedWriter.newLine();
        }
        bufferedReader.close();
        bufferedWriter.close();
        Util.copyFile(file2, file);
        file2.delete();
    }

    public static void replaceLineInFile(File file, String string, StringBuffer stringBuffer) throws IOException, FileNotFoundException {
        File file2 = null;
        try {
            file2 = File.createTempFile("replacelineinfile", ".tmp");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(illegalArgumentException.toString());
        }
        catch (SecurityException securityException) {
            throw new IOException(securityException.toString());
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8"));
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            if (string2.indexOf(string) != -1) {
                bufferedWriter.write(stringBuffer.toString());
                bufferedWriter.newLine();
                continue;
            }
            bufferedWriter.write(string2);
            bufferedWriter.newLine();
        }
        bufferedReader.close();
        bufferedWriter.close();
        Util.copyFile(file2, file);
        file2.delete();
    }

    public static void deleteLineInFile(File file, String string) throws IOException, FileNotFoundException {
        File file2 = null;
        try {
            file2 = File.createTempFile("deletelineinfile", ".tmp");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(illegalArgumentException.toString());
        }
        catch (SecurityException securityException) {
            throw new IOException(securityException.toString());
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8"));
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            if (string2.indexOf(string) != -1) continue;
            bufferedWriter.write(string2);
            bufferedWriter.newLine();
        }
        bufferedReader.close();
        bufferedWriter.close();
        Util.copyFile(file2, file);
        file2.delete();
    }

    public static void deleteUntilBlankLineInFile(File file, String string) throws IOException, FileNotFoundException {
        File file2 = null;
        try {
            file2 = File.createTempFile("deletelineinfile", ".tmp");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(illegalArgumentException.toString());
        }
        catch (SecurityException securityException) {
            throw new IOException(securityException.toString());
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8"));
        boolean bl = true;
        String string2 = "";
        String string3 = null;
        while ((string3 = bufferedReader.readLine()) != null) {
            if (string3.indexOf(string) >= 0) {
                bl = false;
            }
            if (!bl && string3.trim().equals(string2)) {
                bl = true;
            }
            if (!bl) continue;
            bufferedWriter.write(string3);
            bufferedWriter.newLine();
        }
        bufferedReader.close();
        bufferedWriter.close();
        Util.copyFile(file2, file);
        file2.delete();
    }

    public static void appendLineEof(File file, String string, boolean bl) throws IOException, FileNotFoundException {
        String string2;
        File file2 = null;
        try {
            file2 = File.createTempFile("appendlineeof", ".tmp");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(illegalArgumentException.toString());
        }
        catch (SecurityException securityException) {
            throw new IOException(securityException.toString());
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8"));
        boolean bl2 = false;
        while ((string2 = bufferedReader.readLine()) != null) {
            if (bl && string2.equals(string)) {
                bl2 = true;
            }
            bufferedWriter.write(string2);
            bufferedWriter.newLine();
        }
        bufferedReader.close();
        if (!bl2) {
            bufferedWriter.write(string);
            bufferedWriter.newLine();
        }
        bufferedWriter.close();
        Util.copyFile(file2, file);
        file2.delete();
    }

    public static String findTextInFile(File file, String string) throws FileNotFoundException, IOException {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        while ((string2 = bufferedReader.readLine()) != null) {
            if (string2.indexOf(string) < 0) continue;
            bufferedReader.close();
            return string2;
        }
        bufferedReader.close();
        return "";
    }

    public static void replaceTokenInFile(File file, File file2, String string, String string2) throws FileNotFoundException, IOException {
        String string3;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file2)));
        while ((string3 = bufferedReader.readLine()) != null) {
            int n = string3.indexOf(string);
            if (n >= 0) {
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = n + string.length();
                stringBuffer.append(string3.substring(0, n));
                stringBuffer.append(string2);
                stringBuffer.append(string3.substring(n2, string3.length()));
                bufferedWriter.write(stringBuffer.toString());
                bufferedWriter.newLine();
                continue;
            }
            bufferedWriter.write(string3);
            bufferedWriter.newLine();
        }
        bufferedReader.close();
        bufferedWriter.close();
    }

    public static void replaceTokenInFile(File file, String string, String string2) throws FileNotFoundException, IOException {
        String string3;
        File file2 = null;
        try {
            file2 = File.createTempFile("replacetokeninfile", ".tmp");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(illegalArgumentException.toString());
        }
        catch (SecurityException securityException) {
            throw new IOException(securityException.toString());
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file2)));
        while ((string3 = bufferedReader.readLine()) != null) {
            int n = string3.indexOf(string);
            if (n >= 0) {
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = n + string.length();
                stringBuffer.append(string3.substring(0, n));
                stringBuffer.append(string2);
                stringBuffer.append(string3.substring(n2, string3.length()));
                bufferedWriter.write(stringBuffer.toString());
                bufferedWriter.newLine();
                continue;
            }
            bufferedWriter.write(string3);
            bufferedWriter.newLine();
        }
        bufferedReader.close();
        bufferedWriter.close();
        Util.copyFile(file2, file);
        file2.delete();
    }

    public static void replaceTokenInFile(File file, String[] stringArray, String[] stringArray2) throws FileNotFoundException, IOException {
        String string;
        File file2 = null;
        try {
            file2 = File.createTempFile("replacetokeninfile", ".tmp");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(illegalArgumentException.toString());
        }
        catch (SecurityException securityException) {
            throw new IOException(securityException.toString());
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file2)));
        while ((string = bufferedReader.readLine()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                int n = string.indexOf(string2);
                if (n < 0) continue;
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = n + string2.length();
                stringBuffer.append(string.substring(0, n));
                String string3 = stringArray2[i];
                stringBuffer.append(string3);
                stringBuffer.append(string.substring(n2, string.length()));
                string = stringBuffer.toString();
            }
            bufferedWriter.write(string);
            bufferedWriter.newLine();
        }
        bufferedReader.close();
        bufferedWriter.close();
        Util.copyFile(file2, file);
        file2.delete();
    }

    public static void extractPatternFromFile(File file, StringBuffer stringBuffer, String string, String string2) throws IOException, FileNotFoundException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string3 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string3 = bufferedReader.readLine()) != null) {
            arrayList.add(string3 + "\n");
        }
        bufferedReader.close();
        int n = arrayList.size();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        block1: for (n2 = 0; n2 < n; ++n2) {
            if (!((String)arrayList.get(n2)).trim().startsWith(string)) continue;
            if (n2 == n) {
                return;
            }
            n3 = n2;
            while (n2 < n) {
                if (((String)arrayList.get(n2)).trim().startsWith(string2)) {
                    n4 = n2;
                    for (int i = n3; i <= n4; ++i) {
                        stringBuffer.append((String)arrayList.get(i));
                    }
                    continue block1;
                }
                ++n2;
            }
        }
    }

    public static void dos2unix(File file) throws FileNotFoundException, IOException {
        String string;
        File file2 = null;
        try {
            file2 = File.createTempFile("dos2unix", ".tmp");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(illegalArgumentException.toString());
        }
        catch (SecurityException securityException) {
            throw new IOException(securityException.toString());
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file2)));
        while ((string = bufferedReader.readLine()) != null) {
            bufferedWriter.write(string);
            bufferedWriter.write("\n");
        }
        bufferedReader.close();
        bufferedWriter.close();
        Util.copyFile(file2, file);
        file2.delete();
    }

    public static InputStream runCommandLine(String string) throws Exception {
        return Util.runCommandLine(string, null, null, null);
    }

    public static InputStream runCommandLine(String string, String[] stringArray) throws Exception {
        return Util.runCommandLine(string, stringArray, null, null);
    }

    public static InputStream runCommandLine(String string, String[] stringArray, Vector vector) throws Exception {
        return Util.runCommandLine(string, stringArray, vector, null);
    }

    public static InputStream runCommandLine(String string, String[] stringArray, Vector vector, File file) throws Exception {
        if (Util.is_windows()) {
            return Util.executeWindows(string, stringArray, vector, file);
        }
        return Util.execute(string, stringArray, vector);
    }

    public static InputStream execute(String string, String[] stringArray, Vector vector) throws Exception {
        int n;
        int n2;
        int n3;
        int n4 = stringArray != null ? stringArray.length + 1 : 1;
        String[] stringArray2 = new String[n4];
        stringArray2[0] = string;
        if (stringArray != null) {
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                stringArray2[n3 + 1] = stringArray[n3];
            }
        }
        n3 = vector != null ? vector.size() + 7 : 7;
        String[] stringArray3 = new String[n3];
        stringArray3[0] = "DEPLOY_ADMIN_PASSWORD=" + System.getProperty("DEPLOY_ADMIN_PASSWORD");
        stringArray3[1] = "DS_DIRMGR_PASSWORD=" + System.getProperty("DS_DIRMGR_PASSWORD");
        stringArray3[2] = "IDSAME_LDAPUSER_PASSWORD=" + System.getProperty("IDSAME_LDAPUSER_PASSWORD");
        stringArray3[3] = "IDSAME_ADMIN_PASSWORD=" + System.getProperty("IDSAME_ADMIN_PASSWORD");
        stringArray3[4] = "SRA_LOG_USER_PASSWORD=" + System.getProperty("SRA_LOG_USER_PASSWORD");
        stringArray3[5] = "CERT_DB_PASSWORD=" + System.getProperty("CERT_DB_PASSWORD");
        stringArray3[6] = "PATH=/usr/bin:/usr/sbin:/bin";
        if (vector != null) {
            for (n2 = 0; n2 < vector.size(); ++n2) {
                stringArray3[n2 + 7] = (String)vector.get(n2);
            }
        }
        n2 = 0;
        for (n = 0; n < stringArray2.length; ++n) {
            if (n2 == 1) {
                n2 = 0;
                Util.debug("cmd[" + n + "] = ********");
                continue;
            }
            if (stringArray2[n] != null && stringArray2[n].indexOf("_password") != -1) {
                n2 = 1;
            }
            Util.debug("cmd[" + n + "] = " + stringArray2[n]);
        }
        for (n = 0; n < stringArray3.length; ++n) {
            if (stringArray3[n] != null && stringArray3[n].indexOf("_PASSWORD") != -1) {
                int n5 = stringArray3[n].indexOf("=");
                if (n5 != -1) {
                    Util.debug("env[" + n + "] = " + stringArray3[n].substring(0, n5) + "=********");
                    continue;
                }
                Util.debug("env[" + n + "] = " + stringArray3[n]);
                continue;
            }
            Util.debug("env[" + n + "] = " + stringArray3[n]);
        }
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(stringArray2, stringArray3);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getInputStream());
        bufferedInputStream.mark(10000);
        BufferedInputStream bufferedInputStream2 = new BufferedInputStream(process.getErrorStream());
        bufferedInputStream2.mark(10000);
        ProcessStreamBuffer processStreamBuffer = new ProcessStreamBuffer(process.getInputStream());
        ProcessStreamBuffer processStreamBuffer2 = new ProcessStreamBuffer(process.getErrorStream());
        processStreamBuffer.run();
        processStreamBuffer2.run();
        bufferedInputStream.reset();
        bufferedInputStream2.reset();
        if (process.waitFor() == 0) {
            Util.debug("Command - " + string);
            Util.debug("output log:");
            Util.debug(processStreamBuffer.output());
            Util.debug("error log:");
            Util.debug(processStreamBuffer2.output());
            return bufferedInputStream;
        }
        Util.debug("Command - " + string + " - exited with error");
        Util.debug("output log:");
        Util.debug(processStreamBuffer.output());
        Util.debug("error log:");
        Util.debug(processStreamBuffer2.output());
        return bufferedInputStream2;
    }

    public static InputStream executeWindows(String string, String[] stringArray, Vector vector, File file) throws Exception {
        String[] stringArray2;
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("\"" + string + "\" ");
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (n != stringArray.length - 1) {
                    stringBuffer.append(stringArray[n] + " ");
                    continue;
                }
                stringBuffer.append(stringArray[n]);
            }
        }
        n = 0;
        if (file != null && file.exists() && file.isDirectory()) {
            n = 1;
        }
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        if (vector == null || vector.size() == 0) {
            Util.debug(" windows exec:" + stringBuffer.toString());
            process = n != 0 ? runtime.exec(stringBuffer.toString(), null, file) : runtime.exec(stringBuffer.toString());
        } else {
            stringArray2 = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                stringArray2[i] = (String)vector.get(i);
            }
            Util.debug(" windows exec+env:" + stringBuffer.toString());
            process = n != 0 ? runtime.exec(stringBuffer.toString(), stringArray2, file) : runtime.exec(stringBuffer.toString(), stringArray2);
        }
        stringArray2 = new BufferedInputStream(process.getInputStream());
        BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getErrorStream());
        stringArray2.mark(100000);
        bufferedInputStream.mark(100000);
        ProcessStreamBuffer processStreamBuffer = new ProcessStreamBuffer((InputStream)stringArray2);
        ProcessStreamBuffer processStreamBuffer2 = new ProcessStreamBuffer(bufferedInputStream);
        processStreamBuffer.run();
        processStreamBuffer2.run();
        stringArray2.reset();
        bufferedInputStream.reset();
        if (process.waitFor() == 0) {
            Util.debug(" windows exec success");
            Util.debug("output log:" + processStreamBuffer.output());
            Util.debug("error log:" + processStreamBuffer2.output());
            return stringArray2;
        }
        Util.debug(" windows exec failure");
        Util.debug("output log:" + processStreamBuffer.output());
        Util.debug("error log:" + processStreamBuffer2.output());
        return bufferedInputStream;
    }

    public static boolean match_os(String string) {
        return Util.match(string);
    }

    public static boolean match(String string) {
        return name_.equalsIgnoreCase(string);
    }

    public static boolean is_windows() {
        return System.getProperty("os.name").indexOf("indows") != -1;
    }

    public static String replaceToken(String string, String string2, String string3) {
        if (string2 == null || string3 == null || string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        int n2 = string2.length();
        int n3 = string3.length();
        while ((n = stringBuffer.toString().indexOf(string2, n)) != -1) {
            stringBuffer.replace(n, n + n2, string3);
            n += n3;
        }
        return stringBuffer.toString();
    }

    public static String replaceTokens(String string, String[] stringArray, String[] stringArray2) {
        String string2 = string;
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            int n = string2.indexOf(string3);
            if (n < 0) continue;
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = n + string3.length();
            stringBuffer.append(string2.substring(0, n));
            String string4 = stringArray2[i];
            stringBuffer.append(string4);
            stringBuffer.append(string2.substring(n2, string2.length()));
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    public static File extractFileFromJar(String string, String string2) throws IOException, FileNotFoundException {
        String string3;
        String string4;
        String string5;
        int n;
        if (Util.is_windows() && string2.indexOf(92) != -1) {
            string2 = string2.replace('\\', '/');
        }
        System.out.println("Extracting :" + string2 + ":from:" + string);
        JarFile jarFile = new JarFile(string);
        ZipEntry zipEntry = jarFile.getEntry(string2);
        if (null == zipEntry) {
            throw new FileNotFoundException("file:" + string2 + " not in jar file:" + string);
        }
        InputStream inputStream = jarFile.getInputStream(zipEntry);
        int n2 = string2.lastIndexOf("/");
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = (string5 = string2.substring(n2 + 1, string2.length())).indexOf(46)) > 0) {
            string4 = string5.substring(0, n);
            string3 = string5.substring(n + 1);
        } else {
            string4 = string5;
            string3 = null;
        }
        File file = File.createTempFile(string4, string3);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        int n3 = 0;
        byte[] byArray = new byte[2048];
        while (-1 != n3) {
            n3 = inputStream.read(byArray);
            if (n3 <= 0) continue;
            fileOutputStream.write(byArray, 0, n3);
        }
        inputStream.close();
        fileOutputStream.close();
        jarFile.close();
        return file;
    }

    public static void addFileToJar(String string, String string2, File file) throws IOException, FileNotFoundException {
        JarFile jarFile = new JarFile(string);
        File file2 = new File(string + ".tmp");
        JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(file2));
        FileInputStream fileInputStream = new FileInputStream(file);
        ZipEntry zipEntry = new ZipEntry(string2);
        jarOutputStream.putNextEntry(zipEntry);
        byte[] byArray = new byte[2048];
        int n = 0;
        do {
            jarOutputStream.write(byArray, 0, n);
        } while (-1 != (n = fileInputStream.read(byArray, 0, byArray.length)));
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            int n2;
            JarEntry jarEntry = enumeration.nextElement();
            if (jarEntry.getName().equals(string2)) continue;
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            jarOutputStream.putNextEntry(jarEntry);
            while ((n2 = inputStream.read(byArray)) != -1) {
                jarOutputStream.write(byArray, 0, n2);
            }
        }
        fileInputStream.close();
        jarOutputStream.close();
        Util.deleteFile(string);
        Util.moveFile(file2.getAbsolutePath(), string);
    }
}

