/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.config.util;

import com.sun.portal.config.ConfigurationContext;
import com.sun.portal.config.ConfigurationException;
import com.sun.portal.config.util.PortalServerTasks;
import com.sun.portal.config.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;

public class SRATasks
extends Util {
    private static String fs = System.getProperty("file.separator");
    private static ConfigurationContext context;
    private static PortalServerTasks PSTasks;

    public SRATasks(ConfigurationContext configurationContext) {
        context = configurationContext;
        PortalServerTasks portalServerTasks = new PortalServerTasks(configurationContext);
    }

    public static void assignServices(String[] stringArray, boolean bl) throws ConfigurationException {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("dn: " + context.getAmAdminDN() + "\n");
            stringBuffer.append("changetype:modify\n");
            stringBuffer.append("add: objectclass\n");
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append("objectclass:" + stringArray[i] + "\n");
            }
            stringBuffer.append("\n");
            try {
                File file = File.createTempFile("sraAssignService", ".ldif");
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write(stringBuffer.toString());
                fileWriter.close();
                PortalServerTasks.ldapModify(file, false);
                file.delete();
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new ConfigurationException(fileNotFoundException.toString());
            }
            catch (IOException iOException) {
                throw new ConfigurationException(iOException.toString());
            }
        }
        InputStream inputStream = PortalServerTasks.ldapSearch("iplanet-am-managed-person");
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string + "\n");
                stringBuffer.append("changetype:modify\n");
                stringBuffer.append("add: objectclass\n");
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append("objectclass:" + stringArray[i] + "\n");
                }
                stringBuffer.append("\n");
            }
            File file = File.createTempFile("sraAssignService", ".ldif");
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(stringBuffer.toString());
            fileWriter.close();
            PortalServerTasks.ldapModify(file, false);
            file.delete();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ConfigurationException(fileNotFoundException.toString());
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
    }

    public static void assignNetFileUserRole() throws ConfigurationException {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            InputStream inputStream = PortalServerTasks.ldapSearch("iplanet-am-managed-person");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string + "\n");
                stringBuffer.append("changetype:modify\n");
                stringBuffer.append("add: nsRoleDN\n");
                stringBuffer.append("nsRoleDN: cn=NetFile User Role," + context.getDefaultOrgDN());
                stringBuffer.append("\n");
            }
            File file = File.createTempFile("sraAssignNetFileRole", ".ldif");
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(stringBuffer.toString());
            fileWriter.close();
            PortalServerTasks.ldapModify(file, false);
            file.delete();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ConfigurationException(fileNotFoundException.toString());
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
    }

    public static void generateCert(String string, String string2, String string3) throws ConfigurationException {
        String[] stringArray;
        String string4;
        String string5 = context.getPSBaseDir();
        String string6 = context.getJDKDir();
        String string7 = "$CLASSPATH:.";
        String string8 = PSTasks.getJDKVersion();
        if (string8 == "1.3") {
            try {
                string4 = string2 + fs + "solaris" + fs + "sparc" + fs + "libjss3-jdk13.so";
                stringArray = string2 + fs + "solaris" + fs + "sparc" + fs + "libjss3.so";
                Util.createSymbolicLink(string4, (String)stringArray);
            }
            catch (Exception exception) {
                throw new ConfigurationException(exception.toString());
            }
            string7 = string2 + fs + "certadmin.jar" + ":" + string2 + fs + "jss32.jar" + ":" + string2 + fs + "jce1_2_1.jar" + ":" + string2 + fs + "sunjce_provider.jar" + ":" + string2 + fs + "local_policy.jar" + ":" + string2 + fs + "US_export_policy.jar" + ":" + string3 + fs + "SUNWps" + "locale";
        } else if (string8 == "1.4") {
            try {
                string4 = string2 + fs + "solaris" + fs + "sparc" + fs + "libjss3-jdk14.so";
                stringArray = string2 + fs + "solaris" + fs + "sparc" + fs + "libjss3.so";
                Util.createSymbolicLink(string4, (String)stringArray);
            }
            catch (Exception exception) {
                throw new ConfigurationException(exception.toString());
            }
            string7 = string2 + fs + "certadmin.jar" + ":" + string2 + fs + "jss32-jdk14.jar" + ":" + string6 + fs + "jre" + fs + "lib" + "jce.jar" + ":" + string2 + fs + "sunjce_provider.jar" + ":" + string2 + fs + "local_policy.jar" + ":" + string2 + fs + "US_export_policy.jar" + ":" + string3 + fs + "SUNWps" + fs + "locale";
        }
        try {
            string4 = string2 + fs + "solaris" + fs + "sparc" + fs + "libnssckbi.so";
            stringArray = string + fs + "libnssckbi.so";
            Util.copyFile(string4, (String)stringArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ConfigurationException(fileNotFoundException.toString());
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
        string4 = context.getJDKDir() + fs + "bin" + fs + "java";
        stringArray = new String[]{"-classpath", string7, "com.sun.portal.cli.cert.CertUtil", string, context.getCertPassword(), "en_US", context.getCertStart(), "", "server-cert", "6"};
        Vector<String> vector = new Vector<String>();
        vector.add("LD_LIBRARY_PATH=" + string2 + fs + "solaris" + fs + "sparc");
        try {
            SRATasks.runCommandLine(string4, stringArray, vector);
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
    }
}

