/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.config.util;

import com.sun.portal.config.ConfigurationContext;
import com.sun.portal.config.ConfigurationException;
import com.sun.portal.config.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;

public class PortalServerTasks
extends Util {
    private static ConfigurationContext context;
    private static String fs;
    private static String IS_SUFFIX;
    private static String PS_SUFFIX;
    private static String PS_TMP_DIR_SUFFIX;
    public static final String PAR_CMD_EXPORT = "export";
    public static final String PAR_CMD_DESCRIBE = "describe";
    public static final String PAR_CMD_CONTAINERS = "containers";
    public static final String PAR_CMD_IMPORT = "import";
    public static final String PAR_CMD_VERSION = "version";
    private static final String PAR_CLASS_EXPORT = "CmdExport";
    private static final String PAR_CLASS_DESCRIBE = "CmdDescribe";
    private static final String PAR_CLASS_CONTAINERS = "CmdContainers";
    private static final String PAR_CLASS_IMPORT = "CmdImport";
    private static final String PAR_CLASS_VERSION = "CmdVersion";

    public PortalServerTasks(ConfigurationContext configurationContext) {
        context = configurationContext;
        if (Util.is_windows()) {
            IS_SUFFIX = "";
            PS_SUFFIX = "";
            PS_TMP_DIR_SUFFIX = context.getPSBaseDir() + fs + "tmp";
        } else {
            IS_SUFFIX = fs + "SUNWam";
            PS_SUFFIX = fs + "SUNWps";
            PS_TMP_DIR_SUFFIX = fs + "var" + fs + "opt" + fs + "SUNWps" + fs + "tmp";
        }
    }

    public static InputStream ldapSearch(String string) throws ConfigurationException {
        if (string != null && string.trim().length() != 0) {
            String string2 = context.getISBaseDir() + IS_SUFFIX + fs + "bin" + fs + "ldapsearch";
            string2 = Util.is_windows() ? context.getISBaseDir() + IS_SUFFIX + fs + "tools" + fs + "ldapsearch" : context.getISBaseDir() + IS_SUFFIX + fs + "bin" + fs + "ldapsearch";
            String[] stringArray = new String[]{"-b ", "cn=schema", "-h", context.getDSHost(), "-p", context.getDSPort(), "-D", Util.decoratePath(context.getDSDirMgrDN()), "-w", context.getDirMgrPassword(), "(objectclass=" + string + ")"};
            Vector<String> vector = new Vector<String>();
            if (!Util.is_windows()) {
                vector.add("LD_LIBRARY_PATH=" + context.getISBaseDir() + IS_SUFFIX + fs + "ldaplib" + fs + "ldapsdk");
            }
            try {
                Util.debug("LdapSearch cmd:" + string2);
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < 11; ++i) {
                    stringBuffer.append(stringArray[i] + " ");
                }
                Util.debug("LdapSearch args:" + stringBuffer.toString());
                Util.debug("LdapSearch envs:" + vector);
                return PortalServerTasks.runCommandLine(string2, stringArray, vector);
            }
            catch (Exception exception) {
                throw new ConfigurationException(exception.toString());
            }
        }
        return null;
    }

    public static void ldapModify(File file, boolean bl) throws ConfigurationException {
        if (file.exists()) {
            String string = null;
            string = Util.is_windows() ? context.getISBaseDir() + IS_SUFFIX + fs + "tools" + fs + "ldapmodify" : context.getISBaseDir() + IS_SUFFIX + fs + "bin" + fs + "ldapmodify";
            String[] stringArray = new String[]{bl ? "-a" : "-c", "-h", context.getDSHost(), "-p", context.getDSPort(), "-D", Util.decoratePath(context.getDSDirMgrDN()), "-w", context.getDirMgrPassword(), "-v", "-f", Util.decoratePath(file.getAbsolutePath())};
            Vector<String> vector = new Vector<String>();
            if (!Util.is_windows()) {
                vector.add("LD_LIBRARY_PATH=" + context.getISBaseDir() + IS_SUFFIX + fs + "ldaplib" + fs + "ldapsdk");
            }
            try {
                PortalServerTasks.runCommandLine(string, stringArray, vector);
            }
            catch (Exception exception) {
                throw new ConfigurationException(exception.toString());
            }
        }
    }

    public static void loadSchema(File file) throws ConfigurationException {
        try {
            String string;
            PortalServerTasks.debug("loading Schema :" + file.getAbsolutePath());
            String string2 = PortalServerTasks.findTextInFile(file, "objectClasses:");
            int n = string2.indexOf("'", string2.indexOf("NAME"));
            int n2 = string2.indexOf("'", n + 1);
            string2 = string2.substring(n + 1, n2);
            PortalServerTasks.debug("loading Schema : doing ldapsearch on:" + string2);
            InputStream inputStream = PortalServerTasks.ldapSearch(string2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.indexOf(string2) < 0) continue;
                Util.debug(file.getName() + " already loaded");
                return;
            }
            PortalServerTasks.ldapModify(file, true);
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
        catch (NullPointerException nullPointerException) {
            throw new ConfigurationException(nullPointerException.toString());
        }
    }

    public static void loadServiceData(File file) throws ConfigurationException {
        PortalServerTasks.loadService(file, true);
    }

    public static void loadService(File file) throws ConfigurationException {
        PortalServerTasks.loadService(file, false);
    }

    private static void loadService(File file, boolean bl) throws ConfigurationException {
        if (file.exists()) {
            File file2 = new File(PS_TMP_DIR_SUFFIX + fs + "service" + fs + file.getName());
            File file3 = new File(file2.getParent());
            file3.mkdirs();
            try {
                if (!file2.createNewFile()) {
                    Util.debug(file.getName() + " already loaded");
                    return;
                }
            }
            catch (IOException iOException) {
                throw new ConfigurationException(iOException.toString());
            }
            try {
                PortalServerTasks.replaceTokenInFile(file, file2, "%DEPLOY_URI%", context.getDeployURI());
                PortalServerTasks.replaceTokenInFile(file2, "%DYNAMIC_URI%", context.getDeployURI());
                PortalServerTasks.replaceTokenInFile(file2, "INST_SERVER_DOMAIN", context.getSRAServerDomain());
                if (Util.is_windows()) {
                    PortalServerTasks.replaceTokenInFile(file2, "%IDSAME_BASEDIR%/SUNWam", context.getISBaseDir());
                    PortalServerTasks.replaceTokenInFile(file2, "%PS_BASEDIR%/SUNWps", context.getPSBaseDir());
                } else {
                    PortalServerTasks.replaceTokenInFile(file2, "%IDSAME_BASEDIR%", context.getISBaseDir());
                    PortalServerTasks.replaceTokenInFile(file2, "%PS_BASEDIR%", context.getPSBaseDir());
                }
            }
            catch (IOException iOException) {
                throw new ConfigurationException(iOException.toString());
            }
            String string = null;
            string = Util.is_windows() ? context.getISBaseDir() + IS_SUFFIX + fs + "bin" + fs + "amadmin.bat" : context.getISBaseDir() + IS_SUFFIX + fs + "bin" + fs + "amadmin";
            String[] stringArray = new String[]{"--runasdn", context.getAmAdminDN(), "--password", context.getISAdminPassword(), "--verbose", bl ? "--data" : "--schema", Util.decoratePath(file2.getAbsolutePath())};
            try {
                PortalServerTasks.runCommandLine(string, stringArray);
            }
            catch (Exception exception) {
                throw new ConfigurationException(exception.toString());
            }
        }
    }

    public static void loadRequest(File file) throws ConfigurationException {
        if (file.exists()) {
            String[] stringArray;
            String string;
            String string2 = PS_TMP_DIR_SUFFIX + fs + "request" + fs + file.getName();
            Util.debug("loadRequest:load tmp file:" + string2);
            string2 = string2.substring(0, string2.indexOf(".request"));
            File file2 = new File(string2 + ".xml");
            File file3 = new File(file2.getParent());
            file3.mkdirs();
            try {
                if (!file2.createNewFile()) {
                    Util.debug(file.getName() + " already loaded");
                    return;
                }
            }
            catch (IOException iOException) {
                throw new ConfigurationException(iOException.toString());
            }
            try {
                String string3;
                String string4;
                PortalServerTasks.replaceTokenInFile(file, file2, "%DEPLOY_URI%", context.getDeployURI());
                PortalServerTasks.replaceTokenInFile(file2, "%AUTHLESSANONYMOUS_DN%", context.getAuthlessAnonymousDN());
                PortalServerTasks.replaceTokenInFile(file2, "%GW_DOMAIN%", context.getSRAServerDomain());
                PortalServerTasks.replaceTokenInFile(file2, "%IDSAME_AMCONSOLE%", context.getISAmConsole());
                PortalServerTasks.replaceTokenInFile(file2, "%IDSAME_AMSERVER%", context.getISAmServer());
                if (Util.is_windows()) {
                    PortalServerTasks.replaceTokenInFile(file2, "%IDSAME_BASEDIR%/SUNWam", context.getISBaseDir());
                } else {
                    PortalServerTasks.replaceTokenInFile(file2, "%IDSAME_BASEDIR%", context.getISBaseDir());
                }
                PortalServerTasks.replaceTokenInFile(file2, "%IDSAME_LDAPUSER_PASSWORD%", context.getISLdapUserPassword());
                PortalServerTasks.replaceTokenInFile(file2, "%IDSAME_USER_NAMING%", context.getISUserNaming());
                if ("https".equalsIgnoreCase(context.getGWProtocol())) {
                    string = "true";
                    stringArray = context.getGWPort();
                    string4 = "false";
                    string3 = "80";
                } else {
                    string = "false";
                    stringArray = "443";
                    string4 = "true";
                    string3 = context.getGWPort();
                }
                String string5 = context.getServerPort();
                String string6 = "<Value>" + context.getServerProtocol() + "://" + context.getServerHost() + ":" + string5 + "</Value>";
                if ("80".equals(string5) || "443".equals(string5)) {
                    string6 = "<Value>" + context.getServerProtocol() + "://" + context.getServerHost() + "</Value>";
                }
                String string7 = context.getServerProtocol() + "://" + context.getServerHost() + ":" + string5;
                PortalServerTasks.replaceTokenInFile(file2, "INST_ENABLE_EPROXY", string);
                PortalServerTasks.replaceTokenInFile(file2, "INST_ENABLE_RPROXY", string4);
                PortalServerTasks.replaceTokenInFile(file2, "INST_EPROXY_PORT", (String)stringArray);
                PortalServerTasks.replaceTokenInFile(file2, "INST_FCURLS", string6);
                PortalServerTasks.replaceTokenInFile(file2, "INST_GWNAME", context.getSRAGatewayProfile());
                PortalServerTasks.replaceTokenInFile(file2, "INST_PS_SERVER_LIST", string7);
                PortalServerTasks.replaceTokenInFile(file2, "INST_RPROXY_PORT", string3);
                PortalServerTasks.replaceTokenInFile(file2, "INST_SERVER_DOMAIN", context.getSRAServerDomain());
                PortalServerTasks.replaceTokenInFile(file2, "INST_USE_PROXY", context.getSRAUseWebProxy());
                PortalServerTasks.replaceTokenInFile(file2, "INST_WEB_PROXY_DOMAIN", context.getSRAServerDomain());
                PortalServerTasks.replaceTokenInFile(file2, "INST_SUBDOMAIN", context.getSRAServerDomain());
                PortalServerTasks.replaceTokenInFile(file2, "%LOGIN_URL%", context.getDeployURI() + "/dt");
                PortalServerTasks.replaceTokenInFile(file2, "%ORG_DN%", context.getDefaultOrgDN());
                PortalServerTasks.replaceTokenInFile(file2, "%PEOPLE_DN%", context.getPeopleDN());
                PortalServerTasks.replaceTokenInFile(file2, "%ROOT_DN%", context.getRootSuffixDN());
                PortalServerTasks.replaceTokenInFile(file2, "%SRA_LOG_USER_PASSWORD%", context.getSRALogUserPassword());
            }
            catch (IOException iOException) {
                throw new ConfigurationException(iOException.toString());
            }
            string = null;
            string = Util.is_windows() ? context.getISBaseDir() + IS_SUFFIX + fs + "bin" + fs + "amadmin.bat" : context.getISBaseDir() + IS_SUFFIX + fs + "bin" + fs + "amadmin";
            stringArray = new String[]{"--runasdn", context.getAmAdminDN(), "--password", context.getISAdminPassword(), "--continue", "--verbose", "--data", Util.decoratePath(file2.getAbsolutePath())};
            try {
                PortalServerTasks.runCommandLine(string, stringArray);
            }
            catch (Exception exception) {
                throw new ConfigurationException(exception.toString());
            }
        }
    }

    public void isconfig() throws ConfigurationException {
        File file = new File(context.getPSBaseDir() + PS_SUFFIX + fs + PAR_CMD_EXPORT + fs + "ldif");
        FilenameFilter filenameFilter = Util.getExtensionFilter("ldif");
        File[] fileArray = file.listFiles(filenameFilter);
        for (int i = 0; i < fileArray.length; ++i) {
            Util.debug("Loading " + fileArray[i].getName());
            PortalServerTasks.loadSchema(fileArray[i]);
        }
        File file2 = new File(context.getPSBaseDir() + PS_SUFFIX + fs + PAR_CMD_EXPORT + fs + "service");
        filenameFilter = Util.getExtensionFilter("xml");
        File[] fileArray2 = file2.listFiles(filenameFilter);
        for (int i = 0; i < fileArray2.length; ++i) {
            Util.debug("Loading " + fileArray2[i].getName());
            PortalServerTasks.loadService(fileArray2[i]);
        }
        File file3 = new File(context.getPSBaseDir() + PS_SUFFIX + fs + PAR_CMD_EXPORT + fs + "request");
        filenameFilter = Util.getExtensionFilter("request");
        File[] fileArray3 = file3.listFiles(filenameFilter);
        for (int i = 0; i < fileArray3.length; ++i) {
            Util.debug("Loading " + fileArray3[i].getName());
            PortalServerTasks.loadRequest(fileArray3[i]);
        }
    }

    public static void loadRewriterRules(File file) throws ConfigurationException {
        if (file.exists()) {
            String string = null;
            string = Util.is_windows() ? context.getPSBaseDir() + PS_SUFFIX + fs + "bin" + fs + "rwadmin.bat" : context.getPSBaseDir() + PS_SUFFIX + fs + "bin" + fs + "rwadmin";
            String[] stringArray = new String[]{"store", "--runasdn", context.getAmAdminDN(), "--password", context.getISAdminPassword(), Util.decoratePath(file.getAbsolutePath())};
            try {
                PortalServerTasks.runCommandLine(string, stringArray);
            }
            catch (Exception exception) {
                throw new ConfigurationException(exception.toString());
            }
        }
    }

    public void deleteRuleSet(String string) throws ConfigurationException {
        String string2 = null;
        string2 = Util.is_windows() ? context.getPSBaseDir() + PS_SUFFIX + fs + "bin" + fs + "rwadmin.bat" : context.getPSBaseDir() + PS_SUFFIX + fs + "bin" + fs + "rwadmin";
        String[] stringArray = new String[]{"remove", "--runasdn", context.getAmAdminDN(), "--password", context.getISAdminPassword(), "--rulesetid", string};
        try {
            Util.debug("Deleting ruleset <" + string + ">");
            PortalServerTasks.runCommandLine(string2, stringArray);
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
    }

    public static void loadDisplayProfile(String[] stringArray) throws ConfigurationException {
        String string = null;
        string = Util.is_windows() ? context.getPSBaseDir() + PS_SUFFIX + fs + "bin" + fs + "dpadmin.bat" : context.getPSBaseDir() + PS_SUFFIX + fs + "bin" + fs + "dpadmin";
        try {
            Util.debug("loadDisplayProfile: command:" + string);
            PortalServerTasks.runCommandLine(string, stringArray);
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
    }

    public static void loadDisplayProfile(String[] stringArray, StringBuffer stringBuffer) throws ConfigurationException {
        Object object;
        File file;
        try {
            file = File.createTempFile("tmpfile1", ".xml");
            object = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            ((PrintWriter)object).write(stringBuffer.toString());
            ((PrintWriter)object).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ConfigurationException(fileNotFoundException.toString());
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
        object = null;
        object = Util.is_windows() ? context.getPSBaseDir() + PS_SUFFIX + fs + "bin" + fs + "dpadmin.bat" : context.getPSBaseDir() + PS_SUFFIX + fs + "bin" + fs + "dpadmin";
        int n = stringArray.length;
        String[] stringArray2 = new String[n + 1];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i];
        }
        stringArray2[n] = Util.decoratePath(file.getAbsolutePath());
        try {
            Util.debug("loadDisplayProfile2");
            PortalServerTasks.runCommandLine((String)object, stringArray2);
            file.delete();
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
    }

    public static void updateServerClassPath(String string) throws ConfigurationException {
        String string2 = context.getDeployType();
        if ("SUNONE".equals(string2)) {
            PortalServerTasks.updateSunOneServerClassPath(string);
        } else if ("IWS".equals(string2)) {
            PortalServerTasks.updateIWSServerClassPath(string);
        }
    }

    private static void updateSunOneServerClassPath(String string) throws ConfigurationException {
        try {
            File file = new File(context.getDeployDomain() + fs + context.getDeployInstance() + fs + "config" + fs + "server.xml");
            String string2 = Util.findTextInFile(file, string);
            if (string2 != null && string2.equals("")) {
                String string3 = Util.is_windows() ? ";" : ":";
                Util.replaceTokenInFile(file, "server-classpath=\"", "server-classpath=\"" + string + string3);
            }
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
    }

    private static void updateIWSServerClassPath(String string) throws ConfigurationException {
        try {
            File file = new File(context.getDeployDir() + fs + "https-" + context.getDeployInstance() + fs + "config" + fs + "server.xml");
            String string2 = Util.findTextInFile(file, string);
            if (string2 != null && string2.equals("")) {
                String string3 = Util.is_windows() ? ";" : ":";
                Util.replaceTokenInFile(file, "serverclasspath=\"", "serverclasspath=\"" + string + string3);
            }
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
    }

    public static void createMultiServerInstance(String string, String string2) throws ConfigurationException {
        PortalServerTasks.redeploy(string);
        PortalServerTasks.searchConfig(string, string2);
    }

    public static void deleteMultiServerInstance(String string) throws ConfigurationException {
        PortalServerTasks.undeploy(string);
    }

    public static void redeploy(String string) throws ConfigurationException {
        PortalServerTasks.deploy(string, context.getDeployURI());
    }

    public static void deploy(String string, String string2) throws ConfigurationException {
        PortalServerTasks.doWar(string, string2);
        String string3 = null;
        string3 = Util.is_windows() ? context.getPSBaseDir() + PS_SUFFIX + fs + "tmp" + fs + "deploy" : "/var/opt/SUNWps/tmp/deploy";
        PortalServerTasks.deployWar(string, string2, string3);
        if (Util.is_windows()) {
            PortalServerTasks.updateDesktopConfigPropertiesFile();
        }
    }

    private static void deployWar(String string, String string2, String string3) throws ConfigurationException {
        String string4 = context.getDeployType();
        if ("SUNONE".equals(string4)) {
            PortalServerTasks.deployWarToSunOne(string, string2, string3);
        } else if (!"WEBLOGIC".equals(string4) && !"WEBSPHERE".equals(string4) && "IWS".equals(string4)) {
            PortalServerTasks.deployWarToIWS(string, string2, string3);
        }
    }

    public static void doWar(String string, String string2) throws ConfigurationException {
        PortalServerTasks.mergeWebXml(string, string2);
        PortalServerTasks.importDeployFiles();
        PortalServerTasks.processPropertiesLocale();
        PortalServerTasks.createWarFile(string2);
        PortalServerTasks.removeImportedFiles();
    }

    private static void mergeWebXml(String string, String string2) throws ConfigurationException {
        String string3 = context.getPSBaseDir() + PS_SUFFIX + fs + "web-src";
        String string4 = string3 + fs + "WEB-INF" + fs + "xml";
        try {
            Object object;
            Object object2;
            Object object3;
            String string5 = context.getDeployType();
            String string6 = context.getPSBaseDir().replace('\\', '/');
            boolean bl = "SUNONE".equals(string5) || "IWS".equals(string5);
            String string7 = string4 + fs + "1.xml";
            File file = new File(string7);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            Util.appendLineEof(file, "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>", false);
            Util.appendLineEof(file, "", false);
            Util.appendLineEof(file, "<!DOCTYPE web-app PUBLIC", false);
            Util.appendLineEof(file, "  \"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN\"", false);
            if (Util.is_windows()) {
                if ("IWS".equals(string5)) {
                    Util.appendLineEof(file, "  \"file:" + string6 + "/config/dtd/web-app_2_3.dtd\">", false);
                } else if ("SUNONE".equals(string5)) {
                    Util.appendLineEof(file, "  \"file:" + string6 + "/config/dtd/web-app_2_3.dtd\">", false);
                }
            } else if ("IWS".equals(string5)) {
                Util.appendLineEof(file, "  \"file:" + context.getPSBaseDir() + "/SUNWps/dtd/web-app_2_3.dtd\">", false);
            } else if ("SUNONE".equals(string5)) {
                Util.appendLineEof(file, "  \"file:" + context.getPSBaseDir() + "/SUNWps/dtd/web-app_2_3.dtd\">", false);
            }
            Util.appendLineEof(file, "", false);
            Util.appendLineEof(file, "<web-app>", false);
            Util.appendLineEof(file, "  <icon/>", false);
            Util.appendLineEof(file, "  <display-name/>", false);
            Util.appendLineEof(file, "  <description/>", false);
            Util.appendLineEof(file, "  <distributable/>", false);
            Util.appendLineEof(file, "  <context-param>", false);
            Util.appendLineEof(file, "    <param-name>dynamicContext</param-name>", false);
            Util.appendLineEof(file, "    <param-value>" + string2 + "</param-value>", false);
            Util.appendLineEof(file, "  </context-param>", false);
            Util.appendLineEof(file, "  <context-param>", false);
            Util.appendLineEof(file, "    <param-name>staticContext</param-name>", false);
            Util.appendLineEof(file, "    <param-value>" + string2 + "</param-value>", false);
            Util.appendLineEof(file, "  </context-param>", false);
            Util.appendLineEof(file, "  <context-param>", false);
            Util.appendLineEof(file, "    <param-name>desktop.propertiesFile</param-name>", false);
            if (Util.is_windows()) {
                Util.appendLineEof(file, "    <param-value>" + string6 + PS_SUFFIX + "/config/desktop/desktopconfig.properties</param-value>", false);
            } else {
                Util.appendLineEof(file, "    <param-value>/etc/opt/SUNWps/desktop/desktopconfig.properties</param-value>", false);
            }
            Util.appendLineEof(file, "  </context-param>", false);
            if ("IWS".equals(string5)) {
                Util.appendLineEof(file, "    <filter/>", false);
                Util.appendLineEof(file, "    <filter-mapping/>", false);
            } else if ("SUNONE".equals(string5)) {
                Util.appendLineEof(file, "    <filter/>", false);
                Util.appendLineEof(file, "    <filter-mapping/>", false);
            }
            Util.appendLineEof(file, "  <listener/>", false);
            Util.appendLineEof(file, "  <servlet/>", false);
            Util.appendLineEof(file, "  <servlet-mapping/>", false);
            Util.appendLineEof(file, "  <session-config/>", false);
            Util.appendLineEof(file, "  <mime-mapping/>", false);
            Util.appendLineEof(file, "  <welcome-file-list/>", false);
            Util.appendLineEof(file, "  <error-page/>", false);
            Util.appendLineEof(file, "  <taglib/>", false);
            Util.appendLineEof(file, "  <resource-env-ref/>", false);
            Util.appendLineEof(file, "  <resource-ref/>", false);
            Util.appendLineEof(file, "  <security-constraint/>", false);
            Util.appendLineEof(file, "  <login-config/>", false);
            Util.appendLineEof(file, "  <security-role/>", false);
            Util.appendLineEof(file, "  <env-entry/>", false);
            Util.appendLineEof(file, "  <ejb-ref/>", false);
            Util.appendLineEof(file, "  <ejb-local-ref/>", false);
            Util.appendLineEof(file, "</web-app>", false);
            String string8 = string4 + fs + "search.xml-orig";
            String string9 = string4 + fs + "search.xml";
            try {
                Util.copyFile(string8, string9);
                object3 = new File(string9);
                Util.replaceTokenInFile((File)object3, "%DEPLOY_INSTANCE%", string);
                Util.replaceTokenInFile((File)object3, "%DYNAMIC_URI%", string2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new ConfigurationException(fileNotFoundException.toString());
            }
            catch (IOException iOException) {
                throw new ConfigurationException(iOException.toString());
            }
            object3 = null;
            String string10 = null;
            if (Util.is_windows()) {
                object3 = context.getISBaseDir() + IS_SUFFIX;
                object3 = ((String)object3).replace('\\', '/');
                string10 = context.getPSBaseDir() + PS_SUFFIX;
                string10 = string10.replace('\\', '/');
            }
            Vector vector = new Vector();
            File file2 = new File(string4);
            Util.getFilteredFiles(file2, vector, "xml");
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < vector.size(); ++i) {
                object2 = (File)vector.elementAt(i);
                if (Util.is_windows()) {
                    Util.replaceTokenInFile((File)object2, "/var/opt/SUNWam", (String)object3);
                    Util.replaceTokenInFile((File)object2, "/etc/opt/SUNWps", string10 + "/config");
                    Util.replaceTokenInFile((File)object2, "/var/opt/SUNWps", string10);
                }
                stringBuffer.append(Util.decoratePath(((File)object2).getAbsolutePath()));
                stringBuffer.append(" ");
            }
            String string11 = context.getJDKDir() + fs + "bin" + fs + "java";
            object2 = Util.is_windows() ? ";" : ":";
            String string12 = context.getPSBaseDir() + PS_SUFFIX + fs + "lib" + fs;
            String string13 = string12 + "jaxp.jar" + (String)object2 + string12 + "xalan.jar" + (String)object2 + string12 + "webxmlmerge.jar";
            String[] stringArray = new String[]{"-classpath", Util.decoratePath(string13), "com.sun.portal.webxmlmerge.WebxmlMerge", stringBuffer.toString()};
            File file3 = new File(string3 + fs + "WEB-INF" + fs + "web.xml");
            if (file3.exists()) {
                file3.delete();
            }
            file3.createNewFile();
            try {
                String string14;
                object = PortalServerTasks.runCommandLine(string11, stringArray);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
                while ((string14 = bufferedReader.readLine()) != null) {
                    Util.appendLineEof(file3, string14, false);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new ConfigurationException(exception.toString());
            }
            Util.deleteFile(string9);
            Util.deleteFile(file);
            object = Util.is_windows() ? context.getPSBaseDir() + PS_SUFFIX + fs + "tmp" + fs + "deploy" : "/var/opt/SUNWps/tmp/deploy";
            Util.deleteDir((String)object + fs + "xml");
            if (bl) {
                PortalServerTasks.generateSunWebXml(string, string2);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ConfigurationException(fileNotFoundException.toString());
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
    }

    private static void generateSunWebXml(String string, String string2) throws ConfigurationException {
        String string3 = context.getPSBaseDir() + PS_SUFFIX + fs + "web-src";
        String string4 = string3 + fs + "WEB-INF" + fs + "xml";
        Util.debug("Generating sun-web.xml file");
        String string5 = string3 + fs + "WEB-INF" + fs + "sun-web.xml";
        try {
            String string6 = context.getDeployType();
            String string7 = context.getPSBaseDir().replace('\\', '/');
            File file = new File(string5);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            Util.appendLineEof(file, "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>", false);
            Util.appendLineEof(file, "<!DOCTYPE sun-web-app PUBLIC", false);
            Util.appendLineEof(file, "  \"-//Sun Microsystems, Inc.//Sun ONE Application Server 7.0 Servlet 2.3//EN\"", false);
            if (Util.is_windows()) {
                Util.appendLineEof(file, "  \"file:" + string7 + "/config/dtd/sun-web-app_2_3-0.dtd\">", false);
            } else {
                Util.appendLineEof(file, "  \"file:" + context.getPSBaseDir() + "/SUNWps/dtd/sun-web-app_2_3-0.dtd\">", false);
            }
            Util.appendLineEof(file, "", false);
            Util.appendLineEof(file, "<sun-web-app>", false);
            Util.appendLineEof(file, "  <locale-charset-info>", false);
            Util.appendLineEof(file, "    <parameter-encoding form-hint-field=\"gx_charset\"/>", false);
            Util.appendLineEof(file, "  </locale-charset-info>", false);
            Util.appendLineEof(file, "  <session-config>", false);
            Util.appendLineEof(file, "    <cookie-properties>", false);
            Util.appendLineEof(file, "       <property name=\"cookiePath\" value=\"/\"/>", false);
            Util.appendLineEof(file, "    </cookie-properties>", false);
            Util.appendLineEof(file, "  </session-config>", false);
            Util.appendLineEof(file, "</sun-web-app>", false);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ConfigurationException(fileNotFoundException.toString());
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
    }

    private static void importDeployFiles() throws ConfigurationException {
        Util.debug("Processing deploy.import file");
        String string = context.getPSBaseDir() + PS_SUFFIX + fs + PAR_CMD_EXPORT + fs + "deploy.import";
        File file = new File(string);
        try {
            if (file.exists()) {
                String string2 = null;
                string2 = Util.is_windows() ? "%IS_BASEDIR%/SUNWam" : "%IS_BASEDIR%";
                String[] stringArray = new String[]{string2, "%PS_BASEDIR%", "%WEB_SRC_DIR%", "/etc/opt/SUNWps"};
                String[] stringArray2 = new String[]{context.getISBaseDir() + IS_SUFFIX, context.getPSBaseDir() + PS_SUFFIX, context.getPSBaseDir() + PS_SUFFIX + fs + "web-src", context.getPSBaseDir() + PS_SUFFIX + fs + "config"};
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                String string3 = null;
                while ((string3 = bufferedReader.readLine()) != null) {
                    if ((string3 = string3.trim()).equals("")) continue;
                    StringTokenizer stringTokenizer = new StringTokenizer(string3);
                    String string4 = null;
                    String string5 = null;
                    if (stringTokenizer.hasMoreTokens()) {
                        string4 = stringTokenizer.nextToken();
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        string5 = stringTokenizer.nextToken();
                    }
                    string4 = Util.replaceTokens(string4, stringArray, stringArray2);
                    string5 = Util.replaceTokens(string5, stringArray, stringArray2);
                    if (Util.directoryExists(string4)) {
                        if (Util.directoryExists(string5)) {
                            Util.deleteDir(string5);
                        }
                        Util.copyDir(string4, string5);
                        Util.debug("Copying dir:" + string4 + ":to:" + string5);
                        continue;
                    }
                    if (!Util.fileExists(string4)) continue;
                    if (Util.fileExists(string5)) {
                        Util.deleteFile(string5);
                    }
                    Util.copyFile(string4, string5);
                    Util.debug("Copying File:" + string4 + ":to:" + string5);
                }
                bufferedReader.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ConfigurationException(fileNotFoundException.toString());
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
    }

    private static void removeImportedFiles() throws ConfigurationException {
        Util.debug("Removing files imported from deploy.import file");
        String string = context.getPSBaseDir() + PS_SUFFIX + fs + PAR_CMD_EXPORT + fs + "deploy.import";
        File file = new File(string);
        try {
            if (file.exists()) {
                String string2 = null;
                string2 = Util.is_windows() ? "%IS_BASEDIR%/SUNWam" : "%IS_BASEDIR%";
                String[] stringArray = new String[]{string2, "%PS_BASEDIR%", "%WEB_SRC_DIR%"};
                String[] stringArray2 = new String[]{context.getISBaseDir() + IS_SUFFIX, context.getPSBaseDir() + PS_SUFFIX, context.getPSBaseDir() + PS_SUFFIX + fs + "web-src"};
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                String string3 = null;
                while ((string3 = bufferedReader.readLine()) != null) {
                    if ((string3 = string3.trim()).equals("")) continue;
                    StringTokenizer stringTokenizer = new StringTokenizer(string3);
                    String string4 = null;
                    String string5 = null;
                    if (stringTokenizer.hasMoreTokens()) {
                        string4 = stringTokenizer.nextToken();
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        string5 = stringTokenizer.nextToken();
                    }
                    if (Util.directoryExists(string5 = Util.replaceTokens(string5, stringArray, stringArray2))) {
                        Util.deleteDir(string5);
                    } else if (Util.fileExists(string5)) {
                        Util.deleteFile(string5);
                    }
                    Util.debug("Deleting:" + string5);
                }
                bufferedReader.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ConfigurationException(fileNotFoundException.toString());
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
    }

    private static void processPropertiesLocale() {
        File file = new File(context.getPSBaseDir() + PS_SUFFIX + fs + "web-src" + fs + "WEB-INF");
        try {
            FilenameFilter filenameFilter = Util.getExtensionFilter("properties");
            File[] fileArray = file.listFiles(filenameFilter);
            for (int i = 0; i < fileArray.length; ++i) {
                String string = fileArray[i].getName().substring(0, fileArray[i].getName().indexOf(".properties"));
                String string2 = file.getAbsolutePath() + fs + string + "_en.properties";
                if (Util.fileExists(string2)) continue;
                Util.copyFile(fileArray[i].getAbsolutePath(), string2);
            }
        }
        catch (IOException iOException) {
            Util.debug("Error processing properties locale" + iOException);
        }
    }

    private static void createWarFile(String string) throws ConfigurationException {
        String string2 = context.getPSBaseDir() + PS_SUFFIX + fs + "web-src";
        Util.debug("Creating war file");
        String string3 = null;
        string3 = Util.is_windows() ? context.getPSBaseDir() + PS_SUFFIX + fs + "tmp" + fs + "deploy" : "/var/opt/SUNWps/tmp/deploy";
        Util.makeDir(string3);
        String string4 = string3 + fs + string + ".war";
        String string5 = context.getJDKDir() + fs + "bin" + fs + "jar";
        File file = new File(string2);
        String[] stringArray = new String[]{"cf", Util.decoratePath(string4), "*"};
        Vector vector = new Vector();
        try {
            PortalServerTasks.runCommandLine(string5, stringArray, vector, file);
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
    }

    private static void deployWarToIWS(String string, String string2, String string3) throws ConfigurationException {
        Util.debug("Deploying to IWS");
        String string4 = null;
        string4 = Util.is_windows() ? context.getDeployDir() + fs + "bin" + fs + "https" + fs + "httpadmin" + fs + "bin" + fs + "wdeploy.bat" : context.getDeployDir() + fs + "bin" + fs + "https" + fs + "httpadmin" + fs + "bin" + fs + "wdeploy";
        File file = new File(string4);
        if (!file.exists()) {
            throw new ConfigurationException("Deploy utility for SunOne WebServer missing:" + string4);
        }
        String string5 = string3 + fs + "web-apps" + fs + "https-" + context.getDeployInstance() + fs + string2;
        String string6 = string3 + fs + string2 + ".war";
        String[] stringArray = new String[]{"deploy -u", string2, "-i", string, "-v", "https-" + string, "-d", Util.decoratePath(string5), Util.decoratePath(string6)};
        Vector<String> vector = new Vector<String>();
        vector.add("IWS_SERVER_HOME=" + context.getDeployDir());
        try {
            PortalServerTasks.runCommandLine(string4, stringArray, vector);
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
    }

    private static void deployWarToSunOne(String string, String string2, String string3) throws ConfigurationException {
        Util.debug("Deploying to SunOne");
        String string4 = null;
        string4 = Util.is_windows() ? context.getDeployDir() + fs + "bin" + fs + "asadmin.bat" : context.getDeployDir() + fs + "bin" + fs + "asadmin";
        File file = new File(string4);
        if (!file.exists()) {
            throw new ConfigurationException("Deploy utility for SunOne AppServer missing:" + string4);
        }
        String string5 = null;
        string5 = string2.startsWith("/") ? string2.substring(1) : string2;
        String string6 = string3 + fs + string2 + ".war";
        String[] stringArray = new String[16];
        stringArray[0] = "deploy -u";
        stringArray[1] = context.getDeployAdmin();
        stringArray[2] = "-w";
        stringArray[3] = context.getDeployAdminPassword();
        stringArray[4] = "-p";
        stringArray[5] = context.getDeployAdminPort();
        stringArray[6] = "-H";
        stringArray[7] = context.getServerHost();
        stringArray[8] = "--instance";
        stringArray[9] = string;
        stringArray[10] = "--name";
        stringArray[11] = string5;
        if (string5.equals("portal")) {
            stringArray[12] = "--contextroot ";
            stringArray[13] = string2;
        } else {
            stringArray[12] = "";
            stringArray[13] = "";
        }
        stringArray[14] = "--type web ";
        stringArray[15] = Util.decoratePath(string6);
        try {
            PortalServerTasks.runCommandLine(string4, stringArray);
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
    }

    private static void updateDesktopConfigPropertiesFile() throws ConfigurationException {
        if (!Util.is_windows()) {
            return;
        }
        String string = context.getPSBaseDir() + PS_SUFFIX + fs + "config" + fs + "desktop" + fs + "desktopconfig.properties";
        File file = new File(string);
        if (file.exists()) {
            try {
                String string2 = "jspCompilerWARClassPath=";
                String string3 = Util.findTextInFile(file, string2);
                String string4 = context.getPSBaseDir().replace('\\', '/');
                if (string3.indexOf("%PS_BASEDIR%") >= 0) {
                    string3 = string3.replace(':', ';');
                    string3 = Util.replaceToken(string3, "%PS_BASEDIR%/SUNWps", string4);
                    Util.debug(string2 + string3);
                    Util.replaceLineInFile(file, string2, new StringBuffer(string3));
                }
                String string5 = string4 + "/config";
                Util.replaceTokenInFile(file, "/etc/opt/SUNWps", string5);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new ConfigurationException(fileNotFoundException.toString());
            }
            catch (IOException iOException) {
                throw new ConfigurationException(iOException.toString());
            }
        }
    }

    public static void undeploy(String string) throws ConfigurationException {
        PortalServerTasks.undeploy(string, context.getDeployURI());
    }

    public static void undeploy(String string, String string2) throws ConfigurationException {
        PortalServerTasks.checkRequiredAttributesForUndeploy();
        String string3 = context.getDeployType();
        if ("SUNONE".equals(string3)) {
            PortalServerTasks.undeploySunOne(string, string2);
        } else if ("WEBLOGIC".equals(string3)) {
            PortalServerTasks.undeployWeblogic(string, string2);
        } else if ("WEBSPHERE".equals(string3)) {
            PortalServerTasks.undeployWebsphere(string, string2);
        } else if ("IWS".equals(string3)) {
            PortalServerTasks.undeployIWS(string, string2);
        }
    }

    private static void undeployIWS(String string, String string2) throws ConfigurationException {
        String string3 = null;
        string3 = Util.is_windows() ? context.getDeployDir() + fs + "bin" + fs + "https" + fs + "httpadmin" + fs + "bin" + fs + "wdeploy.bat" : context.getDeployDir() + fs + "bin" + fs + "https" + fs + "httpadmin" + fs + "bin" + fs + "wdeploy";
        File file = new File(string3);
        if (!file.exists()) {
            throw new ConfigurationException("Deploy utility for SunOne WebServer missing:" + string3);
        }
        String[] stringArray = new String[]{"delete -u", string2, "-i", string, "-v", "https-" + string, "hard"};
        Vector<String> vector = new Vector<String>();
        vector.add("IWS_SERVER_HOME=" + context.getDeployDir());
        try {
            PortalServerTasks.runCommandLine(string3, stringArray, vector);
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
    }

    private static void undeployWebsphere(String string, String string2) throws ConfigurationException {
        File file = null;
        try {
            file = File.createTempFile("undeploy", ".tcl");
            Util.appendLineEof(file, "EnterpriseApp stop /EnterpriseApp:" + string2 + "/", false);
            Util.appendLineEof(file, "EnterpriseApp remove /EnterpriseApp:" + string2 + "/ -recursive", false);
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
        String string3 = null;
        string3 = Util.is_windows() ? context.getDeployDir() + fs + "bin" + fs + "wscp.bat" : context.getDeployDir() + fs + "bin" + fs + "wscp.sh";
        String[] stringArray = new String[]{"-f", Util.decoratePath(file.getAbsolutePath())};
        try {
            PortalServerTasks.runCommandLine(string3, stringArray);
            file.delete();
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
        string3 = Util.is_windows() ? context.getDeployDir() + fs + "bin" + fs + "GenPluginCfg.bat" : context.getDeployDir() + fs + "bin" + fs + "GenPluginCfg.sh";
        stringArray[0] = "-adminNodeName";
        stringArray[1] = context.getServerHost();
        try {
            PortalServerTasks.runCommandLine(string3, stringArray);
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
    }

    private static void undeployWeblogic(String string, String string2) throws ConfigurationException {
        string2 = Util.replaceToken(string2, "^", "");
        String string3 = context.getJDKDir() + fs + "bin" + fs + "java";
        String[] stringArray = new String[]{"-classpath", context.getDeployDir(), fs + "lib" + fs + "weblogic.jar", "weblogic.deploy -url", context.getDeployAdminProtocol(), "://", context.getDeployAdminHost(), ":", context.getDeployAdminPort(), "-component", string2, ":", string, "delete", context.getDeployAdminPassword(), string2};
        try {
            PortalServerTasks.runCommandLine(string3, stringArray);
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
    }

    private static void undeploySunOne(String string, String string2) throws ConfigurationException {
        String string3 = Util.is_windows() ? context.getDeployDir() + fs + "bin" + fs + "asadmin.bat" : context.getDeployDir() + fs + "bin" + fs + "asadmin";
        File file = new File(string3);
        if (!file.exists()) {
            throw new ConfigurationException("Deploy utility for SunOne AppServer missing:" + string3);
        }
        String string4 = null;
        string4 = string2.startsWith("/") ? string2.substring(1) : string2;
        String[] stringArray = new String[]{"undeploy -u", context.getDeployAdmin(), "-w", context.getDeployAdminPassword(), "-p", context.getDeployAdminPort(), "-H", context.getServerHost(), "--instance", string, "--type web", string4};
        try {
            PortalServerTasks.runCommandLine(string3, stringArray);
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
    }

    public static void searchConfig(String string, String string2) throws ConfigurationException {
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        Util.debug("Do Search Config");
        if (Util.is_windows() && "IWS".equals(context.getDeployType())) {
            Util.debug("Copying libdb, icu, scheduler files to webserver bin");
            string8 = context.getDeployDir() + fs + "bin" + fs + "https" + fs + "bin";
            string7 = context.getPSBaseDir() + fs + "lib";
            string6 = "libdb33.dll";
            string5 = "libdb_java33.dll";
            string4 = "icuuc2d.dll";
            string3 = "scheduleTask.dll";
            try {
                if (!Util.fileExists(string8 + fs + string6) && Util.fileExists(string7 + fs + string6)) {
                    Util.copyFile(string7 + fs + string6, string8 + fs + string6);
                }
                if (!Util.fileExists(string8 + fs + string5) && Util.fileExists(string7 + fs + string5)) {
                    Util.copyFile(string7 + fs + string5, string8 + fs + string5);
                }
                if (!Util.fileExists(string8 + fs + string4) && Util.fileExists(string7 + fs + string4)) {
                    Util.copyFile(string7 + fs + string4, string8 + fs + string4);
                }
                if (!Util.fileExists(string8 + fs + string3) && Util.fileExists(string7 + fs + string3)) {
                    Util.copyFile(string7 + fs + string3, string8 + fs + string3);
                }
            }
            catch (IOException iOException) {
                Util.debug("Error copying files:" + iOException.getMessage());
            }
        }
        try {
            string8 = context.getPSBaseDir() + PS_SUFFIX + fs + "https-" + string + fs + context.getDeployURI();
            if (Util.directoryExists(string8)) {
                string7 = context.getPSBaseDir() + PS_SUFFIX + fs + "SAVE-https-" + string + fs + context.getDeployURI();
                if (Util.directoryExists(string7)) {
                    Util.deleteDir(string7);
                }
                Util.renameDir(string8, string7);
            }
            Util.makeDir(string8);
            string7 = context.getPSBaseDir();
            if (Util.is_windows()) {
                string7 = string7.replace('\\', '/');
                string8 = string8.replace('\\', '/');
            }
            Util.debug("Run SearchSetup class");
            string6 = context.getPSBaseDir() + PS_SUFFIX + fs + "lib" + fs;
            string5 = Util.is_windows() ? ";" : ":";
            string4 = "." + string5 + string6 + "searchserver.jar" + string5 + string6 + "db.jar" + string5 + string6 + "ktsearch.jar";
            string3 = "IWS".equals(context.getDeployType()) ? "n" : "y";
            String string9 = context.getJDKDir() + fs + "bin" + fs + "java";
            String[] stringArray = new String[]{"-classpath", Util.decoratePath(string4), "com/sun/portal/search/rdmgr/SearchSetup", Util.decoratePath(string7), Util.decoratePath(string8), string3, context.getServerHost(), string2, string};
            Vector<String> vector = new Vector<String>();
            if (Util.is_windows()) {
                vector.add("PATH=" + string6);
                Util.debug("Adding env var:SYSTEMROOT=" + System.getProperty("SYSTEMROOT"));
                Util.debug("Adding env var:COMSPEC=" + System.getProperty("COMSPEC"));
                vector.add("SYSTEMROOT=" + System.getProperty("SYSTEMROOT"));
                vector.add("COMSPEC=" + System.getProperty("COMSPEC"));
            } else {
                vector.add("LD_LIBRARY_PATH=" + string6);
            }
            PortalServerTasks.runCommandLine(string9, stringArray, vector);
            Util.debug("Load SunPortalSearchService");
            if (Util.directoryExists(context.getISBaseDir() + IS_SUFFIX)) {
                String string10 = context.getServerProtocol() + "://" + context.getServerHost() + ":" + string2 + context.getDeployURI();
                Util.debug("Search URL" + string10);
                File file = File.createTempFile("SUNWpsse_requests", ".xml");
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
                fileWriter.write("<!DOCTYPE Requests\n");
                fileWriter.write("  PUBLIC \"-//iPlanet//iDSAME 5.0 Admin CLI DTD//EN\"\n");
                fileWriter.write("  \"file:" + context.getISBaseDir() + IS_SUFFIX + "/dtd/amAdmin.dtd\">\n");
                fileWriter.write("<Requests>\n");
                fileWriter.write("  <SchemaRequests serviceName=\"SunPortalSearchService\" SchemaType=\"global\">\n");
                fileWriter.write("    <AddDefaultValues>\n");
                fileWriter.write("      <AttributeValuePair>\n");
                fileWriter.write("          <Attribute name=\"sunPortalSearchInstances\"/>\n");
                fileWriter.write("          <Value>" + string10 + "</Value>\n");
                fileWriter.write("      </AttributeValuePair>\n");
                fileWriter.write("    </AddDefaultValues>\n");
                fileWriter.write("  </SchemaRequests>\n");
                fileWriter.write("</Requests>\n");
                fileWriter.close();
                PortalServerTasks.loadServiceData(file);
                file.delete();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ConfigurationException(fileNotFoundException.toString());
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
    }

    public static void runCsCli(String[] stringArray) throws ConfigurationException {
        String string = null;
        string = Util.is_windows() ? context.getPSBaseDir() + PS_SUFFIX + fs + "https-" + context.getDeployInstance() + fs + context.getDeployURI() + fs + "run-cs-cli.bat" : context.getPSBaseDir() + PS_SUFFIX + fs + "https-" + context.getDeployInstance() + fs + context.getDeployURI() + fs + "run-cs-cli";
        try {
            PortalServerTasks.runCommandLine(string, stringArray);
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
    }

    private static boolean checkRequiredAttributesForUndeploy() throws ConfigurationException {
        String[] stringArray;
        String[] stringArray2 = new String[]{"DEPLOY_TYPE", "DEPLOY_DIR", "com.iplanet.am.jdk.path", "IDSAME_BASEDIR", "BASEDIR", "com.iplanet.am.server.protocol", "com.iplanet.am.server.host", "com.iplanet.am.server.port", "DEPLOY_URI"};
        if (!context.checkRequiredAttributes(stringArray2)) {
            throw new ConfigurationException("Required Keys for undeploy missing");
        }
        String string = context.getDeployType();
        if ("SUNONE".equals(string)) {
            String[] stringArray3 = new String[]{"DEPLOY_DOMAIN", "DEPLOY_ADMIN", "DEPLOY_ADMIN_PORT"};
            if (!context.checkRequiredAttributes(stringArray3)) {
                throw new ConfigurationException("Required Keys for SunOne AppServer undeploy missing");
            }
        } else if ("WEBLOGIC".equals(string)) {
            String[] stringArray4 = new String[]{"DEPLOY_DOMAIN", "DEPLOY_ADMIN_PROTOCOL", "com.iplanet.am.server.host"};
            if (!context.checkRequiredAttributes(stringArray4)) {
                throw new ConfigurationException("Required Keys for Weblogic AppServer undeploy missing");
            }
        } else if ("WEBSPHERE".equals(string) && !context.checkRequiredAttributes(stringArray = new String[]{"DEPLOY_DOMAIN", "DEPLOY_VIRTUAL_HOST", "DEPLOY_INSTANCE"})) {
            throw new ConfigurationException("Required Keys for Websphere AppServer undeploy missing");
        }
        return true;
    }

    public static String getJDKVersion() throws ConfigurationException {
        String string = context.getJDKDir() + fs + "bin" + fs + "java";
        String[] stringArray = new String[]{"-fullversion"};
        byte[] byArray = null;
        String string2 = "1.4";
        try {
            InputStream inputStream = Util.runCommandLine(string, stringArray);
            inputStream.read(byArray);
            String string3 = new String(byArray);
            if (string3 != null && string3.trim().length() != 0) {
                if (string3.indexOf("1.4") >= 0) {
                    string2 = "1.4";
                } else if (string3.indexOf("1.3") >= 0) {
                    string2 = "1.3";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public static void pdeploy(String string, String[] stringArray) throws ConfigurationException {
        String string2;
        Object object;
        Object object2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        Object object3;
        String string8;
        Object object4;
        String string9;
        String string10;
        String string11;
        Object object5;
        String string12;
        String string13;
        String string14;
        String string15;
        Util.debug("Call PS Portlet Cli...");
        if (Util.is_windows()) {
            string15 = context.getPSBaseDir() + PS_SUFFIX + fs + "tmp" + fs + "portlet";
            string14 = context.getISBaseDir() + fs + "config";
            string13 = context.getPSBaseDir() + fs + "config";
        } else {
            string15 = "/var/opt/SUNWps/tmp/portlet";
            string14 = fs + "etc" + fs + "opt" + IS_SUFFIX + fs + "config";
            string13 = fs + "etc" + fs + "opt" + PS_SUFFIX;
        }
        if (!Util.directoryExists(string15)) {
            Util.makeDir(string15);
        }
        if (Util.is_windows()) {
            Util.debug("Replace /etc/opt/SUNWps,/var/opt/SUNWps,/var/opt/SUNWam  in PDConfig.properties");
            try {
                string12 = string13 + fs + "portlet" + fs + "PDConfig.properties";
                object5 = new File(string12);
                if (((File)object5).exists()) {
                    string11 = string13.replace('\\', '/');
                    Util.debug("Replacing token:/etc/opt/SUNWps with:" + string11);
                    Util.replaceTokenInFile((File)object5, "/etc/opt/SUNWps", string11);
                    string10 = context.getPSBaseDir().replace('\\', '/');
                    Util.debug("Replacing token:/var/opt/SUNWps with:" + string10);
                    Util.replaceTokenInFile((File)object5, "/var/opt/SUNWps", string10);
                    string9 = context.getISBaseDir().replace('\\', '/');
                    Util.debug("Replacing token:/var/opt/SUNWam with:" + string9);
                    Util.replaceTokenInFile((File)object5, "/var/opt/SUNWam", string9);
                }
            }
            catch (IOException iOException) {
                throw new ConfigurationException(iOException.toString());
            }
            Util.debug("original portletsamples.war web.xml hardcodes web-app_2_3.dtd,sun-web-app_2_3-0.dtd files in web.xml template. replacing these to pick up from PS_BASE_DIR/config");
            try {
                string12 = string13.replace('\\', '/');
                object5 = "/etc/opt/SUNWps";
                string11 = string12;
                string10 = context.getPSBaseDir() + PS_SUFFIX + fs + "samples" + fs + "portlet" + fs + "original" + fs + "portletsamples.war";
                string9 = "WEB-INF" + fs + "web.xml";
                string9 = string9.replace('\\', '/');
                object4 = Util.extractFileFromJar(string10, string9);
                Util.replaceTokenInFile((File)object4, (String)object5, string11);
                Util.addFileToJar(string10, string9, (File)object4);
                string8 = "WEB-INF" + fs + "sun-web.xml";
                string8 = string8.replace('\\', '/');
                object3 = Util.extractFileFromJar(string10, string8);
                Util.replaceTokenInFile((File)object3, (String)object5, string11);
                Util.addFileToJar(string10, string8, (File)object3);
            }
            catch (IOException iOException) {
                throw new ConfigurationException(iOException.toString());
            }
        }
        string12 = Util.is_windows() ? ";" : ":";
        object5 = context.getISBaseDir() + IS_SUFFIX;
        string11 = (String)object5 + fs + "locale";
        string10 = (String)object5 + fs + "lib";
        string9 = string10 + fs + "servlet.jar";
        string8 = null;
        object4 = Util.is_windows() ? string10 + fs + "jss311.jar" : fs + "usr" + fs + "share" + fs + "lib" + fs + "mps" + fs + "secv1" + fs + "jss3.jar";
        object3 = string10 + fs + "jaas.jar";
        String string16 = string10 + fs + "am_sdk.jar" + string12 + string10 + fs + "am_services.jar";
        String string17 = string11 + string12 + string10 + string12 + string16 + string12 + (String)object4 + string12 + string9 + string12 + (String)object3;
        String string18 = context.getPSBaseDir() + PS_SUFFIX + fs + "lib";
        String string19 = context.getPSBaseDir() + PS_SUFFIX + fs + "web-src" + fs + "WEB-INF";
        String string20 = string19 + fs + "classes";
        String string21 = string19 + fs + "lib" + fs + "rewriter.jar";
        String string22 = string19 + fs + "lib" + fs + "desktop.jar";
        String string23 = string18 + fs + "portletcommon.jar";
        String string24 = string18 + fs + "jdom.jar";
        String string25 = string18 + fs + "portletcontainercommon.jar";
        String string26 = string18 + fs + "deployer.jar";
        String string27 = string20 + string12 + string21 + string12 + string23 + string12 + string24 + string12 + string25 + string12 + string22 + string12 + string26;
        if (Util.is_windows()) {
            string7 = string10 + fs + "jaxp-api.jar";
            string6 = string10 + fs + "endorsed" + fs + "xercesImpl.jar";
            string5 = string10 + fs + "endorsed" + fs + "dom.jar";
            string4 = string10 + fs + "endorsed" + fs + "xalan.jar";
            string3 = string10 + fs + "endorsed" + fs + "sax.jar";
        } else {
            string7 = string10 + fs + "jaxp-api.jar";
            string6 = string10 + fs + "xercesImpl.jar";
            string5 = string10 + fs + "dom.jar";
            string4 = string10 + fs + "xalan.jar";
            string3 = string10 + fs + "sax.jar";
        }
        String string28 = string7 + string12 + string6 + string12 + string4 + string12 + string5 + string12 + string3;
        String string29 = context.getJDKDir() + fs + "lib" + fs + "lib.zip";
        String string30 = string27 + string12 + string17 + string12 + string28 + string12 + string29;
        String string31 = context.getJDKDir() + fs + "bin" + fs + "java";
        int n = 0;
        if (stringArray == null) {
            return;
        }
        n = stringArray.length;
        String[] stringArray2 = new String[8 + n];
        stringArray2[0] = " -Xms64m -Xmx256m ";
        stringArray2[1] = "-classpath " + Util.decoratePath(string30);
        boolean bl = false;
        String string32 = fs + "tempPSinstall";
        if (context.getPSBaseDir().indexOf(" ") == -1) {
            stringArray2[2] = "-DDDSchemaLocation=\"" + context.getPSBaseDir() + PS_SUFFIX + fs + "dtd" + "\"";
        } else {
            bl = true;
            File file = new File(string32);
            if (file.exists()) {
                file.delete();
            }
            try {
                Util.copyDir(context.getPSBaseDir() + PS_SUFFIX + fs + "dtd", string32 + fs + "dtd");
                stringArray2[2] = "-DDDSchemaLocation=\"" + string32 + fs + "dtd" + "\"";
            }
            catch (Exception exception) {
                Util.debug("Error copying:" + exception);
            }
        }
        stringArray2[3] = "-Dcom.iplanet.coreservices.configpath=\"" + string14 + fs + "ums" + "\"";
        stringArray2[4] = "-Ddesktop.propertiesFile=\"" + string13 + fs + "desktop" + fs + "desktopconfig.properties" + "\"";
        stringArray2[5] = "-Ddeployer.propertiesFile=\"" + string13 + fs + "portlet" + fs + "PDConfig.properties" + "\"";
        stringArray2[6] = "com.sun.portal.portlet.cli.PortletDeployerMain";
        stringArray2[7] = string;
        for (int i = 0; i < n; ++i) {
            stringArray2[8 + i] = stringArray[i];
        }
        Vector<String> vector = new Vector<String>();
        if (Util.is_windows()) {
            object2 = System.getProperty("PATH");
            object = string10 + ";" + string10 + "\\jss;";
            if (object2 != null) {
                object = (String)object + (String)object2;
            }
            vector.add("PATH=" + (String)object);
            Util.debug("set env PATH=" + (String)object);
            string8 = System.getProperty("SYSTEMROOT");
            if (string8 == null || "".equals(string8.trim())) {
                string8 = "C:\\WINNT";
                if (System.getProperty("os.name").equals("Windows XP")) {
                    string8 = "C:\\WINDOWS";
                }
            }
            vector.add("SYSTEMROOT=" + string8);
        } else {
            vector.add("LD_LIBRARY_PATH=" + string10);
        }
        try {
            object2 = PortalServerTasks.runCommandLine(string31, stringArray2, vector);
            if ("y".equals(System.getProperty("PS_CMDLINE_OUTPUT"))) {
                object = new BufferedReader(new InputStreamReader((InputStream)object2));
                while ((string2 = ((BufferedReader)object).readLine()) != null) {
                    System.out.println(string2);
                }
            }
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
        if (n <= 0) {
            return;
        }
        object2 = stringArray[n - 1];
        object = ((String)object2).substring(((String)object2).lastIndexOf(fs) + 1);
        if (object == null || object == "") {
            return;
        }
        string2 = "/" + ((String)object).substring(0, ((String)object).lastIndexOf(".war"));
        if (string2 == null || string2 == "") {
            return;
        }
        Util.debug("Deploying War File: name:" + string2);
        if ("deploy".equals(string)) {
            PortalServerTasks.deployWar(context.getDeployInstance(), string2, string15);
        } else if ("undeploy".equals(string)) {
            PortalServerTasks.undeploy(context.getDeployInstance(), string2);
        }
        Util.deleteFile(string15 + fs + (String)object);
        if (bl) {
            Util.deleteDir(string32);
        }
    }

    public static void par(String string, String[] stringArray) throws ConfigurationException {
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9 = null;
        if (PAR_CMD_EXPORT.equals(string)) {
            string9 = PAR_CLASS_EXPORT;
        } else if (PAR_CMD_DESCRIBE.equals(string)) {
            string9 = PAR_CLASS_DESCRIBE;
        } else if (PAR_CMD_CONTAINERS.equals(string)) {
            string9 = PAR_CLASS_CONTAINERS;
        } else if (PAR_CMD_IMPORT.equals(string)) {
            string9 = PAR_CLASS_IMPORT;
        } else if (PAR_CMD_VERSION.equals(string)) {
            string9 = PAR_CLASS_VERSION;
        }
        if (string9 == null) {
            return;
        }
        if (Util.is_windows()) {
            string8 = context.getISBaseDir() + fs + "config";
            string7 = context.getPSBaseDir() + fs + "config";
        } else {
            string8 = fs + "etc" + fs + "opt" + IS_SUFFIX + fs + "config";
            string7 = fs + "etc" + fs + "opt" + PS_SUFFIX;
        }
        String string10 = Util.is_windows() ? ";" : ":";
        String string11 = context.getISBaseDir() + IS_SUFFIX;
        String string12 = string11 + fs + "locale";
        String string13 = string11 + fs + "lib";
        String string14 = string13 + fs + "servlet.jar";
        String string15 = Util.is_windows() ? string13 + fs + "jss311.jar" : fs + "usr" + fs + "share" + fs + "lib" + fs + "mps" + fs + "secv1" + fs + "jss3.jar";
        String string16 = string13 + fs + "jaas.jar";
        String string17 = string13 + fs + "mail.jar";
        String string18 = string13 + fs + "am_sdk.jar" + string10 + string13 + fs + "am_services.jar";
        String string19 = string12 + string10 + string13 + string10 + string18 + string10 + string15 + string10 + string14 + string10 + string16 + string10 + string17;
        String string20 = context.getPSBaseDir() + PS_SUFFIX + fs + "lib";
        String string21 = context.getPSBaseDir() + PS_SUFFIX + fs + "web-src" + fs + "WEB-INF";
        String string22 = string21 + fs + "classes";
        String string23 = string21 + fs + "lib" + fs + "rewriter.jar";
        String string24 = string21 + fs + "lib" + fs + "desktop.jar";
        String string25 = string20 + string10 + string22 + string10 + string23 + string10 + string24;
        if (Util.is_windows()) {
            string6 = string13 + fs + "jaxp-api.jar";
            string5 = string13 + fs + "endorsed" + fs + "xercesImpl.jar";
            string4 = string13 + fs + "endorsed" + fs + "xalan.jar";
            string3 = string13 + fs + "endorsed" + fs + "dom.jar";
            string2 = string13 + fs + "endorsed" + fs + "sax.jar";
        } else {
            string6 = string13 + fs + "jaxp-api.jar";
            string5 = string13 + fs + "xercesImpl.jar";
            string4 = string13 + fs + "xalan.jar";
            string3 = string13 + fs + "dom.jar";
            string2 = string13 + fs + "sax.jar";
        }
        String string26 = string6 + string10 + string5 + string10 + string4 + string10 + string3 + string10 + string2;
        String string27 = context.getJDKDir() + fs + "lib" + fs + "lib.zip";
        String string28 = string25 + string10 + string19 + string10 + string26 + string10 + string27;
        String string29 = context.getJDKDir() + fs + "bin" + fs + "java";
        int n = 0;
        if (stringArray != null) {
            n = stringArray.length;
        }
        String[] stringArray2 = new String[6 + n];
        stringArray2[0] = " -Xms64m -Xmx256m ";
        stringArray2[1] = "-classpath " + Util.decoratePath(string28);
        stringArray2[2] = "-Dcom.iplanet.coreservices.configpath=\"" + string8 + fs + "ums" + "\"";
        stringArray2[3] = "-Ddesktop.propertiesFile=\"" + string7 + fs + "desktop" + fs + "desktopconfig.properties" + "\"";
        stringArray2[4] = "-Dps.staticDir=\"" + context.getPSBaseDir() + fs + "web-src" + "\"";
        stringArray2[5] = "com.sun.portal.desktop.deployment." + string9;
        for (int i = 0; i < n; ++i) {
            stringArray2[6 + i] = stringArray[i];
        }
        try {
            InputStream inputStream = PortalServerTasks.runCommandLine(string29, stringArray2);
            if ("y".equals(System.getProperty("PS_CMDLINE_OUTPUT"))) {
                String string30;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                while ((string30 = bufferedReader.readLine()) != null) {
                    System.out.println(string30);
                }
            }
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
        if (PAR_CMD_IMPORT.equals(string)) {
            PortalServerTasks.redeploy(context.getDeployInstance());
        }
    }

    public static void deleteService(String string) throws ConfigurationException {
        String string2 = null;
        string2 = Util.is_windows() ? context.getISBaseDir() + IS_SUFFIX + fs + "bin" + fs + "amadmin.bat" : context.getISBaseDir() + IS_SUFFIX + fs + "bin" + fs + "amadmin";
        String string3 = context.getAmAdminDN();
        String[] stringArray = new String[]{"-u", string3, "-w", context.getISAdminPassword(), "-r", string};
        try {
            Util.debug("deleteService cmd:" + string2);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i] + " ");
            }
            Util.debug("deleteService args:" + stringBuffer.toString());
            PortalServerTasks.runCommandLine(string2, stringArray);
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception.toString());
        }
    }

    public static void removeBase(String string) throws ConfigurationException {
        String[] stringArray;
        String string2 = context.getISBaseDir();
        String string3 = context.getPSBaseDir();
        String string4 = context.getDeployType();
        if (string4.equals("IWS")) {
            stringArray = string2 + IS_SUFFIX + fs + "servers" + fs + "https-" + string + fs + "ClassCache" + fs + "https-" + string;
            Util.deleteDir((String)stringArray);
        } else if (string4.equals("SUNONE")) {
            try {
                stringArray = new File(context.getDeployDomain() + fs + context.getDeployInstance() + fs + "config" + fs + "server.policy");
                if (!stringArray.exists()) {
                    throw new ConfigurationException("Server Policy file for SunOne AppServer missing:" + stringArray.getAbsolutePath());
                }
                PortalServerTasks.deleteUntilBlankLineInFile((File)stringArray, "// S1PS");
            }
            catch (Exception exception) {
                throw new ConfigurationException(exception.toString());
            }
        }
        stringArray = new String[]{string3 + PS_SUFFIX + fs + "lib" + fs + "filter", string3 + PS_SUFFIX + fs + "web-src", string3 + PS_TMP_DIR_SUFFIX};
        for (int i = 0; i < stringArray.length; ++i) {
            Util.deleteDir(stringArray[i]);
        }
    }

    public static void getVersion() throws ConfigurationException {
        String string = context.getPSBaseDir() + PS_SUFFIX + fs + "lib" + fs + "PSversion.properties";
        File file = new File(string);
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.startsWith("productname")) {
                    string3 = string2.substring(12);
                    continue;
                }
                if (string2.startsWith("productversion")) {
                    string4 = string2.substring(15);
                    continue;
                }
                if (!string2.startsWith("build")) continue;
                string5 = string2.substring(6);
            }
            System.out.println(string5 + " " + string3 + " " + string4);
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ConfigurationException(fileNotFoundException.toString());
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.toString());
        }
    }

    static {
        fs = System.getProperty("file.separator");
    }
}

