/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.config.util;

import com.sun.portal.config.ConfigurationContext;
import com.sun.portal.config.util.CLIPException;
import com.sun.portal.config.util.CLIPParser;
import com.sun.portal.config.util.PortalServerTasks;
import com.sun.portal.config.util.Util;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

class PortalServerCommand {
    protected static final String DEPLOY = "deploy";
    protected static final String REDEPLOY = "redeploy";
    protected static final String UNDEPLOY = "undeploy";
    protected static final String MULTISERVERINSTANCE = "multiserverinstance";
    protected static final String MULTISERVERINSTANCE_CREATE = "create";
    protected static final String MULTISERVERINSTANCE_DELETE = "delete";
    protected static final String PDEPLOY = "pdeploy";
    protected static final String PUNDEPLOY = "pundeploy";
    protected static final String PAR = "par";
    protected static final int SUBCMD_DEPLOY = 1;
    protected static final int SUBCMD_REDEPLOY = 2;
    protected static final int SUBCMD_UNDEPLOY = 3;
    protected static final int SUBCMD_MULTISERVERINSTANCE_CREATE = 4;
    protected static final int SUBCMD_MULTISERVERINSTANCE_DELETE = 5;
    protected static final int SUBCMD_PDEPLOY = 6;
    protected static final int SUBCMD_PUNDEPLOY = 7;
    protected static final int SUBCMD_PAR_EXPORT = 8;
    protected static final int SUBCMD_PAR_DESCRIBE = 9;
    protected static final int SUBCMD_PAR_CONTAINERS = 10;
    protected static final int SUBCMD_PAR_IMPORT = 11;
    protected static final int SUBCMD_PAR_VERSION = 12;
    protected static final String PASSWORD = "deploy_admin_password";
    protected static final String INSTANCE = "instance";
    protected static final String URI = "uri";
    protected static final String PORT = "port";
    protected static final String MODE = "mode";
    protected static final String OPT_DEFAULT = "*";
    protected static final String LOCALE_DEFAULT = Locale.getDefault().toString();
    protected int subcmd = -1;
    protected String uri = null;
    protected String password = null;
    protected String instance = null;
    protected String port = null;
    protected String mode = null;
    protected static String command = null;
    protected static String[] globalArgs = null;
    protected static final String RESOURCE_BASE = "PSCommands";
    protected static ResourceBundle rb = PropertyResourceBundle.getBundle("PSCommands", Locale.getDefault());
    PortalServerTasks PSTasks;
    ConfigurationContext context;

    PortalServerCommand(CLIPParser cLIPParser, String[] stringArray) throws Exception {
        String string = null;
        if (Util.is_windows()) {
            String string2 = System.getProperty("user.dir");
            string = string2 + "/..";
        } else {
            string = "/etc/opt/SUNWps";
        }
        this.context = new ConfigurationContext(string);
        this.PSTasks = new PortalServerTasks(this.context);
        this.parse(cLIPParser, stringArray);
    }

    private void parse(CLIPParser cLIPParser, String[] stringArray) throws Exception {
        String string = null;
        Map map = null;
        if (cLIPParser == null) {
            string = this.localParse(stringArray);
        } else {
            if (cLIPParser.needsHelp(stringArray)) {
                boolean bl = true;
                if (PDEPLOY.equals(command) || PAR.equals(command)) {
                    bl = false;
                }
                if (bl) {
                    PortalServerCommand.error(cLIPParser.getHelp(stringArray));
                    System.exit(0);
                }
            }
            try {
                map = cLIPParser.getOptions(stringArray);
            }
            catch (CLIPException cLIPException) {
                throw new Exception(cLIPException.getLocalizedMessage());
            }
            try {
                cLIPParser.verifyArguments(stringArray);
            }
            catch (CLIPException cLIPException) {
                throw new Exception(cLIPException.getLocalizedMessage());
            }
            try {
                string = cLIPParser.getSubCommand(stringArray);
                System.out.println("Sub Command:" + string);
            }
            catch (CLIPException cLIPException) {
                throw new Exception(cLIPException.getLocalizedMessage());
            }
        }
        if (string.equals(DEPLOY)) {
            if (DEPLOY.equals(command)) {
                this.subcmd = 1;
            } else if (PDEPLOY.equals(command)) {
                this.subcmd = 6;
                this.mode = DEPLOY;
            }
        } else if (string.equals(REDEPLOY)) {
            this.subcmd = 2;
        } else if (string.equals(UNDEPLOY)) {
            if (UNDEPLOY.equals(command)) {
                this.subcmd = 3;
            } else if (PDEPLOY.equals(command)) {
                this.subcmd = 7;
                this.mode = UNDEPLOY;
            }
        } else if (string.equals(MULTISERVERINSTANCE_CREATE)) {
            this.subcmd = 4;
        } else if (string.equals(MULTISERVERINSTANCE_DELETE)) {
            this.subcmd = 5;
        } else if (string.equals("export")) {
            this.subcmd = 8;
            this.mode = string;
        } else if (string.equals("describe")) {
            this.subcmd = 9;
            this.mode = string;
        } else if (string.equals("containers")) {
            this.subcmd = 10;
            this.mode = string;
        } else if (string.equals("import")) {
            this.subcmd = 11;
            this.mode = string;
        } else if (string.equals("version")) {
            this.subcmd = 12;
            this.mode = string;
        }
        if (this.subcmd == 1) {
            this.password = ((String[])map.get(PASSWORD))[0];
            this.uri = ((String[])map.get(URI))[0];
            this.instance = ((String[])map.get(INSTANCE))[0];
            if (this.instance.equals(OPT_DEFAULT)) {
                this.instance = this.context.getDeployInstance();
            }
        }
        if (this.subcmd == 2) {
            this.password = ((String[])map.get(PASSWORD))[0];
            this.instance = ((String[])map.get(INSTANCE))[0];
            if (this.instance.equals(OPT_DEFAULT)) {
                this.instance = this.context.getDeployInstance();
            }
        }
        if (this.subcmd == 3) {
            this.password = ((String[])map.get(PASSWORD))[0];
            this.instance = ((String[])map.get(INSTANCE))[0];
            if (this.instance.equals(OPT_DEFAULT)) {
                this.instance = this.context.getDeployInstance();
            }
        }
        if (this.subcmd == 4) {
            this.password = ((String[])map.get(PASSWORD))[0];
            this.instance = ((String[])map.get(INSTANCE))[0];
            this.port = ((String[])map.get(PORT))[0];
        }
        if (this.subcmd == 5) {
            this.password = ((String[])map.get(PASSWORD))[0];
            this.instance = ((String[])map.get(INSTANCE))[0];
        }
    }

    protected String localParse(String[] stringArray) throws Exception {
        String string;
        block10: {
            block11: {
                boolean bl;
                boolean bl2;
                block12: {
                    block13: {
                        block9: {
                            string = null;
                            bl2 = false;
                            bl = false;
                            if (stringArray == null || stringArray.length == 0) {
                                bl2 = false;
                            } else {
                                bl2 = true;
                                string = stringArray[0];
                            }
                            if (!PDEPLOY.equals(command)) break block9;
                            if (string != null && (DEPLOY.equals(string) || UNDEPLOY.equals(string))) {
                                bl = true;
                            }
                            if (!bl2 || !bl) {
                                throw new Exception(PortalServerCommand.getLocalizedString("errorInvalidPdeployCmd"));
                            }
                            break block10;
                        }
                        if (!PAR.equals(command)) break block11;
                        if (string == null) break block12;
                        if ("export".equals(string)) break block13;
                        if ("describe".equals(string)) break block13;
                        if ("containers".equals(string)) break block13;
                        if ("import".equals(string)) break block13;
                        if (!"version".equals(string)) break block12;
                    }
                    bl = true;
                }
                if (!bl2 || !bl) {
                    throw new Exception(PortalServerCommand.getLocalizedString("errorInvalidParCmd"));
                }
                break block10;
            }
            throw new Exception(PortalServerCommand.getLocalizedString("errorInvalidSubCmd"));
        }
        return string;
    }

    protected void runCommand() throws Exception {
        switch (this.subcmd) {
            case 1: {
                System.setProperty("DEPLOY_ADMIN_PASSWORD", this.password);
                PortalServerTasks.deploy(this.instance, this.uri);
                break;
            }
            case 2: {
                System.setProperty("DEPLOY_ADMIN_PASSWORD", this.password);
                PortalServerTasks.redeploy(this.instance);
                break;
            }
            case 3: {
                System.setProperty("DEPLOY_ADMIN_PASSWORD", this.password);
                PortalServerTasks.undeploy(this.instance);
                break;
            }
            case 4: {
                System.setProperty("DEPLOY_ADMIN_PASSWORD", this.password);
                PortalServerTasks.createMultiServerInstance(this.instance, this.port);
                break;
            }
            case 5: {
                System.setProperty("DEPLOY_ADMIN_PASSWORD", this.password);
                PortalServerTasks.deleteMultiServerInstance(this.instance);
                break;
            }
            case 6: 
            case 7: {
                String[] stringArray = PortalServerCommand.processArgs(PDEPLOY, globalArgs);
                String[] stringArray2 = PortalServerCommand.processArgs(this.mode, stringArray);
                PortalServerTasks.pdeploy(this.mode, stringArray2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                String[] stringArray = PortalServerCommand.processArgs(PAR, globalArgs);
                String[] stringArray3 = PortalServerCommand.processArgs(this.mode, stringArray);
                PortalServerTasks.par(this.mode, stringArray3);
                break;
            }
            default: {
                throw new Exception(PortalServerCommand.getLocalizedString("errorInvalidSubCmd"));
            }
        }
    }

    protected static CLIPParser getCLIPParser(String string) throws CLIPException {
        CLIPParser cLIPParser = null;
        if (DEPLOY.equals(string)) {
            CLIPParser.Option[] optionArray = new CLIPParser.Option[]{new CLIPParser.Option(PASSWORD, null, 1, null, PortalServerCommand.getLocalizedString("optPassword")), new CLIPParser.Option(URI, null, 1, null, PortalServerCommand.getLocalizedString("optURI")), new CLIPParser.Option(INSTANCE, null, 1, OPT_DEFAULT, PortalServerCommand.getLocalizedString("optInstance"))};
            CLIPParser.SubCommand subCommand = new CLIPParser.SubCommand(DEPLOY, optionArray, 0, 1, PortalServerCommand.getLocalizedString("optDeploy"), PortalServerCommand.getLocalizedString("helpDeploy"));
            CLIPParser.Option[] optionArray2 = new CLIPParser.Option[]{new CLIPParser.Option(PASSWORD, null, 1, null, PortalServerCommand.getLocalizedString("optPassword")), new CLIPParser.Option(INSTANCE, null, 1, OPT_DEFAULT, PortalServerCommand.getLocalizedString("optInstance"))};
            CLIPParser.SubCommand subCommand2 = new CLIPParser.SubCommand(REDEPLOY, optionArray2, 0, 1, PortalServerCommand.getLocalizedString("optRedeploy"), PortalServerCommand.getLocalizedString("helpRedeploy"));
            CLIPParser.SubCommand[] subCommandArray = new CLIPParser.SubCommand[]{subCommand, subCommand2};
            cLIPParser = new CLIPParser(DEPLOY, subCommandArray, PortalServerCommand.getLocalizedString("helpCmdDeploy"));
        } else if (UNDEPLOY.equals(string)) {
            CLIPParser.Option[] optionArray = new CLIPParser.Option[]{new CLIPParser.Option(PASSWORD, null, 1, null, PortalServerCommand.getLocalizedString("optPassword")), new CLIPParser.Option(INSTANCE, null, 1, OPT_DEFAULT, PortalServerCommand.getLocalizedString("optInstance"))};
            CLIPParser.SubCommand subCommand = new CLIPParser.SubCommand(UNDEPLOY, optionArray, 0, 1, PortalServerCommand.getLocalizedString("optUndeploy"), PortalServerCommand.getLocalizedString("helpUndeploy"));
            CLIPParser.SubCommand[] subCommandArray = new CLIPParser.SubCommand[]{subCommand};
            cLIPParser = new CLIPParser(UNDEPLOY, subCommandArray, PortalServerCommand.getLocalizedString("helpCmdUndeploy"));
        } else if (MULTISERVERINSTANCE.equals(string)) {
            CLIPParser.Option[] optionArray = new CLIPParser.Option[]{new CLIPParser.Option(PASSWORD, null, 1, null, PortalServerCommand.getLocalizedString("optPassword")), new CLIPParser.Option(INSTANCE, null, 1, null, PortalServerCommand.getLocalizedString("optInstance")), new CLIPParser.Option(PORT, null, 1, null, PortalServerCommand.getLocalizedString("optPort"))};
            CLIPParser.SubCommand subCommand = new CLIPParser.SubCommand(MULTISERVERINSTANCE_CREATE, optionArray, 0, 1, PortalServerCommand.getLocalizedString("optMultiServerInstanceCreate"), PortalServerCommand.getLocalizedString("helpMultiServerInstanceCreate"));
            CLIPParser.Option[] optionArray3 = new CLIPParser.Option[]{new CLIPParser.Option(PASSWORD, null, 1, null, PortalServerCommand.getLocalizedString("optPassword")), new CLIPParser.Option(INSTANCE, null, 1, OPT_DEFAULT, PortalServerCommand.getLocalizedString("optInstance"))};
            CLIPParser.SubCommand subCommand3 = new CLIPParser.SubCommand(MULTISERVERINSTANCE_DELETE, optionArray3, 0, 1, PortalServerCommand.getLocalizedString("optMultiServerInstanceDelete"), PortalServerCommand.getLocalizedString("helpMultiServerInstanceDelete"));
            CLIPParser.SubCommand[] subCommandArray = new CLIPParser.SubCommand[]{subCommand, subCommand3};
            cLIPParser = new CLIPParser(MULTISERVERINSTANCE, subCommandArray, PortalServerCommand.getLocalizedString("helpCmdMultiServerInstance"));
        } else if (PDEPLOY.equals(string)) {
            cLIPParser = null;
        } else if (PAR.equals(string)) {
            cLIPParser = null;
        }
        return cLIPParser;
    }

    protected static String getCommand(String[] stringArray) throws Exception {
        String string = null;
        if (stringArray == null || stringArray.length == 0 || stringArray[0] == null || "".equals(stringArray[0].trim())) {
            throw new Exception(PortalServerCommand.getLocalizedString("errorInvalidSubCmd"));
        }
        string = stringArray[0].trim().toLowerCase();
        if (DEPLOY.equals(string) || UNDEPLOY.equals(string) || MULTISERVERINSTANCE.equals(string) || PDEPLOY.equals(string) || PAR.equals(string)) {
            return string;
        }
        throw new Exception(PortalServerCommand.getLocalizedString("errorInvalidSubCmd"));
    }

    protected static String[] processArgs(String string, String[] stringArray) throws Exception {
        if (stringArray == null || stringArray.length == 0 || stringArray[0] == null) {
            throw new Exception(PortalServerCommand.getLocalizedString("errorInvalidSubCmd"));
        }
        if (string == null || !string.equalsIgnoreCase(stringArray[0])) {
            throw new Exception(PortalServerCommand.getLocalizedString("errorInvalidSubCmd"));
        }
        String[] stringArray2 = new String[stringArray.length - 1];
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringArray2[i] = stringArray[i + 1];
        }
        return stringArray2;
    }

    protected static void error(String string) {
        System.out.println(PortalServerCommand.getLocalizedString("errorPSCommand") + string);
    }

    protected static void debug(String string) {
        System.out.println(PortalServerCommand.getLocalizedString("dbgMsg") + string);
    }

    protected static String getLocalizedString(String string) {
        return rb.getString(string);
    }

    protected static String getLocalizedString(String string, Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            MessageFormat messageFormat = new MessageFormat("");
            messageFormat.setLocale(rb.getLocale());
            messageFormat.applyPattern(rb.getString(string));
            return messageFormat.format(objectArray);
        }
        return rb.getString(string);
    }

    public static void main(String[] stringArray) {
        globalArgs = stringArray;
        CLIPParser cLIPParser = null;
        try {
            command = PortalServerCommand.getCommand(stringArray);
            if (!command.equals(UNDEPLOY)) {
                stringArray = PortalServerCommand.processArgs(command, stringArray);
            }
            cLIPParser = PortalServerCommand.getCLIPParser(command);
            PortalServerCommand portalServerCommand = new PortalServerCommand(cLIPParser, stringArray);
            portalServerCommand.runCommand();
            System.exit(0);
        }
        catch (Exception exception) {
            PortalServerCommand.error(exception.getMessage());
            System.exit(1);
        }
    }
}

