/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.config.util;

import com.sun.portal.config.util.CLIPException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class CLIPParser {
    private static final String OPTION_PREFIX = "-";
    private static final String SHORT_OPTION = "-";
    private static final String LONG_OPTION = "--";
    private static final String NEGATE_OPTION = "--no-";
    private static final String NO_MORE_OPTIONS = "--";
    private static final String ADD_TO_COLLECTION_OPTION = "--add-";
    private static final String REMOVE_FROM_COLLECTION_OPTION = "--remove-";
    public static final int BOOLEAN = 0;
    public static final int REGULAR = 1;
    public static final int COLLECTION = 2;
    private String _commandName;
    private String _commandHelpMessage;
    private Map _subCommands = new HashMap();
    private List _orderedSubCommands = new ArrayList();

    private static void verifyName(String string, String string2) {
        if (string == null || string.length() < 2) {
            throw new IllegalArgumentException(string2 + " has to be at least 2 chars long");
        }
        if (string.equals("--")) {
            throw new IllegalArgumentException(string2 + " can not be '--'");
        }
        if (string.startsWith("-") || string.endsWith("-")) {
            throw new IllegalArgumentException(string2 + " can not start or end with '-'");
        }
        if (!string.equals(string.toLowerCase())) {
            throw new IllegalArgumentException(string2 + " has to be in lower case");
        }
    }

    private CLIPParser() {
    }

    public CLIPParser(String string, SubCommand[] subCommandArray, String string2) throws IllegalArgumentException {
        this();
        this._commandName = string;
        this._commandHelpMessage = string2;
        if (subCommandArray == null || subCommandArray.length == 0) {
            throw new IllegalArgumentException("CLIPParser - sub command array can not be null or empty");
        }
        for (int i = 0; i < subCommandArray.length; ++i) {
            if (subCommandArray[i]._subCommandName == null) {
                throw new IllegalArgumentException("CLIPParser - Sub command can not be null");
            }
            this.addSubCommand(subCommandArray[i]);
        }
    }

    public CLIPParser(String string, Option[] optionArray, int n, int n2, String string2, String string3) throws IllegalArgumentException {
        this();
        this._commandName = string;
        this._commandHelpMessage = string2;
        SubCommand subCommand = new SubCommand(null, optionArray, n, n2, this._commandHelpMessage, string3);
        this.addSubCommand(subCommand);
    }

    private void addSubCommand(SubCommand subCommand) throws IllegalArgumentException {
        if (subCommand._subCommandName != null) {
            CLIPParser.verifyName(subCommand._subCommandName, "CLIPParser - Sub command");
        }
        if (this._subCommands.containsKey(subCommand._subCommandName)) {
            throw new IllegalArgumentException("CLIPParser - Sub command '" + subCommand._subCommandName + "', sub command already defined");
        }
        this._subCommands.put(subCommand._subCommandName, subCommand);
        this._orderedSubCommands.add(subCommand);
    }

    public void verifyArguments(String[] stringArray) throws CLIPException {
        boolean bl;
        boolean bl2 = bl = stringArray.length == 1 && (stringArray[0].equals("--help") || stringArray[0].equals("-?"));
        if (!bl) {
            this.getSubCommand(stringArray);
            boolean bl3 = bl = stringArray.length == 2 && (stringArray[1].equals("--help") || stringArray[0].equals("-?"));
            if (!bl) {
                this.getOptions(stringArray);
                this.getOperands(stringArray);
            }
        }
    }

    public String getSubCommand(String[] stringArray) throws CLIPException {
        boolean bl = !this._subCommands.containsKey(null);
        String string = stringArray.length > 0 && bl ? stringArray[0] : null;
        SubCommand subCommand = (SubCommand)this._subCommands.get(string);
        if (subCommand == null) {
            throw new CLIPException("Invalid sub command: " + string, 0);
        }
        return string;
    }

    public Map getOptions(String[] stringArray) throws CLIPException {
        Object object;
        SubCommand subCommand = (SubCommand)this._subCommands.get(this.getSubCommand(stringArray));
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator iterator = subCommand._defaultOptionValues.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            object = (List)subCommand._defaultOptionValues.get(string);
            hashMap.put(string, ((ArrayList)object).clone());
        }
        int n = this.processOptions(stringArray, hashMap);
        iterator = subCommand._validOptions.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            Option option = (Option)subCommand._validOptions.get(object);
            if (option._defaultValues != null || hashMap.containsKey(option._longName)) continue;
            throw new CLIPException("Missing mandatory option: " + option._longName, n);
        }
        return this.massageOptions(hashMap);
    }

    public String[] getOperands(String[] stringArray) throws CLIPException {
        SubCommand subCommand = (SubCommand)this._subCommands.get(this.getSubCommand(stringArray));
        int n = this.processOptions(stringArray, new HashMap());
        int n2 = stringArray.length - n;
        if (subCommand._minOperands > n2 || n2 > subCommand._maxOperands) {
            throw new CLIPException("Invalid number of operands", n);
        }
        for (int i = n; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("--")) continue;
            throw new CLIPException("'--' can not be an operand", i);
        }
        String[] stringArray2 = new String[n2];
        if (stringArray.length > 0) {
            System.arraycopy(stringArray, n, stringArray2, 0, n2);
        }
        return stringArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int processOptions(String[] stringArray, Map map) throws CLIPException {
        int n;
        SubCommand subCommand = (SubCommand)this._subCommands.get(this.getSubCommand(stringArray));
        boolean bl = false;
        int n2 = n = subCommand._subCommandName != null ? 1 : 0;
        while (!bl && n < stringArray.length) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Option option;
            String string;
            if (stringArray[n].startsWith(ADD_TO_COLLECTION_OPTION)) {
                string = stringArray[n].substring(ADD_TO_COLLECTION_OPTION.length());
                option = (Option)subCommand._validOptions.get(string);
                if (string.length() < 2 || option == null) {
                    throw new CLIPException("Invalid option: " + string, n);
                }
                if (option._type != 2) {
                    throw new CLIPException("Not a collection option: " + string, n);
                }
                object4 = this.getOptionValues(subCommand, map, string);
                if (n + 1 == stringArray.length) {
                    throw new CLIPException("Missing collection values to add to option: " + string, n);
                }
                object2 = new StringTokenizer((String)object3, ((String)(object3 = stringArray[++n])).indexOf(" ") > -1 ? " " : ",");
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    object = ((StringTokenizer)object2).nextToken();
                    object4.add(object);
                }
            } else if (stringArray[n].startsWith(REMOVE_FROM_COLLECTION_OPTION)) {
                string = stringArray[n].substring(REMOVE_FROM_COLLECTION_OPTION.length());
                option = (Option)subCommand._validOptions.get(string);
                if (string.length() < 2 || option == null) {
                    throw new CLIPException("Invalid option: " + string, n);
                }
                if (option._type != 2) {
                    throw new CLIPException("Not a collection option: " + string, n);
                }
                if (n + 1 == stringArray.length) {
                    throw new CLIPException("Missing collection values to delete from option: " + string, n);
                }
                object4 = this.getOptionValues(subCommand, map, string);
                object2 = new StringTokenizer((String)object3, ((String)(object3 = stringArray[++n])).indexOf(" ") > -1 ? " " : ",");
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    object = ((StringTokenizer)object2).nextToken();
                    if (object4.contains(object)) {
                        object4.remove(object);
                        continue;
                    }
                    for (int i = 0; i < object4.size(); ++i) {
                        String string2 = (String)object4.get(i);
                        if (!string2.startsWith((String)object + "=")) continue;
                        object4.remove(i);
                    }
                }
            } else if (stringArray[n].equals("--")) {
                ++n;
                bl = true;
            } else if (stringArray[n].startsWith(NEGATE_OPTION)) {
                string = stringArray[n].substring(NEGATE_OPTION.length());
                option = (Option)subCommand._validOptions.get(string);
                if (option == null) {
                    throw new CLIPException("Invalid option: " + string, n);
                }
                if (option._type != 0) {
                    throw new CLIPException("Not a boolean option: " + string, n);
                }
                object4 = "false";
                object3 = this.getOptionValues(subCommand, map, string);
                object3.clear();
                object3.add(object4);
            } else if (stringArray[n].startsWith("--")) {
                string = stringArray[n].substring("--".length());
                option = (Option)subCommand._validOptions.get(string);
                if (option == null) {
                    throw new CLIPException("Invalid option: " + string, n);
                }
                if (option._type == 0) {
                    object4 = "true";
                    object3 = this.getOptionValues(subCommand, map, string);
                    object3.clear();
                    object3.add(object4);
                } else if (option._type == 1) {
                    if (n + 1 == stringArray.length) {
                        throw new CLIPException("Missing value for regular option: " + string, n);
                    }
                    object4 = stringArray[++n];
                    object3 = this.getOptionValues(subCommand, map, string);
                    object3.clear();
                    object3.add(object4);
                } else {
                    if (option._type != 2) throw new CLIPException("CLIPParser - Internal error", n);
                    if (n + 1 == stringArray.length) {
                        throw new CLIPException("Missing value for collection option: " + string, n);
                    }
                    object4 = stringArray[++n];
                    object3 = this.getOptionValues(subCommand, map, string);
                    object3.clear();
                    object2 = new StringTokenizer((String)object4, ((String)object4).indexOf(" ") > -1 ? " " : ",");
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        object = ((StringTokenizer)object2).nextToken();
                        object3.add(object);
                    }
                }
            } else if (stringArray[n].startsWith("-")) {
                string = stringArray[n].substring("-".length());
                for (int i = 0; i < string.length() - 1; ++i) {
                    object4 = "" + string.charAt(i);
                    object3 = (Option)subCommand._validOptions.get(object4);
                    if (object3 == null) {
                        throw new CLIPException("Invalid option: " + (String)object4, n);
                    }
                    if (((Option)object3)._type != 0) {
                        throw new CLIPException("Not an boolean option: " + (String)object4, n);
                    }
                    object2 = "true";
                    object = this.getOptionValues(subCommand, map, (String)object4);
                    object.clear();
                    object.add(object2);
                }
                string = "" + string.charAt(string.length() - 1);
                option = (Option)subCommand._validOptions.get(string);
                if (option == null) {
                    throw new CLIPException("Invalid option: " + string, n);
                }
                if (option._type == 0) {
                    object4 = "true";
                    object3 = this.getOptionValues(subCommand, map, string);
                    object3.clear();
                    object3.add(object4);
                } else {
                    if (option._type != 1) throw new CLIPException("CLIPParser - Internal error", n);
                    if (n + 1 == stringArray.length) {
                        throw new CLIPException("Missing value for regular option: " + string, n);
                    }
                    object4 = stringArray[++n];
                    object3 = this.getOptionValues(subCommand, map, string);
                    object3.clear();
                    object3.add(object4);
                }
            } else {
                bl = true;
            }
            ++n;
        }
        if (!bl) return n;
        --n;
        return n;
    }

    private List getOptionValues(SubCommand subCommand, Map map, String string) {
        Option option = (Option)subCommand._validOptions.get(string);
        String string2 = option._longName;
        ArrayList arrayList = (ArrayList)map.get(string2);
        if (arrayList == null) {
            arrayList = new ArrayList();
            map.put(string2, arrayList);
        }
        return arrayList;
    }

    private Map massageOptions(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            List list = (List)map.get(string);
            String[] stringArray = new String[list.size()];
            list.toArray(stringArray);
            map.put(string, stringArray);
        }
        return map;
    }

    public static String getName(String string) {
        String string2 = string;
        int n = string.indexOf("=");
        if (n > -1) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public static String getValue(String string) {
        String string2 = null;
        int n = string.indexOf("=");
        if (n > -1) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    public String toString(String[] stringArray) throws CLIPException {
        StringBuffer stringBuffer = new StringBuffer(1024);
        String string = this.getSubCommand(stringArray);
        Map map = this.getOptions(stringArray);
        String[] stringArray2 = this.getOperands(stringArray);
        stringBuffer.append("\n").append("Sub-command: ").append(string).append("\n").append("\n").append("Options: ").append("\n");
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String[] stringArray3 = (String[])map.get(string2);
            stringBuffer.append(("  " + string2 + "              ").substring(0, 12) + ": ");
            for (int i = 0; i < stringArray3.length; ++i) {
                stringBuffer.append(stringArray3[i]).append(" ");
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("\n").append("Operands: ").append("\n");
        for (int i = 0; i < stringArray2.length; ++i) {
            stringBuffer.append("  ").append(stringArray2[i]).append("\n");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public boolean needsHelp(String[] stringArray) {
        boolean bl = false;
        try {
            this.verifyArguments(stringArray);
            Map map = this.getOptions(stringArray);
            bl = map.containsKey("help") && ((String[])map.get("help"))[0].equals("true");
        }
        catch (CLIPException cLIPException) {
            bl = true;
        }
        return bl;
    }

    public String getHelp(String[] stringArray) {
        SubCommand subCommand;
        boolean bl = false;
        String string = stringArray.length > 0 ? stringArray[0] : null;
        boolean bl2 = bl = !this._subCommands.containsKey(string);
        if (!bl) {
            subCommand = (SubCommand)this._subCommands.get(string);
        } else {
            subCommand = (SubCommand)this._subCommands.get(null);
            bl = subCommand == null || subCommand._subCommandName != null;
        }
        StringBuffer stringBuffer = new StringBuffer(2048);
        if (bl) {
            stringBuffer.append("Usage: " + this._commandName + " SUBCOMMAND ARGUMENTS\n\n");
            stringBuffer.append(this._commandHelpMessage).append("\n\n");
            stringBuffer.append("The accepted values for SUBCOMMAND are:\n\n");
            int n = this._orderedSubCommands.size();
            for (int i = 0; i < n; ++i) {
                subCommand = (SubCommand)this._orderedSubCommands.get(i);
                String string2 = subCommand._subCommandName;
                string2 = string2 == null ? "<NO SUB COMMAND>  " : string2 + "\t";
                stringBuffer.append(string2).append(subCommand._subCommandHelp).append(".\n");
            }
        } else {
            stringBuffer.append("Usage: " + this._commandName + " " + subCommand._subCommandName + " [OPTIONS...]\n\n");
            stringBuffer.append(subCommand._subCommandHelp).append(".\n\n");
            this.doOptionsHelp(stringBuffer, "", subCommand._orderedOptions);
            if (subCommand._maxOperands > 0) {
                if (subCommand._maxOperands == 1) {
                    stringBuffer.append("\nOPERAND\n");
                } else {
                    stringBuffer.append("\nOPERANDS\n");
                }
                stringBuffer.append("  ").append(subCommand._operandsHelp).append("\n");
            }
        }
        return stringBuffer.toString();
    }

    public boolean needsVersion(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-V") && !stringArray[i].equals("--version")) continue;
            return true;
        }
        return false;
    }

    private void doOptionsHelp(StringBuffer stringBuffer, String string, List list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Option option = (Option)list.get(i);
            stringBuffer.append(string);
            if (option._shortName != null) {
                stringBuffer.append('-').append(option._shortName);
                if (option._argName != null) {
                    stringBuffer.append(" ").append(option._argName);
                }
                stringBuffer.append(", ");
            }
            stringBuffer.append("--").append(option._longName);
            if (option._argName != null) {
                stringBuffer.append("=").append(option._argName).append("\n\t");
            }
            stringBuffer.append("\t").append(option._helpMessage).append(" (");
            if (option._defaultValues == null) {
                stringBuffer.append("none");
            } else {
                for (int j = 0; j < option._defaultValues.length; ++j) {
                    if (j > 0) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(option._defaultValues[j]);
                }
            }
            stringBuffer.append(")\n\n");
        }
    }

    public static class SubCommand {
        private String _subCommandName;
        private List _orderedOptions;
        private Map _validOptions;
        private Map _defaultOptionValues;
        private int _minOperands;
        private int _maxOperands;
        private String _subCommandHelp;
        private String _operandsHelp;

        public SubCommand(String string, Option[] optionArray, int n, int n2, String string2, String string3) throws IllegalArgumentException {
            int n3;
            if (string != null) {
                CLIPParser.verifyName(string, "CLIPParser - Sub command");
            }
            this._subCommandName = string;
            this._validOptions = new HashMap();
            this._orderedOptions = new ArrayList();
            if (optionArray != null) {
                for (n3 = 0; n3 < optionArray.length; ++n3) {
                    if (optionArray[n3] == null) {
                        throw new IllegalArgumentException("CLIPParser.SubCommand - Sub command '" + string + "', option instances can not be NULL");
                    }
                    if (this._validOptions.containsKey(optionArray[n3]._longName)) {
                        throw new IllegalArgumentException("CLIPParser.SubCommand - Sub command '" + string + "', option long names can not be duplicated within a CLIPParser instance");
                    }
                    this._validOptions.put(optionArray[n3]._longName, optionArray[n3]);
                    this._orderedOptions.add(optionArray[n3]);
                    if (optionArray[n3]._shortName == null) continue;
                    if (this._validOptions.containsKey(optionArray[n3]._shortName)) {
                        throw new IllegalArgumentException("CLIPParser.SubCommand - Sub command '" + string + "', option short names can not be duplicated within a CLIPParser instance");
                    }
                    this._validOptions.put(optionArray[n3]._shortName, optionArray[n3]);
                }
            }
            this._defaultOptionValues = new HashMap();
            if (optionArray != null) {
                for (n3 = 0; n3 < optionArray.length; ++n3) {
                    String[] stringArray = optionArray[n3]._defaultValues;
                    if (stringArray == null) continue;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (int i = 0; i < stringArray.length; ++i) {
                        arrayList.add(stringArray[i]);
                    }
                    this._defaultOptionValues.put(optionArray[n3]._longName, arrayList);
                }
            }
            if (n < 0) {
                throw new IllegalArgumentException("CLIPParser.SubCommand - Sub command '" + string + "', minimum number of operands can not be less than zero");
            }
            this._minOperands = n;
            if (n > n2) {
                throw new IllegalArgumentException("CLIPParser.SubCommand - Sub command '" + string + "', maximum number of operands can not be less than minimum number of operands");
            }
            this._maxOperands = n2;
            if (string2 == null) {
                throw new IllegalArgumentException("CLIPParser.SubCommand - Sub command '" + string + "', sub command help can not be NULL");
            }
            this._subCommandHelp = string2;
            if (string3 == null) {
                throw new IllegalArgumentException("CLIPParser.SubCommand - Sub command '" + string + "', operands help can not be NULL");
            }
            this._operandsHelp = string3;
        }
    }

    public static class Option {
        private String _longName;
        private String _shortName;
        private boolean _mandatory;
        private int _type;
        private String _argName = null;
        private String[] _defaultValues;
        private String _helpMessage;

        public Option(String string, String string2, int n, String string3, String string4, String string5) throws IllegalArgumentException {
            CLIPParser.verifyName(string, "CLIPParser.Option - Option's long name");
            this._longName = string;
            if (string2 != null && string2.length() > 1) {
                throw new IllegalArgumentException("CLIPParser.Option - Option's short name has to be undefined (NULL) or one character long");
            }
            if (string2 != null && string2.equals("-")) {
                throw new IllegalArgumentException("CLIPParser.Option - Option's short name can not be '-'");
            }
            this._shortName = string2;
            this._mandatory = string3 == null;
            this._argName = string4;
            if (string5 == null) {
                throw new IllegalArgumentException("CLIPParser.Option - Option's help can not be NULL");
            }
            this._helpMessage = string5;
            this._type = n;
            switch (n) {
                case 0: {
                    if (string3 == null) break;
                    if (!string3.equals("true") && !string3.equals("false")) {
                        throw new IllegalArgumentException("CLIPParser.Option - Boolean default value has to be 'true' or 'false'");
                    }
                    this._defaultValues = new String[1];
                    this._defaultValues[0] = string3;
                    break;
                }
                case 1: {
                    if (string3 == null) break;
                    this._defaultValues = new String[1];
                    this._defaultValues[0] = string3;
                    break;
                }
                case 2: {
                    if (string2 != null) {
                        throw new IllegalArgumentException("CLIPParser.Option - Collection options can not have short names");
                    }
                    if (string3 == null) break;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    String string6 = string3.indexOf(" ") > -1 ? " " : ",";
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, string6);
                    while (stringTokenizer.hasMoreTokens()) {
                        String string7 = stringTokenizer.nextToken();
                        arrayList.add(string7);
                    }
                    this._defaultValues = new String[arrayList.size()];
                    arrayList.toArray(this._defaultValues);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("CLIPParser.Option - Invalid type");
                }
            }
        }

        public Option(String string, String string2, int n, String string3, String string4) throws IllegalArgumentException {
            this(string, string2, n, string3, null, string4);
        }
    }
}

