/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.config.tasks;

import com.sun.portal.config.context.DebugContext;
import com.sun.portal.config.context.SRAFileContext;
import com.sun.portal.config.context.SRAPropertyContext;
import com.sun.portal.config.context.SRAWindowsFileContext;
import com.sun.portal.config.tasks.TasksImpl;
import com.sun.wizards.core.ArchiveReader;
import com.sun.wizards.core.PlatformToolkit;
import java.io.File;
import java.io.IOException;

public class SRAWindowsTasks
extends TasksImpl {
    private SRAPropertyContext pc = null;
    private SRAFileContext fc = null;
    protected static final String REGISTRY_FOLDER_BASE = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths\\";
    protected static final String REGISTRY_ENTRY_SEPARATOR = "\\";

    public SRAWindowsTasks(SRAPropertyContext sRAPropertyContext, SRAFileContext sRAFileContext) {
        this.pc = sRAPropertyContext;
        this.fc = sRAFileContext;
    }

    public Boolean createLoggingUserAuthenticationEntry() {
        int n;
        Boolean bl = Boolean.TRUE;
        String string = this.fc.getCreateSelfSignedCertificateLibraryPath();
        string = string + File.pathSeparator + this.replaceBackSlash(System.getProperty("java.library.path"));
        String string2 = this.fc.getCreateSelfSignedCertificateClassPath();
        String[] stringArray = new String[7];
        String string3 = this.replaceBackSlash(this.fc.getJavaHome()) + "/" + "bin" + "/" + "java";
        stringArray[0] = "-classpath";
        stringArray[1] = "\"" + string2 + "\"";
        stringArray[2] = "com.sun.portal.cli.cert.CertUtil";
        stringArray[3] = "\"-option=createloguserpassword\"";
        stringArray[4] = "\"" + this.fc.getInstancePlatformConfigurationFile() + "\"";
        stringArray[5] = "\"" + this.fc.getInstanceCertificatesDirectory() + "\"";
        stringArray[6] = this.pc.getCertificateDatabasePassword();
        String[] stringArray2 = new String[8];
        DebugContext.message("Command = " + string3);
        stringArray2[0] = string3;
        DebugContext.message("Command arguments...");
        for (int i = 0; i < stringArray.length; ++i) {
            DebugContext.message(i + " = " + stringArray[i]);
            stringArray2[i + 1] = stringArray[i];
        }
        String[] stringArray3 = new String[]{"PATH=" + string, "NSPR_NATIVE_THREADS_ONLY=1"};
        DebugContext.message("Command envp parameters are...");
        for (n = 0; n < stringArray3.length; ++n) {
            DebugContext.message(n + " = " + stringArray3[n]);
        }
        try {
            n = this.exec(stringArray2, stringArray3);
            if (n != 0) {
                DebugContext.error("Update logging user authentication entry command returned <" + n + ">");
                bl = Boolean.FALSE;
            } else {
                DebugContext.message("Updated logging user authentication entry successfully.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            DebugContext.error("Confiugration Error: Could not update logging user authentication entry!");
            bl = Boolean.FALSE;
        }
        return bl;
    }

    public Boolean createSelfSignedCertificate() {
        Boolean bl = Boolean.TRUE;
        Boolean bl2 = this.fc.existsGWInstance(this.pc.getInstanceName()) != false || this.fc.existsNLPInstance(this.pc.getInstanceName()) != false || this.fc.existsRWPInstance(this.pc.getInstanceName()) != false ? Boolean.FALSE : Boolean.TRUE;
        bl = this.copyFile(this.fc.getSourceRootCACertificatesFile(), this.fc.getDestinationRootCACertificatesFile(), bl2);
        if (bl.booleanValue()) {
            int n;
            String string = this.fc.getCreateSelfSignedCertificateLibraryPath();
            string = string + File.pathSeparator + this.replaceBackSlash(System.getProperty("java.library.path"));
            String string2 = this.fc.getCreateSelfSignedCertificateClassPath();
            String[] stringArray = new String[10];
            String string3 = this.replaceBackSlash(this.fc.getJavaHome()) + "/" + "bin" + "/" + "java";
            stringArray[0] = "-classpath";
            stringArray[1] = "\"" + string2 + "\"";
            stringArray[2] = "com.sun.portal.cli.cert.CertUtil";
            stringArray[3] = "\"" + this.fc.getInstanceCertificatesDirectory() + "\"";
            stringArray[4] = this.pc.getCertificateDatabasePassword();
            stringArray[5] = "en_US";
            stringArray[6] = "\"" + this.pc.getSelfSignedCertificateInformation() + "\"";
            stringArray[7] = " ";
            stringArray[8] = "\"" + this.pc.getSelfSignedCertificateNickName() + "\"";
            stringArray[9] = "6";
            String[] stringArray2 = new String[11];
            DebugContext.message("Command = " + string3);
            stringArray2[0] = string3;
            DebugContext.message("Command arguments...");
            for (int i = 0; i < stringArray.length; ++i) {
                DebugContext.message(i + " = " + stringArray[i]);
                stringArray2[i + 1] = stringArray[i];
            }
            String[] stringArray3 = new String[]{"PATH=" + string, "NSPR_NATIVE_THREADS_ONLY=1"};
            DebugContext.message("Command envp parameters are...");
            for (n = 0; n < stringArray3.length; ++n) {
                DebugContext.message(n + " = " + stringArray3[n]);
            }
            try {
                n = this.exec(stringArray2, stringArray3);
                if (n != 0) {
                    DebugContext.error("Create self signed certificate command returned <" + n + ">");
                    bl = Boolean.FALSE;
                } else {
                    DebugContext.message("Created self signed certificate successfully.");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                DebugContext.error("Confiugration Error: Could not create self signed certificate!");
                bl = Boolean.FALSE;
            }
        }
        return bl;
    }

    public Boolean createCertAdminCmdFile() {
        Boolean bl = Boolean.TRUE;
        SRAWindowsFileContext sRAWindowsFileContext = (SRAWindowsFileContext)this.fc;
        File file = new File(sRAWindowsFileContext.getInstanceCertAdminCmdFile());
        if (!file.exists()) {
            this.copyFile(sRAWindowsFileContext.getTemplateCertAdminCmdFile(), sRAWindowsFileContext.getInstanceCertAdminCmdFile(), Boolean.FALSE);
            String[][] stringArray = new String[][]{{"SRA_HOME_TOKEN", this.pc.getInstallDirectory()}, {"SRA_INSTANCE_TOKEN", this.pc.getInstanceName()}};
            try {
                bl = this.replaceTokens(sRAWindowsFileContext.getInstanceCertAdminCmdFile(), stringArray);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                bl = Boolean.FALSE;
            }
        }
        return bl;
    }

    public Boolean createSRAIMCmdFile() {
        Boolean bl = Boolean.TRUE;
        SRAWindowsFileContext sRAWindowsFileContext = (SRAWindowsFileContext)this.fc;
        File file = new File(sRAWindowsFileContext.getSRAIMFile());
        if (!file.exists()) {
            this.copyFile(sRAWindowsFileContext.getTemplateSRAIMFile(), sRAWindowsFileContext.getSRAIMFile(), Boolean.FALSE);
            String[][] stringArray = new String[][]{{"SRA_HOME_TOKEN", this.pc.getInstallDirectory()}};
            try {
                bl = this.replaceTokens(sRAWindowsFileContext.getSRAIMFile(), stringArray);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                bl = Boolean.FALSE;
            }
        }
        return bl;
    }

    protected String getCommandName(String string) {
        return string.lastIndexOf("/") == -1 ? string : string.substring(string.lastIndexOf("/") + "/".length());
    }

    protected Boolean addToWindowsRegistry(String string, String string2) {
        boolean bl = Boolean.TRUE;
        String string3 = this.getCommandName(string);
        PlatformToolkit platformToolkit = ArchiveReader.systemInterface.getPlatformToolkit();
        platformToolkit.createRegistryFolder(0, REGISTRY_FOLDER_BASE + string3);
        platformToolkit.setRegistryValue(0, REGISTRY_FOLDER_BASE + string3 + REGISTRY_ENTRY_SEPARATOR, string);
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Boolean removeFromWindowsRegistry(String string) {
        boolean bl = Boolean.TRUE;
        String string2 = this.getCommandName(string);
        PlatformToolkit platformToolkit = ArchiveReader.systemInterface.getPlatformToolkit();
        platformToolkit.deleteRegistryFolder(0, REGISTRY_FOLDER_BASE + string2);
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Boolean doUpdateWindowsRegistryForSRAIMCmd() {
        String[] stringArray = this.fc.getGWInstanceNames();
        String[] stringArray2 = this.fc.getRWPInstanceNames();
        String[] stringArray3 = this.fc.getNLPInstanceNames();
        int n = 0;
        if (stringArray != null) {
            n += stringArray.length;
        }
        if (stringArray2 != null) {
            n += stringArray2.length;
        }
        if (stringArray3 != null) {
            n += stringArray3.length;
        }
        return n == 1 ? Boolean.TRUE : Boolean.FALSE;
    }
}

