/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.config.tasks;

import com.sun.portal.config.context.DebugContext;
import com.sun.portal.config.context.RWPWindowsFileContext;
import com.sun.portal.config.context.SRAFileContext;
import com.sun.portal.config.context.SRAPropertyContext;
import com.sun.portal.config.tasks.RWPTasksImpl;
import com.sun.portal.config.tasks.SRAWindowsTasks;
import java.io.IOException;

public class RWPWindowsTasks
extends RWPTasksImpl {
    public RWPWindowsTasks() {
    }

    public RWPWindowsTasks(SRAPropertyContext sRAPropertyContext, SRAFileContext sRAFileContext) {
        super(sRAPropertyContext, sRAFileContext);
    }

    public Boolean createLoggingUserAuthenticationEntry() {
        return new SRAWindowsTasks(this.pc, this.fc).createLoggingUserAuthenticationEntry();
    }

    public Boolean createSelfSignedCertificate() {
        return new SRAWindowsTasks(this.pc, this.fc).createSelfSignedCertificate();
    }

    protected Boolean createInstanceWindowsService() {
        Boolean bl = Boolean.TRUE;
        RWPWindowsFileContext rWPWindowsFileContext = (RWPWindowsFileContext)this.fc;
        try {
            int n = this.exec(rWPWindowsFileContext.getInstanceInstallCmdFile());
            if (n != 0) {
                DebugContext.error("Install rewriter proxy instance Windows service command returned <" + n + ">");
                bl = Boolean.FALSE;
            } else {
                DebugContext.message("Installed rewriter proxy instance Windows service.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            DebugContext.error("Confiugration Error: Could not install rewriter proxy instance Windows service!");
            bl = Boolean.FALSE;
        }
        return bl;
    }

    public Boolean createInstanceSignature() {
        Boolean bl = Boolean.TRUE;
        RWPWindowsFileContext rWPWindowsFileContext = (RWPWindowsFileContext)this.fc;
        Boolean bl2 = this.fc.existsGWInstance(this.pc.getInstanceName()) != false || this.fc.existsNLPInstance(this.pc.getInstanceName()) != false || this.fc.existsRWPInstance(this.pc.getInstanceName()) != false ? Boolean.FALSE : Boolean.TRUE;
        this.copyFile(rWPWindowsFileContext.getTemplateEnvSetupFile(), rWPWindowsFileContext.getEnvSetupFile(), Boolean.FALSE);
        new SRAWindowsTasks(this.pc, this.fc).createSRAIMCmdFile();
        this.copyFile(rWPWindowsFileContext.getTemplateInstanceEnvSetupFile(), rWPWindowsFileContext.getInstanceEnvSetupFile(), bl2);
        this.copyFile(rWPWindowsFileContext.getTemplateCmdFile(), rWPWindowsFileContext.getInstanceCmdFile(), Boolean.TRUE);
        this.copyFile(rWPWindowsFileContext.getTemplateInstallCmdFile(), rWPWindowsFileContext.getInstanceInstallCmdFile(), Boolean.TRUE);
        this.copyFile(rWPWindowsFileContext.getTemplateUninstallCmdFile(), rWPWindowsFileContext.getInstanceUninstallCmdFile(), Boolean.TRUE);
        this.copyFile(rWPWindowsFileContext.getTemplateStartCmdFile(), rWPWindowsFileContext.getInstanceStartCmdFile(), Boolean.TRUE);
        this.copyFile(rWPWindowsFileContext.getTemplateStopCmdFile(), rWPWindowsFileContext.getInstanceStopCmdFile(), Boolean.TRUE);
        String[][] stringArray = new String[][]{{"JAVA_HOME_TOKEN", this.replaceBackSlash(this.fc.getJavaHome())}, {"SRA_HOME_TOKEN", this.pc.getInstallDirectory()}, {"IDENTITY_HOME_TOKEN", this.pc.getIdentityInstallDirectory()}, {"SRA_INSTANCE_TOKEN", this.pc.getInstanceName()}, {"PROTOCOL_TOKEN", this.pc.getProtocol()}, {"HOSTNAME_TOKEN", this.pc.getHost()}, {"PORT_TOKEN", this.pc.getPort()}};
        try {
            this.replaceTokens(rWPWindowsFileContext.getEnvSetupFile(), stringArray);
            this.replaceTokens(rWPWindowsFileContext.getInstanceEnvSetupFile(), stringArray);
            this.replaceTokens(rWPWindowsFileContext.getInstanceCmdFile(), stringArray);
            this.replaceTokens(rWPWindowsFileContext.getInstanceInstallCmdFile(), stringArray);
            this.replaceTokens(rWPWindowsFileContext.getInstanceUninstallCmdFile(), stringArray);
            this.replaceTokens(rWPWindowsFileContext.getInstanceStartCmdFile(), stringArray);
            this.replaceTokens(rWPWindowsFileContext.getInstanceStopCmdFile(), stringArray);
            this.addToWindowsRegistry();
            if (this.pc.doStartAtSystemBoot().booleanValue()) {
                bl = this.createInstanceWindowsService();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            bl = Boolean.FALSE;
        }
        return bl;
    }

    protected Boolean startInstance() {
        Boolean bl = Boolean.TRUE;
        RWPWindowsFileContext rWPWindowsFileContext = (RWPWindowsFileContext)this.fc;
        try {
            int n = this.exec(rWPWindowsFileContext.getInstanceStartCmdFile());
            if (n != 0) {
                DebugContext.error("Start rewriter proxy instance command returned <" + n + ">");
                bl = Boolean.FALSE;
            } else {
                DebugContext.message("Started rewriter proxy instance.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            DebugContext.error("Confiugration Error: Could not start rewriter proxy instance!");
            bl = Boolean.FALSE;
        }
        return bl;
    }

    public Boolean startRewriterProxy() {
        return this.startInstance();
    }

    protected Boolean removeInstanceWindowsService() {
        Boolean bl = Boolean.TRUE;
        RWPWindowsFileContext rWPWindowsFileContext = (RWPWindowsFileContext)this.fc;
        try {
            int n = this.exec(rWPWindowsFileContext.getInstanceUninstallCmdFile());
            if (n != 0) {
                DebugContext.error("Uninstall rewriter proxy instance Windows service command returned <" + n + ">");
                bl = Boolean.FALSE;
            } else {
                DebugContext.message("Uninstalled rewriter proxy instance Windows service.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            DebugContext.error("Confiugration Error: Could not Uninstall rewriter proxy instance Windows service!");
            bl = Boolean.FALSE;
        }
        return bl;
    }

    public Boolean stopRewriterProxy() {
        return this.removeInstanceWindowsService();
    }

    public Boolean removeInstanceSignature() {
        Boolean bl;
        Boolean bl2 = Boolean.TRUE;
        RWPWindowsFileContext rWPWindowsFileContext = (RWPWindowsFileContext)this.fc;
        this.removeFromWindowsRegistry();
        this.removeFile(rWPWindowsFileContext.getInstanceStopCmdFile());
        this.removeFile(rWPWindowsFileContext.getInstanceStartCmdFile());
        this.removeFile(rWPWindowsFileContext.getInstanceUninstallCmdFile());
        this.removeFile(rWPWindowsFileContext.getInstanceInstallCmdFile());
        this.removeFile(rWPWindowsFileContext.getInstanceCmdFile());
        this.removeFile(rWPWindowsFileContext.getInstanceEnvSetupFile());
        this.removeFile(rWPWindowsFileContext.getInstanceRWPConfigurationPropertiesFile());
        if (!this.fc.existsGWInstance(this.pc.getInstanceName()).booleanValue() && !this.fc.existsNLPInstance(this.pc.getInstanceName()).booleanValue()) {
            this.removeDirectory(this.fc.getInstanceDirectory());
        }
        String[] stringArray = this.fc.getGWInstanceNames();
        String[] stringArray2 = this.fc.getRWPInstanceNames();
        String[] stringArray3 = this.fc.getNLPInstanceNames();
        Boolean bl3 = bl = stringArray == null && stringArray2 == null && stringArray3 == null ? Boolean.TRUE : Boolean.FALSE;
        if (bl.booleanValue()) {
            this.removeFile(rWPWindowsFileContext.getEnvSetupFile());
            this.removeFile(rWPWindowsFileContext.getSRAIMFile());
        }
        return bl2;
    }

    protected Boolean addToWindowsRegistry() {
        Boolean bl = Boolean.TRUE;
        RWPWindowsFileContext rWPWindowsFileContext = (RWPWindowsFileContext)this.fc;
        SRAWindowsTasks sRAWindowsTasks = new SRAWindowsTasks(this.pc, this.fc);
        sRAWindowsTasks.addToWindowsRegistry(rWPWindowsFileContext.getInstanceCmdFile(), this.pc.getInstallDirectory());
        sRAWindowsTasks.addToWindowsRegistry(rWPWindowsFileContext.getInstanceInstallCmdFile(), this.pc.getInstallDirectory());
        sRAWindowsTasks.addToWindowsRegistry(rWPWindowsFileContext.getInstanceUninstallCmdFile(), this.pc.getInstallDirectory());
        sRAWindowsTasks.addToWindowsRegistry(rWPWindowsFileContext.getInstanceStartCmdFile(), this.pc.getInstallDirectory());
        sRAWindowsTasks.addToWindowsRegistry(rWPWindowsFileContext.getInstanceStopCmdFile(), this.pc.getInstallDirectory());
        if (!this.fc.existsGWInstance(this.pc.getInstanceName()).booleanValue() && !this.fc.existsNLPInstance(this.pc.getInstanceName()).booleanValue()) {
            sRAWindowsTasks.addToWindowsRegistry(rWPWindowsFileContext.getInstanceCertAdminCmdFile(), this.pc.getInstallDirectory());
        }
        if (sRAWindowsTasks.doUpdateWindowsRegistryForSRAIMCmd().booleanValue()) {
            sRAWindowsTasks.addToWindowsRegistry(rWPWindowsFileContext.getSRAIMFile(), this.pc.getInstallDirectory());
        }
        return bl;
    }

    protected Boolean removeFromWindowsRegistry() {
        Boolean bl = Boolean.TRUE;
        RWPWindowsFileContext rWPWindowsFileContext = (RWPWindowsFileContext)this.fc;
        SRAWindowsTasks sRAWindowsTasks = new SRAWindowsTasks(this.pc, this.fc);
        sRAWindowsTasks.removeFromWindowsRegistry(rWPWindowsFileContext.getInstanceCmdFile());
        sRAWindowsTasks.removeFromWindowsRegistry(rWPWindowsFileContext.getInstanceInstallCmdFile());
        sRAWindowsTasks.removeFromWindowsRegistry(rWPWindowsFileContext.getInstanceUninstallCmdFile());
        sRAWindowsTasks.removeFromWindowsRegistry(rWPWindowsFileContext.getInstanceStartCmdFile());
        sRAWindowsTasks.removeFromWindowsRegistry(rWPWindowsFileContext.getInstanceStopCmdFile());
        if (!this.fc.existsGWInstance(this.pc.getInstanceName()).booleanValue() && !this.fc.existsNLPInstance(this.pc.getInstanceName()).booleanValue()) {
            sRAWindowsTasks.removeFromWindowsRegistry(rWPWindowsFileContext.getInstanceCertAdminCmdFile());
        }
        if (sRAWindowsTasks.doUpdateWindowsRegistryForSRAIMCmd().booleanValue()) {
            sRAWindowsTasks.removeFromWindowsRegistry(rWPWindowsFileContext.getSRAIMFile());
        }
        return bl;
    }
}

